/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.crypto;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.crypto.config.KeySetManager;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.crypto.config.WSKeySetGroup;
import java.util.Map;
import java.util.TreeMap;

public class KeySetHelper {
    private static final TraceComponent tc = Tr.register(KeySetHelper.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static KeySetHelper thisClass = null;
    private static final WebSphereRuntimePermission GET_KEYSETGROUPS = new WebSphereRuntimePermission("getKeySetGroups");
    private static final WebSphereRuntimePermission GET_KEYSETS = new WebSphereRuntimePermission("getKeySets");

    public static KeySetHelper getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (thisClass == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new instance of KeySetHelper.");
            }
            thisClass = new KeySetHelper();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return thisClass;
    }

    public Map getAllKeysForKeySetGroup(String keySetGroupName) throws KeyException, SecurityException {
        WSKeySetGroup keySetGroup;
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeysByVersion", new Object[]{keySetGroupName});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_KEYSETGROUPS.toString());
            }
            try {
                sm.checkPermission(GET_KEYSETGROUPS);
            }
            catch (SecurityException e) {
                Tr.debug(tc, "Expecting : " + GET_KEYSETGROUPS.toString() + "." + keySetGroupName);
                sm.checkPermission(new WebSphereRuntimePermission("GetKeySetGroups." + keySetGroupName));
            }
        }
        if ((keySetGroup = KeySetGroupManager.getInstance().getKeySetGroup(keySetGroupName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified KeySetGroup name is not found.");
            }
            throw new KeyException("KeySetGroup name " + keySetGroupName + " is not found.");
        }
        TreeMap allKeys = keySetGroup.getAllKeysByVersion();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeysByVersion", new Object[]{allKeys});
        }
        return allKeys;
    }

    public Map getLatestKeysForKeySetGroup(String keySetGroupName) throws KeyException, SecurityException {
        WSKeySetGroup keySetGroup;
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeysForKeySetGroup", new Object[]{keySetGroupName});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_KEYSETGROUPS.toString());
            }
            try {
                sm.checkPermission(GET_KEYSETGROUPS);
            }
            catch (SecurityException e) {
                Tr.debug(tc, "Expecting : " + GET_KEYSETGROUPS.toString() + "." + keySetGroupName);
                sm.checkPermission(new WebSphereRuntimePermission("GetKeySetGroups." + keySetGroupName));
            }
        }
        if ((keySetGroup = KeySetGroupManager.getInstance().getKeySetGroup(keySetGroupName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified KeySetGroup name is not found.");
            }
            throw new KeyException("KeySetGroup name " + keySetGroupName + " is not found.");
        }
        Map latestKeys = keySetGroup.getLatestKeys();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKeysForKeySetGroup", new Object[]{latestKeys});
        }
        return latestKeys;
    }

    public Map getAllKeysForKeySet(String keySetName) throws KeyException {
        WSKeySet keySet;
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeysForKeySet", new Object[]{keySetName});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_KEYSETS.toString());
            }
            try {
                sm.checkPermission(GET_KEYSETS);
            }
            catch (SecurityException e) {
                Tr.debug(tc, "Expecting : " + GET_KEYSETS.toString() + "." + keySetName);
                sm.checkPermission(new WebSphereRuntimePermission("GetKeySets." + keySetName));
            }
        }
        if ((keySet = KeySetManager.getInstance().getKeySet(keySetName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified KeySet name is not found.");
            }
            throw new KeyException("KeySet name " + keySetName + " is not found.");
        }
        Map allKeys = keySet.getAllKeys();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeysForKeySet", new Object[]{allKeys});
        }
        return allKeys;
    }

    public Object getLatestKeyForKeySet(String keySetName) throws KeyException {
        WSKeySet keySet;
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeyForKeySet", new Object[]{keySetName});
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_KEYSETS.toString());
            }
            try {
                sm.checkPermission(GET_KEYSETS);
            }
            catch (SecurityException e) {
                Tr.debug(tc, "Expecting : " + GET_KEYSETS.toString() + "." + keySetName);
                sm.checkPermission(new WebSphereRuntimePermission("GetKeySets." + keySetName));
            }
        }
        if ((keySet = KeySetManager.getInstance().getKeySet(keySetName)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified KeySet name is not found.");
            }
            throw new KeyException("KeySet name " + keySetName + " is not found.");
        }
        Object latest = keySet.getLatestKey();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKeyForKeySet", new Object[]{latest});
        }
        return latest;
    }
}

