/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.server;

import com.ibm.ras.RASMessageCatalog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RASConnectionHandler
implements Runnable {
    private boolean toFile = false;
    private PrintWriter pWriter = null;
    private RASMessageCatalog cat = new RASMessageCatalog("com.ibm.ras.server.RASLogServerMsgs");
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss:SSS");
    private Socket socket = null;

    public RASConnectionHandler(Socket socket, boolean toFile, PrintWriter pWriter) {
        this.socket = socket;
        this.toFile = toFile;
        this.pWriter = pWriter;
        String dateString = df.format(new Date());
        this.write(this.cat.getMessage("CONNECTION_OPENED", socket.getInetAddress().getHostName(), dateString));
    }

    public void run() {
        BufferedReader clientStream = null;
        try {
            clientStream = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (Throwable e) {
            this.write(this.cat.getMessage("ERR_INPUT_STREAM"));
            this.write(e.getMessage());
            return;
        }
        try {
            while (true) {
                String s = null;
                s = clientStream.readLine();
                if (s == null) {
                    return;
                }
                this.write(s);
            }
        }
        catch (Throwable e) {
            String dateString = df.format(new Date());
            this.write(this.cat.getMessage("CONNECTION_CLOSED", this.socket.getInetAddress().getHostName(), dateString));
            this.write(e.getMessage());
            return;
        }
    }

    private void write(String msg) {
        if (this.toFile) {
            this.pWriter.println(msg);
        }
        System.out.println(msg);
    }
}

