/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.mgr;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASHandler;
import com.ibm.ras.RASIFormatter;
import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASILogger;
import com.ibm.ras.RASIMessageLogger;
import com.ibm.ras.RASIOException;
import com.ibm.ras.RASITraceLogger;
import com.ibm.ras.RASObject;
import com.ibm.ras.RASUtil;
import com.ibm.ras.mgr.RASBaseGroup;
import com.ibm.ras.mgr.RASConfig;
import com.ibm.ras.mgr.RASGroup;
import com.ibm.ras.mgr.RASIDataStore;
import com.ibm.ras.mgr.RASIManager;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class RASManager
implements RASConstants,
RASIManager {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    protected static final Object dsLock = new Object();
    protected static final Object getMgrLock = new Object();
    protected static final Object getObjLock = new Object();
    private RASIDataStore dataStore = null;
    private RASBaseGroup baseGroup = null;
    private static RASManager mgr = null;

    public static RASManager getManager() {
        RASManager.getManager(null);
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RASManager getManager(RASIDataStore store) {
        Object object = getMgrLock;
        synchronized (object) {
            if (mgr == null) {
                mgr = new RASManager(store);
            }
        }
        return mgr;
    }

    protected RASManager(RASIDataStore store) {
        this.addDataStore(store);
        try {
            this.restoreConfig();
        }
        catch (RASIOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataStore(RASIDataStore store) {
        Object object = dsLock;
        synchronized (object) {
            if (store != null) {
                this.dataStore = store;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataStore(RASIDataStore store) {
        Object object = dsLock;
        synchronized (object) {
            if (store != null && this.dataStore.equals(store)) {
                this.dataStore = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getDataStores() {
        Vector<RASIDataStore> stores = new Vector<RASIDataStore>(1);
        Object object = dsLock;
        synchronized (object) {
            if (this.dataStore != null) {
                stores.addElement(this.dataStore);
            }
        }
        return stores.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreConfig() throws RASIOException {
        RASBaseGroup newBaseGroup = null;
        Object object = dsLock;
        synchronized (object) {
            if (this.dataStore != null) {
                newBaseGroup = this.dataStore.restoreConfig();
            }
        }
        object = getObjLock;
        synchronized (object) {
            if (newBaseGroup != null) {
                RASBaseGroup oldBaseGroup = this.baseGroup;
                this.baseGroup = newBaseGroup;
                this.baseGroup.updateActiveObjects(oldBaseGroup, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() throws RASIOException {
        Object object = dsLock;
        synchronized (object) {
            if (this.dataStore != null) {
                this.dataStore.saveConfig(this.baseGroup);
            }
        }
    }

    public RASIMessageLogger getMessageLogger(String name2) {
        return this.getMessageLogger(name2, this.baseGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIMessageLogger getMessageLogger(String name2, String groupName) {
        RASIMessageLogger logger = null;
        Object object = getObjLock;
        synchronized (object) {
            RASGroup group = this.baseGroup.getGroup(groupName);
            if (group != null) {
                logger = this.getMessageLogger(name2, group);
            }
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIMessageLogger getMessageLogger(String name2, RASGroup group) {
        RASIMessageLogger logger = null;
        Object object = getObjLock;
        synchronized (object) {
            RASConfig cfg = group.getMessageLoggerConfig(name2);
            if (cfg != null) {
                logger = (RASIMessageLogger)((Object)this.getObject(cfg));
                this.addHandlers(logger, cfg, group);
            }
        }
        return logger;
    }

    public void returnMessageLogger(RASIMessageLogger logger) {
        String groupName = logger.getGroup();
        if (groupName.equals("")) {
            this.returnMessageLogger(logger, this.baseGroup);
        } else {
            this.returnMessageLogger(logger, groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnMessageLogger(RASIMessageLogger logger, String groupName) {
        if (groupName != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASGroup group = this.baseGroup.getGroup(groupName);
                if (group != null) {
                    this.returnMessageLogger(logger, group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnMessageLogger(RASIMessageLogger logger, RASGroup group) {
        if (logger != null && group != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASConfig cfg = group.getMessageLoggerConfig(logger.getName());
                if (cfg != null && cfg.decrementInUseCount() == 0) {
                    this.removeHandlers(logger, group);
                    cfg.setObject(null);
                    logger = null;
                }
            }
        }
    }

    public RASITraceLogger getTraceLogger(String name2) {
        return this.getTraceLogger(name2, this.baseGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASITraceLogger getTraceLogger(String name2, String groupName) {
        RASITraceLogger logger = null;
        Object object = getObjLock;
        synchronized (object) {
            RASGroup group = this.baseGroup.getGroup(groupName);
            if (group != null) {
                logger = this.getTraceLogger(name2, group);
            }
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASITraceLogger getTraceLogger(String name2, RASGroup group) {
        RASITraceLogger logger = null;
        Object object = getObjLock;
        synchronized (object) {
            RASConfig cfg = group.getTraceLoggerConfig(name2);
            if (cfg != null) {
                logger = (RASITraceLogger)((Object)this.getObject(cfg));
                this.addHandlers(logger, cfg, group);
            }
        }
        return logger;
    }

    public void returnTraceLogger(RASITraceLogger logger) {
        String groupName = logger.getGroup();
        if (groupName.equals("")) {
            this.returnTraceLogger(logger, this.baseGroup);
        } else {
            this.returnTraceLogger(logger, groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnTraceLogger(RASITraceLogger logger, String groupName) {
        if (groupName != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASGroup group = this.baseGroup.getGroup(groupName);
                if (group != null) {
                    this.returnTraceLogger(logger, group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnTraceLogger(RASITraceLogger logger, RASGroup group) {
        if (logger != null && group != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASConfig cfg = group.getTraceLoggerConfig(logger.getName());
                if (cfg != null && cfg.decrementInUseCount() == 0) {
                    this.removeHandlers(logger, group);
                    cfg.setObject(null);
                    logger = null;
                }
            }
        }
    }

    public RASIHandler getHandler(String name2) {
        return this.getHandler(name2, this.baseGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIHandler getHandler(String name2, String groupName) {
        RASIHandler handler2 = null;
        Object object = getObjLock;
        synchronized (object) {
            RASGroup group = this.baseGroup.getGroup(groupName);
            if (group != null) {
                handler2 = this.getHandler(name2, group);
            }
        }
        return handler2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIHandler getHandler(String name2, RASGroup group) {
        RASIHandler handler2 = null;
        Object object = getObjLock;
        synchronized (object) {
            RASConfig cfg = group.getHandlerConfig(name2);
            if (cfg != null) {
                handler2 = (RASIHandler)((Object)this.getObject(cfg));
                this.addFormatters(handler2, cfg, group);
            }
        }
        return handler2;
    }

    public void returnHandler(RASIHandler handler2) {
        String groupName = handler2.getGroup();
        if (groupName.equals("")) {
            this.returnHandler(handler2, this.baseGroup);
        } else {
            this.returnHandler(handler2, groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnHandler(RASIHandler handler2, String groupName) {
        if (groupName != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASGroup group = this.baseGroup.getGroup(groupName);
                if (group != null) {
                    this.returnHandler(handler2, group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnHandler(RASIHandler handler2, RASGroup group) {
        if (handler2 != null && group != null) {
            String handlerName = handler2.getName();
            Object object = getObjLock;
            synchronized (object) {
                RASConfig cfg = group.getHandlerConfig(handlerName);
                if (cfg == null) {
                    cfg = this.baseGroup.getHandlerConfig(handlerName);
                }
                if (cfg != null && cfg.decrementInUseCount() == 0) {
                    handler2.stop();
                    this.removeFormatters(handler2, group);
                    cfg.setObject(null);
                    handler2 = null;
                }
            }
        }
    }

    public RASIFormatter getFormatter(String name2) {
        return this.getFormatter(name2, this.baseGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIFormatter getFormatter(String name2, String groupName) {
        RASIFormatter formatter = null;
        Object object = getObjLock;
        synchronized (object) {
            RASGroup group = this.baseGroup.getGroup(groupName);
            if (group != null) {
                formatter = this.getFormatter(name2, group);
            }
        }
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RASIFormatter getFormatter(String name2, RASGroup group) {
        RASIFormatter formatter = null;
        Object object = getObjLock;
        synchronized (object) {
            RASConfig cfg = group.getFormatterConfig(name2);
            if (cfg != null) {
                formatter = (RASIFormatter)((Object)this.getObject(cfg));
            }
        }
        return formatter;
    }

    public void returnFormatter(RASIFormatter formatter) {
        String groupName = formatter.getGroup();
        if (groupName.equals("")) {
            this.returnFormatter(formatter, this.baseGroup);
        } else {
            this.returnFormatter(formatter, groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnFormatter(RASIFormatter formatter, String groupName) {
        if (groupName != null) {
            Object object = getObjLock;
            synchronized (object) {
                RASGroup group = this.baseGroup.getGroup(groupName);
                if (group != null) {
                    this.returnFormatter(formatter, group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnFormatter(RASIFormatter formatter, RASGroup group) {
        if (formatter != null && group != null) {
            String formatterName = formatter.getName();
            Object object = getObjLock;
            synchronized (object) {
                RASConfig cfg = group.getFormatterConfig(formatterName);
                if (cfg == null) {
                    cfg = this.baseGroup.getFormatterConfig(formatterName);
                }
                if (cfg != null && cfg.decrementInUseCount() == 0) {
                    cfg.setObject(null);
                    formatter = null;
                }
            }
        }
    }

    public RASBaseGroup getBaseGroup() {
        return this.baseGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaseGroup(RASBaseGroup baseGroup) {
        Object object = dsLock;
        synchronized (object) {
            this.baseGroup = baseGroup;
        }
    }

    protected RASObject getObject(RASConfig cfg) {
        Object objClass = null;
        RASObject object = null;
        if (cfg != null) {
            object = cfg.getObject();
            if (object == null && (object = (RASObject)RASUtil.createObject((String)cfg.get("className"))) != null) {
                object.setConfig(cfg);
                cfg.setObject(object);
            }
            if (object != null) {
                cfg.incrementInUseCount();
            }
        }
        return object;
    }

    protected void addHandlers(RASILogger logger, RASConfig cfg, RASGroup group) {
        if (logger != null) {
            RASIHandler handler2;
            String handlerNames = (String)cfg.get("handlerNames");
            if ((handlerNames == null || handlerNames.equals("")) && (handlerNames = logger instanceof RASIMessageLogger ? this.baseGroup.getDefaultMessageHandlers() : this.baseGroup.getDefaultTraceHandlers()) == null) {
                handlerNames = this.baseGroup.getDefaultHandlers();
            }
            Vector current = new Vector();
            Enumeration e = logger.getHandlers();
            while (e.hasMoreElements()) {
                current.addElement(e.nextElement());
            }
            if (handlerNames != null) {
                StringTokenizer st = new StringTokenizer(handlerNames);
                while (st.hasMoreTokens()) {
                    String name2 = st.nextToken();
                    handler2 = this.getHandler(name2, group);
                    if (handler2 == null) {
                        handler2 = this.getHandler(name2, this.baseGroup);
                    }
                    if (handler2 == null) continue;
                    if (current.contains(handler2)) {
                        this.returnHandler(handler2);
                        current.removeElement(handler2);
                        continue;
                    }
                    logger.addHandler(handler2);
                }
            }
            Enumeration e2 = current.elements();
            while (e2.hasMoreElements()) {
                handler2 = (RASHandler)e2.nextElement();
                logger.removeHandler(handler2);
                this.returnHandler(handler2);
            }
        }
    }

    protected void removeHandlers(RASILogger logger, RASGroup group) {
        Enumeration e = logger.getHandlers();
        while (e.hasMoreElements()) {
            RASIHandler handler2 = (RASIHandler)e.nextElement();
            this.returnHandler(handler2, group);
        }
    }

    protected void addFormatters(RASIHandler handler2, RASConfig cfg, RASGroup group) {
        String formatterNames;
        if (handler2 != null && (formatterNames = (String)cfg.get("formatterNames")) != null) {
            StringTokenizer st = new StringTokenizer(formatterNames);
            while (st.hasMoreTokens()) {
                String name2 = st.nextToken();
                RASIFormatter formatter = this.getFormatter(name2, group);
                if (formatter == null) {
                    formatter = this.getFormatter(name2, this.baseGroup);
                }
                if (formatter == null) continue;
                handler2.addFormatter(formatter);
            }
        }
    }

    protected void removeFormatters(RASIHandler handler2, RASGroup group) {
        Enumeration e = handler2.getFormatters();
        while (e.hasMoreElements()) {
            RASIFormatter formatter = (RASIFormatter)e.nextElement();
            if (formatter.isDefault()) continue;
            this.returnFormatter(formatter, group);
        }
    }

    protected void finalize() throws Throwable {
        Enumeration e = this.baseGroup.getHandlerConfigs().elements();
        this.stopHandlers(e, this.baseGroup);
        e = this.baseGroup.getGroups().elements();
        while (e.hasMoreElements()) {
            RASGroup group = (RASGroup)e.nextElement();
            Enumeration e2 = group.getHandlerConfigs().elements();
            this.stopHandlers(e2, group);
        }
        super.finalize();
    }

    private void stopHandlers(Enumeration e, RASGroup group) {
        while (e.hasMoreElements()) {
            RASConfig cfg = (RASConfig)e.nextElement();
            RASHandler h = (RASHandler)cfg.getObject();
            if (h == null) continue;
            this.returnHandler((RASIHandler)h, group);
        }
    }
}

