/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.mgr;

import com.ibm.ras.RASUtil;
import com.ibm.ras.mgr.RASGroup;
import com.ibm.ras.mgr.RASManager;
import java.util.Enumeration;
import java.util.Hashtable;

public class RASBaseGroup
extends RASGroup
implements Cloneable {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = -5797962705232046385L;
    private Hashtable groups = new Hashtable();
    private String defaultHandlers = null;
    private String defaultMessageHandlers = null;
    private String defaultTraceHandlers = null;

    public RASBaseGroup() {
        super(RASUtil.rasMsgs.getMessage("BASE_GROUP_NAME"));
    }

    public synchronized Object clone() {
        RASBaseGroup obj = (RASBaseGroup)super.clone();
        obj.groups = (Hashtable)this.groups.clone();
        return obj;
    }

    public void addGroup(RASGroup grp) {
        if (grp != null) {
            this.groups.put(grp.getName(), grp);
        }
    }

    public void removeGroup(RASGroup grp) {
        if (grp != null) {
            this.groups.remove(grp.getName());
        }
    }

    public RASGroup getGroup(String name2) {
        RASGroup grp = null;
        if (name2 != null) {
            grp = (RASGroup)this.groups.get(name2);
        }
        return grp;
    }

    public Hashtable getGroups() {
        return this.groups;
    }

    public String getDefaultHandlers() {
        return this.defaultHandlers;
    }

    public void setDefaultHandlers(String names) {
        this.defaultHandlers = names;
    }

    public String getDefaultMessageHandlers() {
        return this.defaultMessageHandlers;
    }

    public void setDefaultMessageHandlers(String names) {
        this.defaultMessageHandlers = names;
    }

    public String getDefaultTraceHandlers() {
        return this.defaultTraceHandlers;
    }

    public void setDefaultTraceHandlers(String names) {
        this.defaultTraceHandlers = names;
    }

    public void updateActiveObjects(RASBaseGroup oldBaseGroup, RASManager mgr) {
        if (oldBaseGroup != null) {
            super.updateActiveObjects(oldBaseGroup, mgr);
            Enumeration e = oldBaseGroup.getGroups().elements();
            while (e.hasMoreElements()) {
                RASGroup oldGroup = (RASGroup)e.nextElement();
                String groupName = oldGroup.getName();
                RASGroup newGroup = this.getGroup(groupName);
                if (newGroup == null) {
                    this.addGroup(oldGroup);
                    continue;
                }
                newGroup.updateActiveObjects(oldGroup, mgr);
            }
        }
    }

    public String toString() {
        StringBuffer bfr = new StringBuffer();
        bfr.append("\r\n");
        bfr.append(super.toString());
        if (!this.groups.isEmpty()) {
            Enumeration e = this.groups.elements();
            while (e.hasMoreElements()) {
                RASGroup group = (RASGroup)e.nextElement();
                bfr.append(group.toString());
            }
        }
        if (this.defaultHandlers != null) {
            bfr.append("Default Handlers:  " + this.defaultHandlers + "\r\n");
        }
        return bfr.toString();
    }
}

