/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIHandler;
import com.ibm.ras.RASILogger;
import com.ibm.ras.RASIMaskChangeListener;
import com.ibm.ras.RASMaskChangeEvent;
import com.ibm.ras.RASMaskChangeGenerator;
import com.ibm.ras.RASUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class RASLogger
extends RASMaskChangeGenerator
implements RASConstants,
RASILogger,
RASIMaskChangeListener {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    public boolean isLogging;
    private boolean isSync;
    protected transient int handlerFailures;
    protected long isLoggableMask;
    private String handlerNames;
    private String client;
    private String server;
    private Vector handlers = new Vector(1);

    public RASLogger() {
    }

    public RASLogger(String name2) {
        super(name2);
    }

    public RASLogger(String name2, String desc) {
        super(name2, desc);
    }

    public RASLogger(String name2, String desc, String server2, String client2) {
        this(name2, desc);
        this.setServer(server2);
        this.setClient(client2);
    }

    protected void init() {
        super.init();
        this.setLogging(false);
        this.setSynchronous(false);
        this.handlerFailures = 0;
        this.isLoggableMask = 0L;
        this.handlerNames = "";
        this.setClient("");
        this.setServer("");
        this.addMaskChangeListener(this);
    }

    public Hashtable getConfig() {
        Hashtable ht = super.getConfig();
        ht.put("isLogging", new Boolean(this.isLogging).toString());
        ht.put("isSync", new Boolean(this.isSync).toString());
        ht.put("server", this.getServer());
        ht.put("client", this.getClient());
        ht.put("handlerNames", this.handlerNames);
        return ht;
    }

    public void setConfig(Hashtable ht) {
        super.setConfig(ht);
        if (ht.containsKey("isLogging")) {
            this.isLogging = new Boolean((String)ht.get("isLogging"));
        }
        if (ht.containsKey("isSync")) {
            this.isSync = new Boolean((String)ht.get("isSync"));
        }
        if (ht.containsKey("server")) {
            this.setServer((String)ht.get("server"));
        }
        if (ht.containsKey("client")) {
            this.setClient((String)ht.get("client"));
        }
        if (ht.containsKey("handlerNames")) {
            this.handlerNames = (String)ht.get("handlerNames");
        }
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String name2) {
        if (name2 != null) {
            this.client = name2;
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String name2) {
        if (name2 != null) {
            this.server = name2;
        }
    }

    public void addHandler(RASIHandler handler2) {
        if (handler2 != null && !this.handlers.contains(handler2)) {
            this.handlers.addElement(handler2);
            handler2.addMaskChangeListener(this);
            this.maskValueChanged(new RASMaskChangeEvent(this, 0L, 0L, false));
        }
    }

    public void removeHandler(RASIHandler handler2) {
        if (handler2 != null && this.handlers.contains(handler2)) {
            this.handlers.removeElement(handler2);
            handler2.removeMaskChangeListener(this);
            this.maskValueChanged(new RASMaskChangeEvent(this, 0L, 0L, false));
        }
    }

    public Enumeration getHandlers() {
        return this.handlers.elements();
    }

    public boolean isSynchronous() {
        return this.isSync;
    }

    public void setSynchronous(boolean flag) {
        this.isSync = flag;
    }

    public boolean isLogging() {
        return this.isLogging;
    }

    public void setLogging(boolean flag) {
        this.isLogging = flag;
    }

    public boolean isLoggable(long type) {
        boolean isLoggable = false;
        long invertedMask = this.isLoggableMask ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.isLogging && ((type | invertedMask) ^ invertedMask) != 0L) {
            isLoggable = true;
        }
        return isLoggable;
    }

    public abstract void maskValueChanged(RASMaskChangeEvent var1);

    public void fireRASEvent(RASIEvent event) {
        if (event != null) {
            Enumeration e = this.getHandlers();
            if (e.hasMoreElements()) {
                long type = event.getType();
                while (e.hasMoreElements()) {
                    RASIHandler h = (RASIHandler)e.nextElement();
                    long invertedMask = event.isMessageEvent() ? h.getMessageMask() ^ 0xFFFFFFFFFFFFFFFFL : h.getTraceMask() ^ 0xFFFFFFFFFFFFFFFFL;
                    if (((type | invertedMask) ^ invertedMask) == 0L) continue;
                    if (this.isSynchronous()) {
                        h.writeEvent(event);
                        continue;
                    }
                    h.logEvent(event);
                }
                this.handlerFailures = 0;
            } else if (this.handlerFailures == 0) {
                RASUtil.errorMsg(RASUtil.rasMsgs.getMessage("ERR_NO_HANDLERS", this.getName()));
                ++this.handlerFailures;
            }
        }
    }
}

