/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASMessageCatalog;
import com.ibm.ras.RASMessageEvent;
import com.ibm.ras.RASMessageFormatter;
import com.ibm.ras.RASUtil;
import java.util.MissingResourceException;

public class RASEnhancedMessageFormatter
extends RASMessageFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = 4777919917975263160L;
    private static final String SPACE = "  ";
    private transient String date = null;
    private transient String className = null;
    private transient String methodName = null;
    private transient String org = null;
    private transient String product = null;
    private transient String comp = null;
    private transient String server = null;
    private transient String client = null;

    public String format(RASIEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        if (this.date == null) {
            try {
                RASMessageCatalog cat = new RASMessageCatalog("com.ibm.ras.RASMsgs", this.getLocale());
                this.date = cat.getMessage("DATE");
                this.className = cat.getMessage("CLASS_NAME");
                this.methodName = cat.getMessage("METHOD_NAME");
                this.org = cat.getMessage("ORGANIZATION");
                this.product = cat.getMessage("PRODUCT");
                this.comp = cat.getMessage("COMPONENT");
                this.server = cat.getMessage("SERVER");
                this.client = cat.getMessage("CLIENT");
            }
            catch (MissingResourceException e) {
                this.date = "Date:";
                this.className = "Class:";
                this.methodName = "Method:";
                this.org = "Organization:";
                this.product = "Product:";
                this.comp = "Component:";
                this.server = "Server:";
                this.client = "Client:";
            }
            int max2 = this.date.length();
            if (this.className.length() > max2) {
                max2 = this.className.length();
            }
            if (this.methodName.length() > max2) {
                max2 = this.methodName.length();
            }
            if (this.org.length() > max2) {
                max2 = this.org.length();
            }
            if (this.product.length() > max2) {
                max2 = this.product.length();
            }
            if (this.comp.length() > max2) {
                max2 = this.comp.length();
            }
            if (this.server.length() > max2) {
                max2 = this.server.length();
            }
            if (this.client.length() > max2) {
                max2 = this.client.length();
            }
            this.date = RASUtil.left(this.date, max2);
            this.className = RASUtil.left(this.className, max2);
            this.methodName = RASUtil.left(this.methodName, max2);
            this.org = RASUtil.left(this.org, max2);
            this.product = RASUtil.left(this.product, max2);
            this.comp = RASUtil.left(this.comp, max2);
            this.server = RASUtil.left(this.server, max2);
            this.client = RASUtil.left(this.client, max2);
        }
        RASMessageEvent mevent = (RASMessageEvent)event;
        long timeStamp = mevent.getTimeStamp();
        bfr.append(this.date + SPACE + this.getDate(timeStamp) + SPACE + this.getTime(timeStamp) + this.lineSep);
        Object item = mevent.getAttribute("loggingClass");
        if (item != null) {
            bfr.append(this.className + SPACE + item + this.lineSep);
        }
        if ((item = mevent.getAttribute("loggingMethod")) != null) {
            bfr.append(this.methodName + SPACE + item + this.lineSep);
        }
        if ((item = mevent.getAttribute("organization")) != null) {
            bfr.append(this.org + SPACE + item + this.lineSep);
        }
        if ((item = mevent.getAttribute("product")) != null) {
            bfr.append(this.product + SPACE + item + this.lineSep);
        }
        if ((item = mevent.getAttribute("component")) != null) {
            bfr.append(this.comp + SPACE + item + this.lineSep);
        }
        if ((item = mevent.getAttribute("server")) != null) {
            bfr.append(this.server + SPACE + item + this.lineSep);
        }
        if ((item = mevent.getAttribute("client")) != null) {
            bfr.append(this.client + SPACE + item + this.lineSep);
        }
        bfr.append(SPACE + this.getText(mevent));
        return bfr.toString();
    }
}

