/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.osgi;

import com.ibm.ffdc.config.IncidentForwarder;
import com.ibm.ffdc.provider.FfdcProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class IncidentForwarderTracker
extends ServiceTracker {
    private final FfdcProvider ffdcProvider;
    private static final Logger tracer = Logger.getLogger(IncidentForwarderTracker.class.getName());
    private static final Level LOGLEVEL = Level.INFO;

    public IncidentForwarderTracker(BundleContext context, FfdcProvider ffdcProvider) {
        super(context, IncidentForwarder.class.getName(), null);
        this.ffdcProvider = ffdcProvider;
    }

    public Object addingService(ServiceReference reference) {
        IncidentForwarder processor = (IncidentForwarder)this.context.getService(reference);
        this.ffdcProvider.register(processor);
        if (tracer.isLoggable(LOGLEVEL)) {
            tracer.logp(LOGLEVEL, ((Object)((Object)this)).getClass().getName(), "addingService", "FFDCForwarderAdded", processor);
        }
        return processor;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.ffdcProvider.deregister((IncidentForwarder)service);
        if (tracer.isLoggable(LOGLEVEL)) {
            tracer.logp(LOGLEVEL, ((Object)((Object)this)).getClass().getName(), "addingService", "FFDCForwarderRemoved", service);
        }
    }
}

