/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.osgi;

import com.ibm.ffdc.config.Formatter;
import com.ibm.ffdc.provider.FfdcProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class FormatterTracker
extends ServiceTracker {
    private static final String thisClass = ServiceTracker.class.getName();
    private final FfdcProvider ffdcProvider;
    private static final Logger tracer = Logger.getLogger(thisClass, "com.ibm.ffdc.FFDCBundleMessages");
    private static final Level LOGLEVEL = Level.INFO;

    public FormatterTracker(BundleContext context, FfdcProvider ffdcProvider) {
        super(context, Formatter.class.getName(), null);
        this.ffdcProvider = ffdcProvider;
    }

    public Object addingService(ServiceReference reference) {
        Formatter formatter = (Formatter)this.context.getService(reference);
        this.ffdcProvider.register(formatter);
        if (tracer.isLoggable(LOGLEVEL)) {
            tracer.logp(LOGLEVEL, thisClass, "addingService", "FFDCAddedFormatter", formatter);
        }
        return formatter;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.ffdcProvider.deregister((Formatter)service);
        if (tracer.isLoggable(LOGLEVEL)) {
            tracer.logp(LOGLEVEL, thisClass, "removedService", "FFDCRemovedFormatter", service);
        }
    }
}

