/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.tran;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.ejs.util.tran.SyncDriver;
import com.ibm.ejs.util.tran.SyncDriverCreationFailure;
import com.ibm.ejs.util.tran.TxSync;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

public class SyncDriverFactory
implements TxSync {
    private static final TraceComponent tc = Tr.register(SyncDriverFactory.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.tran.SyncDriverFactory";
    private FastHashtable syncDrivers = new FastHashtable(255);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncDriver create(UOWCoordinator uowCoord) throws SyncDriverCreationFailure {
        SyncDriver sd = null;
        Object bucket = null;
        Object object = bucket = this.syncDrivers.getLock((Object)uowCoord);
        synchronized (bucket) {
            sd = (SyncDriver)this.syncDrivers.get(bucket, (Object)uowCoord);
            if (sd == null) {
                sd = new SyncDriver(uowCoord, (TxSync)this);
                try {
                    if (uowCoord.isGlobal()) {
                        ((Transaction)uowCoord).registerSynchronization(sd);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Registered syncDriver with global tx", sd);
                        }
                    } else {
                        ((LocalTransactionCoordinator)uowCoord).enlistSynchronization((Synchronization)sd);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Registered syncDriver with local tx", sd);
                        }
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ejs.util.tran.SyncDriverFactory.create", "111", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Failed to register syncDriver with UOWCoord", ex);
                    }
                    throw new SyncDriverCreationFailure(ex);
                }
                this.syncDrivers.put(bucket, (Object)uowCoord, (Object)sd);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return sd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncDriver create(Transaction globalTxCoord) throws SyncDriverCreationFailure {
        SyncDriver sd = null;
        Object bucket = null;
        Object object = bucket = this.syncDrivers.getLock((Object)globalTxCoord);
        synchronized (bucket) {
            sd = (SyncDriver)this.syncDrivers.get(bucket, (Object)globalTxCoord);
            if (sd == null) {
                sd = new SyncDriver(globalTxCoord, (TxSync)this);
                try {
                    globalTxCoord.registerSynchronization(sd);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Registered syncDriver with global tx", sd);
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ejs.util.tran.SyncDriverFactory.create", "102", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Failed to register syncDriver with global tx", ex);
                    }
                    throw new SyncDriverCreationFailure(ex);
                }
                this.syncDrivers.put(bucket, (Object)globalTxCoord, (Object)sd);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return sd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncDriver create(LocalTransactionCoordinator localTxCoord) throws SyncDriverCreationFailure {
        SyncDriver sd = null;
        Object bucket = null;
        Object object = bucket = this.syncDrivers.getLock((Object)localTxCoord);
        synchronized (bucket) {
            sd = (SyncDriver)this.syncDrivers.get(bucket, (Object)localTxCoord);
            if (sd == null) {
                sd = new SyncDriver(localTxCoord, (TxSync)this);
                try {
                    localTxCoord.enlistSynchronization((Synchronization)sd);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Registered syncDriver with local tx", sd);
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ejs.util.tran.SyncDriverFactory.create", "137", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Failed to register syncDriver with local tx", ex);
                    }
                    throw new SyncDriverCreationFailure(ex);
                }
                this.syncDrivers.put(bucket, (Object)localTxCoord, (Object)sd);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return sd;
        }
    }

    public void beforeCompletion() {
    }

    public void beforeCompletionFinally() throws Exception {
    }

    public void afterCompletion(boolean committed, Object tx) {
        if (this.syncDrivers.remove(tx) == null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Unknown transaction completed", tx);
        }
    }
}

