/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa;

import com.ibm.ejs.oa.InvalidUserKeyException;
import com.ibm.ejs.oa.Utility;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;

public final class UserKey
extends ByteArray
implements Cloneable,
com.ibm.CORBA.iiop.UserKey {
    public static final int MAGIC_OFFSET = 0;
    public static final int VERSION_OFFSET = 4;
    public static final int REFTYPE_OFFSET = 5;
    public static final int HASH_OFFSET = 6;
    public static final int NAME_LENGTH_OFFSET_V1 = 6;
    public static final int NAME_LENGTH_OFFSET_V2 = 10;
    public static int NAME_LENGTH_OFFSET = 10;
    public static final int NAME_OFFSET_V1 = 7;
    public static final int NAME_OFFSET_V2 = 11;
    public static int NAME_OFFSET;
    public static int HEADER_LENGTH;
    public static final int NAME_LENGTH_SIZE = 1;
    public static final int OA_NAME_LENGTH_SIZE = 1;
    public static final int SERVANT_NAME_LENGTH_SIZE = 4;
    public static final byte PLAIN_REF = 0;
    public static final byte SGAWARE_REF = 1;
    public static final int MAGIC = 1229277776;
    public static final byte VERSION_1 = 1;
    public static final byte VERSION_2 = 2;
    public static byte VERSION;
    private static final TraceComponent tc;

    public static void enableVersion1CompatibilityMode() {
        VERSION = 1;
        NAME_LENGTH_OFFSET = 6;
        HEADER_LENGTH = NAME_OFFSET = 7;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ObjectIDVersionCompatibility = 1");
        }
    }

    public UserKey(String rootName, boolean sgAware, byte[] oaPrefix, byte[] objKey) throws InvalidUserKeyException {
        byte[] rootKey = rootName.getBytes();
        if (rootKey.length > 127) {
            throw new InvalidUserKeyException("Server/group name too long.");
        }
        if (oaPrefix.length > 127) {
            throw new InvalidUserKeyException("Object adapter prefix too long.");
        }
        byte[] key = new byte[this.computeKeyLength(rootKey.length, oaPrefix.length, objKey.length)];
        Utility.intToBytes(1229277776, key, 0);
        key[4] = VERSION;
        key[5] = sgAware ? (byte)1 : 0;
        key[UserKey.NAME_LENGTH_OFFSET] = (byte)rootKey.length;
        System.arraycopy(rootKey, 0, key, NAME_OFFSET, rootKey.length);
        key[UserKey.getOAKeyLengthOffset((byte[])key)] = (byte)oaPrefix.length;
        System.arraycopy(oaPrefix, 0, key, UserKey.getOAKeyOffset(key), oaPrefix.length);
        Utility.intToBytes(objKey.length, key, UserKey.getServantKeyLengthOffset(key));
        System.arraycopy(objKey, 0, key, UserKey.getServantKeyOffset(key), objKey.length);
        this.updateBytes(key, UserKey.getServantKeyOffset(key));
        if (VERSION >= 2) {
            Utility.intToBytes(this.hashCode(), key, 6);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>[1] : length = " + key.length + ", " + "version = " + this.getVersionNumber() + ", " + this.getWLMObjectRefTypeString() + ", hashcode = " + this.hashCode() + ", Server = " + this.getName() + ", ObjectAdapter = " + this.getOAName(), this.data);
        }
    }

    public UserKey(byte[] rootKey, boolean sgAware, byte[] oaPrefix, byte[] objKey) throws InvalidUserKeyException {
        if (rootKey.length > 127) {
            throw new InvalidUserKeyException("Server/group name too long.");
        }
        if (oaPrefix.length > 127) {
            throw new InvalidUserKeyException("Object adapter prefix too long.");
        }
        byte[] key = new byte[this.computeKeyLength(rootKey.length, oaPrefix.length, objKey.length)];
        Utility.intToBytes(1229277776, key, 0);
        key[4] = VERSION;
        key[5] = sgAware ? (byte)1 : 0;
        key[UserKey.NAME_LENGTH_OFFSET] = (byte)rootKey.length;
        System.arraycopy(rootKey, 0, key, NAME_OFFSET, rootKey.length);
        key[UserKey.getOAKeyLengthOffset((byte[])key)] = (byte)oaPrefix.length;
        System.arraycopy(oaPrefix, 0, key, UserKey.getOAKeyOffset(key), oaPrefix.length);
        Utility.intToBytes(objKey.length, key, UserKey.getServantKeyLengthOffset(key));
        System.arraycopy(objKey, 0, key, UserKey.getServantKeyOffset(key), objKey.length);
        this.updateBytes(key, UserKey.getServantKeyOffset(key));
        if (VERSION >= 2) {
            Utility.intToBytes(this.hashCode(), key, 6);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>[2] : length = " + key.length + ", " + "version = " + this.getVersionNumber() + ", " + this.getWLMObjectRefTypeString() + ", hashcode = " + this.hashCode() + ", Server = " + this.getName() + ", ObjectAdapter = " + this.getOAName(), this.data);
        }
    }

    public UserKey(byte[] rootKey, boolean sgAware, byte[] oaPrefix, ByteArray objKey) throws InvalidUserKeyException {
        if (rootKey.length > 127) {
            throw new InvalidUserKeyException("Server/group name too long.");
        }
        if (oaPrefix.length > 127) {
            throw new InvalidUserKeyException("Object adapter prefix too long.");
        }
        byte[] key = new byte[this.computeKeyLength(rootKey.length, oaPrefix.length, objKey.length())];
        Utility.intToBytes(1229277776, key, 0);
        key[4] = VERSION;
        key[5] = sgAware ? (byte)1 : 0;
        key[UserKey.NAME_LENGTH_OFFSET] = (byte)rootKey.length;
        System.arraycopy(rootKey, 0, key, NAME_OFFSET, rootKey.length);
        key[UserKey.getOAKeyLengthOffset((byte[])key)] = (byte)oaPrefix.length;
        System.arraycopy(oaPrefix, 0, key, UserKey.getOAKeyOffset(key), oaPrefix.length);
        byte[] objKeyBytes = objKey.getBytes();
        Utility.intToBytes(objKeyBytes.length, key, UserKey.getServantKeyLengthOffset(key));
        System.arraycopy(objKeyBytes, 0, key, UserKey.getServantKeyOffset(key), objKeyBytes.length);
        this.updateBytes(key, UserKey.getServantKeyOffset(key), objKey.hashCode());
        if (VERSION >= 2) {
            Utility.intToBytes(this.hashCode(), key, 6);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>[3] : length = " + key.length + ", " + "version = " + this.getVersionNumber() + ", " + this.getWLMObjectRefTypeString() + ", hashcode = " + this.hashCode() + ", Server = " + this.getName() + ", ObjectAdapter = " + this.getOAName(), this.data);
        }
    }

    public UserKey(byte[] key) throws InvalidUserKeyException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", key);
        }
        this.data = key;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "length    : " + key.length);
        }
        if (this.getMagicNumber() != 1229277776) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: EyeCatcher " + this.getMagicNumber() + " not supported.");
            }
            throw new InvalidUserKeyException("EyeCatcher " + this.getMagicNumber() + " not supported.");
        }
        byte thisVersion = this.getVersionNumber();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "version   : " + thisVersion);
        }
        if (thisVersion > 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: Version " + thisVersion + " not supported.");
            }
            throw new InvalidUserKeyException("Version " + thisVersion + " not supported.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "refType   : " + this.getWLMObjectRefTypeString());
        }
        if (this.getWLMObjectRefType() != 0 && this.getWLMObjectRefType() != 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: Ref Type " + this.getWLMObjectRefType() + " not supported.");
            }
            throw new InvalidUserKeyException("Ref Type " + this.getWLMObjectRefType() + " not supported.");
        }
        if (thisVersion > 1) {
            int hashValue = this.getHashValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "hashcode  : " + hashValue);
            }
            if (VERSION == 1) {
                byte[] vkey = new byte[key.length - 4];
                System.arraycopy(key, 0, vkey, 0, 6);
                System.arraycopy(key, 10, vkey, 6, key.length - 10);
                key = vkey;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Compatibility Mode : Version 2 -> Version 1");
                }
            }
            this.updateBytes(key, UserKey.getServantKeyOffset(key), hashValue);
        } else if (VERSION == 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Compatibility Mode : Version 1 -> Version 1");
            }
            this.updateBytes(key, UserKey.getServantKeyOffset(key));
        } else {
            byte[] vkey = new byte[key.length + 4];
            System.arraycopy(key, 0, vkey, 0, 6);
            System.arraycopy(key, 6, vkey, 10, key.length - 6);
            key = vkey;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Converted : Version 1 -> Version 2");
            }
            this.updateBytes(key, UserKey.getServantKeyOffset(key));
            Utility.intToBytes(this.hashCode(), key, 6);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "hashcode  : " + this.getHashValue());
            }
        }
        if (this.data[NAME_LENGTH_OFFSET] < 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: Server/Group name length " + this.data[NAME_LENGTH_OFFSET] + " not supported.");
            }
            throw new InvalidUserKeyException("Server/Group name length " + this.data[NAME_LENGTH_OFFSET] + " not supported.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Server    : " + this.getName());
        }
        if (this.getOAKeyLength() < 1 || this.getOAKeyOffset() + this.getOAKeyLength() >= key.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: ObjectAdapter length " + this.getOAKeyLength() + ", or offset " + this.getOAKeyOffset() + " not supported.");
            }
            throw new InvalidUserKeyException("ObjectAdapter length " + this.getOAKeyLength() + ", or offset " + this.getOAKeyOffset() + " not supported.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OA Name   : " + this.getOAName());
        }
        if (this.getServantKeyLength() < 1 || this.getServantKeyOffset() + this.getServantKeyLength() != key.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "<init> : InvalidUserKeyException: Servant Key length " + this.getServantKeyLength() + ", or offset " + this.getServantKeyOffset() + " not supported.");
            }
            throw new InvalidUserKeyException("Servant Key length " + this.getServantKeyLength() + ", or offset " + this.getServantKeyOffset() + " not supported.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    private UserKey(UserKey u) {
        super((ByteArray)u);
    }

    public Object clone() {
        return new UserKey(this);
    }

    public byte[] getOAKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOAKey");
        }
        byte[] key = new byte[this.getOAKeyLength()];
        System.arraycopy(this.data, this.getOAKeyOffset(), key, 0, key.length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOAKey", key);
        }
        return key;
    }

    public byte[] getServantKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServantKey");
        }
        byte[] key = new byte[this.getServantKeyLength()];
        System.arraycopy(this.data, this.getServantKeyOffset(), key, 0, key.length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServantKey", key);
        }
        return key;
    }

    public int getMagicNumber() {
        return Utility.bytesToInt(this.data, 0);
    }

    public byte getVersionNumber() {
        return this.data[4];
    }

    public byte getWLMObjectRefType() {
        return this.data[5];
    }

    private String getWLMObjectRefTypeString() {
        if (this.data[5] == 0) {
            return "PLAIN_REF";
        }
        if (this.data[5] == 1) {
            return "SGAWARE_REF";
        }
        return "INVALID:" + this.data[5];
    }

    public int getHashValue() {
        return Utility.bytesToInt(this.data, 6);
    }

    public String getName() {
        return new String(this.data, NAME_OFFSET, (int)this.data[NAME_LENGTH_OFFSET]);
    }

    public String getOAName() {
        return new String(this.data, this.getOAKeyOffset(), (int)this.getOAKeyLength());
    }

    public void setPlainRef(String name2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setPlainRef : " + name2);
        }
        this.data[5] = 0;
        if (name2 != null) {
            this.setName(name2);
        }
    }

    public void setName(String name2) {
        if (!name2.equals(this.getName())) {
            byte[] nameByteArr = name2.getBytes();
            if (nameByteArr.length != this.data[NAME_LENGTH_OFFSET]) {
                byte[] newKey = new byte[this.computeKeyLength(nameByteArr.length, this.getOAKeyLength(), this.getServantKeyLength())];
                System.arraycopy(this.data, 0, newKey, 0, HEADER_LENGTH);
                System.arraycopy(this.data, this.getOAKeyLengthOffset(), newKey, NAME_OFFSET + nameByteArr.length, this.data.length - this.getOAKeyLengthOffset());
                newKey[UserKey.NAME_LENGTH_OFFSET] = (byte)nameByteArr.length;
                this.data = newKey;
            }
            System.arraycopy(nameByteArr, 0, this.data, NAME_OFFSET, nameByteArr.length);
        }
    }

    public final boolean equals(Object o) {
        try {
            ByteArray array = (ByteArray)o;
            return this.regionMatches(UserKey.getOAKeyLengthOffset(this.data), array);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public final boolean equals(com.ibm.CORBA.iiop.UserKey o) {
        try {
            ByteArray array = (ByteArray)o;
            return this.regionMatches(UserKey.getOAKeyLengthOffset(this.data), array);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public final boolean equals(ByteArray array) {
        return this.regionMatches(UserKey.getOAKeyLengthOffset(this.data), array);
    }

    public void dump() {
        Tr.debug(tc, "UserKey dump : ", new Object[]{new Integer(this.getMagicNumber()), new Byte(this.getVersionNumber()), new Byte(this.getWLMObjectRefType()), new Integer(this.getHashValue()), this.getName(), this.getOAName(), super.toString()});
    }

    private static final int getOAKeyLengthOffset(byte[] key) {
        return NAME_OFFSET + key[NAME_LENGTH_OFFSET];
    }

    private static final int getOAKeyOffset(byte[] key) {
        return UserKey.getOAKeyLengthOffset(key) + 1;
    }

    private static final byte getOAKeyLength(byte[] key) {
        return key[UserKey.getOAKeyLengthOffset(key)];
    }

    private static final int getServantKeyLengthOffset(byte[] key) {
        return UserKey.getOAKeyOffset(key) + UserKey.getOAKeyLength(key);
    }

    private static final int getServantKeyOffset(byte[] key) {
        return UserKey.getServantKeyLengthOffset(key) + 4;
    }

    private static final int getServantKeyLength(byte[] key) {
        return Utility.bytesToInt(key, UserKey.getServantKeyLengthOffset(key));
    }

    private int getOAKeyLengthOffset() {
        return UserKey.getOAKeyLengthOffset(this.data);
    }

    private int getOAKeyOffset() {
        return UserKey.getOAKeyOffset(this.data);
    }

    private byte getOAKeyLength() {
        return UserKey.getOAKeyLength(this.data);
    }

    private int getServantKeyLengthOffset() {
        return UserKey.getServantKeyLengthOffset(this.data);
    }

    private int getServantKeyOffset() {
        return UserKey.getServantKeyOffset(this.data);
    }

    private int getServantKeyLength() {
        return UserKey.getServantKeyLength(this.data);
    }

    private int computeKeyLength(int serverKeyLen, int oaKeyLen, int servantKeyLen) {
        return HEADER_LENGTH + serverKeyLen + oaKeyLen + 1 + servantKeyLen + 4;
    }

    static {
        HEADER_LENGTH = NAME_OFFSET = 11;
        VERSION = (byte)2;
        tc = Tr.register(UserKey.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");
    }
}

