/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.HCMDetails;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;

public final class HandleList
implements Serializable {
    protected static final Object lockObject = new Object();
    protected static ArrayList orphanedHandles = new ArrayList();
    protected static Vector _noContextHandles = new Vector();
    private ArrayList handleList = new ArrayList();
    private boolean destroyed = false;
    private static final TraceComponent tc = Tr.register(HandleList.class, "WAS.j2c", "com.ibm.ejs.resources.J2CAMessages");
    private static final long serialVersionUID = -4425328702653290017L;

    public void add(HCMDetails a) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "add HCMDetails");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "adding handle " + a._handle);
        }
        this.handleList.add(a);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug(tc, "  handleList size " + this.handleList.size() + " _noContextHandles size " + _noContextHandles.size() + "  orphanedHandles size " + orphanedHandles.size());
        }
        Tr.exit(tc, "add HCMDetails");
    }

    public void removeConnections(Object mcw) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeConnections");
        }
        for (int i = this.handleList.size() - 1; i >= 0; --i) {
            HCMDetails hcmd = (HCMDetails)this.handleList.get(i);
            if (hcmd._mcWrapper != mcw) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing HCMDetails for MCWrapper " + mcw);
            }
            this.handleList.remove(i);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug(tc, "  handleList size " + this.handleList.size() + " _noContextHandles size " + _noContextHandles.size() + "  orphanedHandles size " + orphanedHandles.size());
            Tr.exit(tc, "removeConnections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object r) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "remove");
        }
        if (!this.destroyed) {
            for (int index = this.handleList.size() - 1; index >= 0; --index) {
                HCMDetails hcmd = (HCMDetails)this.handleList.get(index);
                if (!hcmd._handle.equals(r)) continue;
                this.handleList.remove(index);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.debug(tc, "  handleList size " + this.handleList.size() + " _noContextHandles size " + _noContextHandles.size() + "  orphanedHandles size " + orphanedHandles.size());
                    Tr.exit(tc, "remove, handle removed " + hcmd._handle);
                }
                return;
            }
            if (_noContextHandles.remove(r)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "  handleList size " + this.handleList.size() + " _noContextHandles size " + _noContextHandles.size() + "  orphanedHandles size " + orphanedHandles.size());
                    Tr.exit(tc, "remove, handle removed" + r + ".  from _noContextHandles");
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "HandleList does not contain the handle attempting to be removed: " + r + ".  Adding to orphanedHandles");
            }
            Object object = lockObject;
            synchronized (object) {
                orphanedHandles.add(r);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "This connection handle was added to orphanedHandles: " + r);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Ignoring remove request.  This is ok as it is being destroyed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug(tc, "  handleList size " + this.handleList.size() + " _noContextHandles size " + _noContextHandles.size() + "  orphanedHandles size " + orphanedHandles.size());
            Tr.exit(tc, "remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        this.destroyed = true;
        for (int index = this.handleList.size() - 1; index >= 0; --index) {
            try {
                HCMDetails hcmd = (HCMDetails)this.handleList.get(index);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Closing cached handle " + hcmd._handle);
                }
                if (hcmd._handle instanceof Connection) {
                    ((Connection)hcmd._handle).close();
                } else if (hcmd._handle instanceof javax.jms.Connection) {
                    ((javax.jms.Connection)hcmd._handle).close();
                } else if (hcmd._handle instanceof javax.resource.cci.Connection) {
                    ((javax.resource.cci.Connection)hcmd._handle).close();
                } else {
                    try {
                        Method m = hcmd._handle.getClass().getMethod("close", null);
                        m.invoke(hcmd._handle, (Object[])null);
                    }
                    catch (Exception e) {
                        Tr.debug(tc, "Troubles with introspection while closing connection handles, exception = " + e);
                    }
                }
                Object e = lockObject;
                synchronized (e) {
                    int oListSize = orphanedHandles.size();
                    if (oListSize > 0 && orphanedHandles.remove(hcmd._handle) && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing handle from  orphanedHandles list because handlelist that contains this handle is being destroyed");
                        Tr.debug(tc, "orphanedHandles list size before remove: " + oListSize);
                        Tr.debug(tc, "orphanedHandles list size after remove:  " + orphanedHandles.size());
                    }
                    continue;
                }
            }
            catch (Exception e) {
                Tr.debug(tc, "Troubles with closing connection handles, exception = " + e);
            }
        }
        this.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reAssociate() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reAssociate");
        }
        for (int i = 0; i < this.handleList.size(); ++i) {
            Object[] parms;
            HCMDetails hcmd = (HCMDetails)this.handleList.get(i);
            int orphanIndex = orphanedHandles.indexOf(hcmd._handle);
            if (orphanIndex >= 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "reAssociate: handle found in orphanedHandles");
                }
                this.handleList.remove(i);
                --i;
                Object object = lockObject;
                synchronized (object) {
                    orphanedHandles.remove(orphanIndex);
                    continue;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "reAssociate " + hcmd._handle);
            }
            try {
                hcmd._cm.reAssociate(hcmd);
                continue;
            }
            catch (IllegalStateException e) {
                parms = new Object[]{"reAssociate", "reAssociate", hcmd._handle, e};
                Tr.warning(tc, "PARK_OR_REASSOCIATE_FAILED_W_J2CA0083", parms);
                continue;
            }
            catch (Exception e) {
                parms = new Object[]{"reAssociate", "reAssociate", hcmd._handle, e};
                Tr.warning(tc, "PARK_OR_REASSOCIATE_FAILED_W_J2CA0083", parms);
                FFDCFilter.processException((Throwable)e, "com.ibm.ejs.j2c.HandleList.reAssociate", "297", this);
                ResourceException re = new ResourceException("Reassociate call Failed");
                re.initCause(e);
                throw re;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reAssociate");
        }
    }

    public void parkHandle() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "parkHandle");
        }
        for (int i = 0; i < this.handleList.size(); ++i) {
            Object[] parms;
            HCMDetails hcmd = (HCMDetails)this.handleList.get(i);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "....parking " + hcmd._handle);
            }
            try {
                hcmd._cm.parkHandle(hcmd);
                continue;
            }
            catch (IllegalStateException e) {
                parms = new Object[]{"parkHandle", "parkHandle", hcmd._handle, e};
                Tr.warning(tc, "PARK_OR_REASSOCIATE_FAILED_W_J2CA0083", parms);
                continue;
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "parkHandle: error");
                }
                parms = new Object[]{"parkHandle", "parkHandle", hcmd._handle, e};
                Tr.warning(tc, "PARK_OR_REASSOCIATE_FAILED_W_J2CA0083", parms);
                FFDCFilter.processException((Throwable)e, "com.ibm.ejs.j2c.HandleList.parkHandle", "373", this);
                ResourceException re = new ResourceException("parkHandle call Failed");
                re.initCause(e);
                throw re;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "parkHandle");
        }
    }

    public void printAllHandles() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "printAllHandles");
        }
        for (int index = this.handleList.size() - 1; index >= 0; --index) {
            HCMDetails hcmd = (HCMDetails)this.handleList.get(index);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "...." + hcmd._handle);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "printAllHandles");
        }
    }

    public void componentDestroyed() {
        int size = this.handleList.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "componentDestroyed");
        }
        if (size > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Closing " + size + " cached handle(s) at the end of boundary.");
            }
            this.close();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "componentDestroyed");
        }
    }

    private void clear() {
        this.destroyed = false;
        this.handleList.clear();
    }

    public boolean findHandle(Object handle) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findHandle");
        }
        boolean found = false;
        for (int i = this.handleList.size() - 1; i >= 0; --i) {
            HCMDetails hcmd = (HCMDetails)this.handleList.get(i);
            if (!hcmd._handle.equals(handle)) continue;
            found = true;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findHandle: " + found);
        }
        return found;
    }
}

