/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.csi.ResRef;
import com.ibm.ws.security.util.AccessController;
import org.eclipse.emf.common.util.EList;

public class ResRefImpl
implements ResRef {
    private String _description;
    private String _name;
    private String _type;
    private String _jndiName;
    private int _commitPriority;
    private int _resAuth;
    private int _resSharingScope;
    private int _resIsolationLevel;
    private String _loginConfigurationName;
    private EList _loginProperties;
    private final String application = "APPLICATION";
    private final String container = "CONTAINER";
    private final String shareable = "SHAREABLE";
    private final String unshare = "UNSHAREABLE";
    private final String transaction_none = "TRANSACTION_NONE";
    private final String read_uncommitted = "TRANSACTION_READ_UNCOMMITTED";
    private final String read_committed = "TRANSACTION_READ_COMMITTED";
    private final String repeatable_read = "TRANSACTION_REPEATABLE_READ";
    private final String serializable = "TRANSACTION_SERIALIZABLE";

    public ResRefImpl(String description, String name2, String jndiName, String type, int resAuth, int resSharingScope, int resIsolationLevel) {
        this.initialize(description, name2, jndiName, type, resAuth, resSharingScope, resIsolationLevel, null, null);
    }

    public ResRefImpl(String description, String name2, String jndiName, String type, int resAuth, int resSharingScope, int resIsolationLevel, String loginConfigurationName, EList loginProperties) {
        this.initialize(description, name2, jndiName, type, resAuth, resSharingScope, resIsolationLevel, loginConfigurationName, loginProperties);
    }

    public ResRefImpl(String name2, String jndiName, String loginConfigurationName, EList loginProperties) {
        this.initialize("Data From JAXB ResourceRefType", name2, jndiName, null, 0, 0, 0, loginConfigurationName, loginProperties);
    }

    public ResRefImpl(ResRef rri) {
        this.initialize(rri.getDescription(), rri.getName(), rri.getJNDIName(), rri.getType(), rri.getAuth(), rri.getSharingScope(), rri.getIsolationLevel(), rri.getLoginConfigurationName(), rri.getLoginProperties());
    }

    private void initialize(String description, String name2, String jndiName, String type, int resAuth, int resSharingScope, int resIsolationLevel, String loginConfigurationName, EList loginProperties) {
        this._description = description;
        this._name = name2;
        this._type = type;
        this._jndiName = jndiName;
        this._resAuth = resAuth == 0 ? 0 : 1;
        this._resSharingScope = resSharingScope;
        this._resIsolationLevel = resIsolationLevel;
        this._loginConfigurationName = loginConfigurationName;
        this._loginProperties = loginProperties;
    }

    public String getDescription() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public int getAuth() {
        return this._resAuth;
    }

    public int getSharingScope() {
        return this._resSharingScope;
    }

    public int getIsolationLevel() {
        return this._resIsolationLevel;
    }

    public String getJNDIName() {
        return this._jndiName;
    }

    public String getLoginConfigurationName() {
        return this._loginConfigurationName;
    }

    public EList getLoginProperties() {
        return this._loginProperties;
    }

    public void setIsolationLevel(int isoLevel) {
        this._resIsolationLevel = isoLevel;
    }

    public void setCommitPriority(int commitPriority) {
        this._commitPriority = commitPriority;
    }

    public int getCommitPriority() {
        return this._commitPriority;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String separator = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("line.separator", "\n"));
        String sep = "                                 ";
        sb.append(separator + sep + "    ******* Resource-Ref ******* ");
        sb.append(separator + sep + "Description=" + this._description);
        sb.append(separator + sep + "Name=" + this._name);
        sb.append(separator + sep + "JNDIName=" + this._jndiName);
        sb.append(separator + sep + "Type=" + this._type);
        if (this._resAuth == 0) {
            sb.append(separator + sep + "ResAuth=" + "CONTAINER");
        } else {
            sb.append(separator + sep + "ResAuth=" + "APPLICATION");
        }
        if (this._resSharingScope == 0) {
            sb.append(separator + sep + "ResSharingScope=" + "SHAREABLE");
        } else {
            sb.append(separator + sep + "ResSharingScope=" + "UNSHAREABLE");
        }
        if (this._resIsolationLevel == 1) {
            sb.append(separator + sep + "IsolationLevel=" + "TRANSACTION_READ_UNCOMMITTED");
        } else if (this._resIsolationLevel == 2) {
            sb.append(separator + sep + "IsolationLevel=" + "TRANSACTION_READ_COMMITTED");
        } else if (this._resIsolationLevel == 4) {
            sb.append(separator + sep + "IsolationLevel=" + "TRANSACTION_REPEATABLE_READ");
        } else if (this._resIsolationLevel == 8) {
            sb.append(separator + sep + "IsolationLevel=" + "TRANSACTION_SERIALIZABLE");
        } else {
            sb.append(separator + sep + "IsolationLevel=" + "TRANSACTION_NONE");
        }
        sb.append(separator + sep + "loginConfigurationName=" + this._loginConfigurationName);
        sb.append(separator + sep + "loginProperties=" + this._loginProperties);
        sb.append(separator + sep + "CommitPriority=" + this._commitPriority);
        return sb.toString();
    }

    public final void setSharingScope(int resSharable) {
        this._resSharingScope = resSharable;
    }

    public void setResAuthType(int resAuth) {
        this._resAuth = resAuth == 0 ? 0 : 1;
    }

    public void setLoginConfigurationName(String loginConfigurationName) {
        this._loginConfigurationName = loginConfigurationName;
    }

    public void setLoginProperties(EList loginProperties) {
        this._loginProperties = loginProperties;
    }

    public void setDescription(String description) {
        this._description = description;
    }
}

