/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public abstract class TransformService
implements Transform {
    private String algorithm;
    private String mechanism;
    private Provider provider;
    private static Class cl;
    private static final Class[] getImplParams;
    private static Method getImplMethod;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map$Entry;
    static /* synthetic */ Class class$java$security$Provider;

    protected TransformService() {
    }

    public static TransformService getInstance(String algorithm, String mechanismType) throws NoSuchAlgorithmException {
        if (mechanismType == null || algorithm == null) {
            throw new NullPointerException();
        }
        return TransformService.findInstance(algorithm, mechanismType, null);
    }

    public static TransformService getInstance(String algorithm, String mechanismType, Provider provider) throws NoSuchAlgorithmException {
        if (mechanismType == null || algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        return TransformService.findInstance(algorithm, mechanismType, provider);
    }

    public static TransformService getInstance(String algorithm, String mechanismType, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (mechanismType == null || algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        Provider prov = Security.getProvider(provider);
        if (prov == null) {
            throw new NoSuchProviderException("cannot find provider named " + provider);
        }
        return TransformService.findInstance(algorithm, mechanismType, prov);
    }

    private static TransformService findInstance(String algorithm, String mechanismType, Provider provider) throws NoSuchAlgorithmException {
        if (getImplMethod == null) {
            throw new NoSuchAlgorithmException("Cannot find + algorithm:" + algorithm);
        }
        Object[] objs = null;
        try {
            objs = (Object[])getImplMethod.invoke(null, algorithm, new MechanismMapEntry(algorithm, mechanismType), "TransformService", provider);
        }
        catch (IllegalAccessException iae) {
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("Cannot find algorithm:" + algorithm).initCause(iae);
        }
        catch (InvocationTargetException ite) {
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("Cannot find algorithm:" + algorithm).initCause(ite);
        }
        TransformService spi = (TransformService)objs[0];
        spi.mechanism = mechanismType;
        spi.algorithm = algorithm;
        spi.provider = (Provider)objs[1];
        return spi;
    }

    public final String getMechanismType() {
        return this.mechanism;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract void init(TransformParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract void marshalParams(XMLStructure var1, XMLCryptoContext var2) throws MarshalException;

    public abstract void init(XMLStructure var1, XMLCryptoContext var2) throws InvalidAlgorithmParameterException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        getImplParams = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TransformService.class$("java.lang.String")) : class$java$lang$String, class$java$util$Map$Entry == null ? (class$java$util$Map$Entry = TransformService.class$("java.util.Map$Entry")) : class$java$util$Map$Entry, class$java$lang$String == null ? (class$java$lang$String = TransformService.class$("java.lang.String")) : class$java$lang$String, class$java$security$Provider == null ? (class$java$security$Provider = TransformService.class$("java.security.Provider")) : class$java$security$Provider};
        try {
            cl = Class.forName("javax.xml.crypto.dsig.XMLDSigSecurity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        getImplMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method m = null;
                try {
                    m = cl.getDeclaredMethod("getImpl", getImplParams);
                    if (m != null) {
                        m.setAccessible(true);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return m;
            }
        });
    }

    private static class MechanismMapEntry
    implements Map.Entry {
        private final String mechanism;
        private final String algorithm;

        MechanismMapEntry(String algorithm, String mechanism) {
            this.algorithm = algorithm;
            this.mechanism = mechanism;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
        }

        public Object getKey() {
            return "TransformService." + this.algorithm + " MechanismType";
        }

        public Object getValue() {
            return this.mechanism;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

