/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.jras.pdjlog.jlog;

import com.tivoli.pd.jras.pdjlog.jlog.Handler;
import com.tivoli.pd.jras.pdjlog.jlog.IConstants;
import com.tivoli.pd.jras.pdjlog.jlog.LogObject;
import com.tivoli.pd.jras.pdjlog.jlog.LogUtil;
import com.tivoli.pd.jras.pdjlog.jlog.NestedException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class FileHandler
extends Handler
implements IConstants {
    private final String M = "$Id: @(#)15  1.2 src/com/tivoli/pd/jras/pdjlog/jlog/FileHandler.java, pd.jras, am600, 050110a 04/02/23 17:57:11 @(#) $";
    private static final String N = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = 6304371609654288622L;
    private String O;
    protected String P;
    protected String Q;

    public FileHandler() {
    }

    public FileHandler(String string) {
        super(string);
    }

    public FileHandler(String string, String string2) {
        super(string, string2);
    }

    public FileHandler(String string, String string2, String string3) {
        super(string, string2);
        this.setFileName(string3);
    }

    public FileHandler(String string, String string2, String string3, String string4) {
        this(string, string2, string3);
        this.setEncoding(string4);
    }

    public void init() {
        super.init();
        this.setEncoding(null);
        this.P = null;
        this.Q = null;
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        if (this.Q != null) {
            properties.put("fileName", this.Q);
        }
        if (this.getEncoding() != null) {
            properties.put("encoding", this.getEncoding());
        }
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("fileName");
        if (string != null) {
            this.setFileName(string);
        }
        if ((string = properties.getProperty("encoding")) != null) {
            this.setEncoding(string);
        }
    }

    public String getFileName() {
        return this.P;
    }

    public void setFileName(String string) {
        if (string != null) {
            this.Q = string;
            this.P = string.replace('/', File.separatorChar);
        }
    }

    public String getEncoding() {
        return this.O;
    }

    public void setEncoding(String string) {
        this.O = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDevice() throws NestedException, AccessControlException {
        block8: {
            Object object = this.D;
            synchronized (object) {
                block7: {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) break block7;
                    this.b();
                    if (!LogObject.j) break block8;
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            FileHandler.this.b();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (NestedException)privilegedActionException.getException();
                }
            }
        }
    }

    protected void b() throws NestedException {
        this.closeDevice();
        String string = this.getFileName();
        try {
            OutputStreamWriter outputStreamWriter;
            block5: {
                String string2;
                FileOutputStream fileOutputStream;
                block4: {
                    LogUtil.makePath(string);
                    fileOutputStream = new FileOutputStream(string, true);
                    string2 = this.getEncoding();
                    if (string2 != null) break block4;
                    outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                    if (!LogObject.j) break block5;
                }
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            }
            this.H = new PrintWriter((Writer)new BufferedWriter(outputStreamWriter), true);
            this.u = true;
        }
        catch (Exception exception) {
            String string3 = LogUtil.getLogMessage("ERR_OPEN_FILE", string);
            throw new NestedException(string3, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLog() {
        block6: {
            Object object = this.D;
            synchronized (object) {
                block5: {
                    this.closeDevice();
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) break block5;
                    this.c();
                    if (!LogObject.j) break block6;
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        FileHandler.this.c();
                        return null;
                    }
                });
            }
        }
    }

    private void c() {
        File file;
        String string = this.getFileName();
        if (string != null && (file = new File(string)).exists() && !file.delete()) {
            LogUtil.errorMsg(LogUtil.getLogMessage("ERR_DELETE_FILE", string));
        }
    }

    public String toString() {
        String string = super.toString();
        return string + ", fileName=" + this.getFileName();
    }
}

