/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

abstract class SimpleEUCDecoder
extends CharsetDecoder {
    private final int SS2 = 142;
    private final int SS3 = 143;
    protected int convertType = 0;
    protected int mask = 65535;
    protected int shift = 0;
    protected static String mappingTableG1;
    protected static String byteToCharTable;

    protected SimpleEUCDecoder(Charset charset) {
        super(charset, 0.5f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n <= n2);
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        try {
            int n5;
            for (n = n <= n2 ? n : n2; n < n2; n += n5) {
                n5 = 1;
                int n6 = 65533;
                int n7 = byArray[n] & 0xFF;
                if (n7 <= 159) {
                    if (this.convertType == 2) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    n6 = byteToCharTable.charAt(n7);
                } else {
                    if (n7 < 161 || n7 > 254 && this.convertType != 2) {
                        if (this.convertType == 1) {
                            CoderResult coderResult = CoderResult.unmappableForLength(n5);
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (this.convertType == 1) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (n2 - n < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int n8 = byArray[n + 1] & 0xFF;
                    ++n5;
                    if (n8 < 161 || n8 > 254) {
                        CoderResult coderResult = CoderResult.malformedForLength(2);
                        return coderResult;
                    }
                    n6 = mappingTableG1.charAt((n7 - 161) * 94 + n8 - 161);
                }
                if (n6 == 65533) {
                    CoderResult coderResult = CoderResult.unmappableForLength(n5);
                    return coderResult;
                }
                if (n4 - n3 < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                cArray[n3++] = n6;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            charBuffer.position(n3 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.hasRemaining()) {
                char c = '\ufffd';
                int n2 = 1;
                int n3 = byteBuffer.get() & 0xFF;
                if (n3 <= 159) {
                    if (this.convertType == 2) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    c = byteToCharTable.charAt(n3);
                } else {
                    if (n3 < 161 || n3 > 254 && this.convertType != 2) {
                        if (this.convertType == 1) {
                            CoderResult coderResult = CoderResult.unmappableForLength(n2);
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (this.convertType == 1) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (!byteBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int n4 = byteBuffer.get() & 0xFF;
                    ++n2;
                    if (n4 < 161 || n4 > 254) {
                        CoderResult coderResult = CoderResult.malformedForLength(2);
                        return coderResult;
                    }
                    c = mappingTableG1.charAt((n3 - 161) * 94 + n4 - 161);
                }
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(n2);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                charBuffer.put(c);
                n += n2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

