/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

public abstract class DBCS_IBM_EBCDIC_Encoder
extends CharsetEncoder {
    protected static final char REPLACE_CHAR = '\ufffd';
    private byte b1;
    private byte b2;
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected int mask1;
    protected int mask2;
    protected int shift;
    private boolean islegal = true;
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final byte SO = 14;
    private static final byte SI = 15;
    private int currentState;
    private int convertType = 0;
    private static String swapValue;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    protected static String byteArray;
    protected static String leftPair;
    protected static String rightPair;
    protected static String bytePair;
    protected static int[] surrogateArray;
    protected static int numberOfSurrogates;
    private int savedFirstOfPairBytes;
    private char savedFirstOfPair;
    protected boolean subMode = true;
    protected char[] index = null;
    private char highHalfZoneCode = '\u0000';
    private int charOff;
    private int byteOff;
    protected int badInputLength;

    protected DBCS_IBM_EBCDIC_Encoder(Charset charset) {
        super(charset, 4.0f, 5.0f, new byte[]{111});
    }

    protected DBCS_IBM_EBCDIC_Encoder(Charset charset, byte[] byArray) {
        super(charset, 4.0f, 5.0f, new byte[]{111});
        if (null != byArray) {
            this.replaceWith(byArray);
        }
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (this.islegal) {
            return true;
        }
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    protected String setIndex2(String string, int n) {
        swapValue = System.getSecurityManager() == null ? new GetPropertyAction("ibm.swapLF").run() : AccessController.doPrivileged(new GetPropertyAction("ibm.swapLF"));
        if (Boolean.parseBoolean(swapValue)) {
            char[] cArray = string.toCharArray();
            cArray[n] = 37;
            return new String(cArray);
        }
        return string;
    }

    protected void implReset() {
        this.byteOff = 0;
        this.charOff = 0;
        this.highHalfZoneCode = '\u0000';
        this.savedFirstOfPair = '\u0000';
        this.savedFirstOfPairBytes = 0;
        if (this.convertType == 0) {
            this.currentState = 0;
        }
    }

    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        if (this.currentState == 1) {
            if (byteBuffer.remaining() < 1) {
                return CoderResult.OVERFLOW;
            }
            if (this.convertType != 2) {
                byteBuffer.put((byte)15);
            }
        }
        this.implReset();
        return CoderResult.UNDERFLOW;
    }

    public boolean canEncode(char c) {
        int n = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
        char c2 = n < 15000 ? this.index2.charAt(n) : this.index2a.charAt(n - 15000);
        if (c2 != '\u0000') {
            return true;
        }
        return c == '\u0000';
    }

    protected void setType(int n) {
        this.convertType = n;
        this.currentState = n == 2 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        try {
            int n5;
            int n6;
            int n7;
            char c;
            if (this.convertType != 0) {
                if (this.convertType == 1) {
                    CoderResult coderResult = this.convertType1(cArray, n, n2, byArray, n3, n4);
                    return coderResult;
                }
                CoderResult coderResult = this.convertType2(cArray, n, n2, byArray, n3, n4);
                return coderResult;
            }
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = n;
            int n12 = n3;
            int n13 = n2;
            int n14 = n4;
            int n15 = this.replacement().length;
            byte by = this.replacement()[0];
            byte by2 = 0;
            if (n15 > 1) {
                by2 = this.replacement()[1];
            }
            boolean bl = this.subMode;
            char[] cArray2 = this.index;
            int n16 = this.currentState;
            int n17 = 0;
            int n18 = 1;
            int n19 = 14;
            int n20 = 15;
            if ('\u0000' != this.savedFirstOfPair) {
                c = cArray[n11];
                n7 = this.getBytesForPairedCharacters(this.savedFirstOfPair, c);
                n6 = 0 != n7 ? n7 : this.savedFirstOfPairBytes;
                if (n16 == n17) {
                    if (n12 >= n14) {
                        CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                        return coderResult;
                    }
                    byArray[n12++] = n19;
                    n16 = n18;
                }
                if (n12 + 1 >= n14) {
                    CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                    return coderResult;
                }
                byArray[n12++] = (byte)((n6 & 0xFF00) >> 8);
                byArray[n12++] = (byte)(n6 & 0xFF);
                if (0 != n7) {
                    ++n11;
                }
                this.savedFirstOfPair = '\u0000';
                this.savedFirstOfPairBytes = 0;
            }
            if (this.highHalfZoneCode != '\u0000') {
                n7 = this.highHalfZoneCode;
                this.highHalfZoneCode = '\u0000';
                c = cArray[n11];
                if (c >= '\udc00' && c <= '\udfff') {
                    n5 = this.getBytesForSurrogatePair(n7, c);
                    if (0 != n5) {
                        if (n16 == n17) {
                            if (n12 >= n14) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                return coderResult;
                            }
                            byArray[n12++] = n19;
                            n16 = n18;
                        }
                        if (n12 + 1 >= n14) {
                            CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                            return coderResult;
                        }
                        byArray[n12++] = (byte)((n5 & 0xFF00) >> 8);
                        byArray[n12++] = (byte)(n5 & 0xFF);
                    } else {
                        if (!bl) {
                            CoderResult coderResult = this.throwUnknownCharacterException(n11, n12, n16, 2);
                            return coderResult;
                        }
                        if (n15 == 1) {
                            if (n16 != n17) {
                                if (n12 >= n14) {
                                    CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                    return coderResult;
                                }
                                byArray[n12++] = n20;
                                n16 = n17;
                            }
                            if (n12 >= n14) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                return coderResult;
                            }
                            byArray[n12++] = by;
                        } else {
                            if (n16 == n17) {
                                if (n12 >= n14) {
                                    CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                    return coderResult;
                                }
                                byArray[n12++] = n19;
                                n16 = n18;
                            }
                            if (n12 + 1 >= n14) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                return coderResult;
                            }
                            byArray[n12++] = by;
                            byArray[n12++] = by2;
                        }
                    }
                    ++n11;
                } else {
                    CoderResult coderResult = this.throwMalformedInputException(n11, n12, n16, 0);
                    return coderResult;
                }
            }
            if (n16 == n17) {
                n9 = n14 - n12;
                n8 = n13 - n11;
                int n21 = n10 = n9 < n8 ? n11 + n9 : n13;
                while (n11 < n10 && (n6 = cArray2[c = cArray[n11]]) < 256) {
                    byArray[n12++] = (byte)n6;
                    ++n11;
                }
            }
            if (n11 < n13) {
                n9 = (n14 - n12) / 3;
                n8 = n13 - n11;
                int n22 = n10 = n9 < n8 ? n11 + n9 : n13;
                while (n11 < n10) {
                    c = cArray[n11];
                    n6 = cArray2[c];
                    if (n6 < 256) {
                        if (n16 != n17) {
                            byArray[n12++] = n20;
                            n16 = n17;
                        }
                        byArray[n12++] = (byte)n6;
                    } else {
                        if (n6 < 65534 && this.isFirstOfAPair(c)) break;
                        if (n6 < 65534) {
                            if (n16 == n17) {
                                byArray[n12++] = n19;
                                n16 = n18;
                            }
                            byArray[n12++] = (byte)(n6 >> 8);
                            byArray[n12++] = (byte)(n6 & 0xFF);
                        } else {
                            if (n6 != 65535) break;
                            if (!bl) {
                                CoderResult coderResult = this.throwUnknownCharacterException(n11, n12, n16, 1);
                                return coderResult;
                            }
                            if (n15 == 1) {
                                if (n16 != n17) {
                                    byArray[n12++] = n20;
                                    n16 = n17;
                                }
                                byArray[n12++] = by;
                            } else {
                                if (n16 == n17) {
                                    byArray[n12++] = n19;
                                    n16 = n18;
                                }
                                byArray[n12++] = by;
                                byArray[n12++] = by2;
                            }
                        }
                    }
                    ++n11;
                }
                while (n11 < n13) {
                    c = cArray[n11];
                    n6 = cArray2[c];
                    if (n6 < 256) {
                        if (n16 != n17) {
                            if (n12 >= n14) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                return coderResult;
                            }
                            byArray[n12++] = n20;
                            n16 = n17;
                        }
                        if (n12 >= n14) {
                            CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                            return coderResult;
                        }
                        byArray[n12++] = (byte)n6;
                    } else if (this.isFirstOfAPair(c) && n11 + 1 >= n13) {
                        this.savedFirstOfPair = c;
                        this.savedFirstOfPairBytes = n6;
                    } else if (n6 < 65534) {
                        if (this.isFirstOfAPair(c) && 0 != (n5 = this.getBytesForPairedCharacters(c, (char)(n7 = cArray[n11 + 1])))) {
                            n6 = n5;
                            ++n11;
                        }
                        if (n16 == n17) {
                            if (n12 >= n14) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                return coderResult;
                            }
                            byArray[n12++] = n19;
                            n16 = n18;
                        }
                        if (n12 + 1 >= n14) {
                            CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                            return coderResult;
                        }
                        byArray[n12++] = (byte)(n6 >> 8);
                        byArray[n12++] = (byte)(n6 & 0xFF);
                    } else if (n6 == 65535) {
                        if (!bl) {
                            CoderResult coderResult = this.throwUnknownCharacterException(n11, n12, n16, 1);
                            return coderResult;
                        }
                        if (n15 == 1) {
                            if (n16 != n17) {
                                if (n12 >= n14) {
                                    CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                    return coderResult;
                                }
                                byArray[n12++] = n20;
                                n16 = n17;
                            }
                            if (n12 >= n14) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                return coderResult;
                            }
                            byArray[n12++] = by;
                        } else {
                            if (n16 == n17) {
                                if (n12 >= n14) {
                                    CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                    return coderResult;
                                }
                                byArray[n12++] = n19;
                                n16 = n18;
                            }
                            if (n12 + 1 >= n14) {
                                CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                return coderResult;
                            }
                            byArray[n12++] = by;
                            byArray[n12++] = by2;
                        }
                    } else {
                        if (c >= '\udc00') {
                            CoderResult coderResult = this.throwMalformedInputException(n11, n12, n16, 1);
                            return coderResult;
                        }
                        n7 = c;
                        if (n11 + 1 >= n13) {
                            this.highHalfZoneCode = c;
                        } else {
                            c = cArray[n11 + 1];
                            if (c >= '\udc00' && c <= '\udfff') {
                                n5 = this.getBytesForSurrogatePair(n7, c);
                                if (0 != n5) {
                                    if (n16 == n17) {
                                        if (n12 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                            return coderResult;
                                        }
                                        byArray[n12++] = n19;
                                        n16 = n18;
                                    }
                                    if (n12 + 1 >= n14) {
                                        CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                        return coderResult;
                                    }
                                    byArray[n12++] = (byte)((n5 & 0xFF00) >> 8);
                                    byArray[n12++] = (byte)(n5 & 0xFF);
                                    ++n11;
                                } else {
                                    if (!bl) {
                                        CoderResult coderResult = this.throwUnknownCharacterException(n11, n12, n16, 2);
                                        return coderResult;
                                    }
                                    if (n15 == 1) {
                                        if (n16 != n17) {
                                            if (n12 >= n14) {
                                                CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                                return coderResult;
                                            }
                                            byArray[n12++] = n20;
                                            n16 = n17;
                                        }
                                        if (n12 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                            return coderResult;
                                        }
                                        byArray[n12++] = by;
                                    } else {
                                        if (n16 == n17) {
                                            if (n12 >= n14) {
                                                CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                                return coderResult;
                                            }
                                            byArray[n12++] = n19;
                                            n16 = n18;
                                        }
                                        if (n12 + 1 >= n14) {
                                            CoderResult coderResult = this.throwConversionBufferFullException(n11, n12, n16);
                                            return coderResult;
                                        }
                                        byArray[n12++] = by;
                                        byArray[n12++] = by2;
                                    }
                                    ++n11;
                                }
                            } else {
                                CoderResult coderResult = this.throwMalformedInputException(n11, n12, n16, 1);
                                return coderResult;
                            }
                        }
                    }
                    ++n11;
                }
            }
            this.charOff = n11;
            this.byteOff = n12;
            this.currentState = n16;
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(this.charOff - charBuffer.arrayOffset());
            byteBuffer.position(this.byteOff - byteBuffer.arrayOffset());
        }
    }

    protected static char[] expandMap(short[] sArray, String string, String string2, int n, int n2, int n3) {
        char c = '\u0000';
        char[] cArray = new char[65536];
        for (int i = 0; i < cArray.length; ++i) {
            if (i >= 55296 && i <= 57343) {
                cArray[i] = 65534;
                continue;
            }
            int n4 = sArray[(i & n2) >> n] + (i & n3);
            c = n4 >= 0 ? (n4 < 15000 ? string.charAt(n4) : string2.charAt(n4 - 15000)) : string2.charAt((n4 & 0xFFFF) - 15000);
            cArray[i] = c == '\u0000' && i != 0 ? 65535 : c;
        }
        return cArray;
    }

    private int getBytesForPairedCharacters(char c, char c2) {
        int n = leftPair.indexOf(c);
        while (n > -1) {
            if (rightPair.charAt(n) == c2) {
                return bytePair.charAt(n);
            }
            n = leftPair.indexOf(c, n + 1);
        }
        return 0;
    }

    private CoderResult throwConversionBufferFullException(int n, int n2, int n3) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        return CoderResult.OVERFLOW;
    }

    private CoderResult throwUnknownCharacterException(int n, int n2, int n3, int n4) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        this.badInputLength = n4;
        return CoderResult.unmappableForLength(n4);
    }

    private CoderResult throwMalformedInputException(int n, int n2, int n3, int n4) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        this.badInputLength = n4;
        return CoderResult.unmappableForLength(n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoderResult convertType1(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) {
        char c;
        char c2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n;
        int n9 = n3;
        int n10 = n2;
        int n11 = n4;
        byte by = this.replacement()[0];
        boolean bl = this.subMode;
        char[] cArray2 = this.index;
        int n12 = this.currentState;
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            c2 = cArray[n8];
            if (c2 < '\udc00' || c2 > '\udfff') return this.throwMalformedInputException(n8, n9, 0, 0);
            if (!bl) return this.throwUnknownCharacterException(n8, n9, 0, 2);
            if (n9 >= n11) {
                return this.throwConversionBufferFullException(n8, n9, 0);
            }
            byArray[n9++] = by;
            ++n8;
        }
        int n13 = n7 = (n6 = n11 - n9) < (n5 = n10 - n8) ? n8 + n6 : n10;
        while (n8 < n7 && (c = cArray2[c2 = cArray[n8]]) < '\u0100') {
            byArray[n9++] = (byte)c;
            ++n8;
        }
        if (n8 < n10) {
            n6 = n11 - n9;
            n5 = n10 - n8;
            int n14 = n7 = n6 < n5 ? n8 + n6 : n10;
            while (n8 < n7) {
                c2 = cArray[n8];
                c = cArray2[c2];
                if (c < '\u0100') {
                    byArray[n9++] = (byte)c;
                } else {
                    if (c == '\ufffe') break;
                    if (!bl) return this.throwUnknownCharacterException(n8, n9, 0, 1);
                    byArray[n9++] = by;
                }
                ++n8;
            }
            while (n8 < n10) {
                c2 = cArray[n8];
                c = cArray2[c2];
                if (c < '\u0100') {
                    if (n9 >= n11) {
                        return this.throwConversionBufferFullException(n8, n9, 0);
                    }
                    byArray[n9++] = (byte)c;
                } else if (c != '\ufffe') {
                    if (!bl) return this.throwUnknownCharacterException(n8, n9, 0, 1);
                    if (n9 >= n11) {
                        return this.throwConversionBufferFullException(n8, n9, 0);
                    }
                    byArray[n9++] = by;
                } else {
                    if (c2 >= '\udc00') return this.throwMalformedInputException(n8, n9, 0, 1);
                    if (n8 + 1 >= n10) {
                        this.highHalfZoneCode = c2;
                    } else {
                        c2 = cArray[n8 + 1];
                        if (c2 < '\udc00' || c2 > '\udfff') return this.throwMalformedInputException(n8, n9, 0, 1);
                        if (!bl) return this.throwUnknownCharacterException(n8, n9, 0, 2);
                        if (n9 >= n11) {
                            return this.throwConversionBufferFullException(n8, n9, 0);
                        }
                        byArray[n9++] = by;
                        ++n8;
                    }
                }
                ++n8;
            }
        }
        this.charOff = n8;
        this.byteOff = n9;
        return CoderResult.UNDERFLOW;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoderResult convertType2(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = n;
        int n13 = n3;
        int n14 = n2;
        int n15 = n4;
        int n16 = this.replacement().length;
        byte by = this.replacement()[0];
        byte by2 = this.replacement()[1];
        boolean bl = this.subMode;
        char[] cArray2 = this.index;
        if ('\u0000' != this.savedFirstOfPair) {
            n8 = cArray[n12];
            n7 = this.getBytesForPairedCharacters(this.savedFirstOfPair, (char)n8);
            n6 = 0 != n7 ? n7 : this.savedFirstOfPairBytes;
            if (n13 + 1 >= n15) {
                return this.throwConversionBufferFullException(n12, n13, this.currentState);
            }
            byArray[n13++] = (byte)((n6 & 0xFF00) >> 8);
            byArray[n13++] = (byte)(n6 & 0xFF);
            if (0 != n7) {
                ++n12;
            }
            this.savedFirstOfPair = '\u0000';
            this.savedFirstOfPairBytes = 0;
        }
        if (this.highHalfZoneCode != '\u0000') {
            n7 = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            n8 = cArray[n12];
            if (n8 < 56320 || n8 > 57343) return this.throwMalformedInputException(n12, n13, 1, 0);
            n5 = this.getBytesForSurrogatePair(n7, n8);
            if (0 != n5) {
                if (this.currentState == 0) {
                    if (n13 >= n15) {
                        return this.throwConversionBufferFullException(n12, n13, this.currentState);
                    }
                    byArray[n13++] = 14;
                    this.currentState = 1;
                }
                if (n13 + 1 >= n15) {
                    return this.throwConversionBufferFullException(n12, n13, this.currentState);
                }
                byArray[n13++] = (byte)((n5 & 0xFF00) >> 8);
                byArray[n13++] = (byte)(n5 & 0xFF);
            } else {
                if (!bl) return this.throwUnknownCharacterException(n12, n13, 1, 2);
                if (n13 + 1 >= n15) {
                    return this.throwConversionBufferFullException(n12, n13, 1);
                }
                byArray[n13++] = by;
                byArray[n13++] = by2;
            }
            ++n12;
        }
        if (n12 < n14) {
            n10 = (n15 - n13) / 2;
            n9 = n14 - n12;
            int n17 = n11 = n10 < n9 ? n12 + n10 : n14;
            while (!(n12 >= n11 || (n6 = cArray2[n8 = cArray[n12]]) < 65534 && this.isFirstOfAPair((char)n8))) {
                if (n6 < 65534 && n6 >= 256) {
                    byArray[n13++] = (byte)(n6 >> 8);
                    byArray[n13++] = (byte)(n6 & 0xFF);
                } else {
                    if (n6 == 65534) break;
                    if (!bl) return this.throwUnknownCharacterException(n12, n13, 1, 1);
                    byArray[n13++] = by;
                    byArray[n13++] = by2;
                }
                ++n12;
            }
            while (n12 < n14) {
                n8 = cArray[n12];
                n6 = cArray2[n8];
                if (n6 < 65534 && this.isFirstOfAPair((char)n8) && n12 + 1 >= n14) {
                    this.savedFirstOfPair = (char)n8;
                    this.savedFirstOfPairBytes = n6;
                } else if (n6 < 65534 && n6 >= 256) {
                    if (this.isFirstOfAPair((char)n8) && n12 + 1 < n14 && 0 != (n5 = this.getBytesForPairedCharacters((char)n8, (char)(n7 = cArray[n12 + 1])))) {
                        n6 = n5;
                        ++n12;
                    }
                    if (n13 + 1 >= n15) {
                        return this.throwConversionBufferFullException(n12, n13, 1);
                    }
                    byArray[n13++] = (byte)(n6 >> 8);
                    byArray[n13++] = (byte)(n6 & 0xFF);
                } else if (n6 != 65534) {
                    if (!bl) return this.throwUnknownCharacterException(n12, n13, 1, 1);
                    if (n13 + 1 >= n15) {
                        return this.throwConversionBufferFullException(n12, n13, 1);
                    }
                    byArray[n13++] = by;
                    byArray[n13++] = by2;
                } else {
                    if (n8 >= 56320) return this.throwMalformedInputException(n12, n13, 1, 1);
                    n7 = n8;
                    if (n12 + 1 >= n14) {
                        this.highHalfZoneCode = (char)n8;
                    } else {
                        n8 = cArray[n12 + 1];
                        if (n8 < 56320 || n8 > 57343) return this.throwMalformedInputException(n12, n13, 1, 1);
                        n5 = this.getBytesForSurrogatePair(n7, n8);
                        if (0 != n5) {
                            if (this.currentState == 0) {
                                if (n13 >= n15) {
                                    return this.throwConversionBufferFullException(n12, n13, this.currentState);
                                }
                                byArray[n13++] = 14;
                                this.currentState = 1;
                            }
                            if (n13 + 1 >= n15) {
                                return this.throwConversionBufferFullException(n12, n13, this.currentState);
                            }
                            byArray[n13++] = (byte)((n5 & 0xFF00) >> 8);
                            byArray[n13++] = (byte)(n5 & 0xFF);
                            ++n12;
                        } else {
                            if (!bl) return this.throwUnknownCharacterException(n12, n13, 1, 2);
                            if (n13 + 1 >= n15) {
                                return this.throwConversionBufferFullException(n12, n13, 1);
                            }
                            byArray[n13++] = by;
                            byArray[n13++] = by2;
                            ++n12;
                        }
                    }
                }
                ++n12;
            }
        }
        this.charOff = n12;
        this.byteOff = n13;
        return CoderResult.UNDERFLOW;
    }

    private int getBytesForSurrogatePair(int n, int n2) {
        if (0 == numberOfSurrogates) {
            return 0;
        }
        int n3 = numberOfSurrogates;
        int n4 = -1;
        int n5 = ((n & 0x3FF) << 10 | n2 & 0x3FF) + 65536;
        int n6 = n3 / 2;
        int n7 = 0;
        if (surrogateArray[0] == n5) {
            n4 = 0;
            n6 = 0;
        } else if (surrogateArray[n3 - 1] == n5) {
            n4 = n3 - 1;
            n6 = 0;
        }
        while (n6 >= 1) {
            if (surrogateArray[n6] == n5) {
                n4 = n6;
                break;
            }
            if (surrogateArray[n6] < n5) {
                if ((n3 + n6) / 2 == n6) {
                    n6 = 0;
                    continue;
                }
                n6 = (n3 + n6) / 2;
                continue;
            }
            if (surrogateArray[n6] <= n5) continue;
            n3 = n6;
            n6 = n3 / 2;
        }
        if (n4 >= 0) {
            n7 = byteArray.charAt(n4);
        }
        return n7;
    }

    private boolean isFirstOfAPair(char c) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (this.convertType == 1) {
            return this.encodeBufferLoop_CT1(charBuffer, byteBuffer);
        }
        if (this.convertType == 2) {
            return this.encodeBufferLoop_CT2(charBuffer, byteBuffer);
        }
        int n = charBuffer.position();
        boolean bl = false;
        try {
            while (charBuffer.hasRemaining()) {
                boolean bl2;
                boolean bl3;
                char c;
                char c2;
                block38: {
                    int n2;
                    int n3;
                    int n4;
                    block40: {
                        block39: {
                            c2 = '\u0000';
                            charBuffer.position(n);
                            c = charBuffer.get();
                            int n5 = leftPair.indexOf(c);
                            bl3 = false;
                            bl2 = false;
                            if (charBuffer.hasRemaining() && n5 > -1 && null != surrogateArray) {
                                while (n5 > -1) {
                                    charBuffer.position(n + 1);
                                    if (rightPair.charAt(n5) == charBuffer.get()) {
                                        c2 = bytePair.charAt(n5);
                                        ++n;
                                        bl3 = true;
                                        n5 = -1;
                                        continue;
                                    }
                                    n5 = leftPair.indexOf(c, n5 + 1);
                                }
                            }
                            if (!Surrogate.is(c)) break block38;
                            if (this.sgp.parse(c, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (null == surrogateArray || bl3) break block39;
                            n4 = numberOfSurrogates;
                            n3 = -1;
                            boolean bl4 = false;
                            n2 = n4 / 2;
                            if (surrogateArray[0] == this.sgp.character()) {
                                n3 = 0;
                                n2 = 0;
                                break block40;
                            } else if (surrogateArray[n4 - 1] == this.sgp.character()) {
                                n3 = n4 - 1;
                                n2 = 0;
                            }
                            break block40;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    while (n2 >= 1) {
                        if (surrogateArray[n2] == this.sgp.character()) {
                            n3 = n2;
                            break;
                        }
                        if (surrogateArray[n2] < this.sgp.character()) {
                            if ((n4 + n2) / 2 == n2) {
                                n2 = 0;
                                continue;
                            }
                            n2 = (n4 + n2) / 2;
                            continue;
                        }
                        if (surrogateArray[n2] <= this.sgp.character()) continue;
                        n4 = n2;
                        n2 = n4 / 2;
                    }
                    if (n3 >= 0) {
                        c2 = byteArray.charAt(n3);
                        ++n;
                        bl2 = true;
                    } else {
                        this.sgp.unmappableResult();
                        break;
                    }
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n6 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                if (!bl3 && !bl2) {
                    c2 = n6 >= 0 ? (n6 < 15000 ? this.index2.charAt(n6) : this.index2a.charAt(n6 - 15000)) : this.index2a.charAt((n6 & 0xFFFF) - 15000);
                }
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                    byteBuffer.put((byte)15);
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                    byteBuffer.put((byte)14);
                }
                int n7 = this.currentState == 1 ? 2 : 1;
                if (byteBuffer.remaining() < n7) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    byteBuffer.put(this.b2);
                } else {
                    if (this.currentState == 1 || bl3 || bl2) {
                        byteBuffer.put(this.b1);
                    }
                    byteBuffer.put(this.b2);
                }
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop_CT1(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                int n3 = leftPair.indexOf(c);
                boolean bl3 = false;
                boolean bl4 = false;
                if (charBuffer.hasRemaining() && n3 > -1 && null != surrogateArray) {
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n4 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char c2 = n4 >= 0 ? (n4 < 15000 ? this.index2.charAt(n4) : this.index2a.charAt(n4 - 15000)) : this.index2a.charAt((n4 & 0xFFFF) - 15000);
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 0 && this.b1 != 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState != 0) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n2 = 1;
                if (byteBuffer.remaining() < n2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    if (this.b2 > 255) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                } else {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                byteBuffer.put(this.b2);
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop_CT2(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        boolean bl = false;
        try {
            while (charBuffer.hasRemaining()) {
                char c;
                boolean bl2;
                boolean bl3;
                char c2;
                block35: {
                    int n2;
                    int n3;
                    int n4;
                    block37: {
                        block36: {
                            charBuffer.position(n);
                            c2 = charBuffer.get();
                            int n5 = leftPair.indexOf(c2);
                            bl3 = false;
                            bl2 = false;
                            if (charBuffer.hasRemaining() && n5 > -1 && null != surrogateArray) {
                                while (n5 > -1) {
                                    charBuffer.position(n + 1);
                                    if (rightPair.charAt(n5) == charBuffer.get()) {
                                        c = bytePair.charAt(n5);
                                        ++n;
                                        bl3 = true;
                                        n5 = -1;
                                        continue;
                                    }
                                    n5 = leftPair.indexOf(c2, n5 + 1);
                                }
                            }
                            if (!Surrogate.is(c2)) break block35;
                            if (this.sgp.parse(c2, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (null == surrogateArray || bl3) break block36;
                            n4 = numberOfSurrogates;
                            n3 = -1;
                            boolean bl4 = false;
                            n2 = n4 / 2;
                            if (surrogateArray[0] == this.sgp.character()) {
                                n3 = 0;
                                n2 = 0;
                                break block37;
                            } else if (surrogateArray[n4 - 1] == this.sgp.character()) {
                                n3 = n4 - 1;
                                n2 = 0;
                            }
                            break block37;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    while (n2 >= 1) {
                        if (surrogateArray[n2] == this.sgp.character()) {
                            n3 = n2;
                            break;
                        }
                        if (surrogateArray[n2] < this.sgp.character()) {
                            if ((n4 + n2) / 2 == n2) {
                                n2 = 0;
                                continue;
                            }
                            n2 = (n4 + n2) / 2;
                            continue;
                        }
                        if (surrogateArray[n2] <= this.sgp.character()) continue;
                        n4 = n2;
                        n2 = n4 / 2;
                    }
                    if (n3 >= 0) {
                        c = byteArray.charAt(n3);
                        ++n;
                        bl2 = true;
                    } else {
                        this.sgp.unmappableResult();
                        break;
                    }
                }
                if (c2 >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n6 = this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2);
                c = n6 >= 0 ? (n6 < 15000 ? this.index2.charAt(n6) : this.index2a.charAt(n6 - 15000)) : this.index2a.charAt((n6 & 0xFFFF) - 15000);
                this.b1 = (byte)((c & 0xFF00) >> 8);
                this.b2 = (byte)(c & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c2 != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                }
                int n7 = this.currentState == 1 ? 2 : 1;
                if (byteBuffer.remaining() < n7) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 || bl3 || bl2) {
                    byteBuffer.put(this.b1);
                }
                byteBuffer.put(this.b2);
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeArrayLoop_CT2(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        boolean bl = false;
        try {
            for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                char c;
                boolean bl2;
                boolean bl3;
                char c2;
                block35: {
                    int n5;
                    int n6;
                    int n7;
                    block37: {
                        block36: {
                            c2 = cArray[n];
                            int n8 = leftPair.indexOf(c2);
                            bl3 = false;
                            bl2 = false;
                            if (n + 1 < n2 && n8 > -1 && null != surrogateArray) {
                                while (n8 > -1) {
                                    if (rightPair.charAt(n8) == cArray[n + 1]) {
                                        c = bytePair.charAt(n8);
                                        ++n;
                                        bl3 = true;
                                        n8 = -1;
                                        continue;
                                    }
                                    n8 = leftPair.indexOf(c2, n8 + 1);
                                }
                            }
                            if (!Surrogate.is(c2)) break block35;
                            if (this.sgp.parse(c2, cArray, n, n2) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (null == surrogateArray || bl3) break block36;
                            n7 = numberOfSurrogates;
                            n6 = -1;
                            boolean bl4 = false;
                            n5 = n7 / 2;
                            if (surrogateArray[0] == this.sgp.character()) {
                                n6 = 0;
                                n5 = 0;
                                break block37;
                            } else if (surrogateArray[n7 - 1] == this.sgp.character()) {
                                n6 = n7 - 1;
                                n5 = 0;
                            }
                            break block37;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    while (n5 >= 1) {
                        if (surrogateArray[n5] == this.sgp.character()) {
                            n6 = n5;
                            break;
                        }
                        if (surrogateArray[n5] < this.sgp.character()) {
                            if ((n7 + n5) / 2 == n5) {
                                n5 = 0;
                                continue;
                            }
                            n5 = (n7 + n5) / 2;
                            continue;
                        }
                        if (surrogateArray[n5] <= this.sgp.character()) continue;
                        n7 = n5;
                        n5 = n7 / 2;
                    }
                    if (n6 >= 0) {
                        c = byteArray.charAt(n6);
                        ++n;
                        bl2 = true;
                    } else {
                        this.sgp.unmappableResult();
                        break;
                    }
                }
                if (c2 >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n9 = this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2);
                c = n9 >= 0 ? (n9 < 15000 ? this.index2.charAt(n9) : this.index2a.charAt(n9 - 15000)) : this.index2a.charAt((n9 & 0xFFFF) - 15000);
                this.b1 = (byte)((c & 0xFF00) >> 8);
                this.b2 = (byte)(c & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c2 != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 && this.b1 == 0) {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 0;
                } else if (this.currentState == 0 && this.b1 != 0) {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    this.currentState = 1;
                }
                int n10 = this.currentState == 1 ? 2 : 1;
                if (n4 - n3 < n10) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 1 || bl3 || bl2) {
                    byArray[n3++] = this.b1;
                }
                byArray[n3++] = this.b2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop_CT1(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        boolean bl = false;
        int n5 = 0;
        try {
            for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                char c = cArray[n];
                int n6 = leftPair.indexOf(c);
                boolean bl2 = false;
                boolean bl3 = false;
                if (n + 1 < n2 && n6 > -1 && null != surrogateArray) {
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n7 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char c2 = n7 >= 0 ? (n7 < 15000 ? this.index2.charAt(n7) : this.index2a.charAt(n7 - 15000)) : this.index2a.charAt((n7 & 0xFFFF) - 15000);
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.b1 == 0 && this.b2 == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState == 0 && this.b1 != 0) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (this.currentState != 0) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                n5 = 1;
                if (n4 - n3 < n5) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.currentState == 0) {
                    if (this.b2 > 255) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                } else {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                byArray[n3++] = this.b2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    static {
        byteArray = "";
        leftPair = "";
        rightPair = "";
        bytePair = "";
        surrogateArray = null;
        numberOfSurrogates = 0;
    }
}

