/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ext.DBCSDecoderMapping;

public abstract class DBCS_IBM_EBCDIC_Decoder
extends CharsetDecoder {
    private DBCSDecoderMapping decoderMapping;
    protected static final char REPLACE_CHAR = '\ufffd';
    protected String singleByteToChar;
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected int mask1;
    protected int mask2;
    protected int shift;
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final int SO = 14;
    private static final int SI = 15;
    private int currentState;
    private int convertType = 0;
    protected static String indexSurrogate = "";
    protected static String indexSurrogate2 = "";
    protected static int bytePairLead = 0;
    protected static int[] pairsArray = null;
    protected static String bytePairs = "";
    private boolean fastSBCS = false;
    private char[] singleByte = null;
    private static final char kSentinalValue = '\uffff';
    private int charOff;
    private int byteOff;
    private boolean subMode = true;
    private static final int MALFORMED_CHAR = 65534;
    private static final int INVALID_SHIFT = 65532;
    private static final int END_INPUT = 65535;
    private boolean savedBytePresent = false;
    private boolean sentinalsAdded = false;
    private char originalSI = '\u0000';
    private char originalSO = '\u0000';
    protected char[] charMap = null;
    private byte savedByte;
    private char[] subChars = new char[]{'\ufffd'};
    private int badInputLength;

    public int getBytePairLead() {
        return bytePairLead;
    }

    protected DBCS_IBM_EBCDIC_Decoder(Charset charset) {
        super(charset, 0.5f, 1.0f);
    }

    protected void implReset() {
        this.byteOff = 0;
        this.charOff = 0;
        if (this.singleByte == null && this.singleByteToChar.length() == 256) {
            this.singleByte = this.singleByteToChar.toCharArray();
        }
        if (this.convertType == 0) {
            this.setSBCS();
        }
        this.savedBytePresent = false;
    }

    protected void setType(int n) {
        this.convertType = n;
        this.currentState = n == 2 ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n <= n2);
        n = n <= n2 ? n : n2;
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        try {
            int n5;
            int n6 = n2 - n;
            this.charOff = n3;
            if (this.fastSBCS && n3 + (n2 - n) <= n4) {
                char c;
                for (n5 = 0; n5 < n6 && (c = this.singleByte[byArray[n5 + n] & 0xFF]) != '\uffff'; ++n5) {
                    cArray[n3 + n5] = c;
                }
                this.charOff = n3 + n5;
            }
            this.byteOff = n5 + n;
            if (n5 + n != n2) {
                this.convertSlow(byArray, n2, cArray, n4);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(this.byteOff);
            charBuffer.position(this.charOff);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoderResult convertSlow(byte[] byArray, int n, char[] cArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 65533;
        int n9 = 65533;
        boolean bl = false;
        if (0 != this.convertType && this.sentinalsAdded) {
            this.sentinalsAdded = false;
            this.singleByte[14] = this.originalSO;
            this.singleByte[15] = this.originalSI;
        }
        if (this.convertType != 0) {
            if (this.convertType != 1) return this.convertType2(byArray, n, cArray, n2);
            return this.convertType1(byArray, n, cArray, n2);
        }
        int n10 = 0;
        int n11 = 0;
        int n12 = 65533;
        int n13 = this.charOff;
        int n14 = this.byteOff;
        int n15 = n;
        int n16 = n2;
        int n17 = this.currentState;
        char[] cArray2 = this.charMap;
        if (this.savedBytePresent && n14 < n15) {
            if (n13 >= n16) return this.throwConversionBufferFullException(n13, n14, n17);
            n11 = byArray[n14++] & 0xFF;
            n12 = cArray2[n11 = (this.savedByte & 0xFF) << 8 | n11];
            if (n12 < 65532) {
                cArray[n13++] = n12;
            } else if (n12 == 65533) {
                if (!this.subMode) return this.throwUnknownCharacterException(n13, n14, n17, 1);
                cArray[n13++] = this.subChars[0];
            } else {
                if (n12 == 65534) {
                    return this.throwMalformedInputException(n13, n14, n17, 1);
                }
                if (n12 == 65532) {
                    return this.throwMalformedInputException(n13, n14, n17, 0);
                }
            }
            this.savedBytePresent = false;
        }
        int n18 = n7 = (n6 = n16 - n13) < (n5 = n15 - n14 - 1) ? n14 + n6 : n15 - 1;
        while (n14 < n7) {
            n10 = byArray[n14++] & 0xFF;
            if (n17 == 0) {
                while (n10 != 14) {
                    n12 = cArray2[n10];
                    if (n12 < 65532) {
                        cArray[n13++] = n12;
                    } else if (n12 == 65533) {
                        if (!this.subMode) return this.throwUnknownCharacterException(n13, n14, n17, 1);
                        cArray[n13++] = this.subChars[0];
                    } else {
                        if (n12 == 65534) {
                            return this.throwMalformedInputException(n13, n14, n17, 1);
                        }
                        if (n12 == 65532) {
                            return this.throwMalformedInputException(n13, n14, n17, 1);
                        }
                    }
                    if (n14 >= n7) break;
                    n10 = byArray[n14++] & 0xFF;
                }
                if (n10 != 14) continue;
                n17 = 1;
                continue;
            }
            while (n10 != 15) {
                n11 = byArray[n14++] & 0xFF;
                n12 = cArray2[n11 = n10 << 8 | n11];
                if (n12 < 65532) {
                    if (n12 >= 55296 && n12 <= 56319) {
                        n8 = this.getSurrogatePair(n11);
                        if (n8 == 65533) {
                            if (!this.subMode) return this.throwMalformedInputException(n13, n14, n17, 2);
                            cArray[n13++] = this.subChars[0];
                        }
                        if (n13 >= n16) {
                            return this.throwConversionBufferFullException(n13, n14 - 2, n17);
                        }
                        cArray[n13++] = n12;
                        if (n13 >= n16) {
                            return this.throwConversionBufferFullException(n13, n14 - 2, n17);
                        }
                        cArray[n13++] = n8;
                    } else {
                        cArray[n13++] = n12;
                    }
                } else {
                    if (n10 == bytePairLead && null != bytePairs) {
                        for (n4 = 0; n4 < bytePairs.length(); ++n4) {
                            if (bytePairs.charAt(n4) != n11) continue;
                            n3 = pairsArray[n4];
                            if (n13 >= n16) {
                                return this.throwConversionBufferFullException(n13, n14 - 2, n17);
                            }
                            cArray[n13++] = (char)(n3 >> 16 & 0xFFFF);
                            if (n13 >= n16) {
                                return this.throwConversionBufferFullException(n13, n14 - 2, n17);
                            }
                            cArray[n13++] = (char)(n3 & 0xFFFF);
                            bl = true;
                        }
                    }
                    if (!bl) {
                        if (n12 == 65533) {
                            if (!this.subMode) return this.throwUnknownCharacterException(n13, n14, n17, 2);
                            cArray[n13++] = this.subChars[0];
                        } else {
                            if (n12 == 65534) {
                                return this.throwMalformedInputException(n13, n14, n17, 2);
                            }
                            if (n12 == 65532) {
                                return this.throwMalformedInputException(n13, --n14, n17, 1);
                            }
                        }
                    } else {
                        bl = false;
                    }
                }
                if (n14 >= n7) break;
                n10 = byArray[n14++] & 0xFF;
            }
            if (n10 != 15) continue;
            n17 = 0;
        }
        while (n14 < n15) {
            n10 = byArray[n14++] & 0xFF;
            if (n17 == 0) {
                while (n10 != 14 && n10 != 15) {
                    n12 = cArray2[n10];
                    if (n12 < 65532) {
                        if (n13 >= n16) {
                            return this.throwConversionBufferFullException(n13, n14 - 1, n17);
                        }
                        cArray[n13++] = n12;
                    } else if (n12 == 65533) {
                        if (!this.subMode) return this.throwUnknownCharacterException(n13, n14, n17, 1);
                        if (n13 >= n16) {
                            return this.throwConversionBufferFullException(n13, n14 - 1, n17);
                        }
                        cArray[n13++] = this.subChars[0];
                    } else {
                        if (n12 == 65534) {
                            return this.throwMalformedInputException(n13, n14, n17, 1);
                        }
                        if (n12 == 65532) {
                            return this.throwMalformedInputException(n13, n14, n17, 1);
                        }
                    }
                    if (n14 >= n15) break;
                    n10 = byArray[n14++] & 0xFF;
                }
                if (n10 != 14) continue;
                n17 = 1;
                continue;
            }
            while (n10 != 15) {
                if (n14 >= n15) {
                    if (n10 == 14) {
                        return this.throwMalformedInputException(n13, n14, n17, 1);
                    }
                    this.savedByte = (byte)n10;
                    this.savedBytePresent = true;
                    break;
                }
                n11 = byArray[n14++] & 0xFF;
                n12 = cArray2[n11 = n10 << 8 | n11];
                if (n12 < 65532) {
                    if (n12 >= 55296 && n12 <= 56319) {
                        n8 = this.getSurrogatePair(n11);
                        if (n8 == 65533) {
                            if (!this.subMode) return this.throwMalformedInputException(n13, n14, n17, 2);
                            cArray[n13++] = this.subChars[0];
                        }
                        if (n13 >= n16) {
                            return this.throwConversionBufferFullException(n13, n14 - 2, n17);
                        }
                        cArray[n13++] = n12;
                        if (n13 >= n16) {
                            return this.throwConversionBufferFullException(n13, n14 - 2, n17);
                        }
                        cArray[n13++] = n8;
                    } else {
                        if (n13 >= n16) {
                            return this.throwConversionBufferFullException(n13, n14 - 2, n17);
                        }
                        cArray[n13++] = n12;
                    }
                } else {
                    if (n10 == bytePairLead && null != bytePairs) {
                        for (n4 = 0; n4 < bytePairs.length(); ++n4) {
                            if (bytePairs.charAt(n4) != n11) continue;
                            n3 = pairsArray[n4];
                            if (n13 >= n16) {
                                return this.throwConversionBufferFullException(n13, n14 - 2, n17);
                            }
                            cArray[n13++] = (char)(n3 >> 16 & 0xFFFF);
                            if (n13 >= n16) {
                                return this.throwConversionBufferFullException(n13, n14 - 2, n17);
                            }
                            cArray[n13++] = (char)(n3 & 0xFFFF);
                            bl = true;
                        }
                    }
                    if (!bl) {
                        if (n12 == 65533) {
                            if (!this.subMode) return this.throwUnknownCharacterException(n13, n14, n17, 2);
                            if (n13 >= n16) {
                                return this.throwConversionBufferFullException(n13, n14 - 2, n17);
                            }
                            cArray[n13++] = this.subChars[0];
                        } else {
                            if (n12 == 65534) {
                                return this.throwMalformedInputException(n13, n14, n17, 2);
                            }
                            if (n12 == 65532) {
                                return this.throwMalformedInputException(n13, n14 - 1, n17, 1);
                            }
                        }
                    } else {
                        bl = false;
                    }
                }
                if (n14 >= n15) break;
                n10 = byArray[n14++] & 0xFF;
            }
            if (n10 != 15) continue;
            n17 = 0;
        }
        this.charOff = n13;
        this.byteOff = n14;
        this.currentState = n17;
        if (n17 == 0) {
            this.setSBCS();
            return CoderResult.UNDERFLOW;
        } else {
            this.fastSBCS = false;
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult convertType1(byte[] byArray, int n, char[] cArray, int n2) {
        int n3;
        int n4 = 0;
        boolean bl = false;
        int n5 = 65533;
        int n6 = this.charOff;
        int n7 = this.byteOff;
        int n8 = n;
        int n9 = n2;
        int n10 = this.currentState;
        char[] cArray2 = this.charMap;
        int n11 = n9 - n6;
        int n12 = n8 - n7;
        int n13 = n3 = n11 < n12 ? n7 + n11 : n8;
        while (n7 < n3) {
            if ((n5 = cArray2[n4 = byArray[n7++] & 0xFF]) < 65532) {
                cArray[n6++] = n5;
                continue;
            }
            if (n5 == 65533) {
                if (this.subMode) {
                    cArray[n6++] = this.subChars[0];
                    continue;
                }
                return this.throwUnknownCharacterException(n6, n7, n10, 1);
            }
            if (n5 == 65534) {
                return this.throwMalformedInputException(n6, n7, n10, 1);
            }
            if (n5 != 65532) continue;
            return this.throwMalformedInputException(n6, n7, n10, 1);
        }
        if (n3 < n8) {
            return this.throwConversionBufferFullException(n6, n7, n10);
        }
        this.charOff = n6;
        this.byteOff = n7;
        return CoderResult.UNDERFLOW;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoderResult convertType2(byte[] byArray, int n, char[] cArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 65533;
        int n9 = 65533;
        int n10 = 65533;
        boolean bl = false;
        int n11 = this.charOff;
        int n12 = this.byteOff;
        int n13 = n;
        int n14 = n2;
        int n15 = this.currentState;
        char[] cArray2 = this.charMap;
        if (this.savedBytePresent && n12 < n13) {
            if (n11 >= n14) return this.throwConversionBufferFullException(n11, n12, n15);
            n7 = byArray[n12++] & 0xFF;
            n8 = cArray2[n7 = this.savedByte << 8 | n7];
            if (n8 < 65532) {
                if (n8 >= 55296 && n8 <= 56319) {
                    n9 = this.getSurrogatePair(n7);
                    if (n9 == 65533) {
                        if (!this.subMode) return this.throwMalformedInputException(n11, n12, n15, 2);
                        cArray[n11++] = this.subChars[0];
                    }
                    if (n11 >= n14) {
                        return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                    }
                    cArray[n11++] = n8;
                    if (n11 >= n14) {
                        return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                    }
                    cArray[n11++] = n9;
                } else {
                    cArray[n11++] = n8;
                }
            } else {
                if (n6 == bytePairLead && null != bytePairs) {
                    for (n5 = 0; n5 < bytePairs.length(); ++n5) {
                        if (bytePairs.charAt(n5) != n7) continue;
                        n4 = pairsArray[n5];
                        if (n11 >= n14) {
                            return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                        }
                        cArray[n11++] = (char)(n4 >> 16 & 0xFFFF);
                        if (n11 >= n14) {
                            return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                        }
                        cArray[n11++] = (char)(n4 & 0xFFFF);
                        bl = true;
                    }
                }
                if (!bl) {
                    if (n8 == 65533) {
                        if (!this.subMode) return this.throwUnknownCharacterException(n11, n12, n15, 1);
                        cArray[n11++] = this.subChars[0];
                    } else {
                        if (n8 == 65534) {
                            return this.throwMalformedInputException(n11, n12, n15, 1);
                        }
                        if (n8 == 65532) {
                            return this.throwMalformedInputException(n11, n12, n15, 0);
                        }
                    }
                } else {
                    bl = false;
                }
            }
            this.savedBytePresent = false;
        }
        int n16 = n3 = (n4 = n14 - n11) < (n5 = (n13 - n12) / 2) ? n12 + n4 * 2 : n12 + n5 * 2;
        while (n12 < n3) {
            n6 = byArray[n12++] & 0xFF;
            n7 = byArray[n12++] & 0xFF;
            n8 = cArray2[n7 = n6 << 8 | n7];
            if (n8 < 65532) {
                if (n8 >= 55296 && n8 <= 56319) {
                    n9 = this.getSurrogatePair(n7);
                    if (n9 == 65533) {
                        if (!this.subMode) return this.throwMalformedInputException(n11, n12, n15, 2);
                        cArray[n11++] = this.subChars[0];
                    }
                    if (n11 >= n14) {
                        return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                    }
                    cArray[n11++] = n8;
                    if (n11 >= n14) {
                        return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                    }
                    cArray[n11++] = n9;
                    continue;
                }
                cArray[n11++] = n8;
                continue;
            }
            if (n6 == bytePairLead && null != bytePairs) {
                for (int i = 0; i < bytePairs.length(); ++i) {
                    if (bytePairs.charAt(i) != n7) continue;
                    int n17 = pairsArray[i];
                    if (n11 >= n14) {
                        return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                    }
                    cArray[n11++] = (char)(n17 >> 16 & 0xFFFF);
                    if (n11 >= n14) {
                        return this.throwConversionBufferFullException(n11, n12 - 2, n15);
                    }
                    cArray[n11++] = (char)(n17 & 0xFFFF);
                    bl = true;
                }
            }
            if (!bl) {
                if (n8 == 65533) {
                    if (!this.subMode) return this.throwUnknownCharacterException(n11, n12, n15, 2);
                    cArray[n11++] = this.subChars[0];
                    continue;
                }
                if (n8 == 65534) {
                    return this.throwMalformedInputException(n11, n12, n15, 2);
                }
                if (n8 != 65532) continue;
                return this.throwMalformedInputException(n11, --n12, n15, 2);
            }
            bl = false;
        }
        if (n3 < n13) {
            if (n12 >= n13) return this.throwConversionBufferFullException(n11, n12, n15);
            n6 = byArray[n12++] & 0xFF;
            this.savedByte = (byte)n6;
            this.savedBytePresent = true;
        }
        this.charOff = n11;
        this.byteOff = n12;
        return CoderResult.UNDERFLOW;
    }

    private CoderResult throwConversionBufferFullException(int n, int n2, int n3) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        if (n3 == 0) {
            this.setSBCS();
        } else {
            this.fastSBCS = false;
        }
        return CoderResult.OVERFLOW;
    }

    private CoderResult throwMalformedInputException(int n, int n2, int n3, int n4) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        if (n3 == 0) {
            this.setSBCS();
        } else {
            this.fastSBCS = false;
        }
        this.badInputLength = n4;
        return CoderResult.unmappableForLength(n4);
    }

    private CoderResult throwUnknownCharacterException(int n, int n2, int n3, int n4) {
        this.charOff = n;
        this.byteOff = n2;
        this.currentState = n3;
        if (n3 == 0) {
            this.setSBCS();
        } else {
            this.fastSBCS = false;
        }
        this.badInputLength = n4;
        return CoderResult.unmappableForLength(n4);
    }

    protected void setSBCS() {
        this.currentState = 0;
        boolean bl = this.fastSBCS = this.subMode && this.subChars.length == 1 && this.subChars[0] == '\ufffd' && this.singleByte != null;
        if (this.singleByte != null && !this.sentinalsAdded) {
            this.sentinalsAdded = true;
            this.originalSO = this.singleByte[14];
            this.originalSI = this.singleByte[15];
            this.singleByte[14] = 65535;
            this.singleByte[15] = 65535;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (this.convertType == 1) {
            return this.decodeBufferLoop_CT1(byteBuffer, charBuffer);
        }
        if (this.convertType == 2) {
            return this.decodeBufferLoop_CT2(byteBuffer, charBuffer);
        }
        int n = byteBuffer.position();
        char c = '\ufffd';
        char c2 = '\ufffd';
        boolean bl = false;
        boolean bl2 = false;
        try {
            while (byteBuffer.hasRemaining()) {
                int n2 = 0;
                int n3 = byteBuffer.get();
                int n4 = 1;
                int n5 = 65533;
                if (n3 < 0) {
                    n3 += 256;
                }
                if (n3 == 14) {
                    if (this.currentState != 0) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 1;
                } else if (n3 == 15) {
                    if (this.currentState != 1) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 0;
                } else {
                    int n6;
                    if (this.currentState == 0) {
                        n5 = this.singleByteToChar.charAt(n3);
                    } else {
                        if (n3 < 64 || n3 > 254) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n7 = byteBuffer.get();
                        if (n7 < 0) {
                            n7 += 256;
                        }
                        ++n4;
                        if (!(n3 == 64 && n7 == 64 || n7 >= 65 && n7 <= 254)) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        n2 = n3 * 256 + n7;
                        n6 = this.index1[(n2 & this.mask1) >> this.shift] + (n2 & this.mask2);
                        n5 = this.index2a == null || n6 < 15000 ? this.index2.charAt(n6) : this.index2a.charAt(n6 - 15000);
                        if (n5 >= 55296 && n5 <= 56319) {
                            c = this.getSurrogatePair(n3 * 256 + n7);
                            if (c == '\ufffd') {
                                CoderResult coderResult = CoderResult.unmappableForLength(n4);
                                return coderResult;
                            }
                            bl = true;
                        }
                        if (n5 == 0 && n2 != 0) {
                            n5 = 65533;
                        }
                        if (n5 == 65533 && n3 == bytePairLead && null != bytePairs) {
                            for (int i = 0; i < bytePairs.length(); ++i) {
                                if (bytePairs.charAt(i) != n3 * 256 + n7) continue;
                                int n8 = pairsArray[i];
                                n5 = (char)(n8 >> 16 & 0xFFFF);
                                c2 = (char)(n8 & 0xFFFF);
                                bl2 = true;
                                break;
                            }
                        }
                    }
                    if (n5 == 0 && n2 != 0) {
                        n5 = 65533;
                    }
                    if (n5 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n4);
                        return coderResult;
                    }
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (bl || bl2) {
                        n6 = charBuffer.arrayOffset() + charBuffer.position();
                        if (charBuffer.arrayOffset() + charBuffer.limit() - (n6 + 1) < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                    }
                    charBuffer.put((char)n5);
                    if (bl) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c);
                        bl = false;
                    } else if (bl2) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c2);
                        bl2 = false;
                    }
                }
                n += n4;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop_CT1(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.hasRemaining()) {
                boolean bl = false;
                int n2 = byteBuffer.get();
                int n3 = 1;
                char c = '\ufffd';
                if (n2 < 0) {
                    n2 += 256;
                }
                if (this.currentState == 0) {
                    if (n2 > 255) {
                        c = '\ufffd';
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                } else {
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                c = this.singleByteToChar.charAt(n2);
                if (c == '\u0000' && bl) {
                    c = '\ufffd';
                }
                if (c == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(n3);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                charBuffer.put(c);
                n += n3;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop_CT2(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        char c = '\ufffd';
        char c2 = '\ufffd';
        boolean bl = false;
        boolean bl2 = false;
        this.currentState = 1;
        try {
            while (byteBuffer.hasRemaining()) {
                int n2 = 0;
                int n3 = 0;
                int n4 = byteBuffer.get();
                int n5 = 1;
                int n6 = 65533;
                if (n4 < 0) {
                    n4 += 256;
                }
                if (n4 == 14 && this.convertType == 0) {
                    if (this.currentState != 0) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 1;
                } else if (n4 == 15 && this.convertType == 0) {
                    if (this.currentState != 1) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    this.currentState = 0;
                } else {
                    int n7;
                    if (this.currentState == 0) {
                        n6 = this.singleByteToChar.charAt(n4);
                    } else {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n2 = byteBuffer.get();
                        if (n2 < 0) {
                            n2 += 256;
                        }
                        ++n5;
                        if (n4 == 0 && n2 <= 255) {
                            n6 = this.singleByteToChar.charAt(n2);
                        } else {
                            n3 = n4 * 256 + n2;
                            n7 = this.index1[(n3 & this.mask1) >> this.shift] + (n3 & this.mask2);
                            n6 = this.index2a == null || n7 < 15000 ? this.index2.charAt(n7) : this.index2a.charAt(n7 - 15000);
                            if (n6 >= 55296 && n6 <= 56319) {
                                c = this.getSurrogatePair(n4 * 256 + n2);
                                if (c == '\ufffd') {
                                    CoderResult coderResult = CoderResult.unmappableForLength(n5);
                                    return coderResult;
                                }
                                bl = true;
                            }
                            if (n6 == 0 && n3 != 0) {
                                n6 = 65533;
                            }
                            if (n6 == 65533 && n4 == bytePairLead && null != bytePairs) {
                                for (int i = 0; i < bytePairs.length(); ++i) {
                                    if (bytePairs.charAt(i) != n4 * 256 + n2) continue;
                                    int n8 = pairsArray[i];
                                    n6 = (char)(n8 >> 16 & 0xFFFF);
                                    c2 = (char)(n8 & 0xFFFF);
                                    bl2 = true;
                                    break;
                                }
                            }
                        }
                    }
                    if (n6 == 0 && n3 != 0) {
                        n6 = 65533;
                    }
                    if (n6 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n5);
                        return coderResult;
                    }
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (bl || bl2) {
                        n7 = charBuffer.arrayOffset() + charBuffer.position();
                        if (charBuffer.arrayOffset() + charBuffer.limit() - (n7 + 1) < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                    }
                    charBuffer.put((char)n6);
                    if (bl) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c);
                        bl = false;
                    } else if (bl2) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c2);
                        bl2 = false;
                    }
                }
                n += n5;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected char getSurrogatePair(int n) {
        int n2 = this.index1[n >> this.shift] + (n & this.mask2);
        char c = n2 >= 0 ? (indexSurrogate2 == null || n2 < 15000 ? indexSurrogate.charAt(n2) : indexSurrogate2.charAt(n2 - 15000)) : indexSurrogate2.charAt((n2 & 0xFFFF) - 15000);
        if (c == '\u0000' && n != 0) {
            return '\ufffd';
        }
        return c;
    }

    public static char[] expandCharMap(short[] sArray, String string, String string2, int n, int n2) {
        int n3 = 1 << n;
        int n4 = 65536 / n3;
        char[] cArray = new char[65536];
        for (int n5 = 0; n5 < n4; n5 = (int)((short)(n5 + 1))) {
            int n6 = n5 * n3;
            if (sArray[n5] == n2) continue;
            for (int i = 0; i < n3; ++i) {
                int n7 = sArray[n5] + i;
                cArray[n6++] = n7 < 15000 || string2 == null ? string.charAt(n7) : string2.charAt(n7 - 15000);
            }
        }
        return cArray;
    }

    public static char[] expandCharMap(short[] sArray, String string, String string2, String string3, int n, int n2) {
        int n3;
        int n4;
        int n5 = 1 << n;
        int n6 = 65536 / n5;
        char[] cArray = new char[65536];
        for (n4 = 0; n4 < n6; n4 = (int)((short)(n4 + 1))) {
            int n7 = n4 * n5;
            if (sArray[n4] == n2) continue;
            for (n3 = 0; n3 < n5; ++n3) {
                int n8 = sArray[n4] + n3;
                cArray[n7++] = n8 < 15000 || string2 == null ? string.charAt(n8) : string2.charAt(n8 - 15000);
            }
        }
        for (n4 = 0; n4 < 256; n4 = (int)((short)(n4 + 1))) {
            cArray[n4] = string3.charAt(n4);
        }
        cArray[255] = 159;
        for (n3 = 256; n3 < 65536; ++n3) {
            if (cArray[n3] != '\u0000') continue;
            cArray[n3] = 65533;
        }
        return cArray;
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

