/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

class ArabicEncoder
extends CharsetEncoder {
    private final short[] index;
    private final String data;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private byte[] lamAlef;
    private static boolean UseBuffer = false;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;
    private final int[] mask1All = new int[]{65535, 65534, 65532, 65528, 65520, 65504, 65472, 65408, 65280};
    private final int[] mask2All = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    protected static boolean swapAllowed;
    protected static int offset;
    private static String swapValue;

    ArabicEncoder(Charset charset, short[] sArray, String string, int n, byte[] byArray, byte[] byArray2) {
        super(charset, byArray == null ? 1.0f : 1.5f, byArray == null ? 1.0f : 2.0f);
        this.index = sArray;
        this.data = this.handleIBMSwapLF(string);
        this.mask1 = this.mask1All[n];
        this.mask2 = this.mask2All[n];
        this.shift = n;
        this.lamAlef = byArray;
        if (byArray2 != null) {
            this.replaceWith(byArray2);
        }
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    private String handleIBMSwapLF(String string) {
        if (swapAllowed && Boolean.parseBoolean(swapValue = System.getSecurityManager() == null ? new GetPropertyAction("ibm.swapLF").run() : AccessController.doPrivileged(new GetPropertyAction("ibm.swapLF")))) {
            char[] cArray = string.toCharArray();
            cArray[ArabicEncoder.offset] = 37;
            return new String(cArray);
        }
        return string;
    }

    public boolean isLegalReplacement(byte[] byArray) {
        return true;
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
            char c = cArray[n];
            if (Surrogate.is(c)) {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            char c2 = this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
            if (c2 == '\u0000' && c != '\u0000') {
                if (this.lamAlef != null && c > '\ufef4' && c <= '\ufefc') {
                    if (n4 - n3 < 2) {
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    byArray[n3++] = this.lamAlef[0];
                    byArray[n3++] = this.lamAlef[c - 65268];
                    continue;
                }
                coderResult = CoderResult.unmappableForLength(1);
                break;
            }
            if (n4 - n3 < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            byArray[n3++] = (byte)c2;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                char c2 = this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
                if (c2 == '\u0000' && c != '\u0000') {
                    if (this.lamAlef != null && c > '\ufef4' && c <= '\ufefc') {
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put(this.lamAlef[0]);
                        byteBuffer.put(this.lamAlef[c - 65268]);
                        ++n;
                        continue;
                    }
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!byteBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                byteBuffer.put((byte)c2);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        BidiConvert bidiConvert;
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(charBuffer, UseBuffer, this.bidiParms, this.toString())) {
            int n;
            int n2;
            int n3;
            byte[] byArray = this.lamAlef;
            this.lamAlef = null;
            int n4 = charBuffer.remaining();
            if (n4 > byteBuffer.remaining()) {
                n4 = byteBuffer.remaining();
            }
            if (charBuffer.hasArray() && !UseBuffer) {
                char[] cArray = charBuffer.array();
                n3 = charBuffer.arrayOffset() + charBuffer.position();
                n2 = n3 + n4;
                char c = cArray[n3];
                byte by = (byte)this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
                boolean bl = by == 0 && c != '\u0000';
                for (n = n3 + 1; n < n2 && ((by = (byte)this.data.charAt(this.index[(c = cArray[n]) >> this.shift] + (c & this.mask2))) == 0 && c != '\u0000') == bl; ++n) {
                }
                n4 = n - n3;
            } else {
                int n5 = charBuffer.position();
                n2 = n4;
                n = charBuffer.get();
                byte by = (byte)this.data.charAt(this.index[n >> this.shift] + (n & this.mask2));
                boolean bl = by == 0 && n != 0;
                for (n3 = 1; n3 < n2 && ((by = (byte)this.data.charAt(this.index[(n = charBuffer.get()) >> this.shift] + (n & this.mask2))) == 0 && n != 0) == bl; ++n3) {
                }
                charBuffer.position(n5);
                n4 = n3;
            }
            int n6 = charBuffer.limit();
            charBuffer.limit(charBuffer.position() + n4);
            CharBuffer charBuffer2 = bidiConvert.toSbcs(charBuffer, UseBuffer, this.bidiParms, this.toString());
            charBuffer.limit(n6);
            n2 = charBuffer2.position();
            CoderResult coderResult = charBuffer2.hasArray() && byteBuffer.hasArray() && !UseBuffer ? this.encodeArrayLoop(charBuffer2, byteBuffer) : this.encodeBufferLoop(charBuffer2, byteBuffer);
            n2 = charBuffer.position() + charBuffer2.position() - n2;
            charBuffer.position(n2);
            if (coderResult == CoderResult.UNDERFLOW && charBuffer.hasRemaining()) {
                coderResult = CoderResult.OVERFLOW;
            }
            this.lamAlef = byArray;
            return coderResult;
        }
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    static {
        try {
            String string = System.getProperty("java.nio.usebuffer");
            if (string != null && string.length() > 0 && string.charAt(0) == '1') {
                UseBuffer = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        swapAllowed = false;
    }
}

