/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.nio.ByteBuffer;
import java.security.AccessController;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public abstract class CharToByteSingleByte
extends CharToByteConverter {
    protected short[] index1;
    protected char[] index2;
    protected final byte[] byteMap;
    protected int mask1;
    protected int mask2;
    protected int shift;
    private char highHalfZoneCode;
    private static final int NOOUTPUT = 256;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;
    private final int kMinStringSize = 25;
    static final byte kSentinalValue = 0;
    protected ByteBuffer trtoXlateTable = null;

    public CharToByteSingleByte() {
        this.byteMap = null;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    protected CharToByteSingleByte(byte[] byArray) {
        this.byteMap = byArray;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public String getType() {
        return "sbcs";
    }

    public short[] getIndex() {
        return this.index1;
    }

    public char[] getCharData() {
        return this.index2;
    }

    public byte[] getByteData() {
        return this.byteMap;
    }

    public int getShift() {
        return this.shift;
    }

    public int flush(byte[] byArray, int n, int n2) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        int n5;
        boolean bl;
        int n6;
        int n7;
        int n8;
        int n9;
        block26: {
            char c;
            byte by;
            int n10;
            block28: {
                byte by2;
                block27: {
                    block25: {
                        Object object;
                        BidiConvert bidiConvert;
                        n9 = 256;
                        this.charOff = n;
                        this.byteOff = n3;
                        if (this.highHalfZoneCode != '\u0000') {
                            char c2 = this.highHalfZoneCode;
                            this.highHalfZoneCode = '\u0000';
                            if (cArray[n] >= '\udc00' && cArray[n] <= '\udfff') {
                                this.badInputLength = 1;
                                throw new UnknownCharacterException();
                            }
                            this.badInputLength = 0;
                            throw new MalformedInputException();
                        }
                        n8 = n;
                        n7 = n3;
                        n6 = n2 - n8;
                        int n11 = n4 - n7;
                        boolean bl2 = true;
                        bl = false;
                        if (n11 < n6) {
                            n6 = n11;
                            bl = true;
                        }
                        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n, n + n6, this.bidiParms, this.getCharacterEncoding())) {
                            object = new char[n6];
                            object = bidiConvert.toSbcs(cArray, n, n + n6, this.bidiParms, this.getCharacterEncoding());
                            System.arraycopy(object, 0, cArray, n, n6);
                        }
                        n5 = n7 + n6;
                        if (this.byteMap == null) break block25;
                        if (null != this.trtoXlateTable && n6 > 25) {
                            object = this.trtoXlateTable;
                            if (0 != this.JITintrinsicConvert((ByteBuffer)object, cArray, n8 + n6, byArray)) {
                                bl2 = false;
                                n8 += this.byteOff - n7;
                                n7 = this.byteOff;
                            } else if (n7 != this.byteOff) {
                                bl2 = false;
                                this.byteOff = n7;
                                this.charOff = n8;
                            }
                        }
                        if (!bl2) break block26;
                        break block27;
                    }
                    n10 = this.mask2;
                    break block28;
                }
                while (n7 < n5 && (by2 = this.byteMap[cArray[n8]]) != 0) {
                    ++n8;
                    byArray[n7++] = by2;
                }
                this.byteOff = n7;
                this.charOff = n8;
                break block26;
            }
            while (n7 < n5 && (by = (byte)this.index2[this.index1[(c = cArray[n8]) >> this.shift] + (c & n10)]) != 0) {
                ++n8;
                byArray[n7++] = by;
            }
        }
        this.byteOff = n7;
        this.charOff = n8;
        if (n7 == n5) {
            if (!bl) return n6;
            throw new ConversionBufferFullException();
        }
        while (this.charOff < n2) {
            int n12;
            block24: {
                char c = cArray[this.charOff];
                n12 = 1;
                if ((c & 0xF800) == 55296) {
                    if (c <= '\udbff') {
                        if (this.charOff + 1 >= n2) {
                            this.highHalfZoneCode = c;
                            return this.byteOff - n3;
                        }
                        c = cArray[this.charOff + 1];
                        if (c >= '\udc00' && c <= '\udfff') {
                            if (!this.subMode) {
                                this.badInputLength = 2;
                                throw new UnknownCharacterException();
                            }
                            n9 = this.subBytes.length > 0 ? this.subBytes[0] : 256;
                            n12 = 2;
                            break block24;
                        } else {
                            this.badInputLength = 1;
                            throw new MalformedInputException();
                        }
                    }
                    if (c <= '\udfff') {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                } else {
                    n9 = (byte)(this.byteMap != null ? this.byteMap[c] : (byte)this.index2[this.index1[c >> this.shift] + (c & this.mask2)]);
                    byte by = (byte)n9;
                    if (n9 == 0 && cArray[this.charOff] != '\u0000') {
                        if (!this.subMode) {
                            this.badInputLength = 1;
                            throw new UnknownCharacterException();
                        }
                        int n13 = n9 = this.subBytes.length > 0 ? this.subBytes[0] : 256;
                    }
                }
            }
            if (this.byteOff >= n4) {
                throw new ConversionBufferFullException();
            }
            if (n9 != 256) {
                byArray[this.byteOff++] = (byte)n9;
            }
            this.charOff += n12;
        }
        return this.byteOff - n3;
    }

    public int getMaxBytesPerChar() {
        return 1;
    }

    public byte getNative(char c) {
        if (this.byteMap != null) {
            return this.byteMap[c];
        }
        return (byte)this.index2[this.index1[c >> this.shift] + (c & this.mask2)];
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    public boolean canConvert(char c) {
        if (this.getNative(c) != 0) {
            return true;
        }
        return c == '\u0000';
    }

    public static byte[] expandByteMap(short[] sArray, char[] cArray, int n, int n2) {
        if (n < 5 || n > 8) {
            return null;
        }
        int n3 = 1 << n;
        int n4 = 65536 / n3;
        byte[] byArray = new byte[65536];
        for (int i = 0; i < n4; ++i) {
            int n5 = i * n3;
            if (sArray[i] == n2) continue;
            for (int j = 0; j < n3; ++j) {
                byArray[n5++] = (byte)cArray[sArray[i] + j];
            }
        }
        return byArray;
    }

    public static byte[] expandByteMap(short[] sArray, String string, int n, int n2) {
        if (n < 5 || n > 8) {
            return null;
        }
        int n3 = 1 << n;
        int n4 = 65536 / n3;
        byte[] byArray = new byte[65536];
        for (int i = 0; i < n4; ++i) {
            int n5 = i * n3;
            if (sArray[i] == n2) continue;
            for (int j = 0; j < n3; ++j) {
                byArray[n5++] = (byte)string.charAt(sArray[i] + j);
            }
        }
        return byArray;
    }

    protected static void insertTRTOsentinals(ByteBuffer byteBuffer) {
        if (null == byteBuffer) {
            return;
        }
        for (int i = 55296; i <= 55551; ++i) {
            byteBuffer.position(i);
            byteBuffer.put((byte)0);
        }
    }

    private int JITintrinsicConvert(ByteBuffer byteBuffer, char[] cArray, int n, byte[] byArray) {
        int n2;
        int n3 = this.byteOff;
        int n4 = this.charOff;
        for (n2 = 0; n2 < n - n4; ++n2) {
            byte by = byteBuffer.get(cArray[n2 + n4]);
            if (by == 0) {
                return 0;
            }
            byArray[n2 + n3] = by;
        }
        this.byteOff += n2;
        this.charOff += n2;
        return n2;
    }

    protected static final ByteBuffer createCopy(byte[] byArray) {
        ByteBuffer byteBuffer = null;
        byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        if (null == byteBuffer) {
            throw new OutOfMemoryError();
        }
        byteBuffer.put(byArray);
        CharToByteSingleByte.insertTRTOsentinals(byteBuffer);
        return byteBuffer;
    }
}

