/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.Trace;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.ui.DownloadWindow;
import com.sun.jnlp.JNLPClassLoader;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;

public final class DownloadServiceImpl
implements DownloadService {
    private static DownloadServiceImpl _sharedInstance = null;
    private DownloadServiceListener _defaultProgress = null;

    private DownloadServiceImpl() {
    }

    public static synchronized DownloadServiceImpl getInstance() {
        DownloadServiceImpl.initialize();
        return _sharedInstance;
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new DownloadServiceImpl();
        }
    }

    public DownloadServiceListener getDefaultProgressWindow() {
        if (this._defaultProgress == null) {
            this._defaultProgress = (DownloadServiceListener)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DownloadWindow downloadWindow = new DownloadWindow();
                    downloadWindow.initialize(JNLPClassLoader.getInstance().getLaunchDesc(), false, false);
                    return new DefaultProgressImpl(downloadWindow);
                }
            });
        }
        return this._defaultProgress;
    }

    public boolean isResourceCached(final URL uRL, final String string) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DownloadServiceImpl.this.isResourceValid(uRL, string)) {
                    try {
                        if (DownloadEngine.isResourceCached((URL)uRL, null, (String)string)) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                    }
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    public boolean isPartCached(String string) {
        return this.isPartCached(new String[]{string});
    }

    public boolean isPartCached(final String[] stringArray) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                return new Boolean(DownloadServiceImpl.this.isJARInCache(jARDescArray, true));
            }
        });
        return bl;
    }

    public boolean isExtensionPartCached(URL uRL, String string, String string2) {
        return this.isExtensionPartCached(uRL, string, new String[]{string2});
    }

    public boolean isExtensionPartCached(final URL uRL, final String string, final String[] stringArray) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc == null) {
                    return Boolean.FALSE;
                }
                JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                return new Boolean(DownloadServiceImpl.this.isJARInCache(jARDescArray, true));
            }
        });
        return bl;
    }

    public void loadResource(final URL uRL, final String string, final DownloadServiceListener downloadServiceListener) throws IOException {
        if (this.isResourceValid(uRL, string)) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        ProgressHelper progressHelper = new ProgressHelper(downloadServiceListener);
                        try {
                            if (uRL.toString().endsWith(".jar")) {
                                JNLPClassLoader jNLPClassLoader = JNLPClassLoader.getInstance();
                                jNLPClassLoader.addResource(uRL, string, null);
                                if (!DownloadServiceImpl.this.isResourceCached(uRL, string)) {
                                    progressHelper = new ProgressHelper(downloadServiceListener);
                                    jNLPClassLoader.downloadResource(uRL, string, progressHelper, true);
                                }
                            } else {
                                DownloadEngine.getResource((URL)uRL, null, (String)string, null, (boolean)true);
                            }
                        }
                        catch (JNLPException jNLPException) {
                            throw new IOException(jNLPException.getMessage());
                        }
                        finally {
                            progressHelper.done();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    public void loadPart(String string, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadPart(new String[]{string}, downloadServiceListener);
    }

    public void loadPart(final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        if (this.isPartCached(stringArray)) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ProgressHelper progressHelper = new ProgressHelper(downloadServiceListener);
                    try {
                        JNLPClassLoader.getInstance().downloadParts(stringArray, progressHelper, true);
                    }
                    catch (JNLPException jNLPException) {
                        throw new IOException(jNLPException.getMessage());
                    }
                    finally {
                        progressHelper.done();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void loadExtensionPart(URL uRL, String string, String string2, DownloadServiceListener downloadServiceListener) throws IOException {
        this.loadExtensionPart(uRL, string, new String[]{string2}, downloadServiceListener);
    }

    public void loadExtensionPart(final URL uRL, final String string, final String[] stringArray, final DownloadServiceListener downloadServiceListener) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ProgressHelper progressHelper = new ProgressHelper(downloadServiceListener);
                    try {
                        JNLPClassLoader.getInstance().downloadExtensionParts(uRL, string, stringArray, progressHelper, true);
                    }
                    catch (JNLPException jNLPException) {
                        throw new IOException(jNLPException.getMessage());
                    }
                    finally {
                        progressHelper.done();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removeResource(final URL uRL, final String string) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (DownloadServiceImpl.this.isResourceValid(uRL, string)) {
                        if (uRL.toString().endsWith("jnlp")) {
                            CacheUtil.remove(Cache.getCacheEntry((URL)uRL, null, (String)string));
                        }
                        DownloadEngine.removeCachedResource((URL)uRL, null, (String)string);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removePart(String string) throws IOException {
        this.removePart(new String[]{string});
    }

    public void removePart(final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getPartJars(stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public void removeExtensionPart(URL uRL, String string, String string2) throws IOException {
        this.removeExtensionPart(uRL, string, new String[]{string2});
    }

    public void removeExtensionPart(final URL uRL, final String string, final String[] stringArray) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
                    ResourcesDesc resourcesDesc = launchDesc.getResources();
                    if (resourcesDesc == null) {
                        return null;
                    }
                    JARDesc[] jARDescArray = resourcesDesc.getExtensionPart(uRL, string, stringArray);
                    DownloadServiceImpl.this.removeJARFromCache(jARDescArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void removeJARFromCache(JARDesc[] jARDescArray) throws IOException {
        if (jARDescArray == null) {
            return;
        }
        if (jARDescArray.length == 0) {
            return;
        }
        for (int i = 0; i < jARDescArray.length; ++i) {
            DownloadEngine.removeCachedResource((URL)jARDescArray[i].getLocation(), null, (String)jARDescArray[i].getVersion());
        }
    }

    private boolean isJARInCache(JARDesc[] jARDescArray, boolean bl) {
        if (jARDescArray == null) {
            return false;
        }
        if (jARDescArray.length == 0) {
            return false;
        }
        boolean bl2 = true;
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (jARDescArray[i].isNativeLib()) {
                try {
                    if (DownloadEngine.getCachedJarFile((URL)jARDescArray[i].getLocation(), (String)jARDescArray[i].getVersion()) != null) {
                        if (bl) continue;
                        return true;
                    }
                    bl2 = false;
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                    bl2 = false;
                }
                continue;
            }
            try {
                if (DownloadEngine.getCachedJarFile((URL)jARDescArray[i].getLocation(), (String)jARDescArray[i].getVersion()) != null) {
                    if (bl) continue;
                    return true;
                }
                bl2 = false;
                continue;
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
                bl2 = false;
            }
        }
        return bl2;
    }

    private boolean isResourceValid(URL uRL, String string) {
        LaunchDesc launchDesc = JNLPClassLoader.getInstance().getLaunchDesc();
        JARDesc[] jARDescArray = launchDesc.getResources().getEagerOrAllJarDescs(true);
        if (launchDesc.getSecurityModel() != 0) {
            return true;
        }
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (!uRL.toString().equals(jARDescArray[i].getLocation().toString()) || string != null && !string.equals(jARDescArray[i].getVersion())) continue;
            return true;
        }
        URL uRL2 = launchDesc.getCodebase();
        return uRL2 != null && uRL != null && uRL.toString().startsWith(uRL2.toString());
    }

    private class ProgressHelper
    implements LaunchDownload.DownloadProgress {
        DownloadServiceListener _dsp = null;

        public ProgressHelper(DownloadServiceListener downloadServiceListener) {
            this._dsp = downloadServiceListener;
            if (this._dsp instanceof DefaultProgressImpl) {
                ((DefaultProgressImpl)this._dsp).initialize();
            }
            this._dsp.progress(null, null, 0L, 0L, -1);
        }

        public void extensionDownload(String string, int n) {
        }

        public void jreDownload(String string, URL uRL) {
        }

        public void progress(URL uRL, String string, long l, long l2, int n) {
            if (this._dsp != null) {
                this._dsp.progress(uRL, string, l, l2, n);
            }
        }

        public void validating(URL uRL, String string, long l, long l2, int n) {
            if (this._dsp != null) {
                this._dsp.validating(uRL, string, l, l2, n);
            }
        }

        public void patching(URL uRL, String string, int n, int n2) {
            if (this._dsp != null) {
                this._dsp.upgradingArchive(uRL, string, n, n2);
            }
        }

        public void downloadFailed(URL uRL, String string) {
            if (this._dsp != null) {
                this._dsp.downloadFailed(uRL, string);
            }
        }

        public void done() {
            if (this._dsp instanceof DefaultProgressImpl) {
                ((DefaultProgressImpl)this._dsp).done();
            }
        }
    }

    private class DefaultProgressImpl
    implements DownloadServiceListener {
        private DownloadWindow _dw = null;

        DefaultProgressImpl(final DownloadWindow downloadWindow) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DefaultProgressImpl.this._dw = downloadWindow;
                    DefaultProgressImpl.this._dw.showLoadingProgressScreen();
                    return null;
                }
            });
        }

        public void initialize() {
            this._dw.resetCancled();
        }

        public void progress(URL uRL, String string, long l, long l2, int n) {
            this.ensureVisible();
            this._dw.progress(uRL, string, l, l2, n);
            if (this._dw.isCanceled()) {
                throw new RuntimeException("canceled by user");
            }
        }

        public void validating(URL uRL, String string, long l, long l2, int n) {
            this.ensureVisible();
            this._dw.validating(uRL, string, l, l2, n);
        }

        public void upgradingArchive(URL uRL, String string, int n, int n2) {
            this.ensureVisible();
            this._dw.patching(uRL, string, n, n2);
        }

        public void downloadFailed(URL uRL, String string) {
            this.hideFrame();
        }

        private void ensureVisible() {
            if (!this._dw.isVisible()) {
                this._dw.setVisible(true);
            }
        }

        private synchronized void hideFrame() {
            this._dw.resetCancled();
            this._dw.setVisible(false);
        }

        public void done() {
            this.hideFrame();
        }
    }
}

