/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.CacheUtil;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.javaws.ui.CacheObject;
import com.sun.javaws.ui.CacheTable;
import com.sun.javaws.ui.DownloadWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CacheViewer
extends JDialog
implements ListSelectionListener,
PopupMenuListener {
    private final JPanel tablePanel = new JPanel(new BorderLayout());
    private CacheTable jnlpTable = null;
    private CacheTable resourceTable = null;
    private CacheTable importTable = null;
    private CacheTable sysJnlpTable = null;
    private CacheTable sysResourceTable = null;
    private CacheTable activeTable;
    private boolean noSeparator = false;
    private boolean wasDirty = false;
    private int leadinSpace;
    private int minSpace;
    private JComboBox viewComboBox;
    private JLabel viewLabel;
    private JToolBar toolbar;
    private JLabel sizeLabel = new JLabel("");
    private JButton runButton;
    private JButton removeButton;
    private JButton installButton;
    private JButton showButton;
    private JButton showResourceButton;
    private JButton homeButton;
    private JButton removeResourceButton;
    private JButton removeRemovedButton;
    private JButton importButton;
    private JButton closeButton;
    private JPopupMenu runPopup;
    private JMenuItem onlineMI;
    private JMenuItem offlineMI;
    private JPopupMenu popup;
    private JMenuItem runOnlineMI;
    private JMenuItem runOfflineMI;
    private JMenuItem installMI;
    private JMenuItem removeMI;
    private JMenuItem showMI;
    private JMenuItem showResourceMI;
    private JMenuItem homeMI;
    private JMenuItem importMI;
    private static final int WAIT_REMOVE = 0;
    private static final int WAIT_IMPORT = 1;
    private ImageIcon dummy = null;
    private static final String BOUNDS_PROPERTY_KEY = "deployment.javaws.viewer.bounds";
    private final int SLEEP_DELAY = 2000;

    private CacheViewer(JFrame jFrame) {
        super(jFrame);
        Cache.setDoIPLookup((boolean)false);
        this.setTitle(this.getResource("viewer.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CacheViewer.this.exitViewer();
            }
        });
        this.initComponents();
        this.wasDirty = Config.isDirty();
    }

    private void refresh() {
        final int n = this.viewComboBox.getSelectedIndex();
        final Dimension dimension = new Dimension(this.minSpace, 0);
        final Dimension dimension2 = new Dimension(8, 0);
        final Dimension dimension3 = new Dimension(this.leadinSpace, 0);
        final Dimension dimension4 = new Dimension(4, 0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JButton jButton;
                JButton jButton2;
                Component[] componentArray = CacheViewer.this.toolbar.getComponents();
                if (componentArray.length == 0) {
                    CacheViewer.this.toolbar.add(new Box.Filler(dimension2, dimension2, dimension2));
                    CacheViewer.this.toolbar.add(CacheViewer.this.viewLabel);
                    CacheViewer.this.toolbar.add(new Box.Filler(dimension4, dimension4, dimension4));
                    CacheViewer.this.toolbar.add(CacheViewer.this.viewComboBox);
                    CacheViewer.this.toolbar.add(new Box.Filler(dimension3, dimension3, dimension3));
                } else {
                    for (int i = componentArray.length - 1; i > 4; --i) {
                        CacheViewer.this.toolbar.remove(i);
                    }
                }
                switch (n) {
                    default: {
                        if (CacheViewer.this.jnlpTable == null) {
                            CacheViewer.this.jnlpTable = new CacheTable(CacheViewer.this, 0, false);
                        }
                        CacheViewer.this.sizeLabel.setText(CacheViewer.this.jnlpTable.getSizeLabelText());
                        CacheViewer.this.activeTable = CacheViewer.this.jnlpTable;
                        CacheViewer.this.toolbar.add(CacheViewer.this.runButton);
                        jButton2 = CacheViewer.this.runButton;
                        if (CacheViewer.this.noSeparator) {
                            CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        } else {
                            CacheViewer.this.toolbar.addSeparator(dimension2);
                            CacheViewer.this.toolbar.add(new VSeparator());
                            CacheViewer.this.toolbar.addSeparator(dimension2);
                        }
                        CacheViewer.this.toolbar.add(CacheViewer.this.showButton);
                        CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        CacheViewer.this.toolbar.add(CacheViewer.this.installButton);
                        if (CacheViewer.this.noSeparator) {
                            CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        } else {
                            CacheViewer.this.toolbar.addSeparator(dimension2);
                            CacheViewer.this.toolbar.add(new VSeparator());
                            CacheViewer.this.toolbar.addSeparator(dimension2);
                        }
                        CacheViewer.this.toolbar.add(CacheViewer.this.removeButton);
                        CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        CacheViewer.this.toolbar.add(CacheViewer.this.homeButton);
                        CacheViewer.this.runButton.setNextFocusableComponent(CacheViewer.this.showButton);
                        CacheViewer.this.showButton.setNextFocusableComponent(CacheViewer.this.installButton);
                        CacheViewer.this.installButton.setNextFocusableComponent(CacheViewer.this.removeButton);
                        CacheViewer.this.removeButton.setNextFocusableComponent(CacheViewer.this.homeButton);
                        jButton = CacheViewer.this.homeButton;
                        break;
                    }
                    case 1: {
                        if (CacheViewer.this.resourceTable == null) {
                            CacheViewer.this.resourceTable = new CacheTable(CacheViewer.this, 1, false);
                        }
                        CacheViewer.this.sizeLabel.setText(CacheViewer.this.resourceTable.getSizeLabelText());
                        CacheViewer.this.activeTable = CacheViewer.this.resourceTable;
                        CacheViewer.this.toolbar.add(CacheViewer.this.showResourceButton);
                        jButton2 = CacheViewer.this.showResourceButton;
                        CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        CacheViewer.this.toolbar.add(CacheViewer.this.removeResourceButton);
                        CacheViewer.this.showResourceButton.setNextFocusableComponent(CacheViewer.this.removeResourceButton);
                        jButton = CacheViewer.this.removeResourceButton;
                        break;
                    }
                    case 2: {
                        if (CacheViewer.this.importTable == null) {
                            CacheViewer.this.importTable = new CacheTable(CacheViewer.this, 2, false);
                        }
                        CacheViewer.this.sizeLabel.setText(CacheViewer.this.importTable.getSizeLabelText());
                        CacheViewer.this.activeTable = CacheViewer.this.importTable;
                        CacheViewer.this.toolbar.add(CacheViewer.this.importButton);
                        jButton2 = CacheViewer.this.importButton;
                        CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        CacheViewer.this.toolbar.add(CacheViewer.this.removeRemovedButton);
                        CacheViewer.this.importButton.setNextFocusableComponent(CacheViewer.this.removeRemovedButton);
                        jButton = CacheViewer.this.removeRemovedButton;
                        break;
                    }
                    case 3: {
                        if (CacheViewer.this.sysJnlpTable == null) {
                            CacheViewer.this.sysJnlpTable = new CacheTable(CacheViewer.this, 0, true);
                        }
                        CacheViewer.this.sizeLabel.setText(CacheViewer.this.sysJnlpTable.getSizeLabelText());
                        CacheViewer.this.activeTable = CacheViewer.this.sysJnlpTable;
                        CacheViewer.this.toolbar.add(CacheViewer.this.runButton);
                        jButton2 = CacheViewer.this.runButton;
                        if (CacheViewer.this.noSeparator) {
                            CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        } else {
                            CacheViewer.this.toolbar.addSeparator(dimension2);
                            CacheViewer.this.toolbar.add(new VSeparator());
                            CacheViewer.this.toolbar.addSeparator(dimension2);
                        }
                        CacheViewer.this.toolbar.add(CacheViewer.this.showButton);
                        CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        CacheViewer.this.toolbar.add(CacheViewer.this.installButton);
                        if (CacheViewer.this.noSeparator) {
                            CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        } else {
                            CacheViewer.this.toolbar.addSeparator(dimension2);
                            CacheViewer.this.toolbar.add(new VSeparator());
                            CacheViewer.this.toolbar.addSeparator(dimension2);
                        }
                        CacheViewer.this.toolbar.add(CacheViewer.this.removeButton);
                        CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        CacheViewer.this.toolbar.add(CacheViewer.this.homeButton);
                        CacheViewer.this.runButton.setNextFocusableComponent(CacheViewer.this.showButton);
                        CacheViewer.this.showButton.setNextFocusableComponent(CacheViewer.this.installButton);
                        CacheViewer.this.installButton.setNextFocusableComponent(CacheViewer.this.removeButton);
                        CacheViewer.this.removeButton.setNextFocusableComponent(CacheViewer.this.homeButton);
                        jButton = CacheViewer.this.homeButton;
                        break;
                    }
                    case 4: {
                        if (CacheViewer.this.sysResourceTable == null) {
                            CacheViewer.this.sysResourceTable = new CacheTable(CacheViewer.this, 1, true);
                        }
                        CacheViewer.this.sizeLabel.setText(CacheViewer.this.sysResourceTable.getSizeLabelText());
                        CacheViewer.this.activeTable = CacheViewer.this.sysResourceTable;
                        CacheViewer.this.toolbar.add(CacheViewer.this.showResourceButton);
                        jButton2 = CacheViewer.this.showResourceButton;
                        CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                        CacheViewer.this.toolbar.add(CacheViewer.this.removeResourceButton);
                        CacheViewer.this.showResourceButton.setNextFocusableComponent(CacheViewer.this.removeResourceButton);
                        jButton = CacheViewer.this.removeResourceButton;
                    }
                }
                CacheViewer.this.popup = new JPopupMenu();
                CacheViewer.this.popup.addPopupMenuListener(CacheViewer.this);
                switch (n) {
                    case 0: 
                    case 3: {
                        CacheViewer.this.popup.add(CacheViewer.this.runOnlineMI);
                        CacheViewer.this.popup.add(CacheViewer.this.runOfflineMI);
                        CacheViewer.this.popup.addSeparator();
                        CacheViewer.this.popup.add(CacheViewer.this.installMI);
                        CacheViewer.this.popup.add(CacheViewer.this.removeMI);
                        CacheViewer.this.popup.addSeparator();
                        CacheViewer.this.popup.add(CacheViewer.this.showMI);
                        CacheViewer.this.popup.add(CacheViewer.this.homeMI);
                        break;
                    }
                    case 1: 
                    case 4: {
                        CacheViewer.this.popup.add(CacheViewer.this.showResourceMI);
                        CacheViewer.this.popup.add(CacheViewer.this.removeMI);
                        break;
                    }
                    case 2: {
                        CacheViewer.this.popup.add(CacheViewer.this.importMI);
                        CacheViewer.this.popup.add(CacheViewer.this.removeMI);
                    }
                }
                JScrollPane jScrollPane = new JScrollPane(CacheViewer.this.activeTable);
                CacheViewer.this.toolbar.add(new Box.Filler(dimension, dimension, dimension));
                CacheViewer.this.toolbar.add(new remainingSpacer());
                CacheViewer.this.toolbar.add(CacheViewer.this.sizeLabel);
                CacheViewer.this.toolbar.add(new Box.Filler(dimension2, dimension2, dimension2));
                CacheViewer.this.tablePanel.removeAll();
                CacheViewer.this.tablePanel.add(jScrollPane);
                CacheViewer.this.enableButtons();
                CacheViewer.this.closeButton.setNextFocusableComponent(CacheViewer.this.viewComboBox);
                CacheViewer.this.viewComboBox.setNextFocusableComponent(jButton2);
                jButton.setNextFocusableComponent(CacheViewer.this.activeTable);
                CacheViewer.this.validate();
                CacheViewer.this.repaint();
            }
        });
    }

    private void initComponents() {
        this.tablePanel.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.title"));
        this.tablePanel.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage((String)"viewer.title.description"));
        this.sizeLabel.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage((String)"viewer.size.description"));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.title"));
        jPanel.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage((String)"viewer.title.description"));
        jPanel2.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.title"));
        jPanel2.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage((String)"viewer.title.description"));
        this.toolbar = new JToolBar();
        this.toolbar.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.title"));
        this.toolbar.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage((String)"viewer.title.description"));
        this.toolbar.setBorderPainted(false);
        this.toolbar.setFloatable(false);
        this.toolbar.setMargin(new Insets(2, 2, 0, 0));
        this.toolbar.setRollover(true);
        String string = UIManager.getLookAndFeel().getID();
        if (string.startsWith("Windows")) {
            this.leadinSpace = 27;
            this.minSpace = 4;
            this.noSeparator = false;
        } else {
            this.leadinSpace = 30;
            this.noSeparator = true;
            this.minSpace = string.startsWith("GTK") ? 2 : 10;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.runApplication(true);
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.runApplication(false);
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.installApplication();
            }
        };
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.importApplication();
            }
        };
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.delete();
            }
        };
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CacheViewer.this.activeTable == CacheViewer.this.jnlpTable || CacheViewer.this.activeTable == CacheViewer.this.sysJnlpTable) {
                    CacheViewer.this.showApplication();
                } else if (CacheViewer.this.activeTable == CacheViewer.this.resourceTable || CacheViewer.this.activeTable == CacheViewer.this.sysResourceTable) {
                    CacheViewer.this.showInformation();
                }
            }
        };
        ActionListener actionListener7 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.browseApplication();
            }
        };
        this.runOnlineMI = this.createMI("viewer.run.online.menuitem", actionListener);
        this.runOfflineMI = this.createMI("viewer.run.offline.menuitem", actionListener2);
        this.installMI = this.createMI("viewer.install.menuitem", actionListener3);
        this.removeMI = this.createMI("viewer.remove.menuitem", actionListener5);
        this.showMI = this.createMI("viewer.show.menuitem", actionListener6);
        this.showResourceMI = this.createMI("viewer.show.resource.menuitem", actionListener6);
        this.homeMI = this.createMI("viewer.home.menuitem", actionListener7);
        this.importMI = this.createMI("viewer.import.menuitem", actionListener4);
        boolean bl = Config.getSystemCacheDirectory() != null && !Environment.isSystemCacheMode();
        Object[] objectArray = bl ? new String[5] : new String[3];
        objectArray[0] = this.getResource("viewer.view.jnlp");
        objectArray[1] = this.getResource("viewer.view.res");
        objectArray[2] = this.getResource("viewer.view.import");
        if (bl) {
            objectArray[3] = this.getResource("viewer.sys.view.jnlp");
            objectArray[4] = this.getResource("viewer.sys.view.res");
        }
        this.viewComboBox = new JComboBox(objectArray){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.refresh();
            }
        });
        this.viewComboBox.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.view.label"));
        this.viewComboBox.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage((String)"viewer.view.label.description"));
        this.viewLabel = new JLabel(this.getResource("viewer.view.label"));
        this.viewLabel.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.view.label"));
        this.viewLabel.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage((String)"viewer.view.label.description"));
        this.runButton = this.createRunButton("viewer.run.online");
        this.importButton = this.createImageButton("viewer.import", 0);
        this.importButton.addActionListener(actionListener4);
        this.importButton.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.import.name"));
        this.runButton.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.run.online.menuitem"));
        this.removeButton = this.createImageButton("viewer.remove", 0);
        this.removeButton.addActionListener(actionListener5);
        this.removeButton.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.remove.name"));
        this.removeResourceButton = this.createImageButton("viewer.remove.res", 0);
        this.removeResourceButton.addActionListener(actionListener5);
        this.removeResourceButton.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.remove.res.name"));
        this.removeRemovedButton = this.createImageButton("viewer.remove.removed", 0);
        this.removeRemovedButton.addActionListener(actionListener5);
        this.removeRemovedButton.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.remove.name"));
        this.installButton = this.createImageButton("viewer.install", 0);
        this.installButton.addActionListener(actionListener3);
        this.installButton.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.install.name"));
        this.showButton = this.createImageButton("viewer.show", 0);
        this.showButton.addActionListener(actionListener6);
        this.showButton.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.show.name"));
        this.showResourceButton = this.createImageButton("viewer.info", 0);
        this.showResourceButton.addActionListener(actionListener6);
        this.showResourceButton.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.info.name"));
        this.homeButton = this.createImageButton("viewer.home", 0);
        this.homeButton.addActionListener(actionListener7);
        this.homeButton.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.home.name"));
        this.tablePanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 6, 12));
        this.closeButton = new JButton(this.getResource("viewer.close"));
        this.closeButton.getAccessibleContext().setAccessibleName(ResourceManager.getMessage((String)"viewer.close"));
        this.closeButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage((String)"viewer.close.tooltip"));
        this.closeButton.setMnemonic(67);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.exitViewer();
            }
        });
        this.addCancelAction();
        JButton jButton = new JButton(this.getResource("viewer.help"));
        jButton.setMnemonic(ResourceManager.getVKCode((String)"viewer.help.mnemonic"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.help();
            }
        });
        jPanel2.add(this.closeButton);
        jPanel.add((Component)jPanel2, "East");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.toolbar, "Center");
        jPanel3.add((Component)new JSeparator(), "South");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.tablePanel, "Center");
        jPanel4.add((Component)jPanel, "South");
        this.getContentPane().add((Component)jPanel3, "North");
        this.getContentPane().add((Component)jPanel4, "Center");
        this.runPopup = new JPopupMenu();
        this.onlineMI = this.runPopup.add(this.getResource("viewer.run.online.mi"));
        this.onlineMI.setEnabled(false);
        this.onlineMI.setIcon(this.getIcon("viewer.run.online.mi.icon"));
        this.onlineMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.runApplication(true);
            }
        });
        this.offlineMI = this.runPopup.add(this.getResource("viewer.run.offline.mi"));
        this.offlineMI.setEnabled(false);
        this.offlineMI.setIcon(this.getIcon("viewer.run.offline.mi.icon"));
        this.offlineMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.runApplication(false);
            }
        });
        this.runPopup.addPopupMenuListener(this);
        this.runPopup.addMenuKeyListener(new MenuKeyListener(){

            public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
                int n = menuKeyEvent.getKeyCode();
                if (n == 9 || n == 39 || n == 37) {
                    CacheViewer.this.runPopup.setVisible(false);
                }
            }

            public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
            }

            public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            }
        });
        this.jnlpTable = new CacheTable(this, 0, false);
        if (this.jnlpTable.getModel().getRowCount() != 0) {
            this.viewComboBox.setSelectedIndex(0);
            this.focusLater(this.jnlpTable);
            return;
        }
        this.resourceTable = new CacheTable(this, 1, false);
        if (this.resourceTable.getModel().getRowCount() != 0) {
            this.viewComboBox.setSelectedIndex(1);
            this.focusLater(this.resourceTable);
            return;
        }
        this.importTable = new CacheTable(this, 2, false);
        if (this.importTable.getModel().getRowCount() != 0) {
            this.viewComboBox.setSelectedIndex(2);
            this.focusLater(this.importTable);
            return;
        }
        this.focusLater(this.closeButton);
        this.refresh();
    }

    private void focusLater(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.requestFocus();
            }
        });
    }

    public void addCancelAction() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancelViewer");
        this.getRootPane().getActionMap().put("cancelViewer", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CacheViewer.this.exitViewer();
            }
        });
    }

    public void removeCancelAction() {
        InputMap inputMap = this.getRootPane().getInputMap(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        if (inputMap != null) {
            inputMap.remove(keyStroke);
            this.getRootPane().setInputMap(2, inputMap);
        }
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.addCancelAction();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.removeCancelAction();
    }

    void runApplication() {
        CacheObject cacheObject = this.getSelectedCacheObject();
        LaunchDesc launchDesc = cacheObject.getLaunchDesc();
        this.runApplication(launchDesc.getLocation() != null);
    }

    void delete() {
        if (this.activeTable == this.jnlpTable) {
            this.removeApplications();
        } else if (this.activeTable == this.resourceTable) {
            this.removeResources();
        } else if (this.activeTable == this.importTable) {
            this.removeRemoved();
        }
    }

    void runApplication(boolean bl) {
        try {
            LaunchDesc launchDesc;
            CacheObject cacheObject = this.getSelectedCacheObject();
            if (cacheObject != null && (launchDesc = cacheObject.getLaunchDesc()) != null && launchDesc.isApplicationDescriptor() && (bl && launchDesc.getLocation() != null || launchDesc.getInformation().supportsOfflineOperation())) {
                String[] stringArray = new String[]{Config.getJavawsCommand(), bl ? "-online" : "-offline", cacheObject.getJnlpFile().getPath()};
                Process process = Runtime.getRuntime().exec(stringArray);
                this.traceStream(process.getInputStream());
                this.traceStream(process.getErrorStream());
            }
        }
        catch (Throwable throwable) {
            Trace.ignored((Throwable)throwable);
        }
    }

    void removeApplications() {
        this.removeResources();
    }

    void importApplication() {
        if (this.activeTable == this.importTable) {
            try {
                CacheObject[] cacheObjectArray = this.getSelectedCacheObjects();
                if (cacheObjectArray.length > 0) {
                    this.showWaitDialog(cacheObjectArray, 1);
                }
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }
    }

    void installApplication() {
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        CacheObject cacheObject = this.getSelectedCacheObject();
        if (cacheObject != null && localInstallHandler.isLocalInstallSupported()) {
            LocalApplicationProperties localApplicationProperties = cacheObject.getLocalApplicationProperties();
            localApplicationProperties.refreshIfNecessary();
            if (this.activeTable == this.sysJnlpTable) {
                if (!localApplicationProperties.isLocallyInstalledSystem()) {
                    // empty if block
                }
            } else if (!localApplicationProperties.isLocallyInstalled() || !localInstallHandler.isShortcutExists(localApplicationProperties)) {
                LaunchDesc launchDesc = cacheObject.getLaunchDesc();
                localInstallHandler.uninstallShortcuts(launchDesc, localApplicationProperties);
                localInstallHandler.installShortcuts(launchDesc, localApplicationProperties);
                this.enableButtons();
            }
        }
    }

    private void browseApplication() {
        LaunchDesc launchDesc;
        CacheObject cacheObject = this.getSelectedCacheObject();
        if (cacheObject != null && (launchDesc = cacheObject.getLaunchDesc()) != null) {
            URL uRL = launchDesc.getInformation().getHome();
            this.showDocument(uRL);
        }
    }

    private void showApplication() {
        LaunchDesc launchDesc;
        CacheObject cacheObject = this.getSelectedCacheObject();
        if (cacheObject != null && (launchDesc = cacheObject.getLaunchDesc()) != null) {
            String string = launchDesc.toString();
            UIFactory.showContentDialog((Component)this, (AppInfo)new AppInfo(), (String)this.getResource("viewer.show.title"), (String)string, (boolean)true, (String)this.getResource("common.ok_btn"), null);
        }
    }

    void showInformation() {
        CacheObject cacheObject = this.getSelectedCacheObject();
        if (cacheObject != null) {
            switch (cacheObject.getObjectType()) {
                case 1: {
                    this.showApplication();
                    break;
                }
                case 2: 
                case 3: {
                    this.showResource(cacheObject);
                    break;
                }
                case 4: {
                    this.showImage(cacheObject);
                    break;
                }
            }
        }
    }

    void showResource(CacheObject cacheObject) {
    }

    void showImage(CacheObject cacheObject) {
    }

    void removeRemoved() {
        CacheObject[] cacheObjectArray = this.getSelectedCacheObjects();
        for (int i = 0; i < cacheObjectArray.length; ++i) {
            Cache.removeRemovedApp((String)cacheObjectArray[i].getDeletedUrl(), (String)cacheObjectArray[i].getDeletedTitle());
        }
    }

    void removeResources() {
        try {
            CacheObject[] cacheObjectArray = this.getSelectedCacheObjects();
            this.showWaitDialog(cacheObjectArray, 0);
        }
        catch (Throwable throwable) {
            Trace.ignored((Throwable)throwable);
        }
    }

    public void showWaitDialog(final CacheObject[] cacheObjectArray, final int n) {
        String string;
        String string2;
        boolean bl;
        if (n == 0) {
            bl = true;
            string2 = cacheObjectArray.length > 1 ? "viewer.wait.remove" : "viewer.wait.remove.single";
            string = this.getResource("viewer.wait.remove.title");
        } else {
            bl = false;
            string2 = cacheObjectArray.length > 1 ? "viewer.wait.import" : "viewer.wait.import.single";
            string = this.getResource("viewer.wait.import.title");
        }
        String string3 = this.getResource(string2);
        final DownloadWindow downloadWindow = new DownloadWindow();
        downloadWindow.initialize(this, null, false, false, bl);
        downloadWindow.setHeading(string3, false);
        downloadWindow.setTitle(string);
        downloadWindow.setProgressBarVisible(true);
        downloadWindow.setIndeterminate(cacheObjectArray.length == 1);
        downloadWindow.setProgressBarValue(0);
        downloadWindow.setVisible(true);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < cacheObjectArray.length; ++i) {
                    try {
                        Object object;
                        String[] stringArray;
                        Object object2;
                        Object object3;
                        if (n == 0) {
                            object3 = cacheObjectArray[i].getLaunchDesc();
                            object2 = cacheObjectArray[i].getCE();
                            stringArray = cacheObjectArray[i].getNameString();
                            object = cacheObjectArray[i].getUrlString();
                            if (object3 == null) {
                                downloadWindow.setApplication((String)stringArray, null, (String)object);
                                Cache.removeCacheEntry((CacheEntry)object2);
                            } else {
                                stringArray = ((LaunchDesc)object3).getInformation().getTitle();
                                String string = ((LaunchDesc)object3).getInformation().getVendor();
                                downloadWindow.setApplication((String)stringArray, string, (String)object);
                                CacheUtil.remove(object2, (LaunchDesc)object3);
                            }
                        } else {
                            object3 = cacheObjectArray[i].getDeletedTitle();
                            object2 = cacheObjectArray[i].getDeletedUrl();
                            downloadWindow.setApplication((String)object3, null, (String)object2);
                            stringArray = new String[]{Config.getJavawsCommand(), "-wait", "-quiet", "-import", object2};
                            object = Runtime.getRuntime().exec(stringArray);
                            CacheViewer.this.traceStream(((Process)object).getInputStream());
                            CacheViewer.this.traceStream(((Process)object).getErrorStream());
                            int n2 = ((Process)object).waitFor();
                        }
                        if (!downloadWindow.isVisible()) break;
                        int n3 = (i + 1) * 100 / cacheObjectArray.length;
                        downloadWindow.setProgressBarValue(n3);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Trace.ignored((Throwable)throwable);
                    }
                }
                downloadWindow.setVisible(false);
                CacheViewer.this.enableButtons();
            }
        });
        thread.start();
    }

    private void traceStream(final InputStream inputStream) {
        new Thread(new Runnable(){

            public void run() {
                byte[] byArray = new byte[1024];
                try {
                    int n = 0;
                    while (n != -1) {
                        n = inputStream.read(byArray);
                        if (n > 0 || n != 0) continue;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    void help() {
    }

    private CacheObject getSelectedCacheObject() {
        int[] nArray = this.activeTable.getSelectedRows();
        if (nArray.length == 1) {
            return this.activeTable.getCacheObject(nArray[0]);
        }
        return null;
    }

    private CacheObject[] getSelectedCacheObjects() {
        int[] nArray = this.activeTable.getSelectedRows();
        int n = this.activeTable.getRowCount();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < n) continue;
            Trace.println((String)("Bug in JTable ?, getRowCount() = " + n + " , but getSelectedRows() contains: " + nArray[i]), (TraceLevel)TraceLevel.BASIC);
            return new CacheObject[0];
        }
        CacheObject[] cacheObjectArray = new CacheObject[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            cacheObjectArray[i] = this.activeTable.getCacheObject(nArray[i]);
        }
        return cacheObjectArray;
    }

    private void showDocument(final URL uRL) {
        new Thread(new Runnable(){

            public void run() {
                BrowserSupport.showDocument(uRL);
            }
        }).start();
    }

    private String getResource(String string) {
        return ResourceManager.getMessage((String)string);
    }

    private Icon getDummyIcon() {
        if (this.dummy == null) {
            try {
                this.dummy = ResourceManager.getIcon((String)"java32.image");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.dummy == null) {
                this.dummy = new ImageIcon();
            }
            Image image = this.dummy.getImage().getScaledInstance(20, 20, 1);
            this.dummy.setImage(image);
        }
        return this.dummy;
    }

    private Icon getIcon(String string) {
        try {
            return ResourceManager.getIcon((String)string);
        }
        catch (Throwable throwable) {
            return this.getDummyIcon();
        }
    }

    public JButton createRunButton(String string) {
        final JButton jButton = this.createImageButton(string, 8);
        jButton.addMouseListener(new MouseAdapter(){
            boolean clicked = false;
            Timer t;

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!CacheViewer.this.runPopup.isVisible()) {
                    this.clicked = true;
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.clicked = false;
                this.t = new Timer(500, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!clicked && CacheViewer.this.runButton.isEnabled()) {
                            CacheViewer.this.runPopup.show(jButton, 0, jButton.getHeight());
                            jButton.getModel().setPressed(false);
                        }
                    }
                });
                this.t.setRepeats(false);
                this.t.start();
            }
        });
        jButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 225) {
                    Timer timer = new Timer(50, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (!CacheViewer.this.runPopup.isVisible() && CacheViewer.this.runButton.isEnabled()) {
                                CacheViewer.this.runPopup.show(jButton, 0, jButton.getHeight());
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!CacheViewer.this.runPopup.isVisible()) {
                    CacheViewer.this.runApplication();
                }
            }
        });
        return jButton;
    }

    private JButton createImageButton(String string, int n) {
        final int n2 = 32 + n;
        JButton jButton = new JButton(){

            public Dimension getPreferredSize() {
                return new Dimension(n2, 32);
            }

            public Dimension getMinimumSize() {
                return new Dimension(n2, 32);
            }

            public Dimension getMaximumSize() {
                return new Dimension(n2, 32);
            }
        };
        this.setButtonIcons(jButton, string + ".icon");
        jButton.setToolTipText(this.getResource(string + ".tooltip"));
        return jButton;
    }

    private void setButtonIcons(JButton jButton, String string) {
        ImageIcon[] imageIconArray = ResourceManager.getIcons((String)string);
        jButton.setIcon(imageIconArray[0] != null ? imageIconArray[0] : this.getDummyIcon());
        if (imageIconArray[1] != null) {
            jButton.setPressedIcon(imageIconArray[1]);
        }
        if (imageIconArray[2] != null) {
            jButton.setDisabledIcon(imageIconArray[2]);
        }
        if (imageIconArray[3] != null) {
            jButton.setRolloverIcon(imageIconArray[3]);
        }
    }

    private JMenuItem createMI(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(ResourceManager.getMessage((String)string));
        String string2 = string + ".mnemonic";
        String string3 = ResourceManager.getMessage((String)string2);
        if (!string3.equals(string2)) {
            jMenuItem.setMnemonic(ResourceManager.getVKCode((String)string2));
        }
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private void exitViewer() {
        Rectangle rectangle = this.getBounds();
        Config.setProperty((String)BOUNDS_PROPERTY_KEY, (String)("" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height));
        if (!this.wasDirty) {
            Config.storeIfDirty();
        }
        this.setVisible(false);
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    public void popupApplicationMenu(Component component, int n, int n2) {
        CacheObject cacheObject = this.getSelectedCacheObject();
        if (cacheObject != null) {
            this.popup.show(component, n, n2);
        }
    }

    public void enableButtons() {
        LaunchDesc launchDesc;
        CacheObject[] cacheObjectArray = this.getSelectedCacheObjects();
        boolean bl = cacheObjectArray.length == 1;
        boolean bl2 = cacheObjectArray.length > 0;
        boolean bl3 = this.activeTable != this.sysResourceTable && this.activeTable != this.sysJnlpTable;
        this.showButton.setEnabled(bl);
        this.showMI.setEnabled(bl);
        this.removeRemovedButton.setEnabled(bl2 && bl3);
        this.importButton.setEnabled(bl2);
        this.importMI.setEnabled(bl2);
        this.removeButton.setEnabled(bl2 && bl3);
        this.removeMI.setEnabled(bl2 && bl3);
        this.removeResourceButton.setEnabled(bl2 && bl3);
        this.runButton.setEnabled(false);
        this.runOnlineMI.setEnabled(false);
        this.runOfflineMI.setEnabled(false);
        this.installButton.setEnabled(false);
        this.installMI.setEnabled(false);
        this.homeButton.setEnabled(false);
        this.homeMI.setEnabled(false);
        this.showResourceButton.setEnabled(false);
        this.showResourceMI.setEnabled(false);
        this.onlineMI.setEnabled(false);
        this.offlineMI.setEnabled(false);
        if (bl && (launchDesc = cacheObjectArray[0].getLaunchDesc()) != null) {
            if (launchDesc.isApplicationDescriptor()) {
                LocalInstallHandler localInstallHandler;
                if (launchDesc.getLocation() != null || launchDesc.getInformation().supportsOfflineOperation()) {
                    this.runButton.setEnabled(true);
                    this.onlineMI.setEnabled(true);
                    this.runOnlineMI.setEnabled(true);
                    this.setButtonIcons(this.runButton, "viewer.run.online.icon");
                    this.runButton.setToolTipText(this.getResource("viewer.run.online.tooltip"));
                }
                if (launchDesc.getInformation().supportsOfflineOperation()) {
                    this.runButton.setEnabled(true);
                    this.offlineMI.setEnabled(true);
                    this.runOfflineMI.setEnabled(true);
                    if (launchDesc.getLocation() == null) {
                        this.setButtonIcons(this.runButton, "viewer.run.offline.icon");
                        this.runButton.setToolTipText(this.getResource("viewer.run.offline.tooltip"));
                    }
                }
                if ((localInstallHandler = LocalInstallHandler.getInstance()).isLocalInstallSupported()) {
                    ShortcutDesc shortcutDesc;
                    LocalApplicationProperties localApplicationProperties = cacheObjectArray[0].getLocalApplicationProperties();
                    localApplicationProperties.refreshIfNecessary();
                    if (!localInstallHandler.isShortcutExists(localApplicationProperties) && this.activeTable == this.jnlpTable && ((shortcutDesc = launchDesc.getInformation().getShortcut()) == null || shortcutDesc.getMenu() || shortcutDesc.getDesktop())) {
                        this.installButton.setEnabled(true);
                        this.installMI.setEnabled(true);
                    }
                }
            }
            if (launchDesc.getInformation().getHome() != null) {
                this.homeButton.setEnabled(true);
                this.homeMI.setEnabled(true);
            }
            this.showResourceButton.setEnabled(true);
            this.showResourceMI.setEnabled(true);
        }
        this.activeTable.setEnabled(this.activeTable.getRowCount() > 0);
    }

    private void startWatchers() {
        new Thread(new Runnable(){

            public void run() {
                long l = Cache.getLastAccessed((boolean)false);
                long l2 = Cache.getLastAccessed((boolean)true);
                long l3 = 0L;
                String string = Cache.getRemovePath();
                File file = new File(string);
                if (file != null && file.exists()) {
                    l3 = file.lastModified();
                }
                do {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignored((Throwable)interruptedException);
                        continue;
                    }
                    long l4 = Cache.getLastAccessed((boolean)false);
                    long l5 = Cache.getLastAccessed((boolean)true);
                    long l6 = 0L;
                    if (file != null && file.exists()) {
                        l6 = file.lastModified();
                    }
                    if (l4 != l) {
                        l = l4;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (CacheViewer.this.jnlpTable != null) {
                                    CacheViewer.this.jnlpTable.reset();
                                }
                                if (CacheViewer.this.resourceTable != null) {
                                    CacheViewer.this.resourceTable.reset();
                                }
                                CacheViewer.this.enableButtons();
                                CacheViewer.this.sizeLabel.setText(CacheViewer.this.activeTable.getSizeLabelText());
                            }
                        });
                    }
                    if (l5 != l2) {
                        l2 = l5;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (CacheViewer.this.sysJnlpTable != null) {
                                    CacheViewer.this.sysJnlpTable.reset();
                                }
                                if (CacheViewer.this.sysResourceTable != null) {
                                    CacheViewer.this.sysResourceTable.reset();
                                }
                                CacheViewer.this.enableButtons();
                                CacheViewer.this.sizeLabel.setText(CacheViewer.this.activeTable.getSizeLabelText());
                            }
                        });
                    }
                    if (l6 == l3) continue;
                    l3 = l6;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (CacheViewer.this.importTable != null) {
                                CacheViewer.this.importTable.reset();
                            }
                            CacheViewer.this.enableButtons();
                        }
                    });
                } while (CacheViewer.this.isShowing());
            }
        }).start();
    }

    public static void showCacheViewer(JFrame jFrame) {
        Cache.reset();
        Main.initializeExecutionEnvironment();
        CacheViewer cacheViewer = new CacheViewer(jFrame);
        cacheViewer.setModal(true);
        String string = Config.getProperty((String)BOUNDS_PROPERTY_KEY);
        if (string != null) {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int[] nArray = new int[4];
            for (n = 0; n < 4; ++n) {
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string2 = stringTokenizer.nextToken();
                try {
                    nArray[n] = Integer.parseInt(string2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n == 4) {
                cacheViewer.setBounds(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
        } else {
            cacheViewer.setBounds(100, 100, 720, 360);
            UIFactory.placeWindow((Window)cacheViewer);
        }
        cacheViewer.startWatchers();
        cacheViewer.setVisible(true);
    }

    class VSeparator
    extends JSeparator {
        public VSeparator() {
            super(1);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getUI().getPreferredSize(this);
            dimension.height = 20;
            return dimension;
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private class remainingSpacer
    extends JComponent {
        private remainingSpacer() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Container container = this.getParent();
            int n = container.getWidth();
            int n2 = 0;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (this.equals(componentArray[i])) continue;
                Dimension dimension2 = componentArray[i].getPreferredSize();
                n2 += dimension2.width;
            }
            if (n > n2) {
                dimension.width = n - n2;
            }
            return dimension;
        }
    }
}

