/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import java.util.ArrayList;
import java.util.Collection;

public class StateMachineFactory {
    public static AliasRangeParser getAliasRangeParser() {
        return new AliasRangeParserImpl();
    }

    public static PKCS7MimeParser getPKCS7MimeParser() {
        return new PKCS7MimeParserImpl();
    }

    public static MainParser getMainParser() {
        return new MainParserImpl();
    }

    public static void main(String[] args) {
        String commandLine = "asdf   \"test a b c\" testing\" ffeef jjj ";
        MainParser parser = StateMachineFactory.getMainParser();
        for (int i = 0; i < commandLine.length(); ++i) {
            try {
                parser.handle(Character.valueOf(commandLine.charAt(i)));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String token : parser.getTokens()) {
            System.out.println(token);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TokenState
    implements State<Character> {
        private boolean quoted;
        private MainParserImpl parser;

        public TokenState(MainParserImpl parser, boolean quoted) {
            this.parser = parser;
            this.quoted = quoted;
        }

        @Override
        public boolean handle(Character c) throws Exception {
            if (Character.isWhitespace(c.charValue())) {
                if (this.quoted) {
                    this.parser.buffer(c);
                } else {
                    this.handleTokenEnd();
                }
            } else if (c.charValue() == '\"' && this.quoted) {
                this.handleTokenEnd();
            } else {
                this.parser.buffer(c);
            }
            return true;
        }

        private void handleTokenEnd() {
            this.parser.commitBuffer();
            this.parser.setWhiteSpaceState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WhiteSpaceState
    implements State<Character> {
        private MainParserImpl parser;

        public WhiteSpaceState(MainParserImpl parser) {
            this.parser = parser;
        }

        @Override
        public boolean handle(Character c) {
            if (Character.isWhitespace(c.charValue())) {
                return true;
            }
            if (c.charValue() == '\"') {
                this.parser.setTokenState(true);
                return true;
            }
            this.parser.setTokenState(false);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MainParserImpl
    extends AbstractStateMachineParser<Character>
    implements MainParser {
        private Collection<String> tokens = new ArrayList<String>();
        private State<Character> whiteSpaceState = new WhiteSpaceState(this);
        private State<Character> tokenState = new TokenState(this, false);
        private State<Character> quotedTokenState = new TokenState(this, true);
        private StringBuffer stringBuffer = new StringBuffer();

        public MainParserImpl() {
            super.setState(this.whiteSpaceState);
        }

        @Override
        public String[] getTokens() {
            this.commitBuffer();
            return this.tokens.toArray(new String[0]);
        }

        private void buffer(Character c) {
            this.stringBuffer.append(c);
        }

        private void commitBuffer() {
            if (this.stringBuffer.length() > 0) {
                this.tokens.add(this.stringBuffer.toString());
                this.stringBuffer = new StringBuffer();
            }
        }

        private void setWhiteSpaceState() {
            this.setState(this.whiteSpaceState);
        }

        private void setTokenState(boolean quoted) {
            if (quoted) {
                this.setState(this.quotedTokenState);
            } else {
                this.setState(this.tokenState);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndOfFileState
    implements State<String> {
        private EndOfFileState() {
        }

        @Override
        public boolean handle(String line) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SkipWhiteSpaceState
    extends AbstractState<String, PKCS7MimeParserImpl> {
        public SkipWhiteSpaceState(PKCS7MimeParserImpl parser, State<String> nextState) {
            super(parser, nextState);
        }

        @Override
        public boolean handle(String line) {
            if (!line.trim().equals("")) {
                ((PKCS7MimeParserImpl)this.parser).setState(this.nextState);
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BufferLineState
    extends AbstractState<String, PKCS7MimeParserImpl> {
        public BufferLineState(PKCS7MimeParserImpl parser, State<String> nextState) {
            super(parser, nextState);
        }

        @Override
        public boolean handle(String line) {
            ((PKCS7MimeParserImpl)this.parser).append(line).append("\n");
            if (line.trim().equals("")) {
                ((PKCS7MimeParserImpl)this.parser).setState(this.nextState);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS7MimeParserImpl
    extends AbstractStateMachineParser<String>
    implements PKCS7MimeParser {
        private StringBuffer buff = new StringBuffer();
        private State<String> endOfFileState = new EndOfFileState();
        private State<String> bodyState = new BufferLineState(this, this.endOfFileState);
        private State<String> skipWhiteSpaceState = new SkipWhiteSpaceState(this, this.bodyState);
        private State<String> headerState = new BufferLineState(this, this.skipWhiteSpaceState);

        public PKCS7MimeParserImpl() {
            super.setState(this.headerState);
        }

        public PKCS7MimeParserImpl append(String s) {
            this.buff.append(s);
            return this;
        }

        @Override
        public String getString() {
            return this.buff.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Hex2State
    extends AbstractHexState {
        public Hex2State(AliasRangeParserImpl parser, State<Character> nextState) {
            super(parser, nextState);
        }

        @Override
        protected boolean handleNonHex(char c) throws Exception {
            throw new Exception("invalid state transition");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Hex1State
    extends AbstractHexState {
        public Hex1State(AliasRangeParserImpl parser, State<Character> nextState) {
            super(parser, nextState);
        }

        @Override
        protected boolean handleNonHex(char c) throws Exception {
            if (c == '-') {
                if (this.value.equals("")) {
                    throw new Exception("invalid state transition");
                }
                ((AliasRangeParserImpl)this.parser).setState(this.nextState);
                return true;
            }
            throw new Exception("invalid state transition");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractHexState
    extends AbstractState<Character, AliasRangeParserImpl> {
        protected String value = "";

        public AbstractHexState(AliasRangeParserImpl parser, State<Character> nextState) {
            super(parser, nextState);
        }

        @Override
        public boolean handle(Character c) throws Exception {
            if (this.isHex(c.charValue())) {
                this.value = this.value + c;
                return true;
            }
            return this.handleNonHex(c.charValue());
        }

        public String toString() {
            return this.value;
        }

        private boolean isHex(char c) {
            return Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        protected abstract boolean handleNonHex(char var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrefixState
    extends AbstractState<Character, AliasRangeParserImpl> {
        private String value = "";

        public PrefixState(AliasRangeParserImpl parser, State<Character> nextState) {
            super(parser, nextState);
        }

        @Override
        public boolean handle(Character c) throws Exception {
            if (Character.isLetter(c.charValue())) {
                this.value = this.value + c;
                return true;
            }
            if (this.value.equals("")) {
                throw new Exception("invalid state transition");
            }
            ((AliasRangeParserImpl)this.parser).setState(this.nextState);
            return false;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AliasRangeParserImpl
    extends AbstractStateMachineParser<Character>
    implements AliasRangeParser {
        private State<Character> hex2State = new Hex2State(this, null);
        private State<Character> hex1State = new Hex1State(this, this.hex2State);
        private State<Character> prefixState = new PrefixState(this, this.hex1State);

        public AliasRangeParserImpl() {
            super.setState(this.prefixState);
        }

        @Override
        public String getHex1() {
            return this.hex1State.toString();
        }

        @Override
        public String getHex2() {
            return this.hex2State.toString();
        }

        @Override
        public String getPrefix() {
            return this.prefixState.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractState<T, M extends AbstractStateMachineParser<T>>
    implements State<T> {
        protected M parser;
        protected State<T> nextState;

        public AbstractState(M parser, State<T> nextState) {
            this.parser = parser;
            this.nextState = nextState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractStateMachineParser<T> {
        private State<T> currentState;

        private AbstractStateMachineParser() {
        }

        public void handle(T c) throws Exception {
            while (!this.currentState.handle(c)) {
            }
        }

        public void setState(State<T> s) {
            this.currentState = s;
        }
    }

    public static interface MainParser {
        public String[] getTokens();

        public void handle(Character var1) throws Exception;
    }

    public static interface PKCS7MimeParser {
        public String getString();

        public void handle(String var1) throws Exception;
    }

    public static interface AliasRangeParser {
        public String getHex1();

        public String getHex2();

        public String getPrefix();

        public void handle(Character var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface State<T> {
        public boolean handle(T var1) throws Exception;
    }
}

