/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.ext;

import com.ibm.gsk.ikeyman.keystore.ext.IndentedPrinter;
import com.ibm.gsk.ikeyman.keystore.ext.IndentedStringPrinter;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeymanTree<F, S>
extends DefaultTreeModel {
    public KeymanTree(KeymanTreeNode root) {
        super(root);
    }

    public String toString() {
        return ((KeymanTreeNode)this.getRoot()).toString(new IndentedStringPrinter(), 0);
    }

    public static KeymanTreeNode newNode(String key) {
        return new KeymanTreeNode(new KeymanTreeNode.BasicNode(key));
    }

    public static KeymanTreeNode newNode(String key, String value) {
        return new KeymanTreeNode(new KeymanTreeNode.StringPairNode(key, value));
    }

    public static KeymanTreeNode newNode(String key, boolean isSelected) {
        return new KeymanTreeNode(new KeymanTreeNode.SelectableNode(key, isSelected));
    }

    public Collection<KeymanTreeNode> getLeaves() {
        ArrayList<KeymanTreeNode> leaves = new ArrayList<KeymanTreeNode>();
        leaves.addAll(((KeymanTreeNode)this.getRoot()).getLeaves());
        return leaves;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeymanTreeNode
    implements TreeNode {
        private KeymanTreeNode parent = null;
        private NodeValue value;
        private List<KeymanTreeNode> children = new ArrayList<KeymanTreeNode>();

        public KeymanTreeNode(NodeValue value) {
            this.value = value;
        }

        public Collection<? extends KeymanTreeNode> getLeaves() {
            ArrayList<? extends KeymanTreeNode> leaves = new ArrayList<KeymanTreeNode>();
            if (this.isLeaf()) {
                leaves.add(this);
            } else {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    leaves.addAll(((KeymanTreeNode)this.getChildAt(i)).getLeaves());
                }
            }
            return leaves;
        }

        public KeymanTreeNode addChild(KeymanTreeNode child) {
            this.children.add(child);
            child.parent = this;
            return child;
        }

        public void addChildren(List<KeymanTreeNode> children) {
            for (KeymanTreeNode child : children) {
                this.addChild(child);
            }
        }

        private String toString(IndentedPrinter printer, int indentation) {
            String returnString = printer.print(this.value, indentation);
            for (KeymanTreeNode child : this.children) {
                returnString = returnString + child.toString(printer, indentation + 2);
            }
            return returnString;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }

        public Enumeration<KeymanTreeNode> children() {
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.children.indexOf(node);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class SelectableNode
        extends Pair<String, Boolean>
        implements NodeValue {
            public SelectableNode(String first, Boolean second) {
                super(first, second);
            }

            public String toString() {
                return (String)this.getFirst();
            }

            @Override
            public String toFullString() {
                return this.toString();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class StringPairNode
        extends Pair<String, String>
        implements NodeValue {
            public StringPairNode(String first, String second) {
                super(first, second);
            }

            @Override
            public String toFullString() {
                String key = this.getFirst() == null ? "" : (String)this.getFirst();
                String value = this.getSecond() == null ? Messages.getString("Label.Null") : (String)this.getSecond();
                String[] lines = value.split("\n");
                String returnValue = this.getKeyString(key, value);
                if (lines.length > 1) {
                    returnValue = returnValue + "\n";
                    for (int i = 0; i < lines.length; ++i) {
                        returnValue = returnValue + "  " + lines[i];
                        if (i >= lines.length - 1) continue;
                        returnValue = returnValue + "\n";
                    }
                } else {
                    returnValue = returnValue + " " + lines[0];
                }
                return returnValue;
            }

            private String getKeyString(String key, String value) {
                return key.equals(Messages.getString("Label.Null")) ? key : key + (value.equals("") ? "" : KeymanUtil.getLocalisedColon());
            }

            public String toString() {
                return (String)this.getFirst();
            }
        }

        public static class BasicNode
        implements NodeValue {
            private String value;

            public BasicNode(String value) {
                this.value = value;
            }

            public String toString() {
                return this.value;
            }

            public String toFullString() {
                return this.toString();
            }
        }
    }

    public static interface NodeValue {
        public String toFullString();
    }
}

