/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.ext;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.FilterFactory;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.KeyCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreInfo {
    private DatabaseDescriptorFactory.DatabaseDescriptor descriptor;
    private KeyCreatorFactory.KeyCreator keyCreator;
    private List<Entry> items;
    private Collection<Class<? extends Entry>> supportedEntryTypes;

    public KeyStoreInfo(DatabaseDescriptorFactory.DatabaseDescriptor descriptor, KeyCreatorFactory.KeyCreator keyCreator, List<Entry> displayables, Collection<Class<? extends Entry>> supportedEntryTypes) {
        this.descriptor = descriptor;
        this.keyCreator = keyCreator;
        this.items = displayables;
        this.supportedEntryTypes = supportedEntryTypes;
    }

    public DatabaseDescriptorFactory.DatabaseDescriptor getDescriptor() {
        return this.descriptor;
    }

    public KeyCreatorFactory.KeyCreator getKeyCreator() {
        return this.keyCreator;
    }

    public Collection<Entry> getItems() {
        return this.items;
    }

    public Collection<Entry> getPersonalCerts() {
        return FilterFactory.getListWhichFilter(Constants.ListFilter.Personal).filter(this.items);
    }

    public Collection<Entry> getSignerCerts() {
        return FilterFactory.getListWhichFilter(Constants.ListFilter.CA).filter(this.items);
    }

    public Collection<Entry> getCertificateRequests() {
        return FilterFactory.getCertRequestFilter().filter(this.items);
    }

    public Collection<Entry> getCertificates() {
        return FilterFactory.getListWhichFilter(Constants.ListFilter.All).filter(this.items);
    }

    public Collection<Entry> getSecretKeys() {
        return FilterFactory.getListWhichFilter(Constants.ListFilter.Secret).filter(this.items);
    }

    public ParameterMap getDatabaseParameters(boolean isTarget) throws KeyManagerException {
        return this.descriptor.getDatabaseParameters(isTarget);
    }

    public boolean equals(Object o) {
        if (o instanceof KeyStoreInfo) {
            return ((KeyStoreInfo)o).descriptor.equals(this.descriptor);
        }
        return false;
    }

    public boolean isEntrySupported(Class<? extends Entry> c) {
        return this.supportedEntryTypes.contains(c);
    }
}

