/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.ComparatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum X509Version implements DisplayItemFactory.TreeDisplayItem
{
    ONE(1),
    TWO(2),
    THREE(3);

    private static Map<String, X509Version> versionMap;
    private int version;

    private X509Version(int version) {
        this.version = version;
    }

    public static Collection<String> getValidValues() {
        ArrayList<String> returnList = new ArrayList<String>();
        for (X509Version version : X509Version.values()) {
            returnList.add(version.version + "");
        }
        return returnList;
    }

    public int getVersion() {
        return this.version;
    }

    public int getInternalVersion() {
        return this.version - 1;
    }

    @Override
    public String toString() {
        return "X509 V" + this.version;
    }

    public static X509Version getVersion(int version) {
        switch (version) {
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
        }
        return THREE;
    }

    public static Map<String, X509Version> getParseMap() {
        return versionMap;
    }

    public KeymanTree.KeymanTreeNode getTreeNode() {
        KeymanTree.KeymanTreeNode node = KeymanTree.newNode(Messages.getString("Label.Version"), this.toString());
        return node;
    }

    @Override
    public List<KeymanTree.KeymanTreeNode> getTreeNodes() {
        ArrayList<KeymanTree.KeymanTreeNode> nodes = new ArrayList<KeymanTree.KeymanTreeNode>();
        nodes.add(this.getTreeNode());
        return nodes;
    }

    static {
        try {
            versionMap = new TreeMap<String, X509Version>(ComparatorFactory.newIgnoreCaseStringComparator());
        }
        catch (Error e) {
            e.printStackTrace();
        }
        versionMap.put("1", ONE);
        versionMap.put("2", TWO);
        versionMap.put("3", THREE);
    }
}

