/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory;
import com.ibm.gsk.ikeyman.io.SecretKeyReader;
import com.ibm.gsk.ikeyman.keystore.entry.CMSCertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CMSCertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CMSKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CMSKeyItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.UnloadableCertificateRequestItemImpl;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateIssuerName;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateSubjectName;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryFactory {
    private static TypeDisplayerFactory.TypeDisplayer<Entry> classDisplayer = TypeDisplayerFactory.newGUIEntryDisplayer();

    public static void setClassDisplayer(TypeDisplayerFactory.TypeDisplayer<Entry> displayer) {
        classDisplayer = displayer;
    }

    public static TypeDisplayerFactory.TypeDisplayer<Entry> getClassDisplayer() {
        return classDisplayer;
    }

    public static Collection<CertificateItem> loadCertificateItems(String fileName, String provider) throws KeyManagerException {
        try {
            Collection<? extends Certificate> certs = EntryFactory.generateCertificates(fileName, provider);
            if (certs.isEmpty()) {
                throw new CertificateException(Messages.getString("Label.EmptyFile"));
            }
            ArrayList<CertificateItem> collection = new ArrayList<CertificateItem>();
            for (Certificate certificate : certs) {
                X509Certificate x509Cert = (X509Certificate)certificate;
                collection.add(new CertificateItemImpl(x509Cert.getSubjectDN().getName(), x509Cert));
            }
            return collection;
        }
        catch (CertificateException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.CORRUPT_CERTIFICATE, (Throwable)e, fileName);
        }
    }

    public static CertificateItem newCertificateItem(String alias, X509Certificate certificate) throws KeyManagerException {
        return new CertificateItemImpl(alias, certificate);
    }

    public static CertificateKeyItem newKeyItem(String label, PrivateKey key, Certificate[] chain) throws KeyManagerException {
        return new CertificateKeyItemImpl(label, key, chain);
    }

    public static CertificateKeyItem newKeyItem(CommandParameters param, KeyPair keyPair, String signatureAlgorithm, String provider) throws KeyManagerException {
        try {
            DisplayItemFactory.DNItem dn;
            DisplayItemFactory.DNItem dNItem = dn = param.isParameterPresent(Constants.Parameter.DN) ? param.getDn() : DisplayItemFactory.getDNItem("");
            if (dn.isEmpty() && param.getSan().isEmpty()) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_DN_OR_SAN);
            }
            X500Name subject = dn.getX500Name();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            Calendar now = Calendar.getInstance();
            Calendar expire = Calendar.getInstance();
            expire.add(6, param.getExpire());
            CertificateValidity certificatevalidity = new CertificateValidity(now.getTime(), expire.getTime());
            X509CertInfo x509certinfo = new X509CertInfo(provider);
            x509certinfo.set("version", (Object)param.getX509Ver().getInternalVersion());
            x509certinfo.set("serialNumber", (Object)new CertificateSerialNumber((int)(now.getTime().getTime() / 1000L)));
            AlgorithmId algorithmid = AlgorithmId.get((String)signatureAlgorithm);
            x509certinfo.set("algorithmID", (Object)new CertificateAlgorithmId(algorithmid));
            x509certinfo.set("subject", (Object)new CertificateSubjectName(subject));
            x509certinfo.set("key", (Object)new CertificateX509Key(publicKey));
            x509certinfo.set("validity", (Object)certificatevalidity);
            x509certinfo.set("issuer", (Object)new CertificateIssuerName(subject));
            try {
                CertificateExtensions certificateExtensions = new CertificateExtensions();
                CertAttrSet<?> extns = param.getSan().toExtension(dn.isEmpty());
                if (extns != null) {
                    certificateExtensions.set(extns.getName(), extns);
                }
                if (param.isParameterPresent(Constants.Parameter.CA) && param.isCa()) {
                    certificateExtensions.set("BasicConstraints", (Object)new BasicConstraintsExtension(true, Integer.MAX_VALUE));
                }
                if (certificateExtensions.getAllExtensions().size() > 0) {
                    x509certinfo.set("extensions", (Object)certificateExtensions);
                }
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_SAN, (Throwable)e, e.getMessage());
            }
            X509CertImpl selfCert = new X509CertImpl(x509certinfo, provider);
            selfCert.sign(privateKey, signatureAlgorithm, provider);
            return new CertificateKeyItemImpl(param.getLabel(), privateKey, new Certificate[]{selfCert});
        }
        catch (CertificateException e) {
            if (e.getMessage().contains("Invalid version")) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_CERTIFICATE_VERSION, (Throwable)e, param.getLabel());
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_CREATE_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, signatureAlgorithm);
        }
        catch (NoSuchProviderException e) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, provider);
        }
        catch (InvalidKeyException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_KEY_FOR_SIGNING, (Throwable)e, param.getLabel());
        }
        catch (SignatureException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.SIGNATURE_ERROR, (Throwable)e, param.getLabel());
        }
    }

    public static CertificateKeyItem newKeyItem(String label, X509Certificate cert, PrivateKey privateKey) throws KeyManagerException {
        return new CertificateKeyItemImpl(label, privateKey, new Certificate[]{cert});
    }

    public static SecretKeyItem newSecretKey(String label, SecretKey key) throws KeyManagerException {
        return new SecretKeyItemImpl(label, key);
    }

    public static Collection<SecretKeyItem> loadSecretKeys(String fileName, PrivateKey key, String provider) throws KeyManagerException {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(fileName));
            SecretKeyReader reader = new SecretKeyReader(is);
            List<SecretKeyReader.SecretKeyInfo> keys = reader.readKeys();
            ArrayList<SecretKeyItem> items = new ArrayList<SecretKeyItem>();
            for (SecretKeyReader.SecretKeyInfo info : keys) {
                items.add(SecretKeyItemImpl.decryptKey(key, info.encryptedKey, info.algorithm, info.alias, provider));
            }
            ArrayList<SecretKeyItem> arrayList = items;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INPUT_FILE_NOT_FOUND, (Throwable)e, fileName);
        }
        catch (NoSuchProviderException e) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e);
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INPUT_STREAM_CLOSE_ERROR, (Throwable)e, fileName);
        }
        catch (InvalidKeyException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_DECRYPTION_ERROR, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_DECRYPTION_ERROR, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Debug.log(e.toString(), new Object[0]);
                }
            }
        }
    }

    public static CMSCertificateItem newCMSCertificate(String alias, X509Certificate certificate) throws KeyManagerException {
        return new CMSCertificateItemImpl(alias, certificate);
    }

    public static CMSKeyItem newCMSKey(String alias, PrivateKey privateKey, Certificate[] certificateChain) throws KeyManagerException {
        return new CMSKeyItemImpl(alias, privateKey, certificateChain);
    }

    public static CertificateRequestKeyItem newUnloadableCertificateRequestItem(String label) throws KeyManagerException {
        return new UnloadableCertificateRequestItemImpl(label);
    }

    public static CertificateRequestItem loadCertificateRequestItem(String label, String fileName) throws KeyManagerException {
        try {
            CertificationRequest req = new CertificationRequest(fileName, true);
            return new CertificateRequestItemImpl(label, req);
        }
        catch (IOException e) {
            if (e.getMessage().contains("not found")) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_REQUEST_FILE_NOT_FOUND, (Throwable)e, fileName);
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_REQUEST_DECODING_ERROR, (Throwable)e, fileName);
        }
    }

    public static CertificateRequestKeyItem loadCertificateRequestItem(String label, CertificationRequest request, PrivateKey key) throws KeyManagerException {
        return new CertificateRequestKeyItemImpl(label, request, key);
    }

    public static CertificateRequestKeyItem newCertificateRequestItem(CommandParameters param, KeyPair pair, String signatureAlgorithm, String provider) throws KeyManagerException {
        DisplayItemFactory.SanItem san = param.getSan();
        DisplayItemFactory.DNItem subjectDN = param.isParameterPresent(Constants.Parameter.DN) ? param.getDn() : DisplayItemFactory.getDNItem("");
        String label = param.getLabel();
        return EntryFactory.newCertificateRequestItem(label, subjectDN, san, pair, signatureAlgorithm, provider);
    }

    public static CertificateRequestKeyItem newCertificateRequestItem(CertificateItem cert, KeyPair pair, String provider) throws KeyManagerException {
        DisplayItemFactory.SanItem san = cert.getSan();
        DisplayItemFactory.DNItem subjectDN = cert.getSubjectDN();
        String label = cert.getLabel();
        return EntryFactory.newCertificateRequestItem(label, subjectDN, san, pair, KeymanUtil.getSignatureDigest(pair.getPrivate(), cert.getSignatureAlgorithm().getOID()), provider);
    }

    private static CertificateRequestKeyItem newCertificateRequestItem(String label, DisplayItemFactory.DNItem subjectDN, DisplayItemFactory.SanItem san, KeyPair pair, String signatureAlgorithm, String provider) throws KeyManagerException {
        CertificationRequest req;
        if (subjectDN.isEmpty() && san.isEmpty()) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_DN_OR_SAN);
        }
        try {
            CertAttrSet<?> extns = san.toExtension(subjectDN.isEmpty());
            PKCSAttributes pkcsAttributes = null;
            if (extns != null) {
                CertificateExtensions certExts = new CertificateExtensions();
                certExts.set(extns.getName(), extns);
                PKCSAttribute pkcsAttribute = new PKCSAttribute(PKCSOID.EXTENSION_REQUEST_OID, (Object)certExts);
                pkcsAttributes = new PKCSAttributes(new PKCSAttribute[]{pkcsAttribute});
            }
            CertificationRequestInfo info = new CertificationRequestInfo(subjectDN.getX500Name(), pair.getPublic(), pkcsAttributes, provider);
            req = new CertificationRequest(info, provider);
            req = req.sign(signatureAlgorithm, pair.getPrivate());
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_DN, (Throwable)e, subjectDN.toString());
        }
        catch (PKCSException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.REQUEST_SIGNING_ERROR, (Throwable)e, label);
        }
        catch (SignatureException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.SIGNATURE_ERROR, (Throwable)e, label);
        }
        return new CertificateRequestKeyItemImpl(label, req, pair.getPrivate());
    }

    private static Collection<? extends Certificate> generateCertificates(String fileName, String provider) throws KeyManagerException {
        CertificateParserFactory.CertificateParser<File> parser = CertificateParserFactory.getCertificateParser();
        return parser.getCertificates(new File(fileName), provider);
    }

    public static List<CertificateItem> reorderCertChain(Collection<CertificateItem> certs) {
        ArrayList<CertificateItem> chain = new ArrayList<CertificateItem>();
        for (CertificateItem cert : certs) {
            int i;
            for (i = 0; i < chain.size(); ++i) {
                CertificateItem chainCert = (CertificateItem)chain.get(i);
                if (cert.getIssuerDN().getX500Name().equals(chainCert.getSubjectDN().getX500Name())) break;
            }
            chain.add(i, cert);
        }
        return chain;
    }
}

