/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.CertificateWriter;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractEntry;
import com.ibm.gsk.ikeyman.keystore.entry.ByteArray;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.ext.Details;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

class CertificateRequestItemImpl
extends AbstractEntry
implements CertificateRequestItem {
    private DisplayItemFactory.TreeDisplayItem version;
    private DisplayItemFactory.DNItem subjectDN;
    private int keySize;
    private DisplayItemFactory.DisplayItem fingerprint;
    private PublicKey publicKey;
    private DisplayItemFactory.TreeDisplayItem publicKeyAlgorithm;
    private Collection<DisplayItemFactory.TreeDisplayItem> attributes;
    private DisplayItemFactory.AlgorithmItem signatureAlgorithm;
    private ByteArray signature;
    private CertificationRequest request;
    private PublicKey pubKey;

    protected CertificateRequestItemImpl(String label, CertificationRequest req) throws KeyManagerException {
        super(label);
        this.request = req;
        CertificationRequestInfo info = req.getCertRequestInfo();
        this.version = DisplayItemFactory.getCertificateRequestVersion(info.getVersion());
        this.subjectDN = DisplayItemFactory.getDNItem(info.getSubjectName());
        PublicKey pubKey = null;
        try {
            pubKey = info.getSubjectPublicKeyInfo();
        }
        catch (InvalidKeyException e1) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.PUBLIC_KEY_COPY_ERROR, (Throwable)e1);
        }
        catch (IOException e1) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e1);
        }
        this.keySize = CertificateRequestItemImpl.computeKeySize(pubKey);
        this.fingerprint = DisplayItemFactory.getFinterprintItem(info);
        this.publicKeyAlgorithm = DisplayItemFactory.getAlgorithmItem(pubKey);
        this.publicKey = pubKey;
        this.attributes = DisplayItemFactory.getAttributeItems(info.getAttributes().getAttributes());
        this.signature = new ByteArray(req.getSignature());
        this.signatureAlgorithm = DisplayItemFactory.getAlgorithmItem(req.getSignatureAlgorithm());
    }

    private static int computeKeySize(PublicKey key) {
        int kSize = 0;
        kSize = key instanceof RSAPublicKey ? ((RSAPublicKey)key).getModulus().bitLength() : ((DSAPublicKey)key).getY().bitLength();
        if (kSize % 2 != 0) {
            ++kSize;
        }
        return kSize;
    }

    public void extract(String targetFile, CertificateWriter.OutputMode format) throws KeyManagerException {
        try {
            this.request.writeBASE64(targetFile);
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_FILE_CREATION_ERROR, (Throwable)e, targetFile);
        }
    }

    public int getKeySize() {
        return this.keySize;
    }

    public DisplayItemFactory.DNItem getSubjectDN() {
        return this.subjectDN;
    }

    public CertificationRequest getRequest() {
        return this.request;
    }

    protected X509Certificate createCertificate(X500Name issuer, int expire, Integer serialNumber, AlgorithmId signatureAlgorithm, Extension extension, String provider) throws KeyManagerException {
        X509CertInfo info = new X509CertInfo(provider);
        CertificateVersion vers = KeymanSettings.DEFAULT_CERTIFICATE_VERSION;
        CertificateSerialNumber num = serialNumber != null ? new CertificateSerialNumber(serialNumber.intValue()) : new CertificateSerialNumber((int)(Calendar.getInstance().getTime().getTime() / 1000L));
        AlgorithmId aID = signatureAlgorithm;
        X500Name signerName = null;
        X500Name subjectName = null;
        try {
            signerName = new X500Name(issuer.toString());
            subjectName = new X500Name(this.subjectDN.toString());
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_DN, (Throwable)e);
        }
        CertificationRequest request = this.request;
        CertificationRequestInfo cri = request.getCertRequestInfo();
        PKCSAttributes attributes = cri.getAttributes();
        PKCSAttribute[] attributeArray = attributes.getAttributes();
        CertificateExtensions exts = null;
        for (int i = 0; i < attributeArray.length; ++i) {
            PKCS9DerObject pkcs9Obj = attributeArray[i].getPKCS9DerObject();
            if (!(pkcs9Obj.getValue() instanceof CertificateExtensions)) continue;
            exts = (CertificateExtensions)pkcs9Obj.getValue();
            break;
        }
        if (extension != null) {
            if (exts == null) {
                exts = new CertificateExtensions();
            }
            SubjectKeyIdentifierExtension ski = (SubjectKeyIdentifierExtension)extension;
            try {
                exts.set(ski.getName(), (Object)ski);
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
            }
        }
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.add(6, expire);
        Date notAfter = cal.getTime();
        CertificateValidity validity = new CertificateValidity(notBefore, notAfter);
        try {
            info.set("version", (Object)vers);
            info.set("serialNumber", (Object)num);
            info.set("algorithmID", (Object)aID);
            info.set("issuer", (Object)signerName);
            info.set("validity", (Object)validity);
            info.set("subject", (Object)subjectName);
            info.set("key", (Object)request.getCertRequestInfo().getSubjectPublicKeyInfo());
            if (exts != null) {
                info.set("extensions", (Object)exts);
            }
        }
        catch (CertificateException e1) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_CREATE_ERROR, (Throwable)e1);
        }
        catch (IOException e1) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e1);
        }
        catch (InvalidKeyException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.PUBLIC_KEY_COPY_ERROR, (Throwable)e);
        }
        try {
            return new X509CertImpl(info, provider);
        }
        catch (CertificateParsingException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_PARSING_ERROR, (Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_PARSING_ERROR, (Throwable)e);
        }
    }

    public CertificateItemImpl sign(CertificateKeyItem signer, int expire, Integer serialNumber, String provider) throws KeyManagerException {
        try {
            String sigAlgOID = signer.getSignatureAlgorithm().getOID();
            AlgorithmId signatureAlgorithm = KeymanUtil.getSignatureAlgorithm(sigAlgOID);
            X509CertImpl impl = (X509CertImpl)this.createCertificate(signer.getSubjectDN().getX500Name(), expire, serialNumber, signatureAlgorithm, null, provider);
            impl.sign(signer.getPrivateKey(), sigAlgOID, provider);
            return new CertificateItemImpl(this.getLabel(), (X509Certificate)impl);
        }
        catch (InvalidKeyException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_KEY_FOR_SIGNING, (Throwable)e, this.getLabel());
        }
        catch (CertificateException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, KeymanUtil.getJCEProviderName());
        }
        catch (SignatureException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.SIGNATURE_ERROR, (Throwable)e, this.getLabel());
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String toLongString() {
        return Messages.getString("Label.Label") + " " + this.getLabel() + "\n" + Messages.getString("Label.KeySize") + KeymanUtil.getLocalisedColon() + " " + this.keySize + "\n" + Messages.getString("Label.Subject") + KeymanUtil.getLocalisedColon() + " " + this.subjectDN.toString() + "\n" + Messages.getString("Label.Fingerprint") + " " + this.fingerprint + "\n" + Messages.getString("Label.SigAlg") + KeymanUtil.getLocalisedColon() + " " + this.signatureAlgorithm.toString() + "\n";
    }

    public KeymanTree toTree() {
        KeymanTree tree = new KeymanTree(KeymanTree.newNode(this.getLabel()));
        KeymanTree.KeymanTreeNode rootNode = (KeymanTree.KeymanTreeNode)tree.getRoot();
        KeymanTree.KeymanTreeNode certRequestNode = rootNode.addChild(KeymanTree.newNode(Messages.getString("Label.CertificationRequest")));
        KeymanTree.KeymanTreeNode certRequestInfoNode = certRequestNode.addChild(KeymanTree.newNode(Messages.getString("Label.CertificationRequestInfo")));
        certRequestInfoNode.addChild(KeymanTree.newNode(Messages.getString("Label.Version"), this.version.toString()));
        KeymanTree.KeymanTreeNode subjectNode = certRequestInfoNode.addChild(KeymanTree.newNode(Messages.getString("Label.Subject")));
        subjectNode.addChildren(this.subjectDN.getTreeNodes());
        KeymanTree.KeymanTreeNode spkiNode = certRequestInfoNode.addChild(KeymanTree.newNode(Messages.getString("Label.SubjectPublicKeyInfo")));
        KeymanTree.KeymanTreeNode algorithmNode = spkiNode.addChild(KeymanTree.newNode(Messages.getString("Label.Algorithm")));
        algorithmNode.addChildren(this.publicKeyAlgorithm.getTreeNodes());
        spkiNode.addChild(KeymanTree.newNode(Messages.getString("Label.SubjectPublicKey"), new ByteArray(this.publicKey.getEncoded()).toString()));
        if (this.attributes.size() > 0) {
            KeymanTree.KeymanTreeNode attributesNode = certRequestInfoNode.addChild(KeymanTree.newNode(Messages.getString("Label.Attributes")));
            for (DisplayItemFactory.TreeDisplayItem attribute : this.attributes) {
                attributesNode.addChildren(attribute.getTreeNodes());
            }
        }
        KeymanTree.KeymanTreeNode saNode = certRequestInfoNode.addChild(KeymanTree.newNode(Messages.getString("Label.SigAlg")));
        saNode.addChildren(this.signatureAlgorithm.getTreeNodes());
        certRequestInfoNode.addChild(KeymanTree.newNode(Messages.getString("Label.SigVal"), this.signature.toString()));
        return tree;
    }

    public void setLabel(String newLabel) {
        throw new UnsupportedOperationException("A certificate request label cannot be changed.");
    }

    public KeyStore.Entry toKeyStoreEntry() {
        throw new UnsupportedOperationException("method toKeyStoreEntry");
    }

    public DisplayItemFactory.AlgorithmItem getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String get(Details.DetailIdentifier id) throws KeyManagerException {
        switch (id) {
            case KeySize: {
                return this.keySize + "";
            }
            case Subject: {
                return this.subjectDN.toString();
            }
            case Fingerprint: {
                return ((Object)this.fingerprint).toString();
            }
            case SignatureAlgorithm: {
                return this.signatureAlgorithm.toString();
            }
        }
        return super.get(id);
    }

    public boolean isValid() {
        return true;
    }
}

