/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.CMSKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.ext.Defaultable;
import com.ibm.security.cmskeystore.CMSPrivateKey;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;

class CMSKeyItemImpl
extends CertificateKeyItemImpl
implements CMSKeyItem {
    public CMSKeyItemImpl(String label, PrivateKey key, Certificate[] chain) throws KeyManagerException {
        super(label, key, chain);
        if (!(key instanceof CMSPrivateKey)) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_KEY_TYPE, key.getClass().toString());
        }
    }

    public boolean isDefault() {
        return ((CMSPrivateKey)this.key).isDefault();
    }

    public void setDefault(boolean defaultKey) {
        ((CMSPrivateKey)this.key).setDefault(defaultKey);
    }

    public KeyStore.Entry toKeyStoreEntry() {
        return new KeyStore.PrivateKeyEntry(this.key, this.certChain);
    }

    protected int compareSameType(Entry o) {
        if (this.isDefault()) {
            return -1;
        }
        if (o instanceof Defaultable && ((Defaultable)((Object)o)).isDefault()) {
            return 1;
        }
        return super.compareSameType(o);
    }
}

