/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.BlankPKCS12File;
import com.ibm.gsk.ikeyman.io.FileModificationTracker;
import com.ibm.gsk.ikeyman.io.LockedFileOutputStream;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.security.cmskeystore.CMSLoadParameter;
import com.ibm.security.cmskeystore.CMSLoadStoreParameterFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreProxyCreatorFactory {
    public static final String PKCS11_PROVIDER = "IBMPKCS11Impl-";
    public static final String PKCS11_KEYSTORE_TYPE = "PKCS11IMPLKS";

    public static KeyStoreProxyCreator<DatabaseDescriptorFactory.DatabaseDescriptor> newFileKeyStoreCreater(String keyStoreType) {
        return new FileKeyStoreCreater(keyStoreType);
    }

    public static KeyStoreProxyCreator<DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorConfig> newPKCS11ImplKeyStoreCreater() {
        return new PKCS11ImplKeyStoreCreater();
    }

    public static KeyStoreProxyCreator<DatabaseDescriptorFactory.DatabaseDescriptor> newMSCapiKeyStoreCreater(MSCapiType type) {
        return new MSCapiKeyStoreCreater(type);
    }

    public static KeyStoreProxyCreator<DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect> newPKCS11ImplDirectKeyStoreCreater() {
        return new PKCS11ImplDirectKeyStoreCreater();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS11ImplDirectKeyStoreCreater
    implements KeyStoreProxyCreator<DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect> {
        private PKCS11ImplDirectKeyStoreCreater() {
        }

        @Override
        public KeyStoreProxy create(DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect descriptor, boolean create) throws KeyManagerException, CancelledException {
            return new PKCS11ImplDirectKeyStoreProxy(descriptor, create);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS11ImplDirectKeyStoreProxy
    extends FileLessKeyStoreProxy<DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect> {
        private static final String KEYSTORE_NAME = "PKCS11IMPLKS";
        private static final String FILE_NAME_DIVIDER = ":";
        private static final String PROVIDER = "IBMPKCS11Impl";

        public PKCS11ImplDirectKeyStoreProxy(DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect descriptor, boolean create) throws KeyManagerException, CancelledException {
            super((KeyStore)null, descriptor, create);
        }

        @Override
        protected void load() throws KeyManagerException {
            if (this.create) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ARGUMENT, "loadKeyStore:create");
            }
            IBMPKCS11Impl impl = new IBMPKCS11Impl();
            int slotNumber = ((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect)this.descriptor).getSlotNumber();
            try {
                impl.Init(((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect)this.descriptor).getFileNameString() + FILE_NAME_DIVIDER + slotNumber, ((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect)this.descriptor).getPassword(true, this.create).toCharArray());
                if (Security.getProvider(PROVIDER) != null) {
                    Security.removeProvider(PROVIDER);
                }
                Security.addProvider((Provider)impl);
                this.keyStore = KeyStore.getInstance("PKCS11IMPLKS", (Provider)impl);
                this.keyStore.load(null, null);
            }
            catch (KeyStoreException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_STORE_TYPE_NOT_FOUND, (Throwable)e, "PKCS11IMPLKS");
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
            }
            catch (CertificateException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_LOAD_ERROR, (Throwable)e);
            }
            catch (IOException e) {
                if (e.getMessage() != null) {
                    if (e.getMessage().contains("Invalid slot number")) {
                        throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_SLOT_NUMBER, (Throwable)e);
                    }
                    if (e.getMessage().contains("Pin is incorrect")) {
                        throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_PIN, (Throwable)e);
                    }
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR_MSG, (Throwable)e, e.getMessage());
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
            }
        }

        @Override
        public void close() throws KeyManagerException {
            try {
                IBMPKCS11Impl impl = (IBMPKCS11Impl)Security.getProvider(((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect)this.descriptor).getProvider());
                if (impl != null) {
                    impl.logout();
                }
            }
            catch (Exception e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.KEYSTORE_CLOSE_ERROR, (Throwable)e);
            }
        }

        @Override
        public void delete() throws KeyManagerException {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_OPERATION, "PKCS11ImplDirectKeyStoreProxy.delete");
        }

        @Override
        public void save(DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorDirect descriptor) throws KeyManagerException {
        }

        @Override
        public KeyStore reload() throws KeyManagerException, CancelledException {
            this.close();
            return super.reload();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MSCapiKeyStoreCreater
    implements KeyStoreProxyCreator<DatabaseDescriptorFactory.DatabaseDescriptor> {
        private static final String PROVIDER = "SunMSCAPI";
        private static final String BASE_KS_NAME = "Windows-";
        private MSCapiType type;

        public MSCapiKeyStoreCreater(MSCapiType type) {
            this.type = type;
        }

        @Override
        public KeyStoreProxy create(DatabaseDescriptorFactory.DatabaseDescriptor descriptor, boolean create) throws KeyManagerException, CancelledException {
            String typeName = BASE_KS_NAME + (Object)((Object)this.type);
            try {
                KeyStore keyStore = KeyStore.getInstance(typeName, PROVIDER);
                return new MSCapiKeyStoreProxy(keyStore, descriptor, create);
            }
            catch (KeyStoreException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_STORE_TYPE_NOT_FOUND, (Throwable)e, typeName);
            }
            catch (NoSuchProviderException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, PROVIDER);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MSCapiKeyStoreProxy
    extends FileLessKeyStoreProxy<DatabaseDescriptorFactory.DatabaseDescriptor> {
        public MSCapiKeyStoreProxy(KeyStore keyStore, DatabaseDescriptorFactory.DatabaseDescriptor descriptor, boolean create) throws KeyManagerException, CancelledException {
            super(keyStore, descriptor, create);
        }

        @Override
        protected void load() throws KeyManagerException {
            if (this.create) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ARGUMENT, "loadKeyStore:create");
            }
            try {
                this.keyStore.load(null, null);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
            }
            catch (CertificateException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_LOAD_ERROR, (Throwable)e);
            }
            catch (IOException e) {
                if (e.getMessage().contains("Invalid slot number")) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_SLOT_NUMBER, (Throwable)e);
                }
                if (e.getMessage().contains("Pin is incorrect")) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_PIN, (Throwable)e);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
            }
        }

        @Override
        public void save(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyManagerException {
        }

        @Override
        public void close() throws KeyManagerException {
        }

        @Override
        public void delete() throws KeyManagerException {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_OPERATION, "MSCapiEntryInterfaceImpl.delete");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS11ImplKeyStoreCreater
    implements KeyStoreProxyCreator<DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorConfig> {
        private PKCS11ImplKeyStoreCreater() {
        }

        @Override
        public KeyStoreProxy create(DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorConfig descriptor, boolean create) throws KeyManagerException, CancelledException {
            String provider = KeyStoreProxyCreatorFactory.PKCS11_PROVIDER + descriptor.getTokenLabel();
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStoreProxyCreatorFactory.PKCS11_KEYSTORE_TYPE, provider);
                return new PKCS11ImplKeyStoreProxy(keyStore, descriptor, create);
            }
            catch (KeyStoreException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_STORE_TYPE_NOT_FOUND, (Throwable)e, KeyStoreProxyCreatorFactory.PKCS11_KEYSTORE_TYPE);
            }
            catch (NoSuchProviderException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, provider);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS11ImplKeyStoreProxy
    extends FileLessKeyStoreProxy<DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorConfig> {
        public PKCS11ImplKeyStoreProxy(KeyStore keyStore, DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorConfig descriptor, boolean create) throws KeyManagerException, CancelledException {
            super(keyStore, descriptor, create);
        }

        @Override
        protected void load() throws KeyManagerException, CancelledException {
            if (this.create) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ARGUMENT, "loadKeyStore:create");
            }
            try {
                this.keyStore.load(null, ((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorConfig)this.descriptor).getPassword(true, this.create).toCharArray());
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
            }
            catch (CertificateException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_LOAD_ERROR, (Throwable)e);
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().toLowerCase().contains("pin is incorrect")) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_PIN, (Throwable)e);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
            }
        }

        @Override
        public KeyStore reload() throws KeyManagerException, CancelledException {
            this.close();
            return super.reload();
        }

        @Override
        public void save(DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorConfig descriptor) throws KeyManagerException {
        }

        @Override
        public void close() throws KeyManagerException {
            try {
                IBMPKCS11Impl impl = (IBMPKCS11Impl)Security.getProvider(((DatabaseDescriptorFactory.PKCS11ImplDatabaseDescriptorConfig)this.descriptor).getProvider());
                if (impl != null) {
                    impl.logout();
                }
            }
            catch (Exception e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.KEYSTORE_CLOSE_ERROR, (Throwable)e);
            }
        }

        @Override
        public void delete() throws KeyManagerException {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_OPERATION, "PKCS11ImplKeyStoreProxy.delete");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class FileLessKeyStoreProxy<D extends DatabaseDescriptorFactory.DatabaseDescriptor>
    extends AbstractKeyStoreProxy<D> {
        public FileLessKeyStoreProxy(KeyStore keyStore, D descriptor, boolean create) throws KeyManagerException, CancelledException {
            super(keyStore, descriptor, create);
        }

        @Override
        public boolean needsRefresh() {
            if (this.hasChanged) {
                this.hasChanged = false;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS12KeyStoreProxy
    extends FileKeyStoreProxy<DatabaseDescriptorFactory.DatabaseDescriptor> {
        public PKCS12KeyStoreProxy(KeyStore keyStore, DatabaseDescriptorFactory.DatabaseDescriptor descriptor, boolean create) throws KeyManagerException, CancelledException {
            super(keyStore, descriptor, create);
        }

        @Override
        protected void performSave(DatabaseDescriptorFactory.DatabaseDescriptor descriptor) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagerException {
            if (this.keyStore.size() == 0) {
                BlankPKCS12File file = new BlankPKCS12File();
                file.store(descriptor.getPassword().toCharArray(), descriptor.getFileNameString());
            } else {
                super.performSave(descriptor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CMSKeyStoreProxy
    extends FileKeyStoreProxy<DatabaseDescriptorFactory.CMSDatabaseDescriptor> {
        public CMSKeyStoreProxy(KeyStore keyStore, DatabaseDescriptorFactory.CMSDatabaseDescriptor descriptor, boolean create) throws KeyManagerException, CancelledException {
            super(keyStore, descriptor, create);
        }

        @Override
        protected void performLoad(InputStream in, boolean create) throws NoSuchAlgorithmException, CertificateException, IOException, KeyManagerException, CancelledException {
            byte[] inputBuffer;
            if (in == null) {
                inputBuffer = null;
            } else {
                inputBuffer = new byte[in.available()];
                in.read(inputBuffer);
            }
            String password = ((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.descriptor).getPassword(false, create);
            if (password == null) {
                if (!(create && KeymanSettings.Setting.CMSPasswordRequired.getBoolean().booleanValue() || !this.loadWithPassword(inputBuffer, KeymanSettings.PASSWORDLESS_CMS_PASSWORD))) {
                    return;
                }
                if (KeymanSettings.Setting.DefaultCMSPassword.getString() != null && this.loadWithPassword(inputBuffer, KeymanSettings.Setting.DefaultCMSPassword.getString())) {
                    return;
                }
            }
            super.performLoad(inputBuffer == null ? null : new ByteArrayInputStream(inputBuffer), create);
            CMSLoadParameter param = (CMSLoadParameter)CMSLoadStoreParameterFactory.newCMSLoadParameter((File)(create ? null : new File(((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.descriptor).getFileNameString())), (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.descriptor).getPassword().toCharArray()));
            this.keyStore.load((KeyStore.LoadStoreParameter)param);
            if (!create) {
                ((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.descriptor).setPasswordExpiryTimeSinceEpoch(param.getPasswordExpiry());
            }
        }

        private boolean loadWithPassword(byte[] inputBytes, String password) throws NoSuchAlgorithmException, CertificateException {
            try {
                this.keyStore.load(inputBytes == null ? null : new ByteArrayInputStream(inputBytes), password.toCharArray());
                ((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.descriptor).setPassword(password);
                ((DatabaseDescriptorFactory.CMSDatabaseDescriptor)this.descriptor).setPasswordProtected(!password.equals(KeymanSettings.PASSWORDLESS_CMS_PASSWORD));
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        protected void performSave(DatabaseDescriptorFactory.CMSDatabaseDescriptor descriptor) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
            KeyStore.PasswordProtection protect = new KeyStore.PasswordProtection(descriptor.getPassword().toCharArray());
            KeyStore.LoadStoreParameter params = CMSLoadStoreParameterFactory.newCMSStoreParameter((File)new File(descriptor.getFileNameString()), (KeyStore.ProtectionParameter)protect, (boolean)descriptor.isUseStash(), (int)descriptor.getPasswordExpiryTime());
            this.keyStore.store(params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileKeyStoreCreater
    implements KeyStoreProxyCreator<DatabaseDescriptorFactory.DatabaseDescriptor> {
        private String keyStoreType;

        public FileKeyStoreCreater(String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        @Override
        public KeyStoreProxy create(DatabaseDescriptorFactory.DatabaseDescriptor descriptor, boolean create) throws KeyManagerException, CancelledException {
            try {
                KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
                switch (descriptor.getType()) {
                    case CMS: {
                        return new CMSKeyStoreProxy(keyStore, (DatabaseDescriptorFactory.CMSDatabaseDescriptor)descriptor, create);
                    }
                    case PKCS12: {
                        return new PKCS12KeyStoreProxy(keyStore, descriptor, create);
                    }
                }
                return new FileKeyStoreProxy<DatabaseDescriptorFactory.DatabaseDescriptor>(keyStore, descriptor, create);
            }
            catch (KeyStoreException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_STORE_TYPE_NOT_FOUND, (Throwable)e, this.keyStoreType);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileKeyStoreProxy<T extends DatabaseDescriptorFactory.DatabaseDescriptor>
    extends AbstractKeyStoreProxy<T> {
        private FileModificationTracker tracker;

        public FileKeyStoreProxy(KeyStore keyStore, T descriptor, boolean create) throws KeyManagerException, CancelledException {
            super(keyStore, descriptor, create);
            this.tracker = new FileModificationTracker(descriptor.getFileNameString());
        }

        @Override
        protected void load() throws KeyManagerException, CancelledException {
            this.tracker.loaded();
            InputStream in = null;
            try {
                in = this.create ? null : new FileInputStream(this.descriptor.getFileNameString());
                this.performLoad(in, this.create);
            }
            catch (FileNotFoundException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INPUT_FILE_NOT_FOUND, (Throwable)e, this.descriptor.getFileName().toString());
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
            }
            catch (CertificateException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_LOAD_ERROR, (Throwable)e);
            }
            catch (IOException e) {
                if (e.getMessage() != null) {
                    if (e.getMessage().contains("Illegal key size")) {
                        throw new KeyManagerException(KeyManagerException.ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)e);
                    }
                    if (e.getMessage().toLowerCase().contains("locked")) {
                        throw new KeyManagerException(KeyManagerException.ExceptionReason.DATABASE_LOCKED, (Throwable)e);
                    }
                    if (e.getMessage().toLowerCase().contains("incorrect") || e.getMessage().toLowerCase().contains("unable to verify mac")) {
                        throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_PASSWORD, (Throwable)e, this.descriptor.getType().toString());
                    }
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR_MSG, (Throwable)e, e.getMessage());
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
            }
            catch (CancelledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof KeyManagerException) {
                    KeyManagerException cause = (KeyManagerException)e.getCause();
                    throw new KeyManagerException(cause.getReason(), (Throwable)e, cause.getDetails());
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_STORE_LOAD_ERROR, (Throwable)e, e.getLocalizedMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
                    }
                }
            }
        }

        protected void performLoad(InputStream in, boolean create) throws NoSuchAlgorithmException, CertificateException, IOException, KeyManagerException, CancelledException {
            this.keyStore.load(in, this.descriptor.getPassword(true, create).toCharArray());
        }

        @Override
        public boolean needsRefresh() {
            return this.tracker.needsRefresh();
        }

        @Override
        public void save(T descriptor) throws KeyManagerException {
            try {
                this.performSave(descriptor);
            }
            catch (FileNotFoundException e) {
                if (new File(descriptor.getFileName().getDirectory()).exists()) {
                    SecurityManager manager = new SecurityManager();
                    try {
                        manager.checkWrite(descriptor.getFileNameString());
                    }
                    catch (SecurityException e1) {
                        throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_WRITE_PERMISSION, (Throwable)e, descriptor.getFileNameString());
                    }
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_FILE_CREATION_ERROR, (Throwable)e, descriptor.getFileNameString());
            }
            catch (KeyStoreException e) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.UNINITIALISED_KEY_STORE, (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
            }
            catch (CertificateException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CERTIFICATE_STORE_ERROR, (Throwable)e);
            }
            catch (IOException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
            }
        }

        protected void performSave(T descriptor) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagerException {
            LockedFileOutputStream outputStream = new LockedFileOutputStream(descriptor.getFileNameString());
            this.keyStore.store(outputStream, descriptor.getPassword().toCharArray());
            ((OutputStream)outputStream).close();
        }

        @Override
        public void close() {
        }

        @Override
        public void delete() throws KeyManagerException {
            File tempFile = new File(this.descriptor.getFileNameString());
            if (!tempFile.delete()) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.DELETION_FAILED, tempFile.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractKeyStoreProxy<T extends DatabaseDescriptorFactory.DatabaseDescriptor>
    implements KeyStoreProxy<T> {
        private boolean isLoaded = false;
        protected KeyStore keyStore;
        protected T descriptor;
        protected boolean create;
        protected boolean hasChanged = false;

        public AbstractKeyStoreProxy(KeyStore keyStore, T descriptor, boolean create) throws KeyManagerException, CancelledException {
            this.keyStore = keyStore;
            this.descriptor = descriptor;
            this.create = create;
        }

        @Override
        public KeyStore getKeyStore() throws KeyManagerException, CancelledException {
            if (!this.isLoaded) {
                this.load();
                this.isLoaded = true;
            }
            return this.keyStore;
        }

        @Override
        public KeyStore reload() throws KeyManagerException, CancelledException {
            this.create = false;
            this.load();
            this.isLoaded = true;
            return this.keyStore;
        }

        @Override
        public void setHasChanged(boolean b) {
            this.hasChanged = b;
        }

        protected abstract void load() throws KeyManagerException, CancelledException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface KeyStoreProxyCreator<T extends DatabaseDescriptorFactory.DatabaseDescriptor> {
        public KeyStoreProxy create(T var1, boolean var2) throws KeyManagerException, CancelledException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface KeyStoreProxy<T extends DatabaseDescriptorFactory.DatabaseDescriptor> {
        public KeyStore getKeyStore() throws KeyManagerException, CancelledException;

        public KeyStore reload() throws KeyManagerException, CancelledException;

        public void save(T var1) throws KeyManagerException;

        public void close() throws KeyManagerException;

        public void delete() throws KeyManagerException;

        public boolean needsRefresh();

        public void setHasChanged(boolean var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MSCapiType {
        ROOT,
        MY;

    }
}

