/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.EntryBagFactory;
import com.ibm.gsk.ikeyman.keystore.EntryContainerFactory;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.SelectorFactory;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryInterfaceFactory {
    public static <T extends DatabaseDescriptorFactory.DatabaseDescriptor> EntryInterface<Entry, T> newKeyStoreProxyEntryInterface(EntryBagFactory.EntryBag<Entry> bag, T descriptor, KeyStoreProxyCreatorFactory.KeyStoreProxy<T> keyStore) {
        return new KeyStoreProxyEntryInterface<T>(bag, descriptor, keyStore);
    }

    public static <T extends Entry> EntryInterface<? extends Entry, DatabaseDescriptorFactory.DatabaseDescriptor> newEntryContainerInterface(EntryContainerFactory.EntryContainer<T> bag, DatabaseDescriptorFactory.DatabaseDescriptor descriptor, Class<T> c) {
        return new ReadonlyEntryBagInterface<T>(bag, descriptor, c);
    }

    public static <T extends DatabaseDescriptorFactory.DatabaseDescriptor> EntryInterface<Entry, T> newCompoundEntryInterface(T topLevelDescriptor, EntryInterface<? extends Entry, T> ... entryInterfaces) {
        return new CompoundEntryInterface<T>(SelectorFactory.getEntryInterfaceSelectorByType(entryInterfaces), topLevelDescriptor);
    }

    public static <T extends DatabaseDescriptorFactory.DatabaseDescriptor> EntryInterface<Entry, T> newPrimarySecondaryInterface(T primaryDescriptor, EntryInterface<Entry, T> primaryInterface, EntryInterface<Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> secondaryInterface) {
        return new CompoundEntryInterface<T>(SelectorFactory.getEntryInterfaceSelectorPrimarySecondary(primaryInterface, secondaryInterface), primaryDescriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompoundEntryInterface<T extends DatabaseDescriptorFactory.DatabaseDescriptor>
    implements EntryInterface<Entry, T> {
        private SelectorFactory.Selector<EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor>> selector;
        private T topLevelDescriptor;

        public CompoundEntryInterface(SelectorFactory.Selector<EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor>> selector, T topLevelDescriptor) {
            this.selector = selector;
            this.topLevelDescriptor = topLevelDescriptor;
        }

        @Override
        public void changePassword(CommandParameters params) throws KeyManagerException {
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                entryInterface.changePassword(params);
            }
        }

        @Override
        public void close() throws KeyManagerException {
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                entryInterface.close();
            }
        }

        @Override
        public void delete() throws KeyManagerException {
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                entryInterface.delete();
            }
        }

        @Override
        public void delete(Entry entry) throws KeyManagerException {
            EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface = this.selector.select(entry);
            if (entryInterface != null) {
                entryInterface.delete(entry);
            }
        }

        @Override
        public void save() throws KeyManagerException {
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                entryInterface.save();
            }
        }

        @Override
        public void add(Entry item) throws KeyManagerException {
            EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface = this.selector.select(item);
            if (entryInterface == null) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ENTRY_TYPE, item.getClass().toString());
            }
            entryInterface.add(item);
        }

        @Override
        public boolean contains(String label) {
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                if (!entryInterface.contains(label)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void delete(String label) throws KeyManagerException {
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                if (!entryInterface.contains(label)) continue;
                entryInterface.delete(label);
                return;
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_ENTRY_FOR_LABEL, label);
        }

        @Override
        public Collection<String> getAliases() {
            ArrayList<String> aliases = new ArrayList<String>();
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                aliases.addAll(entryInterface.getAliases());
            }
            return aliases;
        }

        @Override
        public EntryBagFactory.EntryBag<? extends Entry> getEntryBag(Class<? extends Entry> c) {
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                EntryBagFactory.EntryBag<Entry> bag = entryInterface.getEntryBag(c);
                if (bag == null) continue;
                return bag;
            }
            return null;
        }

        @Override
        public Entry getItem(String label) throws KeyManagerException {
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                if (!entryInterface.contains(label)) continue;
                Object returnValue = entryInterface.getItem(label);
                return returnValue;
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_ENTRY_FOR_LABEL, label);
        }

        @Override
        public Collection<Entry> getItems() throws KeyManagerException {
            ArrayList<Entry> items = new ArrayList<Entry>();
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                items.addAll(entryInterface.getItems());
            }
            return items;
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            ArrayList<Class<? extends Entry>> types = new ArrayList<Class<? extends Entry>>();
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                types.addAll(entryInterface.getSupportedTypes());
            }
            return types;
        }

        @Override
        public void refresh() throws KeyManagerException {
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                entryInterface.refresh();
            }
        }

        @Override
        public boolean needsRefresh() {
            for (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor> entryInterface : this.selector.getAll()) {
                if (!entryInterface.needsRefresh()) continue;
                return true;
            }
            return false;
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            return this.selector.compare((EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor>)((Object)e1), (EntryInterface<? extends Entry, ? extends DatabaseDescriptorFactory.DatabaseDescriptor>)((Object)e2));
        }

        @Override
        public T getDescriptor() {
            return this.topLevelDescriptor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReadonlyEntryBagInterface<T extends Entry>
    extends EntryBagFactory.ReadonlyEntryContainerBag<T>
    implements EntryInterface<T, DatabaseDescriptorFactory.DatabaseDescriptor> {
        private DatabaseDescriptorFactory.DatabaseDescriptor descriptor;

        public ReadonlyEntryBagInterface(EntryContainerFactory.EntryContainer<T> bag, DatabaseDescriptorFactory.DatabaseDescriptor descriptor, Class<T> c) {
            super(bag, c);
            this.descriptor = descriptor;
        }

        @Override
        public void close() throws KeyManagerException {
        }

        @Override
        public void delete() throws KeyManagerException {
            throw new UnsupportedOperationException("EntryContainerInterfaceImpl.delete");
        }

        @Override
        public DatabaseDescriptorFactory.DatabaseDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public void save() throws KeyManagerException {
            throw new UnsupportedOperationException("EntryContainerInterfaceImpl.delete");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyStoreProxyEntryInterface<T extends DatabaseDescriptorFactory.DatabaseDescriptor>
    extends AbstractEntryInterface<T> {
        protected KeyStoreProxyCreatorFactory.KeyStoreProxy<T> keyStore;

        public KeyStoreProxyEntryInterface(EntryBagFactory.EntryBag<Entry> bag, T descriptor, KeyStoreProxyCreatorFactory.KeyStoreProxy<T> keyStore) {
            super(bag, descriptor);
            this.keyStore = keyStore;
        }

        @Override
        protected void reload() throws CancelledException, KeyManagerException {
            this.keyStore.reload();
        }

        @Override
        public void close() throws KeyManagerException {
            this.keyStore.close();
        }

        @Override
        public void delete() throws KeyManagerException {
            this.keyStore.delete();
        }

        @Override
        public void save() throws KeyManagerException {
            this.keyStore.save(this.descriptor);
        }

        @Override
        public boolean needsRefresh() {
            return this.keyStore.needsRefresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractEntryInterface<T extends DatabaseDescriptorFactory.DatabaseDescriptor>
    extends EntryBagFactory.AbstractEntryContainerBag<Entry>
    implements EntryInterface<Entry, T> {
        private EntryBagFactory.EntryBag<Entry> bag;
        protected T descriptor;

        public AbstractEntryInterface(EntryBagFactory.EntryBag<Entry> bag, T descriptor) {
            super(bag);
            this.bag = bag;
            this.descriptor = descriptor;
        }

        @Override
        public void add(Entry item) throws KeyManagerException {
            this.bag.add(item);
        }

        @Override
        public void delete(String label) throws KeyManagerException {
            this.bag.delete(label);
        }

        @Override
        public void delete(Entry entry) throws KeyManagerException {
            this.bag.delete(entry);
        }

        @Override
        public EntryBagFactory.EntryBag<? extends Entry> getEntryBag(Class<? extends Entry> c) {
            EntryBagFactory.EntryBag<Entry> returnValue = this.bag.getEntryBag(c);
            return returnValue;
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            List<Class<? extends Entry>> returnValue = this.bag.getSupportedTypes();
            return returnValue;
        }

        @Override
        public void refresh() throws KeyManagerException {
            if (this.needsRefresh()) {
                this.reload();
            }
            this.bag.refresh();
        }

        @Override
        public void changePassword(CommandParameters params) throws KeyManagerException {
            this.bag.changePassword(params);
            this.descriptor.setPassword(params);
        }

        @Override
        public T getDescriptor() {
            return this.descriptor;
        }

        protected abstract void reload() throws CancelledException, KeyManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EntryInterface<E extends Entry, D extends DatabaseDescriptorFactory.DatabaseDescriptor>
    extends EntryBagFactory.EntryBag<E> {
        public void save() throws KeyManagerException;

        public void close() throws KeyManagerException;

        public void delete() throws KeyManagerException;

        public D getDescriptor();
    }
}

