/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.PKCS7Parser;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.util.FileName;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryContainerFactory {
    public static EntryContainer<CertificateItem> newPKCS7EntryFile(FileName f) throws KeyManagerException {
        return new PKCS7EntryFile(f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS7EntryFile
    implements EntryContainer<CertificateItem> {
        private FileName fileName;
        private Collection<CertificateItem> entries = new ArrayList<CertificateItem>();

        private PKCS7EntryFile(FileName f) throws KeyManagerException {
            this.fileName = f;
            this.populateEntries();
        }

        private void populateEntries() throws KeyManagerException {
            try {
                Certificate[] certs;
                for (Certificate cert : certs = PKCS7Parser.getCertificates(this.fileName.toString())) {
                    X509Certificate x509Cert = (X509Certificate)cert;
                    this.entries.add(EntryFactory.newCertificateItem(x509Cert.getSubjectX500Principal().toString(), x509Cert));
                }
            }
            catch (Exception e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.PKCS7_PARSING_ERROR, (Throwable)e, e.getMessage());
            }
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            return e1.compareTo(e2);
        }

        @Override
        public boolean contains(String label) {
            try {
                this.getItem(label);
                return true;
            }
            catch (KeyManagerException e) {
                return false;
            }
        }

        @Override
        public Collection<String> getAliases() {
            ArrayList<String> returnList = new ArrayList<String>();
            for (CertificateItem entry : this.entries) {
                returnList.add(entry.getLabel());
            }
            return returnList;
        }

        @Override
        public CertificateItem getItem(String label) throws KeyManagerException {
            for (CertificateItem entry : this.entries) {
                if (!entry.getLabel().equals(label)) continue;
                return entry;
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_ENTRY_FOR_LABEL, label);
        }

        @Override
        public Collection<CertificateItem> getItems() throws KeyManagerException {
            return this.entries;
        }

        @Override
        public boolean needsRefresh() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EntryContainer<T extends Entry>
    extends Comparator<Entry> {
        public Collection<T> getItems() throws KeyManagerException;

        public T getItem(String var1) throws KeyManagerException;

        public boolean contains(String var1);

        public Collection<String> getAliases();

        public boolean needsRefresh();
    }
}

