/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicCheckbox;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;

public final class PasswordPromptDialog
extends CenteredDialog
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel passwordFieldPanel = null;
    private MnemonicLabel passwordLabel = null;
    private MnemonicLabel confirmPasswordLabel = null;
    private JPasswordField passwordField = null;
    private JPasswordField confirmPasswordField = null;
    private String password = null;
    private GUIConstants.DialogMode mode = null;
    private String prompt;
    private String fileName = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private JSeparator jSeparator = null;
    private JLabel fileNameLbl = null;
    private JPanel cmsOptionsPanel = null;
    private MnemonicCheckbox expirationTimeCheckbox = null;
    private MnemonicCheckbox stashPasswordCheckbox = null;
    private JFormattedTextField expirationTimeField = null;
    private MnemonicLabel daysLabel = null;
    private Constants.DatabaseType type;

    protected PasswordPromptDialog(Frame owner, Constants.DatabaseType type) {
        this(owner, type, GUIConstants.DialogMode.New);
    }

    protected PasswordPromptDialog(Frame owner, Constants.DatabaseType type, GUIConstants.DialogMode mode) {
        this(owner, type, mode, null);
    }

    public PasswordPromptDialog(Frame owner, Constants.DatabaseType type, GUIConstants.DialogMode mode, String fileName) {
        this(owner, type, mode, fileName, Messages.getStringWithMnemonics("Label.Password"));
    }

    public PasswordPromptDialog(Frame owner, Constants.DatabaseType type, GUIConstants.DialogMode mode, String fileName, String prompt) {
        super(owner);
        this.type = type;
        this.mode = mode;
        this.prompt = prompt;
        this.fileName = fileName;
        this.initialize();
    }

    private void initialize() {
        this.setSize(393, 313);
        this.setResizable(false);
        this.setModal(true);
        this.setTitle(Messages.getString("GUI.Title.Password"));
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.getButtonPanel().getOkBtn());
        this.pack();
        this.setName(ControlNames.PasswordPromptDialog.toString());
        this.centerToParent();
    }

    private ParameterMap getParameters(Constants.Parameter passwordParam) throws KeyManagerException {
        ParameterMap map = new ParameterMap();
        map.put(passwordParam, this.password);
        if (this.expirationTimeCheckbox != null) {
            if (this.expirationTimeCheckbox.isSelected()) {
                try {
                    map.put(Constants.Parameter.Expire, this.expirationTimeField.getText());
                }
                catch (KeyManagerException e) {
                    if (e.getReason() == KeyManagerException.ExceptionReason.INVALID_NUMBER_FORMAT) {
                        e.addDetail(Messages.getString("Message.PasswordExpiryTime"));
                    }
                    throw e;
                }
            } else {
                map.put(Constants.Parameter.Expire, 0);
            }
        }
        if (this.stashPasswordCheckbox != null && this.stashPasswordCheckbox.isSelected()) {
            map.put(Constants.Parameter.StashPassword, true);
        }
        return map;
    }

    public static ParameterMap getPasswordData(Frame owner, Constants.DatabaseType type, Constants.Parameter passwordParameter, GUIConstants.DialogMode mode) throws KeyManagerException, CancelledException {
        PasswordPromptDialog dialog = new PasswordPromptDialog(owner, type, mode);
        dialog.setVisible(true);
        return PasswordPromptDialog.getMap(dialog, passwordParameter);
    }

    public static ParameterMap getPasswordData(Frame owner, Constants.DatabaseType type, Constants.Parameter passwordParameter, GUIConstants.DialogMode mode, String fileName) throws KeyManagerException, CancelledException {
        PasswordPromptDialog dialog = new PasswordPromptDialog(owner, type, mode, fileName);
        dialog.setVisible(true);
        return PasswordPromptDialog.getMap(dialog, passwordParameter);
    }

    public static ParameterMap getTargetPasswordData(Frame owner, Constants.DatabaseType type, Constants.Parameter passwordParameter, GUIConstants.DialogMode mode) throws KeyManagerException, CancelledException {
        String prompt = mode == GUIConstants.DialogMode.New ? Messages.getStringWithMnemonics("Label.TargetPasswordNew") : Messages.getStringWithMnemonics("Label.TargetPasswordOpen");
        PasswordPromptDialog dialog = new PasswordPromptDialog(owner, type, mode, null, prompt);
        dialog.setVisible(true);
        return PasswordPromptDialog.getMap(dialog, passwordParameter);
    }

    public static ParameterMap getSourcePasswordData(Frame owner, Constants.DatabaseType type, Constants.Parameter passwordParameter, GUIConstants.DialogMode mode) throws KeyManagerException, CancelledException {
        PasswordPromptDialog dialog = new PasswordPromptDialog(owner, type, mode, null, Messages.getStringWithMnemonics("Label.SourcePassword"));
        dialog.setVisible(true);
        return PasswordPromptDialog.getMap(dialog, passwordParameter);
    }

    private static ParameterMap getMap(PasswordPromptDialog dialog, Constants.Parameter passwordParameter) throws KeyManagerException, CancelledException {
        try {
            if (dialog.getDialogResult() == GUIConstants.DialogResult.OK) {
                ParameterMap parameterMap = dialog.getParameters(passwordParameter);
                return parameterMap;
            }
            throw new CancelledException();
        }
        finally {
            dialog.dispose();
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridy = 2;
            gridBagConstraints10.insets = new Insets(10, 10, 10, 30);
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.gridx = 0;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridy = 4;
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.insets = new Insets(10, 0, 10, 0);
            gridBagConstraints16.gridx = 0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 5;
            gridBagConstraints14.insets = new Insets(0, 0, 5, 0);
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.ipadx = 197;
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridy = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPasswordFieldPanel(), gridBagConstraints13);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints14);
            this.jContentPane.add((Component)this.getJSeparator(), gridBagConstraints16);
            if (this.fileName != null) {
                GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
                gridBagConstraints17.gridy = 0;
                gridBagConstraints17.insets = new Insets(10, 5, 10, 5);
                gridBagConstraints17.gridx = 0;
                this.fileNameLbl = new JLabel();
                this.fileNameLbl.setText(Messages.getString("Label.FileName") + " " + this.fileName);
                this.jContentPane.add((Component)this.fileNameLbl, gridBagConstraints17);
            }
            if (this.mode == GUIConstants.DialogMode.New && this.type.supportsPasswordOptions()) {
                this.jContentPane.add((Component)this.getCmsOptionsPanel(), gridBagConstraints10);
            }
        }
        return this.jContentPane;
    }

    private JPanel getPasswordFieldPanel() {
        if (this.passwordFieldPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints3.ipadx = 25;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints2.ipadx = 25;
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.gridx = 0;
            this.confirmPasswordLabel = new MnemonicLabel();
            this.confirmPasswordLabel.setText(Messages.getStringWithMnemonics("Label.ConfirmPassword"));
            this.confirmPasswordLabel.setName(ControlNames.PasswordPromptDialogConfirmPasswordLabel.toString());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.gridx = 0;
            this.passwordLabel = new MnemonicLabel();
            this.passwordLabel.setText(this.prompt);
            this.passwordLabel.setName(ControlNames.PasswordPromptDialogPasswordLabel.toString());
            this.passwordFieldPanel = new JPanel();
            this.passwordFieldPanel.setLayout(new GridBagLayout());
            this.passwordFieldPanel.add((Component)this.passwordLabel, gridBagConstraints);
            this.passwordFieldPanel.add((Component)this.getPasswordField(), gridBagConstraints2);
            if (this.mode == GUIConstants.DialogMode.New) {
                this.passwordFieldPanel.add((Component)this.confirmPasswordLabel, gridBagConstraints1);
                this.passwordFieldPanel.add((Component)this.getConfirmPasswordField(), gridBagConstraints3);
                this.confirmPasswordLabel.setLabelFor(this.getConfirmPasswordField());
            }
            this.passwordLabel.setLabelFor(this.getPasswordField());
        }
        return this.passwordFieldPanel;
    }

    private JPasswordField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new JPasswordField();
            this.passwordField.setToolTipText(Messages.getString("Tooltip.Password"));
            this.passwordField.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(this.prompt));
            this.passwordField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.Password"));
            this.passwordField.setName(ControlNames.PasswordPromptDialogPasswordField.toString());
        }
        return this.passwordField;
    }

    private JPasswordField getConfirmPasswordField() {
        if (this.confirmPasswordField == null) {
            this.confirmPasswordField = new JPasswordField();
            this.confirmPasswordField.setToolTipText(Messages.getString("Tooltip.PasswordConfirm"));
            this.confirmPasswordField.getAccessibleContext().setAccessibleName(Messages.getString("Label.ConfirmPassword"));
            this.confirmPasswordField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.PasswordConfirm"));
            this.confirmPasswordField.setName(ControlNames.PasswordPromptDialogConfirmPasswordField.toString());
        }
        return this.confirmPasswordField;
    }

    private boolean validateInput() {
        String password = new String(this.passwordField.getPassword());
        if (password.length() == 0) {
            JOptionPane.showMessageDialog(this.getOwner(), Messages.getString("Message.EmptyPassword"), Messages.getString("GUI.Title.PasswordValidation"), 0);
            this.resetHandler();
            return false;
        }
        if (this.mode == GUIConstants.DialogMode.New) {
            String confirmPassword = new String(this.confirmPasswordField.getPassword());
            if (!password.equals(confirmPassword)) {
                JOptionPane.showMessageDialog(this.getOwner(), Messages.getString("Message.PasswordConfirmationFailed"), Messages.getString("GUI.Title.PasswordValidation"), 0);
                this.resetHandler();
                return false;
            }
            if (this.expirationTimeCheckbox != null && this.expirationTimeCheckbox.isSelected() && this.expirationTimeField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.getOwner(), Messages.getString("Message.EmptyPasswordExpiration"), Messages.getString("GUI.Title.PasswordValidation"), 0);
                return false;
            }
            return true;
        }
        if (this.mode == GUIConstants.DialogMode.Open) {
            return true;
        }
        throw new RuntimeException("Invalid password prompt mode.");
    }

    protected void okHandler() {
        if (this.validateInput()) {
            this.setDialogResult(GUIConstants.DialogResult.OK);
            this.password = new String(this.passwordField.getPassword());
            this.setVisible(false);
        }
    }

    protected void resetHandler() {
        this.passwordField.setText("");
        if (this.confirmPasswordField != null) {
            this.confirmPasswordField.setText("");
        }
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(GUIConstants.Actions.OK, GUIConstants.Actions.Cancel, GUIConstants.Actions.Reset);
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    private JSeparator getJSeparator() {
        if (this.jSeparator == null) {
            this.jSeparator = new JSeparator();
        }
        return this.jSeparator;
    }

    private JPanel getCmsOptionsPanel() {
        if (this.cmsOptionsPanel == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.ipadx = 40;
            gridBagConstraints9.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints9.gridx = 3;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.anchor = 17;
            this.daysLabel = new MnemonicLabel();
            this.daysLabel.setText(Messages.getStringWithMnemonics("Label.Days"));
            this.daysLabel.setEnabled(false);
            this.daysLabel.setName(ControlNames.PasswordPromptDialogDaysLabel.toString());
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 3;
            gridBagConstraints8.gridx = 2;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints8.gridy = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridwidth = 1;
            gridBagConstraints7.gridx = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints6.gridx = 0;
            this.cmsOptionsPanel = new JPanel();
            this.cmsOptionsPanel.setLayout(new GridBagLayout());
            this.cmsOptionsPanel.add((Component)this.getExpirationTimeCheckbox(), gridBagConstraints6);
            this.cmsOptionsPanel.add((Component)this.getStashPasswordCheckbox(), gridBagConstraints7);
            this.cmsOptionsPanel.add((Component)this.getExpirationTimeField(), gridBagConstraints8);
            this.cmsOptionsPanel.add((Component)this.daysLabel, gridBagConstraints9);
            this.daysLabel.setLabelFor(this.getExpirationTimeField());
        }
        return this.cmsOptionsPanel;
    }

    private MnemonicCheckbox getExpirationTimeCheckbox() {
        if (this.expirationTimeCheckbox == null) {
            this.expirationTimeCheckbox = new MnemonicCheckbox();
            this.expirationTimeCheckbox.setText(Messages.getStringWithMnemonics("Label.ExpirationTime"));
            this.expirationTimeCheckbox.addItemListener(this);
            this.expirationTimeCheckbox.setName(ControlNames.PasswordPromptDialogExpirationTimeCheckbox.toString());
        }
        return this.expirationTimeCheckbox;
    }

    private MnemonicCheckbox getStashPasswordCheckbox() {
        if (this.stashPasswordCheckbox == null) {
            this.stashPasswordCheckbox = new MnemonicCheckbox();
            this.stashPasswordCheckbox.setSelected(KeymanSettings.Setting.DefaultPasswordStashingState.getBoolean());
            this.stashPasswordCheckbox.setText(Messages.getStringWithMnemonics("Label.StashPassword"));
            this.stashPasswordCheckbox.setName(ControlNames.PasswordPromptDialogStashPasswordCheckbox.toString());
        }
        return this.stashPasswordCheckbox;
    }

    private JFormattedTextField getExpirationTimeField() {
        if (this.expirationTimeField == null) {
            NumberFormat format = NumberFormat.getIntegerInstance();
            format.setGroupingUsed(false);
            format.setMaximumIntegerDigits(KeymanSettings.VALID_PASSWORD_EXPIRY_RANGE.getMaximumDigits());
            this.expirationTimeField = new JFormattedTextField(format);
            this.expirationTimeField.setColumns(5);
            this.expirationTimeField.setText("60");
            this.expirationTimeField.setEnabled(false);
            this.expirationTimeField.setToolTipText(Messages.getString("Tooltip.PasswordExpireTime"));
            this.expirationTimeField.getAccessibleContext().setAccessibleName(Messages.getString("Label.Days"));
            this.expirationTimeField.getAccessibleContext().setAccessibleDescription(Messages.getString("Tooltip.PasswordExpireTime"));
            this.expirationTimeField.setName(ControlNames.PasswordPromptDialogExpirationTimeField.toString());
        }
        return this.expirationTimeField;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.expirationTimeCheckbox)) {
            this.daysLabel.setEnabled(this.expirationTimeCheckbox.isSelected());
            this.expirationTimeField.setEnabled(this.expirationTimeCheckbox.isSelected());
        }
    }
}

