/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.error.ExceptionInfo;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.controls.ButtonFactory;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class MessageDialog
extends CenteredDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton moreLessBtn = null;
    private JPanel morePanel = null;
    private JLabel jLabel = null;
    private JTextArea solutionArea = null;
    private JLabel jLabel1 = null;
    private JTextArea detailsArea = null;
    private ButtonState buttonState = ButtonState.More;
    private OKResetCancelButtonPanel buttonPanel = null;
    private JScrollPane jScrollPane = null;
    private JTextArea userMsgArea = null;
    private JSeparator jSeparator = null;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    protected MessageDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    public MessageDialog(Frame owner, String message, ExceptionInfo info) {
        this(owner);
        this.populateFields(message, info);
    }

    private void populateFields(String message, ExceptionInfo info) {
        if (info != null) {
            this.userMsgArea.setText("");
            if (message != null && message.trim().length() > 0) {
                this.userMsgArea.append(message + "\n");
            }
            this.userMsgArea.append(info.getUserMessage());
            this.userMsgArea.setSelectionStart(0);
            this.userMsgArea.setSelectionEnd(0);
            this.solutionArea.setText(info.getSolutionMessage());
            this.solutionArea.setSelectionStart(0);
            this.solutionArea.setSelectionEnd(0);
            this.detailsArea.setText(info.getDetails());
            this.detailsArea.setSelectionStart(0);
            this.detailsArea.setSelectionEnd(0);
            this.moreLessBtn.setVisible(true);
            this.setTitle(Messages.getString("GUI.Title.Error"));
        } else {
            this.userMsgArea.setText(message);
            this.userMsgArea.setSelectionStart(0);
            this.userMsgArea.setSelectionEnd(0);
            this.moreLessBtn.setVisible(false);
            this.setTitle(Messages.getString("GUI.Title.Message"));
        }
    }

    public void setExceptionInfo(ExceptionInfo info) {
        this.populateFields(null, info);
    }

    public void setMessage(String message) {
        this.populateFields(message, null);
    }

    private void initialize() {
        this.setSize(390, 188);
        this.setModal(true);
        this.setResizable(true);
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.getRootPane().setDefaultButton(this.getButtonPanel().getOkBtn());
        this.centerToParent();
        this.setName(ControlNames.MessageDialog.toString());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridy = 3;
            gridBagConstraints31.fill = 2;
            gridBagConstraints31.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints31.gridx = 1;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 1;
            gridBagConstraints22.gridx = 1;
            gridBagConstraints22.weighty = 1.0;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints22.ipadx = 0;
            gridBagConstraints22.ipady = 0;
            gridBagConstraints22.gridy = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridy = 4;
            gridBagConstraints11.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints11.gridx = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridy = 2;
            gridBagConstraints21.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints21.fill = 1;
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.insets = new Insets(10, 50, 5, 5);
            gridBagConstraints1.gridx = 1;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getMoreLessBtn(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getMorePanel(), gridBagConstraints21);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getJScrollPane(), gridBagConstraints22);
            this.jContentPane.add((Component)this.getJSeparator(), gridBagConstraints31);
        }
        return this.jContentPane;
    }

    private JButton getMoreLessBtn() {
        if (this.moreLessBtn == null) {
            this.moreLessBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.More"), ControlNames.MessageDialogMoreLessButton);
            this.moreLessBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.moreLessHandler();
                }
            });
        }
        return this.moreLessBtn;
    }

    private void moreLessHandler() {
        if (this.buttonState.equals((Object)ButtonState.More)) {
            this.getMorePanel().setVisible(true);
            this.moreLessBtn.setText(Messages.getStringWithMnemonics("Label.Less"));
            this.buttonState = ButtonState.Less;
            this.pack();
        } else {
            this.getMorePanel().setVisible(false);
            this.moreLessBtn.setText(Messages.getStringWithMnemonics("Label.More"));
            this.buttonState = ButtonState.More;
            this.pack();
        }
    }

    private JPanel getMorePanel() {
        if (this.morePanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints5.ipadx = 0;
            gridBagConstraints5.ipady = 0;
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.anchor = 18;
            gridBagConstraints4.gridx = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(Messages.getString("Label.Details"));
            this.jLabel1.setName(ControlNames.MessageDialogDetailsLabel.toString());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.ipady = 0;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.gridx = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText(Messages.getString("Label.Solution"));
            this.jLabel.setName(ControlNames.MessageDialogSolutionLabel.toString());
            this.morePanel = new JPanel();
            this.morePanel.setLayout(new GridBagLayout());
            this.morePanel.setVisible(false);
            this.morePanel.add((Component)this.jLabel, gridBagConstraints2);
            this.morePanel.add((Component)this.getJScrollPane1(), gridBagConstraints3);
            this.morePanel.add((Component)this.jLabel1, gridBagConstraints4);
            this.morePanel.add((Component)this.getJScrollPane2(), gridBagConstraints5);
        }
        return this.morePanel;
    }

    private JTextArea getSolutionArea() {
        if (this.solutionArea == null) {
            this.solutionArea = new JTextArea();
            this.solutionArea.setEditable(false);
            this.solutionArea.setRows(4);
            this.solutionArea.setLineWrap(true);
            this.solutionArea.setWrapStyleWord(true);
            this.solutionArea.setName(ControlNames.MessageDialogSolutionField.toString());
        }
        return this.solutionArea;
    }

    private JTextArea getDetailsArea() {
        if (this.detailsArea == null) {
            this.detailsArea = new JTextArea();
            this.detailsArea.setEditable(false);
            this.detailsArea.setRows(4);
            this.detailsArea.setLineWrap(true);
            this.detailsArea.setWrapStyleWord(true);
            this.detailsArea.setName(ControlNames.MessageDialogDetailsField.toString());
        }
        return this.detailsArea;
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(GUIConstants.Actions.OK);
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    protected void okHandler() {
        this.setVisible(false);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.jScrollPane.setPreferredSize(new Dimension(372, 67));
            this.jScrollPane.setViewportView(this.getUserMsgArea());
        }
        return this.jScrollPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getSolutionArea());
        }
        return this.jScrollPane1;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getDetailsArea());
        }
        return this.jScrollPane2;
    }

    private JTextArea getUserMsgArea() {
        if (this.userMsgArea == null) {
            this.userMsgArea = new JTextArea();
            this.userMsgArea.setLineWrap(true);
            this.userMsgArea.setEditable(false);
            this.userMsgArea.setWrapStyleWord(true);
            this.userMsgArea.setRows(4);
            this.userMsgArea.setName(ControlNames.MessageDialogUserMessageField.toString());
        }
        return this.userMsgArea;
    }

    private JSeparator getJSeparator() {
        if (this.jSeparator == null) {
            this.jSeparator = new JSeparator();
        }
        return this.jSeparator;
    }

    protected void resetHandler() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ButtonState {
        More,
        Less;

    }
}

