/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicCheckbox;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanel;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanelFactory;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;

public class CryptoTokenDialog
extends CenteredDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JFormattedTextField slotNumberField = null;
    private JComboBox tokenLabelCombo = null;
    private JPasswordField tokenPasswordField = null;
    private JPanel jPanel1 = null;
    private JTextArea jTextArea = null;
    private JCheckBox existingSecondaryCheckbox = null;
    private JCheckBox newSecondaryCheckbox = null;
    private FileNamePanel databaseFileNamePanel = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private FileName databaseName;
    private Constants.DatabaseType type;

    public CryptoTokenDialog(Frame owner, FileName databaseName, Constants.DatabaseType type) {
        super(owner);
        this.databaseName = databaseName;
        this.type = type;
        this.initialize();
    }

    private void initialize() {
        this.setSize(548, 388);
        this.setTitle(Messages.getString("GUI.Title.CryptoToken"));
        this.setName(ControlNames.CryptoTokenDialog.toString());
        this.setResizable(false);
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.getButtonPanel().getOkBtn());
        this.pack();
        this.centerToParent();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridy = 3;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.insets = new Insets(5, 0, 10, 0);
            gridBagConstraints11.gridx = 0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridy = 2;
            gridBagConstraints14.gridwidth = 2;
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.anchor = 17;
            gridBagConstraints14.insets = new Insets(10, 0, 10, 0);
            gridBagConstraints14.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(0, 80, 0, 5);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(10, 80, 10, 5);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints1.gridx = 0;
            this.jLabel1 = new MnemonicLabel();
            this.jLabel1.setText(Messages.getStringWithMnemonics("Label.TokenPassword"));
            this.jLabel1.setName(ControlNames.CryptoTokenDialogTokenPassword.toString());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.gridx = 0;
            this.jLabel = new MnemonicLabel();
            this.jLabel.setText(this.type == Constants.DatabaseType.PKCS11Config ? Messages.getStringWithMnemonics("Label.TokenLabel") : Messages.getStringWithMnemonics("Label.TokenSlotNumber"));
            this.jLabel.setName(ControlNames.CryptoTokenDialogTokenLabel.toString());
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.jLabel1, gridBagConstraints1);
            this.jContentPane.add((Component)this.getTokenPasswordField(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getJPanel1(), gridBagConstraints14);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints11);
            JComponent comp = this.type == Constants.DatabaseType.PKCS11Config ? this.getTokenLabelCombo() : this.getSlotNumberField();
            this.jContentPane.add((Component)comp, gridBagConstraints2);
            this.jLabel.setLabelFor(comp);
            this.jLabel1.setLabelFor(this.getTokenPasswordField());
        }
        return this.jContentPane;
    }

    private JFormattedTextField getSlotNumberField() {
        if (this.slotNumberField == null) {
            NumberFormat format = NumberFormat.getIntegerInstance();
            format.setGroupingUsed(false);
            this.slotNumberField = new JFormattedTextField(format);
        }
        return this.slotNumberField;
    }

    private JComboBox getTokenLabelCombo() {
        if (this.tokenLabelCombo == null) {
            this.tokenLabelCombo = new JComboBox<String>(new Vector<String>(KeymanUtil.getPKCS11TokenList()));
        }
        return this.tokenLabelCombo;
    }

    private JPasswordField getTokenPasswordField() {
        if (this.tokenPasswordField == null) {
            this.tokenPasswordField = new JPasswordField();
        }
        return this.tokenPasswordField;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridy = 3;
            gridBagConstraints7.gridx = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.gridwidth = 3;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(0, 7, 0, 0);
            gridBagConstraints6.gridx = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.gridwidth = 3;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(20, 7, 0, 0);
            gridBagConstraints5.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridwidth = 3;
            gridBagConstraints4.insets = new Insets(20, 10, 0, 10);
            gridBagConstraints4.gridy = 0;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.setBorder(BorderFactory.createBevelBorder(1));
            this.jPanel1.add((Component)this.getJTextArea(), gridBagConstraints4);
            this.jPanel1.add((Component)this.getExistingSecondaryCheckbox(), gridBagConstraints5);
            this.jPanel1.add((Component)this.getNewSecondaryCheckbox(), gridBagConstraints6);
            this.jPanel1.add((Component)this.getDatabaseFileNamePanel(), gridBagConstraints7);
        }
        return this.jPanel1;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setLineWrap(true);
            this.jTextArea.setEnabled(true);
            this.jTextArea.setRows(3);
            this.jTextArea.setEditable(false);
            this.jTextArea.setFont(new Font("Dialog", 0, 10));
            this.jTextArea.setWrapStyleWord(true);
            this.jTextArea.setText(Messages.getString("Message.LimitedTokenCapacity"));
            this.jTextArea.setBackground(this.jPanel1.getBackground());
            this.jTextArea.setName(ControlNames.CryptoTokenDialogLimitedTokenCapacityMessage.toString());
        }
        return this.jTextArea;
    }

    private JCheckBox getExistingSecondaryCheckbox() {
        if (this.existingSecondaryCheckbox == null) {
            this.existingSecondaryCheckbox = new MnemonicCheckbox();
            this.existingSecondaryCheckbox.setText(Messages.getStringWithMnemonics("Label.OpenSecondary"));
            this.existingSecondaryCheckbox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    CryptoTokenDialog.this.checkboxHandler(e);
                }
            });
            this.existingSecondaryCheckbox.setName(ControlNames.CryptoTokenDialogOpenExistingCheckBox.toString());
        }
        return this.existingSecondaryCheckbox;
    }

    private void checkboxHandler(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource().equals(this.newSecondaryCheckbox)) {
                this.existingSecondaryCheckbox.setSelected(false);
                this.databaseFileNamePanel.setMode(GUIConstants.DialogMode.New);
            } else {
                this.newSecondaryCheckbox.setSelected(false);
                this.databaseFileNamePanel.setMode(GUIConstants.DialogMode.Open);
            }
            this.databaseFileNamePanel.setEnabled(true);
        } else {
            this.databaseFileNamePanel.setEnabled(false);
        }
    }

    private JCheckBox getNewSecondaryCheckbox() {
        if (this.newSecondaryCheckbox == null) {
            this.newSecondaryCheckbox = new MnemonicCheckbox();
            this.newSecondaryCheckbox.setText(Messages.getStringWithMnemonics("Label.CreateSecondary"));
            this.newSecondaryCheckbox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    CryptoTokenDialog.this.checkboxHandler(e);
                }
            });
            this.newSecondaryCheckbox.setName(ControlNames.CryptoTokenDialogCreateNewCheckBox.toString());
        }
        return this.newSecondaryCheckbox;
    }

    private FileNamePanel getDatabaseFileNamePanel() {
        if (this.databaseFileNamePanel == null) {
            this.databaseFileNamePanel = FileNamePanelFactory.newPanel(FileNamePanelFactory.PanelType.Database, GUIConstants.DialogMode.New, this.databaseName);
            this.databaseFileNamePanel.setEnabled(false);
            KeymanSettings.Setting setting = KeymanSettings.Setting.DefaultCryptoSecondaryDb;
            if (setting.getString() != null) {
                this.databaseFileNamePanel.setFile(setting.getString());
            }
        }
        return this.databaseFileNamePanel;
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(GUIConstants.Actions.OK, GUIConstants.Actions.Cancel);
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    private boolean isValidInput() {
        if (this.slotNumberField != null && this.slotNumberField.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("Message.CannotLeaveBlank"), Messages.getString("Message.SlotNumber")), Messages.getString("GUI.Title.Validation"), 0);
            return false;
        }
        if (this.tokenPasswordField.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("Message.CannotLeaveBlank"), Messages.getString("Message.TokenPassword")), Messages.getString("GUI.Title.Validation"), 0);
            return false;
        }
        return true;
    }

    protected void okHandler() {
        if (this.isValidInput()) {
            this.databaseFileNamePanel.updateDefaultLocation();
            this.setDialogResult(GUIConstants.DialogResult.OK);
            this.setVisible(false);
        }
    }

    public ParameterMap getParameters() throws KeyManagerException {
        ParameterMap map = new ParameterMap();
        if (this.slotNumberField != null) {
            map.put(Constants.Parameter.RelativeSlotNumber, this.slotNumberField.getText());
        }
        if (this.tokenLabelCombo != null) {
            map.put(Constants.Parameter.TokenLabel, this.tokenLabelCombo.getSelectedItem());
        }
        map.put(Constants.Parameter.Password, new String(this.tokenPasswordField.getPassword()));
        if (this.existingSecondaryCheckbox.isSelected() || this.newSecondaryCheckbox.isSelected()) {
            ParameterMap databaseParams = this.databaseFileNamePanel.getParameters();
            map.put(Constants.Parameter.SecondaryDb, databaseParams.get(Constants.Parameter.DatabaseName));
            map.put(Constants.Parameter.SecondaryDbType, databaseParams.get(Constants.Parameter.Type));
            if (this.existingSecondaryCheckbox.isSelected()) {
                map.put(Constants.Option.ExistingSecondaryDb);
            } else {
                map.put(Constants.Option.NewSecondaryDb);
            }
        }
        return map;
    }

    public static ParameterMap getTokenData(Frame frame, FileName databaseName, Constants.DatabaseType type) throws KeyManagerException, CancelledException {
        CryptoTokenDialog dialog = new CryptoTokenDialog(frame, databaseName, type);
        dialog.setVisible(true);
        try {
            if (dialog.getDialogResult() == GUIConstants.DialogResult.OK) {
                ParameterMap parameterMap = dialog.getParameters();
                return parameterMap;
            }
            throw new CancelledException();
        }
        finally {
            dialog.dispose();
        }
    }

    protected void resetHandler() {
    }
}

