/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.LabelMap;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.controls.ButtonFactory;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChangeLabelsDialog
extends CenteredDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JScrollPane jScrollPane = null;
    private JList labelsList = null;
    private JLabel jLabel2 = null;
    private JTextField newLabelField = null;
    private JButton applyBtn = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private String[] oldLabels;
    private String[] initialLabels = null;
    private ListModel newLabels;

    protected ChangeLabelsDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    protected ChangeLabelsDialog(Frame owner, String[] labels) {
        super(owner);
        this.oldLabels = labels;
        this.initialize();
    }

    public ChangeLabelsDialog(Frame owner, LabelMap initialMap) {
        super(owner);
        this.oldLabels = initialMap.getOldLabels();
        this.initialLabels = initialMap.getNewLabels();
        this.initialize();
    }

    public static LabelMap getLabelMap(Frame owner, String[] labels) throws CancelledException {
        ChangeLabelsDialog dialog = new ChangeLabelsDialog(owner, labels);
        dialog.setVisible(true);
        try {
            if (dialog.getDialogResult() == GUIConstants.DialogResult.OK) {
                LabelMap labelMap = dialog.getLabelMap();
                return labelMap;
            }
            throw new CancelledException();
        }
        finally {
            dialog.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LabelMap getLabelMap(Frame owner, LabelMap initialMap) {
        ChangeLabelsDialog dialog = new ChangeLabelsDialog(owner, initialMap);
        dialog.setVisible(true);
        try {
            if (dialog.getDialogResult() == GUIConstants.DialogResult.OK) {
                LabelMap labelMap = dialog.getLabelMap();
                return labelMap;
            }
            LabelMap labelMap = null;
            return labelMap;
        }
        finally {
            dialog.dispose();
        }
    }

    private LabelMap getLabelMap() {
        LabelMap returnList = new LabelMap();
        for (int i = 0; i < this.newLabels.getSize(); ++i) {
            returnList.add(this.oldLabels[i], this.newLabels.getElementAt(i).toString());
        }
        return returnList;
    }

    private void initialize() {
        this.setSize(662, 394);
        this.setResizable(false);
        this.setModal(true);
        this.setTitle(Messages.getString("GUI.Title.ChangeLabels"));
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.getRootPane().setDefaultButton(this.getApplyBtn());
        this.setName(ControlNames.ChangeLabelsDialog.toString());
        this.centerToParent();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.gridheight = 6;
            gridBagConstraints8.anchor = 11;
            gridBagConstraints8.insets = new Insets(10, 20, 0, 5);
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridy = 5;
            gridBagConstraints5.insets = new Insets(10, 5, 10, 0);
            gridBagConstraints5.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints4.gridy = 4;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints3.gridx = 0;
            this.jLabel2 = new MnemonicLabel();
            this.jLabel2.setText(Messages.getStringWithMnemonics("Label.EnterNewLabel"));
            this.jLabel2.setName(ControlNames.ChangeLabelsDialogEnterNewLabelLabel.toString());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, 5, 5, 0);
            gridBagConstraints1.gridx = 0;
            this.jLabel1 = new MnemonicLabel();
            this.jLabel1.setText(Messages.getStringWithMnemonics("Label.SelectLabel"));
            this.jLabel1.setName(ControlNames.ChangeLabelsDialogSelectLabelLabel.toString());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 5, 10, 0);
            gridBagConstraints.gridx = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText(Messages.getString("Question.ChangeLabels"));
            this.jLabel.setName(ControlNames.ChangeLabelsDialogChangeLabelsQuestion.toString());
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.jLabel1, gridBagConstraints1);
            this.jContentPane.add((Component)this.getJScrollPane(), gridBagConstraints2);
            this.jContentPane.add((Component)this.jLabel2, gridBagConstraints3);
            this.jContentPane.add((Component)this.getNewLabelField(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getApplyBtn(), gridBagConstraints5);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints8);
            this.jLabel1.setLabelFor(this.getLabelsList());
            this.jLabel2.setLabelFor(this.getNewLabelField());
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getLabelsList());
        }
        return this.jScrollPane;
    }

    private JList getLabelsList() {
        if (this.labelsList == null) {
            DefaultListModel<String> model = new DefaultListModel<String>();
            String[] valuesList = this.initialLabels != null ? this.initialLabels : this.oldLabels;
            for (int i = 0; i < valuesList.length; ++i) {
                model.addElement(valuesList[i]);
            }
            this.labelsList = new JList(model);
            this.labelsList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ChangeLabelsDialog.this.listValueChangedHandler();
                }
            });
            this.labelsList.setToolTipText(Messages.getString("Tooltip.ChangeLabelList"));
            this.labelsList.setSelectionMode(0);
            this.labelsList.setName(ControlNames.ChangeLabelsDialogLabelsList.toString());
        }
        return this.labelsList;
    }

    private void listValueChangedHandler() {
        if (this.labelsList.getSelectedValue() != null) {
            this.newLabelField.setText(this.labelsList.getSelectedValue().toString());
            this.newLabelField.setEditable(true);
            this.newLabelField.requestFocusInWindow();
        } else {
            this.newLabelField.setEditable(false);
        }
    }

    private JTextField getNewLabelField() {
        if (this.newLabelField == null) {
            this.newLabelField = new JTextField();
            this.newLabelField.setEditable(false);
            this.newLabelField.setToolTipText(Messages.getString("Tooltip.ChangeLabelText"));
            this.newLabelField.setName(ControlNames.ChangeLabelsDialogNewLabelField.toString());
            this.newLabelField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    ChangeLabelsDialog.this.newLabelFieldChangedHandler();
                }

                public void insertUpdate(DocumentEvent e) {
                    ChangeLabelsDialog.this.newLabelFieldChangedHandler();
                }

                public void removeUpdate(DocumentEvent e) {
                    ChangeLabelsDialog.this.newLabelFieldChangedHandler();
                }
            });
        }
        return this.newLabelField;
    }

    private void newLabelFieldChangedHandler() {
        String selectedValue = this.labelsList.getSelectedValue().toString();
        String newValue = this.newLabelField.getText();
        this.applyBtn.setEnabled(!newValue.trim().equals("") && !newValue.equals(selectedValue));
    }

    private JButton getApplyBtn() {
        if (this.applyBtn == null) {
            this.applyBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.Apply"), ControlNames.ChangeLabelsDialogApplyButton);
            this.applyBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChangeLabelsDialog.this.applyHandler();
                }
            });
            this.applyBtn.setEnabled(false);
        }
        return this.applyBtn;
    }

    private void applyHandler() {
        if (this.newLabelField.getText().length() > 0) {
            int index = this.labelsList.getSelectedIndex();
            DefaultListModel model = (DefaultListModel)this.labelsList.getModel();
            model.set(index, this.newLabelField.getText());
            this.labelsList.repaint();
        } else {
            this.newLabelField.setEditable(false);
        }
        this.applyBtn.setEnabled(false);
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(OKResetCancelButtonPanel.Orientation.Vertical, GUIConstants.Actions.OK, GUIConstants.Actions.Cancel);
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    protected void okHandler() {
        this.applyHandler();
        this.setDialogResult(GUIConstants.DialogResult.OK);
        this.newLabels = this.labelsList.getModel();
        this.setVisible(false);
    }

    protected void resetHandler() {
    }
}

