/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.event.CertificateChangeEvent;
import com.ibm.gsk.ikeyman.event.CertificateChangeListener;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.CertificateDetailsTreeDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.controls.ButtonFactory;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicCheckbox;
import com.ibm.gsk.ikeyman.gui.panels.CertificateDetailsPanel;
import com.ibm.gsk.ikeyman.gui.panels.CertificateRequestDetailsPanel;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.gui.panels.SecretKeyDetailsPanel;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.Defaultable;
import com.ibm.gsk.ikeyman.keystore.ext.Details;
import com.ibm.gsk.ikeyman.keystore.ext.Displayable;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.keystore.ext.Trustable;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.EventListenerList;

public class CertificateDetailsDialog
extends CenteredDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JLabel nameLbl = null;
    private JSeparator jSeparator = null;
    private JSeparator jSeparator1 = null;
    private JButton detailsBtn = null;
    private JCheckBox defaultCertCheckbox = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private JPanel detailsPanel = null;
    private Displayable displayable = null;
    private JCheckBox trustedCertCheckbox = null;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean allowModifications;
    private KeymanTree detailedTree;

    public void addCertificateChangeListener(CertificateChangeListener listener) {
        this.listenerList.add(CertificateChangeListener.class, listener);
    }

    public void removeCertificateChangeListener(CertificateChangeListener listener) {
        this.listenerList.remove(CertificateChangeListener.class, listener);
    }

    protected void fireCertificateChanged(String label, CertificateChangeEvent.ChangeType type, boolean value) {
        CertificateChangeListener[] listeners;
        for (CertificateChangeListener listener : listeners = (CertificateChangeListener[])this.listenerList.getListeners(CertificateChangeListener.class)) {
            listener.certificateChanged(new CertificateChangeEvent(this, label, type, value));
        }
    }

    protected CertificateDetailsDialog(Frame owner) throws KeyManagerException {
        super(owner);
        this.initialize();
    }

    public CertificateDetailsDialog(Frame owner, Displayable displayable, boolean allowModifications) throws KeyManagerException {
        super(owner);
        this.displayable = displayable;
        this.allowModifications = allowModifications;
        try {
            this.detailedTree = displayable.toTree();
        }
        catch (KeyManagerException e) {
            this.detailedTree = null;
        }
        this.initialize();
    }

    private void initialize() throws KeyManagerException {
        this.setSize(546, 614);
        this.setModal(true);
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.setTitle(MessageFormat.format(Messages.getString("GUI.Title.CertInfo"), this.displayable.get(Details.DetailIdentifier.Label)));
        this.pack();
        this.setName(ControlNames.CertificateDetailsDialog.toString());
        this.getDetailsBtn().requestFocusInWindow();
        this.centerToParent();
    }

    private JPanel getJContentPane() throws KeyManagerException {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 6;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridx = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridy = 7;
            gridBagConstraints9.insets = new Insets(10, 0, 10, 0);
            gridBagConstraints9.gridx = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints5.gridy = 4;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(5, 0, 10, 0);
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 3;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridy = 5;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints8.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(10, 0, 10, 0);
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJPanel(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getJSeparator(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJSeparator1(), gridBagConstraints5);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints9);
            this.jContentPane.add((Component)this.getDetailsPanel(), gridBagConstraints7);
            if (this.allowModifications) {
                if (this.displayable instanceof Trustable) {
                    this.jContentPane.add((Component)this.getTrustedCertCheckbox(), gridBagConstraints3);
                } else if (this.displayable instanceof Defaultable) {
                    this.jContentPane.add((Component)this.getDefaultCertCheckbox(), gridBagConstraints8);
                }
            }
            if (this.detailedTree != null) {
                this.jContentPane.add((Component)this.getDetailsBtn(), gridBagConstraints6);
            }
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() throws KeyManagerException {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridx = 0;
            this.nameLbl = new JLabel();
            this.nameLbl.setText(this.displayable.get(Details.DetailIdentifier.Label));
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createBevelBorder(1)));
            this.jPanel.add((Component)this.nameLbl, gridBagConstraints);
        }
        return this.jPanel;
    }

    private JSeparator getJSeparator() {
        if (this.jSeparator == null) {
            this.jSeparator = new JSeparator();
        }
        return this.jSeparator;
    }

    private JSeparator getJSeparator1() {
        if (this.jSeparator1 == null) {
            this.jSeparator1 = new JSeparator();
        }
        return this.jSeparator1;
    }

    private JButton getDetailsBtn() {
        if (this.detailsBtn == null) {
            this.detailsBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.ViewDetails"), ControlNames.CertificateDetailsDialogViewDetailsButton);
            this.detailsBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CertificateDetailsDialog.this.detailsHandler();
                }
            });
        }
        return this.detailsBtn;
    }

    private void detailsHandler() {
        CertificateDetailsTreeDialog dialog = new CertificateDetailsTreeDialog((Frame)this.getOwner(), this.displayable, this.detailedTree);
        dialog.setVisible(true);
        dialog.dispose();
    }

    private JCheckBox getDefaultCertCheckbox() {
        if (this.defaultCertCheckbox == null) {
            this.defaultCertCheckbox = new MnemonicCheckbox();
            this.defaultCertCheckbox.setText(Messages.getStringWithMnemonics("Label.SetDefaultCert"));
            this.defaultCertCheckbox.setName(ControlNames.CertificateDetailsDialogDefaultCertCheckbox.toString());
            if (this.displayable instanceof Defaultable) {
                this.defaultCertCheckbox.setSelected(((Defaultable)((Object)this.displayable)).isDefault());
            }
            if (this.defaultCertCheckbox.isSelected()) {
                this.defaultCertCheckbox.setEnabled(false);
            }
        }
        return this.defaultCertCheckbox;
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(GUIConstants.Actions.OK);
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    protected void okHandler() {
        this.setVisible(false);
        if (this.allowModifications) {
            Defaultable def;
            if (this.displayable instanceof Trustable) {
                Trustable trusted = (Trustable)((Object)this.displayable);
                if (trusted.isTrusted() != this.getTrustedCertCheckbox().isSelected()) {
                    this.fireCertificateChanged(this.displayable.getLabel(), CertificateChangeEvent.ChangeType.TRUST_STATUS, this.getTrustedCertCheckbox().isSelected());
                }
            } else if (this.displayable instanceof Defaultable && (def = (Defaultable)((Object)this.displayable)).isDefault() != this.getDefaultCertCheckbox().isSelected()) {
                this.fireCertificateChanged(this.displayable.getLabel(), CertificateChangeEvent.ChangeType.DEFAULT_STATUS, this.getDefaultCertCheckbox().isSelected());
            }
        }
    }

    private JPanel getDetailsPanel() throws KeyManagerException {
        if (this.displayable == null) {
            throw new RuntimeException("keystoreEntry must be non-null.");
        }
        if (this.displayable instanceof CertificateItem) {
            if (this.detailsPanel == null) {
                this.detailsPanel = new CertificateDetailsPanel(this.displayable);
            }
            return this.detailsPanel;
        }
        if (this.displayable instanceof CertificateRequestItem) {
            if (this.detailsPanel == null) {
                this.detailsPanel = new CertificateRequestDetailsPanel(this.displayable);
            }
            return this.detailsPanel;
        }
        if (this.displayable instanceof SecretKeyItem) {
            if (this.detailsPanel == null) {
                this.detailsPanel = new SecretKeyDetailsPanel(this.displayable);
            }
            return this.detailsPanel;
        }
        throw new RuntimeException("keystoreEntry has incorrect type.");
    }

    private JCheckBox getTrustedCertCheckbox() {
        if (this.trustedCertCheckbox == null) {
            this.trustedCertCheckbox = new MnemonicCheckbox();
            this.trustedCertCheckbox.setText(Messages.getStringWithMnemonics("Label.SetTrustedCert"));
            if (this.displayable instanceof Trustable) {
                this.trustedCertCheckbox.setSelected(((Trustable)((Object)this.displayable)).isTrusted());
            }
            this.trustedCertCheckbox.setName(ControlNames.CertificateDetailsDialogTrustedCertCheckbox.toString());
        }
        return this.trustedCertCheckbox;
    }

    protected void resetHandler() {
    }
}

