/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.error;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KeyManagerException
extends Exception {
    private List<String> details;
    private boolean handled = false;
    private ExceptionReason reason;

    public KeyManagerException(ExceptionReason reason) {
        this.reason = reason;
        this.details = new ArrayList<String>();
    }

    public KeyManagerException(ExceptionReason reason, String ... details) {
        this.reason = reason;
        this.details = new ArrayList<String>(Arrays.asList(details));
    }

    public KeyManagerException(ExceptionReason reason, Throwable cause) {
        super(cause);
        this.reason = reason;
        this.details = new ArrayList<String>();
    }

    public KeyManagerException(ExceptionReason reason, Throwable cause, String ... details) {
        super(cause);
        this.reason = reason;
        this.details = new ArrayList<String>(Arrays.asList(details));
    }

    public void addDetail(String detail) {
        this.details.add(detail);
    }

    public String getCustomMessage() {
        return this.reason.toString();
    }

    public String[] getDetails() {
        return this.details.toArray(new String[0]);
    }

    public ExceptionReason getReason() {
        return this.reason;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void setHandled(boolean b) {
        this.handled = b;
    }

    public String toString() {
        return super.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExceptionReason {
        BLANK_PKCS12_CREATION_ERROR(UserMessage.BlankPKCS12CreationError, Solution.ClearSolution, 1),
        BLANK_PKCS12_STORE_ERROR(UserMessage.BlankPKCS12StoreError, Solution.ClearSolution, 2),
        CANNOT_CONVERT_PKCS11(UserMessage.CannotConvertPKCS11, Solution.ClearSolution, 3),
        CANNOT_INSTANTIATE_OBJECT(UserMessage.CannotInstantiateObject, Solution.ClearSolution, 4),
        CANNOT_MODIFY_PERSONAL_CERT_TRUST(UserMessage.CannotModifyPersonalCertTrust, Solution.OnlyApplicableToSignerCerts, 5),
        CERT_REQUEST_FILE_CORRUPTED(UserMessage.CertRequestFileCorrupted, Solution.ClearSolution, 6),
        CERTIFICATE_CREATE_ERROR(UserMessage.CertificateCreateError, Solution.ClearSolution, 7),
        CERTIFICATE_ENCODING_ERROR(UserMessage.CertificateEncodingError, Solution.ClearSolution, 8),
        CERTIFICATE_ERROR(UserMessage.CertificateError, Solution.ClearSolution, 9),
        CERTIFICATE_LOAD_ERROR(UserMessage.ErrorLoadingCertificate, Solution.ClearSolution, 10),
        CERTIFICATE_PARSING_ERROR(UserMessage.InvalidCertificateDetails, Solution.ClearSolution, 11),
        CERTIFICATE_REQUEST_DECODING_ERROR(UserMessage.CertificateRequestDecodingError, Solution.ClearSolution, 12),
        CERTIFICATE_REQUEST_FILE_NOT_FOUND(UserMessage.CertRequestFileNotFound, Solution.CheckFileExistsAndReadPermissions, 13),
        CERTIFICATE_STORE_ERROR(UserMessage.CertificateStoreError, Solution.ClearSolution, 14),
        CLASS_NOT_FOUND(UserMessage.ClassNotFound, Solution.CheckClassPathAndName, 15),
        CORRUPT_CERTIFICATE(UserMessage.CorruptCertificate, Solution.ReissueCertificate, 16),
        DATABASE_LOCKED(UserMessage.DatabaseLocked, Solution.ClearSolution, 17),
        DATABASE_PASSWORD_EXPIRED(UserMessage.DatabasePasswordExpired, Solution.ResetPassword, 18),
        DELETION_FAILED(UserMessage.DeletionFailed, Solution.ClearSolution, 19),
        DER_ENCODING_ERROR(UserMessage.InvalidDerEncoding, Solution.ClearSolution, 20),
        ENTRY_EXISTS_FOR_KEY(UserMessage.EntryExistsForKey, Solution.CannotAddDuplicateKey, 21),
        ENTRY_EXISTS_FOR_LABEL(UserMessage.EntryExistsForLabel, Solution.ChooseDifferentLabel, 22),
        ENTRY_LOAD_ERROR(UserMessage.ErrorLoadingEntry, Solution.ClearSolution, 23),
        FILE_DELETION_FAILED(UserMessage.FileDeletionFailed, Solution.CheckFilePermissions, 24),
        INPUT_FILE_NOT_FOUND(UserMessage.FileNotFound, Solution.CheckDatabasePath, 25),
        INPUT_STREAM_CLOSE_ERROR(UserMessage.IOErrorCloseStream, Solution.CheckDriveAndFile, 26),
        INVALID_ACTION(UserMessage.InvalidAction, Solution.CommandUsage, 27),
        INVALID_ALGORITHM_PARAMETER(UserMessage.InvalidAlgorithmParameter, Solution.ClearSolution, 28),
        INVALID_ALGORITHM_PARAMETERS(UserMessage.InvalidAlgorithmParameters, Solution.ClearSolution, 29),
        INVALID_ALIAS_RANGE_FORMAT(UserMessage.InvalidAliasRangeFormat, Solution.ClearSolution, 30),
        INVALID_CERTIFICATE_FILE(UserMessage.InvalidCertificateFile, Solution.ClearSolution, 31),
        INVALID_CERTIFICATE_VERSION(UserMessage.InvalidVersion, Solution.UnsupportedFeature, 32),
        INVALID_DATABASE_TYPE(UserMessage.InvalidDatabaseType, Solution.ChangeDatabaseType, 33),
        INVALID_DATABASE_TYPE_FOR_PARAMETER(UserMessage.InvalidDatabaseTypeForParameter, Solution.OnlyApplicableToCMS, 34),
        INVALID_DN(UserMessage.InvalidDN, Solution.ValidDN, 35),
        INVALID_KEY_FOR_SIGNING(UserMessage.InvalidKeyForSigning, Solution.ClearSolution, 36),
        INVALID_KEY_SIZE(UserMessage.InvalidKeySize, Solution.ParameterMustBeNumeric, 37),
        INVALID_KEY_SIZE_FOR_ALGORITHM(UserMessage.InvalidKeySizeForAlgorithm, Solution.ClearSolution, 38),
        INVALID_KEY_TYPE_FOR_KEYSTORE(UserMessage.InvalidKeyTypeForKeyStore, Solution.ChangePrivateKeyType, 39),
        INVALID_LIST_FILTER(UserMessage.InvalidListFilter, Solution.ValidListFilters, 40),
        INVALID_NUMBER_FORMAT(UserMessage.InvalidParameter, Solution.ParameterMustBeNumeric, 41),
        INVALID_OBJECT(UserMessage.InvalidObject, Solution.ProgramUsage, 42),
        INVALID_OPTIONAL_PARAMETER(UserMessage.InvalidOptionalParameter, Solution.CorrectCommandUsage, 43),
        INVALID_OUTPUT_MODE(UserMessage.InvalidOutputMode, Solution.ValidOutputModes, 44),
        INVALID_PARAMETER_FOR_COMMAND(UserMessage.InvalidParameterForCommand, Solution.CorrectCommandUsage, 45),
        INVALID_PASSWORD(UserMessage.InvalidPassword, Solution.CheckDatabaseType, 46),
        INVALID_PFX_OPTION(UserMessage.InvalidPfxOption, Solution.EnsureIsP12File, 47),
        INVALID_PIN(UserMessage.InvalidPin, Solution.CheckPin, 48),
        INVALID_REQUEST_FILE(UserMessage.RequestDatabaseCorrupted, Solution.EnsureKeyStoreValidAndType, 49),
        INVALID_SAN(UserMessage.InvalidSan, Solution.CheckSan, 50),
        INVALID_SAN_IN_CERT(UserMessage.InvalidSanInCert, Solution.ClearSolution, 51),
        INVALID_SIGNATURE_ALGORITHM(UserMessage.InvalidSignatureType, Solution.ChangeSignatureType, 52),
        INVALID_SIGNING_KEY_TYPE(UserMessage.InvalidSignigKeyType, Solution.ClearSolution, 53),
        INVALID_SLOT_NUMBER(UserMessage.InvalidSlotNumber, Solution.CheckSlotNumber, 54),
        INVALID_TYPE_FOR_ACTION(UserMessage.InvalidDatabaseTypeForAction, Solution.ClearSolution, 55),
        INVALID_VALUE_FOR_PARAMETER(UserMessage.InvalidValueForParameter, Solution.PermittedValues, 56),
        IO_ERROR(UserMessage.IOException, Solution.ClearSolution, 57),
        IO_ERROR_MSG(UserMessage.IOExceptionMsg, Solution.ClearSolution, 58),
        KEY_DECRYPTION_ERROR(UserMessage.KeyDecryptionError, Solution.CheckKey, 59),
        KEY_ENCRYPTION_ERROR(UserMessage.KeyEncryptionError, Solution.CheckKey, 60),
        KEY_FILE_NOT_FOUND(UserMessage.KeyFileNotFound, Solution.CheckFileExistsAndReadPermissions, 61),
        KEY_STORE_ENTRY_SET_ERROR(UserMessage.KeyStoreEntrySetError, Solution.ClearSolution, 62),
        KEY_STORE_INSTANTIATION_ERROR(UserMessage.KeyStoreInstantiationError, Solution.ClearSolution, 63),
        KEY_STORE_LOAD_ERROR(UserMessage.CannotLoadKeystore, Solution.EnsureKeyStoreValidAndType, 64),
        KEY_STORE_TYPE_NOT_FOUND(UserMessage.KeyStoreTypeNotFound, Solution.EnsureProviderInstalled, 65),
        KEYSTORE_CLOSE_ERROR(UserMessage.KeyStoreCloseError, Solution.ClearSolution, 66),
        MISSING_ACTION(UserMessage.ActionMustBeSpecified, Solution.CommandUsage, 67),
        MISSING_VALUE_FOR_PARAMETER(UserMessage.NoValueForParameter, Solution.IncludeValueForParameter, 68),
        NO_CA_CERT_FOR_LABEL(UserMessage.NoCACertForLabel, Solution.UseCommandToListValidLabels, 69),
        NO_CERTIFICATE_FOR_LABEL(UserMessage.NoCertificateForLabel, Solution.CheckLabel, 70),
        NO_CRYPTO_MODULE_SPECIFIED(UserMessage.NoCryptoModuleSpecified, Solution.SetCryptoModule, 71),
        NO_DEFAULT_CERTIFICATE(UserMessage.NoDefaultCertificate, Solution.ClearSolution, 72),
        NO_DN_OR_SAN(UserMessage.NoDnOrSan, Solution.ProvideAtLeastOneValue, 73),
        NO_ENTRY_FOR_KEY(UserMessage.NoEntryForKey, Solution.CheckKeyStore, 74),
        NO_ENTRY_FOR_LABEL(UserMessage.NoEntryForLabel, Solution.CheckLabel, 75),
        NO_JCE_PROVIDER(UserMessage.NoJCEProvider, Solution.AddJCEProvider, 76),
        NO_KEY_FOR_LABEL(UserMessage.NoKeyForLabel, Solution.CheckLabel, 77),
        NO_OPTIONS_SPECIFIED(UserMessage.NoOptionsSpecified, Solution.ProgramUsage, 78),
        NO_READ_PERMISSION(UserMessage.NoReadPermissionsForFile, Solution.CheckDatabasePathAndPermissions, 79),
        NO_REQUEST_FOR_CERTIFICATE(UserMessage.NoRequestForCertificate, Solution.CheckKeyStore, 80),
        NO_REQUEST_FOR_LABEL(UserMessage.NoRequestForLabel, Solution.CheckLabel, 81),
        NO_SUCH_ALGORITHM(UserMessage.NoSuchAlgorithm, Solution.EnsureProviderInstalled, 82),
        NO_WRITE_PERMISSION(UserMessage.NoWritePermissionsForFile, Solution.CheckDatabasePathAndPermissions, 83),
        NOT_A_PROVIDER(UserMessage.NotAProvider, Solution.CheckClassName, 84),
        OUTPUT_FILE_CREATION_ERROR(UserMessage.OutputFileNotCreated, Solution.CheckDatabasePathAndPermissions, 85),
        OUTPUT_FILE_EXISTS(UserMessage.OutputFileExists, Solution.ChooseDifferentName, 86),
        OUTPUT_STREAM_CLOSE_ERROR(UserMessage.OutputStreamCloseError, Solution.ClearSolution, 87),
        OUTPUT_STREAM_WRITE_ERROR(UserMessage.OutputStreamWriteError, Solution.ClearSolution, 88),
        PASSWORD_CANNOT_BE_NULL(UserMessage.PasswordCannotBeNull, Solution.EnterPassword, 89),
        PKCS11_ERROR(UserMessage.PKCS11Error, Solution.ClearSolution, 90),
        PKCS11_EXCEPTION(UserMessage.PKCS11Exception, Solution.ClearSolution, 91),
        PKCS7_PARSING_ERROR(UserMessage.PKCS7ParsingError, Solution.ClearSolution, 92),
        PRIVATE_KEY_DECRYPTION_ERROR(UserMessage.CorruptPrivateKey, Solution.ClearSolution, 93),
        PRIVATE_KEY_ENCODING_ERROR(UserMessage.PrivateKeyEncodingError, Solution.ClearSolution, 94),
        PRIVATE_KEY_ENCRYPTION_ERROR(UserMessage.PrivateKeyEncryptionError, Solution.ClearSolution, 95),
        PROVIDER_ALREADY_INSTALLED(UserMessage.ProviderAlreadyInstalled, Solution.CheckClassName, 96),
        PUBLIC_KEY_COPY_ERROR(UserMessage.PublicKeyCopyError, Solution.ClearSolution, 97),
        RDB_PASSWORD_CHANGE_ERROR(UserMessage.RdbPasswordChangeError, Solution.ClearSolution, 98),
        REQUEST_SIGNING_ERROR(UserMessage.RequestSigningError, Solution.ClearSolution, 99),
        REQUIRED_DN_NOT_SPECIFIED(UserMessage.DeviceError, Solution.RequiredDnNotSpecified, 100),
        REQUIRED_VALUE_NOT_SPECIFIED(UserMessage.RequiredValueNotSpecified, Solution.CorrectCommandUsage, 101),
        RESTRICTED_POLICY_FILES(UserMessage.RestrictedPolicyFiles, Solution.ReplacePolicyFiles, 102),
        SAN_ENCODING_ERROR(UserMessage.SanEncodingError, Solution.ClearSolution, 103),
        SAN_SUPPORT_NOT_ENABLED(UserMessage.SanSupportNotEnabled, Solution.CheckPropertiesFile, 104),
        SIGNATURE_ERROR(UserMessage.SignatureError, Solution.ClearSolution, 105),
        SOURCE_DB_IS_EMPTY(UserMessage.SourceDbIsEmpty, Solution.CheckDatabasePath, 106),
        TOO_MANY_CHOICES_SELECTED(UserMessage.TooManyChoicesSelected, Solution.CorrectCommandUsage, 107),
        TOO_MANY_PARAMETERS_FOR_TAG(UserMessage.TooManyParametersForTag, Solution.MaximumAllowedOccurrences, 108),
        TOO_MANY_VALUES_FOR_TAG(UserMessage.TooManyValuesForTag, Solution.RemoveExcessParameter, 109),
        UNKNOWN_PARAMETER(UserMessage.UnknownParameter, Solution.CorrectCommandUsage, 110),
        UNRECOVERABLE_ENTRY(UserMessage.UnrecoverableEntry, Solution.ClearSolution, 111),
        UNRECOVERABLE_KEY(UserMessage.UnrecoverableKey, Solution.ClearSolution, 112),
        ILLEGAL_ARGUMENT(UserMessage.InternalException, Solution.ContactSupport, 1000),
        INVALID_ARGUMENT(UserMessage.InternalException, Solution.ContactSupport, 1001),
        INVALID_CERTIFICATE_TYPE(UserMessage.InternalException, Solution.ContactSupport, 1002),
        INVALID_DATABASE_DESCRIPTOR(UserMessage.InternalException, Solution.ContactSupport, 1003),
        INVALID_DEFAULT_CHANGE(UserMessage.InternalException, Solution.ContactSupport, 1004),
        INVALID_ENTRY_TYPE(UserMessage.InternalException, Solution.ContactSupport, 1005),
        INVALID_EXTRACTION_INVOKATION(UserMessage.InternalException, Solution.ContactSupport, 1006),
        INVALID_KEY_ITEM_TYPE(UserMessage.InternalException, Solution.ContactSupport, 1007),
        INVALID_KEY_TYPE(UserMessage.InternalException, Solution.ContactSupport, 1008),
        INVALID_OPERATION(UserMessage.InternalException, Solution.ContactSupport, 1009),
        INVALID_PARAMETER_SPEC(UserMessage.InternalException, Solution.ContactSupport, 1010),
        MISSING_PARAMETER(UserMessage.InternalException, Solution.ContactSupport, 1011),
        NO_SOURCE_DATABASE_SPECIFIED(UserMessage.InternalException, Solution.ContactSupport, 1012),
        NO_SUCH_PROVIDER(UserMessage.InternalException, Solution.ContactSupport, 1013),
        NO_SUITABLE_PARSER(UserMessage.InternalException, Solution.ContactSupport, 1014),
        NO_TARGET_DATABASE_SPECIFIED(UserMessage.InternalException, Solution.ContactSupport, 1015),
        NULL_PARAMETER(UserMessage.InternalException, Solution.ContactSupport, 1016),
        NULL_POINTER(UserMessage.InternalException, Solution.ContactSupport, 1017),
        OBJECT_CONSTRUCTION_ERROR(UserMessage.InternalException, Solution.ContactSupport, 1018),
        OBJECT_INSTANTIATION_ERROR(UserMessage.InternalException, Solution.ContactSupport, 1019),
        OPERATION_NOT_SUPPORTED(UserMessage.InternalException, Solution.ContactSupport, 1020),
        RDB_UNINITIALISED(UserMessage.InternalException, Solution.ContactSupport, 1021),
        UNEXPECTED_CANCELLATION(UserMessage.InternalException, Solution.ContactSupport, 1022),
        UNINITIALISED_KEY_STORE(UserMessage.InternalException, Solution.ContactSupport, 1023),
        UNSUPPORTED_CALLBACK(UserMessage.InternalException, Solution.ContactSupport, 1024),
        UNSUPPORTED_ENCODING(UserMessage.InternalException, Solution.ContactSupport, 1025);

        private Solution solution;
        private UserMessage userMessage;
        private int errorCode;

        private ExceptionReason(UserMessage message, Solution solution, int errorCode) {
            this.userMessage = message;
            this.solution = solution;
            this.errorCode = errorCode;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public Solution getSolution() {
            return this.solution;
        }

        public UserMessage getUserMessage() {
            return this.userMessage;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum UserMessage {
            ActionMustBeSpecified,
            BlankPKCS12CreationError,
            BlankPKCS12StoreError,
            CannotConvertPKCS11,
            CannotInstantiateObject,
            CannotLoadKeystore,
            CannotModifyPersonalCertTrust,
            CertificateCreateError,
            CertificateEncodingError,
            CertificateError,
            CertificateRequestDecodingError,
            CertificateStoreError,
            CertRequestFileCorrupted,
            CertRequestFileNotFound,
            ClassNotFound,
            CorruptCertificate,
            CorruptPrivateKey,
            DatabaseLocked,
            DatabasePasswordExpired,
            DeletionFailed,
            DeviceError,
            EntryExistsForKey,
            EntryExistsForLabel,
            ErrorLoadingCertificate,
            ErrorLoadingEntry,
            FileDeletionFailed,
            FileNotFound,
            InternalException,
            InvalidAction,
            InvalidAlgorithmParameter,
            InvalidAlgorithmParameters,
            InvalidAliasRangeFormat,
            InvalidCertificateDetails,
            InvalidCertificateFile,
            InvalidDatabaseType,
            InvalidDatabaseTypeForAction,
            InvalidDatabaseTypeForParameter,
            InvalidDerEncoding,
            InvalidDN,
            InvalidKeyForSigning,
            InvalidKeySize,
            InvalidKeySizeForAlgorithm,
            InvalidKeyTypeForKeyStore,
            InvalidListFilter,
            InvalidObject,
            InvalidOptionalParameter,
            InvalidOutputMode,
            InvalidParameter,
            InvalidParameterForCommand,
            InvalidPassword,
            InvalidPfxOption,
            InvalidPin,
            InvalidSan,
            InvalidSanInCert,
            InvalidSignatureType,
            InvalidSignigKeyType,
            InvalidSlotNumber,
            InvalidValueForParameter,
            InvalidVersion,
            IOErrorCloseStream,
            IOException,
            IOExceptionMsg,
            KeyDecryptionError,
            KeyEncryptionError,
            KeyFileNotFound,
            KeyStoreCloseError,
            KeyStoreEntrySetError,
            KeyStoreInstantiationError,
            KeyStoreTypeNotFound,
            NoCACertForLabel,
            NoCertificateForLabel,
            NoCryptoModuleSpecified,
            NoDefaultCertificate,
            NoDnOrSan,
            NoEntryForKey,
            NoEntryForLabel,
            NoJCEProvider,
            NoKeyForLabel,
            NoOptionsSpecified,
            NoReadPermissionsForFile,
            NoRequestForCertificate,
            NoRequestForLabel,
            NoSuchAlgorithm,
            NotAProvider,
            NoValueForParameter,
            NoWritePermissionsForFile,
            OutputFileExists,
            OutputFileNotCreated,
            OutputStreamCloseError,
            OutputStreamWriteError,
            PasswordCannotBeNull,
            PKCS11Error,
            PKCS11Exception,
            PKCS7ParsingError,
            PrivateKeyEncodingError,
            PrivateKeyEncryptionError,
            ProviderAlreadyInstalled,
            PublicKeyCopyError,
            RdbPasswordChangeError,
            RequestDatabaseCorrupted,
            RequestSigningError,
            RequiredValueNotSpecified,
            RestrictedPolicyFiles,
            SanEncodingError,
            SanSupportNotEnabled,
            SignatureError,
            SourceDbIsEmpty,
            TooManyChoicesSelected,
            TooManyParametersForTag,
            TooManyValuesForTag,
            UnknownParameter,
            UnrecoverableEntry,
            UnrecoverableKey;

            public static final String KEY_PREFIX = "ExceptionInfo.UserMsg.";

            public String toString() {
                return KEY_PREFIX + super.toString();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Solution {
            AddJCEProvider,
            CannotAddDuplicateKey,
            ChangeDatabaseType,
            ChangePrivateKeyType,
            ChangeSignatureType,
            CheckClassName,
            CheckClassPathAndName,
            CheckDatabasePath,
            CheckDatabasePathAndPermissions,
            CheckDatabaseType,
            CheckDriveAndFile,
            CheckFileExistsAndReadPermissions,
            CheckFilePermissions,
            CheckKey,
            CheckKeyStore,
            CheckLabel,
            CheckPin,
            CheckPropertiesFile,
            CheckSan,
            CheckSlotNumber,
            ChooseDifferentLabel,
            ChooseDifferentName,
            ClearSolution,
            CommandUsage,
            ContactSupport,
            CorrectCommandUsage,
            EnsureIsP12File,
            EnsureKeyStoreValidAndType,
            EnsureProviderInstalled,
            EnterPassword,
            IncludeValueForParameter,
            MaximumAllowedOccurrences,
            OnlyApplicableToCMS,
            OnlyApplicableToSignerCerts,
            ParameterMustBeNumeric,
            PermittedValues,
            ProgramUsage,
            ProvideAtLeastOneValue,
            ReissueCertificate,
            RemoveExcessParameter,
            ReplacePolicyFiles,
            RequiredDnNotSpecified,
            ResetPassword,
            SetCryptoModule,
            UnsupportedFeature,
            UseCommandToListValidLabels,
            ValidDN,
            ValidListFilters,
            ValidOutputModes;

            public static final String KEY_PREFIX = "ExceptionInfo.Solution.";

            public String toString() {
                return KEY_PREFIX + super.toString();
            }
        }
    }
}

