/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command.gui;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory;
import com.ibm.gsk.ikeyman.command.KeyStoreLoaderFactory;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.gui.KeymanView;
import com.ibm.gsk.ikeyman.command.gui.RetrieverFactory;
import com.ibm.gsk.ikeyman.command.password.PasswordCallbackHandlerFactory;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.ExceptionInfo;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.NotImplementedException;
import com.ibm.gsk.ikeyman.event.CertificateChangeEvent;
import com.ibm.gsk.ikeyman.event.CertificateChangeListener;
import com.ibm.gsk.ikeyman.event.KeyManagerEvent;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.event.ProviderEvent;
import com.ibm.gsk.ikeyman.io.Logger;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.Debug;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class KeymanController
implements ActionListener,
CertificateChangeListener,
KeyManagerEventListener {
    private KeymanView view;
    private Frame parentFrame;

    public KeymanController(KeymanView view, Frame parentFrame) {
        this.view = view;
        this.parentFrame = parentFrame;
        CommandFactory.setCallbackHandler(PasswordCallbackHandlerFactory.getGUIHandler(parentFrame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        Debug.entering(e);
        this.view.setWaitStatus(true);
        try {
            Constants.CommandType commandType;
            try {
                commandType = Constants.CommandType.valueOf(e.getActionCommand());
                Debug.log("command type: {0}", commandType);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ParameterMap map = new ParameterMap();
            KeyManagerException lastException = null;
            while (true) {
                try {
                    if (lastException != null && !lastException.isHandled()) {
                        Logger.showError(lastException);
                        lastException.setHandled(true);
                    }
                    this.getParameters(commandType, map, lastException);
                    Debug.log("map: {0}", map);
                    Invoker.invoke(map, this, this.view);
                    Debug.log("after invoke", new Object[0]);
                }
                catch (InternalKeyManagerException e1) {
                    Debug.log("InternalKeyManagerException: {0}", e1);
                }
                catch (NotImplementedException e1) {
                    Debug.log("NotImplementedException: {0}", e1);
                }
                catch (CancelledException e1) {
                    Debug.log("CancelledException: {0}", e1);
                }
                catch (KeyManagerException e1) {
                    Debug.log("KeyManagerException: {0}", e1);
                    lastException = e1;
                    continue;
                }
                break;
            }
        }
        catch (Exception e1) {
            Logger.showError(e1);
        }
        catch (Error e1) {
            Logger.showError(e1);
        }
        finally {
            this.view.setWaitStatus(false);
        }
        Debug.exiting();
    }

    private void getParameters(Constants.CommandType type, ParameterMap map, KeyManagerException lastException) throws CancelledException, KeyManagerException {
        if (lastException == null) {
            this.getParameters(type, map);
        } else {
            this.getParametersAfterError(type, map, lastException);
        }
    }

    private void getParameters(Constants.CommandType type, ParameterMap map) throws KeyManagerException, CancelledException {
        Debug.entering(type, map);
        RetrieverFactory.get(type).getParameters(this.view, this.parentFrame, map);
        if (map.getCommandType() == null) {
            Debug.log("adding type: {0}", type);
            map.put(type);
        }
        Debug.exiting();
    }

    private void getParametersAfterError(Constants.CommandType commandType, ParameterMap map, KeyManagerException lastException) throws KeyManagerException, CancelledException {
        Debug.entering(commandType, map, lastException);
        RetrieverFactory.get(commandType).getParametersAfterError(this.view, this.parentFrame, map, lastException);
        if (map.getCommandType() == null) {
            Debug.log("adding type: {0}", commandType);
            map.put(commandType);
        }
        Debug.exiting();
    }

    public void certificateChanged(CertificateChangeEvent e) {
        block7: {
            Debug.entering(e);
            ParameterMap map = new ParameterMap();
            try {
                map.putAll(this.view.getSelectedDatabase().getDatabaseParameters(false));
                map.put(Constants.Parameter.Label, e.getLabel());
                switch (e.getType()) {
                    case DEFAULT_STATUS: {
                        if (!e.getValue()) {
                            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_DEFAULT_CHANGE, e.getValue() + "");
                        }
                        map.put(Constants.CommandType.SetDefaultCert);
                        break;
                    }
                    case TRUST_STATUS: {
                        map.put(Constants.Parameter.Trust, e.getValue());
                        map.put(Constants.CommandType.ModifyCert);
                    }
                }
                Debug.log("map: {0}", map);
                Invoker.invoke(map, this, this.view);
                Debug.log("after invoke", new Object[0]);
            }
            catch (KeyManagerException e1) {
                Debug.log("key manager exception: {0}", e1);
                if (e1.isHandled()) break block7;
                this.view.showStatusMessage(new ExceptionInfo(e1).getUserMessage());
                Logger.showError(e1);
            }
        }
        Debug.exiting();
    }

    public void databaseChanged(KeyManagerEvent e) {
        Debug.entering(e);
        this.updateView(e.getKeyStoreInfo(), KeymanView.UpdateType.Changed);
        Debug.exiting();
    }

    public void databaseClosed(KeyManagerEvent e) {
        Debug.entering(e);
        this.updateView(e.getKeyStoreInfo(), KeymanView.UpdateType.Closed);
        Debug.exiting();
    }

    public void databaseOpened(KeyManagerEvent e) {
        Debug.entering(e);
        this.updateView(e.getKeyStoreInfo(), KeymanView.UpdateType.Opened);
        Debug.exiting();
    }

    public void providerAdded(ProviderEvent e) {
        Debug.entering(e);
        this.view.updateProviders(e.getProvider());
        Debug.exiting();
    }

    private void updateView(KeyStoreInfo item, KeymanView.UpdateType type) {
        Debug.entering(new Object[]{item, type});
        try {
            this.view.updateDatabase(item, type);
        }
        catch (KeyManagerException e) {
            this.view.showStatusMessage(new ExceptionInfo(e).getUserMessage());
            Logger.showError(e);
            try {
                this.view.updateDatabase(item, KeymanView.UpdateType.Closed);
            }
            catch (KeyManagerException e1) {
                this.view.showStatusMessage(new ExceptionInfo(e).getUserMessage());
                Logger.showError(e);
            }
        }
        Debug.exiting();
    }

    public static class Invoker {
        private static KeyStoreLoaderFactory.KeyStoreLoader loader = KeyStoreLoaderFactory.newCachedKeyStoreLoader();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void invoke(ParameterMap map, KeyManagerEventListener listener, KeymanView view) throws InternalKeyManagerException, KeyManagerException {
            Debug.entering(map, listener, view);
            Command command = null;
            try {
                command = CommandFactory.getCommand(map);
                for (ControlObjectFactory.ControlObject ctrlObj = command.invoke(loader, listener, view); ctrlObj != null; ctrlObj = ctrlObj.invoke(loader, listener, view)) {
                }
                if (view != null) {
                    view.showStatusMessage(Messages.getString("Message.ActionCompleted"));
                }
            }
            catch (InternalKeyManagerException e1) {
                Logger.showError(e1);
                throw e1;
            }
            catch (KeyManagerException e1) {
                if (view != null) {
                    view.showStatusMessage(new ExceptionInfo(e1).getUserMessage());
                }
                Logger.showError(e1);
                e1.setHandled(true);
                throw e1;
            }
            catch (CancelledException e1) {
                Debug.log("cancelled exception: {0}", e1);
                return;
            }
            catch (Exception e1) {
                Logger.showError(e1);
            }
            finally {
                Debug.exiting();
            }
        }
    }
}

