/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command.cli;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.cli.ExtractorFactory;
import com.ibm.gsk.ikeyman.command.cli.TokeniserFactory;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandParser {
    private ParameterMap parameters;
    private static final List<CommandTypeParser> commandTypeParsers = new ArrayList<CommandTypeParser>();
    private static final List<ExtractorFactory.Extractor<Constants.Parameter, TokeniserFactory.Token<String>>> parameterExtractors = new ArrayList<ExtractorFactory.Extractor<Constants.Parameter, TokeniserFactory.Token<String>>>();

    public Command getCommand() throws KeyManagerException {
        return CommandFactory.getCommand(this.parameters);
    }

    public static String getProgramUsage() {
        StringBuffer returnString = new StringBuffer(CommandTypeParser.getUsageHeader());
        for (CommandTypeParser value : commandTypeParsers) {
            returnString.append(value.getUsage());
        }
        return returnString.toString();
    }

    public static CommandParser parseCommand(String[] args) throws KeyManagerException {
        Debug.entering(args);
        TokeniserFactory.Tokeniser<String> tokeniser = TokeniserFactory.newArrayTokeniser(TokeniserFactory.newSimpleTokeniser(2), TokeniserFactory.newParameterTokeniser("-"));
        Stack<TokeniserFactory.Token<String>> tokens = tokeniser.tokenise(args);
        CommandParser parser = new CommandParser();
        parser.parse(tokens);
        Debug.exiting(parser);
        return parser;
    }

    private CommandTypeParser getParser(String tag) {
        for (CommandTypeParser parser : commandTypeParsers) {
            if (!parser.canParse(tag)) continue;
            return parser;
        }
        return null;
    }

    private void parse(Stack<TokeniserFactory.Token<String>> tokens) throws KeyManagerException {
        Debug.entering(tokens);
        if (tokens.isEmpty()) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_OPTIONS_SPECIFIED, CommandParser.getProgramUsage());
        }
        TokeniserFactory.Token<String> object = tokens.pop();
        CommandTypeParser parser = this.getParser(object.getTag());
        if (parser == null) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_OBJECT, CommandParser.getProgramUsage(), object.getTag());
        }
        Constants.CommandType commandType = parser.getCommandType(tokens);
        Debug.log("command type = {0}", commandType);
        this.parameters = new ParameterMap(commandType);
        this.parseParameters(tokens);
        Debug.exiting();
    }

    private void parseParameters(Stack<TokeniserFactory.Token<String>> tokens) throws KeyManagerException {
        Debug.entering(tokens);
        while (!tokens.isEmpty()) {
            Debug.log("next token: {0}", tokens.peek());
            ExtractorFactory.Extractor<Constants.Parameter, TokeniserFactory.Token<String>> extractor = this.getExtractor(tokens.peek());
            extractor.extract(tokens, this.parameters);
        }
        Debug.exiting();
    }

    private ExtractorFactory.Extractor<Constants.Parameter, TokeniserFactory.Token<String>> getExtractor(TokeniserFactory.Token<String> nextToken) throws KeyManagerException {
        for (ExtractorFactory.Extractor<Constants.Parameter, TokeniserFactory.Token<String>> extractor : parameterExtractors) {
            if (!extractor.canExtract(nextToken)) continue;
            return extractor;
        }
        Constants.CommandType type = this.parameters.getCommandType();
        throw new KeyManagerException(KeyManagerException.ExceptionReason.UNKNOWN_PARAMETER, nextToken.getTag(), CommandFactory.getCommand(this.parameters).getUsageString());
    }

    public ParameterMap getParameters() {
        return this.parameters;
    }

    static {
        for (Constants.CommandObject commandObject : new Constants.CommandObject[]{Constants.CommandObject.KeyDB, Constants.CommandObject.Cert, Constants.CommandObject.CertReq, Constants.CommandObject.SecKey}) {
            if (!commandObject.isEnabled()) continue;
            commandTypeParsers.add(new ExtendedCommandTypeParser(commandObject));
        }
        for (Constants.CommandObject commandObject : new Constants.CommandObject[]{Constants.CommandObject.Version, Constants.CommandObject.Help}) {
            if (!commandObject.isEnabled()) continue;
            commandTypeParsers.add(new SimpleCommandTypeParser(commandObject));
        }
        for (Enum enum_ : Constants.Parameter.values()) {
            ExtractorFactory.Extractor<Constants.Parameter, TokeniserFactory.Token<String>> extractor = ((Constants.Parameter)enum_).getExtractor();
            if (extractor == null) continue;
            parameterExtractors.add(extractor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtendedCommandTypeParser
    extends CommandTypeParser {
        private Constants.CommandObject commandObject;
        private List<Constants.CommandType> actions;

        public ExtendedCommandTypeParser(Constants.CommandObject cmdObj) {
            this.commandObject = cmdObj;
            this.actions = cmdObj.getActions();
        }

        @Override
        public Constants.CommandType getCommandType(Stack<TokeniserFactory.Token<String>> tokens) throws KeyManagerException {
            Debug.entering(tokens);
            if (tokens.isEmpty()) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.MISSING_ACTION, this.toString());
            }
            String actionTag = tokens.pop().getTag();
            Debug.log("action tag = {0}", actionTag);
            for (Constants.CommandType action : this.actions) {
                if (!action.getCommandLineParameter().toLowerCase(Locale.US).equals(actionTag.toLowerCase(Locale.US))) continue;
                Debug.exiting(action);
                return action;
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ACTION, this.toString(), actionTag);
        }

        @Override
        public String getUsage() {
            String returnString = "";
            for (int i = 0; i < this.actions.size(); ++i) {
                String column1 = i == 0 ? this.commandObject.getCommandLineParameter() : "";
                Constants.CommandType commandAction = this.actions.get(i);
                String column2 = commandAction.getCommandLineParameter();
                String column3 = commandAction.getLongDescription();
                returnString = returnString + ExtendedCommandTypeParser.formatArguments(column1, column2, column3);
            }
            return returnString;
        }

        @Override
        boolean canParse(String tag) {
            Debug.entering(tag);
            boolean returnValue = this.commandObject.getCommandLineParameter().toLowerCase(Locale.US).equals(tag.toLowerCase(Locale.US));
            Debug.exiting(returnValue);
            return returnValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleCommandTypeParser
    extends CommandTypeParser {
        private Constants.CommandObject commandObject;
        private Constants.CommandType commandType;

        public SimpleCommandTypeParser(Constants.CommandObject cmdObj) {
            this.commandObject = cmdObj;
            this.commandType = cmdObj.getActions().get(0);
        }

        @Override
        public Constants.CommandType getCommandType(Stack<TokeniserFactory.Token<String>> tokens) {
            Debug.entering(tokens);
            Debug.exiting(this.commandType);
            return this.commandType;
        }

        @Override
        protected String getUsage() {
            return SimpleCommandTypeParser.formatArguments(this.commandObject.getCommandLineParameter(), "", this.commandType.getLongDescription());
        }

        @Override
        boolean canParse(String tag) {
            Debug.entering(tag);
            boolean returnValue = this.commandObject.getCommandLineParameter().toLowerCase(Locale.US).equals(tag.toLowerCase(Locale.US));
            Debug.exiting(returnValue);
            return returnValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CommandTypeParser {
        private static final String FORMAT_STRING = "%-8s %-12s %s\n";

        private CommandTypeParser() {
        }

        abstract Constants.CommandType getCommandType(Stack<TokeniserFactory.Token<String>> var1) throws KeyManagerException;

        abstract boolean canParse(String var1);

        protected abstract String getUsage();

        public static String getUsageHeader() {
            return CommandTypeParser.formatArguments(Messages.getString("Message.Object"), Messages.getString("Message.Action"), Messages.getString("Message.Description")) + CommandTypeParser.formatArguments(CommandTypeParser.makeCharString('-', Messages.getString("Message.Object").length()), CommandTypeParser.makeCharString('-', Messages.getString("Message.Action").length()), CommandTypeParser.makeCharString('-', Messages.getString("Message.Description").length()));
        }

        private static String makeCharString(char c, int length) {
            char[] chars = new char[length];
            Arrays.fill(chars, c);
            return new String(chars);
        }

        protected static String formatArguments(Object ... args) {
            return new Formatter().format(FORMAT_STRING, args).toString();
        }

        public String toString() {
            return CommandTypeParser.getUsageHeader() + this.getUsage();
        }
    }
}

