/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.util.AliasRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFactory {
    public static Filter<CertificateItem> getCertificateFilter(CommandParameters params) throws KeyManagerException {
        ArrayList filters = new ArrayList();
        if (params.isParameterPresent(Constants.Parameter.Expiry)) {
            filters.add(new CertificateExpiryFilterItem(params.getExpiry()));
        }
        if (params.isParameterPresent(Constants.Parameter.ListFilter)) {
            filters.add(new ListWhichFilterItem(params.getListWhich()));
        }
        return new FilterImpl<CertificateItem>(filters);
    }

    public static Filter<Entry> getListWhichFilter(Constants.ListFilter which) {
        return new FilterImpl<Entry>(new ListWhichFilterItem(which));
    }

    public static Filter<Entry> getTypeFilter(Class<? extends Entry> c) {
        return new FilterImpl<Entry>(new TypeFilterItem(c));
    }

    public static Filter<Entry> getCertRequestFilter() {
        return new FilterImpl<Entry>(new CertRequestFilterItem());
    }

    public static Filter<Entry> getAliasRangeFilter(CommandParameters params) throws KeyManagerException {
        return new FilterImpl<Entry>(new AliasRangeFilterItem(params.getLabelRange()));
    }

    public static <T> Filter<T> getConstantFilter(boolean value, Class<T> type) {
        return new FilterImpl(new ConstantFilterItem<T>(value, type));
    }

    public static <T> Filter<T> getFilter(FilterTest<T> ... testers) {
        ArrayList items = new ArrayList();
        for (FilterTest<T> tester : testers) {
            items.add(new GenericFilter<T>(tester));
        }
        return new FilterImpl(items);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericFilter<T>
    implements FilterItem<T> {
        private FilterTest<T> tester;

        public GenericFilter(FilterTest<T> tester) {
            this.tester = tester;
        }

        @Override
        public boolean isValid(T item) {
            return this.tester.test(item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CertRequestFilterItem
    implements FilterItem<Entry> {
        private CertRequestFilterItem() {
        }

        @Override
        public boolean isValid(Entry item) {
            return item instanceof CertificateRequestItem;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AliasRangeFilterItem
    implements FilterItem<Entry> {
        private AliasRange aliasRange;

        public AliasRangeFilterItem(String aliasRange) {
            this.aliasRange = new AliasRange(aliasRange);
        }

        @Override
        public boolean isValid(Entry item) {
            try {
                return this.aliasRange.containsAlias(item.getLabel());
            }
            catch (KeyManagerException e) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstantFilterItem<T>
    implements FilterItem<T> {
        private boolean value;

        public ConstantFilterItem(boolean value, Class<T> type) {
            this.value = value;
        }

        @Override
        public boolean isValid(T item) {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeFilterItem
    implements FilterItem<Entry> {
        private Class<? extends Entry> c;

        public TypeFilterItem(Class<? extends Entry> c) {
            this.c = c;
        }

        @Override
        public boolean isValid(Entry item) {
            return this.c.isInstance(item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListWhichFilterItem<T extends Entry>
    implements FilterItem<T> {
        private Constants.ListFilter listFilter;

        public ListWhichFilterItem(Constants.ListFilter listFilter) {
            this.listFilter = listFilter;
        }

        @Override
        public boolean isValid(T item) {
            switch (this.listFilter) {
                case All: {
                    return !(item instanceof CertificateRequestKeyItem);
                }
                case Personal: {
                    return item instanceof CertificateKeyItem;
                }
                case Secret: {
                    return item instanceof SecretKeyItem;
                }
                case CA: {
                    return item instanceof CertificateItem && !(item instanceof CertificateKeyItem);
                }
                case CertRequest: {
                    return item instanceof CertificateRequestKeyItem;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CertificateExpiryFilterItem
    implements FilterItem<CertificateItem> {
        private int expiry;

        public CertificateExpiryFilterItem(int expiry) {
            this.expiry = expiry;
        }

        @Override
        public boolean isValid(CertificateItem item) {
            return !item.getValidity().checkValidity(this.expiry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterImpl<T>
    implements Filter<T> {
        private List<FilterItem<T>> filterItems;

        public FilterImpl(List<FilterItem<T>> filterItems) {
            this.filterItems = filterItems;
        }

        public FilterImpl(FilterItem<T> ... filterItems) {
            this.filterItems = Arrays.asList(filterItems);
        }

        public boolean isValid(T item) {
            for (FilterItem<T> filterItem : this.filterItems) {
                if (filterItem.isValid(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Collection<T> filter(Collection<? extends T> items) {
            ArrayList<T> returnList = new ArrayList<T>();
            for (T item : items) {
                if (!this.isValid(item)) continue;
                returnList.add(item);
            }
            return returnList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FilterTest<T> {
        public boolean test(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FilterItem<T> {
        public boolean isValid(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Filter<T> {
        public Collection<T> filter(Collection<? extends T> var1);
    }
}

