/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.KeyStoreLoaderFactory;
import com.ibm.gsk.ikeyman.command.gui.KeymanView;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.util.Debug;

public class ControlObjectFactory {
    public static ControlObject newMessage(String message) {
        return new MessageObject(message);
    }

    public static ControlObject newCommandObject(Command cmd) {
        return new CommandObject(cmd);
    }

    public static ControlObject newChoiceCommand(String message, Command yesCommand, Command noCommand) {
        return new ChoiceCommand(message, yesCommand, noCommand);
    }

    private static class ChoiceCommand
    implements ControlObject {
        private String question;
        private Command yesCommand;
        private Command noCommand;

        public ChoiceCommand(String question, Command yesCommand, Command noCommand) {
            Debug.entering(question, yesCommand, noCommand);
            this.question = question;
            this.yesCommand = yesCommand;
            this.noCommand = noCommand;
            Debug.exiting();
        }

        public ControlObject invoke(KeyStoreLoaderFactory.KeyStoreLoader loader, KeyManagerEventListener listener, KeymanView view) throws KeyManagerException, CancelledException {
            Debug.entering(loader, listener, view);
            int result = view.showConfirmation(this.question, "", 0);
            Debug.log("Result = {0}", result);
            if (result == 0) {
                if (this.yesCommand != null) {
                    ControlObject returnObject = this.yesCommand.invoke(loader, listener, view);
                    Debug.exiting(returnObject);
                    return returnObject;
                }
            } else if (this.noCommand != null) {
                ControlObject returnObject = this.noCommand.invoke(loader, listener, view);
                Debug.exiting(returnObject);
                return returnObject;
            }
            Debug.exiting(null);
            return null;
        }
    }

    private static class CommandObject
    implements ControlObject {
        private Command cmd;

        public CommandObject(Command cmd) {
            this.cmd = cmd;
        }

        public ControlObject invoke(KeyStoreLoaderFactory.KeyStoreLoader loader, KeyManagerEventListener listener, KeymanView view) throws KeyManagerException, CancelledException {
            return this.cmd.invoke(loader, listener, view);
        }
    }

    private static class MessageObject
    implements ControlObject {
        private String message;

        public MessageObject(String message) {
            this.message = message;
        }

        public ControlObject invoke(KeyStoreLoaderFactory.KeyStoreLoader loader, KeyManagerEventListener listener, KeymanView view) throws KeyManagerException {
            view.showMessage(this.message);
            return null;
        }
    }

    public static interface ControlObject {
        public ControlObject invoke(KeyStoreLoaderFactory.KeyStoreLoader var1, KeyManagerEventListener var2, KeymanView var3) throws KeyManagerException, CancelledException;
    }
}

