/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.FilterFactory;
import com.ibm.gsk.ikeyman.command.LabelMap;
import com.ibm.gsk.ikeyman.command.ParserFactory;
import com.ibm.gsk.ikeyman.command.SupportCheckerFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.cli.ExtractorFactory;
import com.ibm.gsk.ikeyman.command.cli.TokeniserFactory;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.panels.FileNameEnum;
import com.ibm.gsk.ikeyman.io.CertificateWriter;
import com.ibm.gsk.ikeyman.keystore.KeyStoreProxyCreatorFactory;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.X509Version;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.ComparatorFactory;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public interface Constants {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommandType implements CommandLineParameterEnum
    {
        CreateDB("-create", null, "Constants.Command.LongDescription.DB.Create"),
        DeleteDB("-delete", null, "Constants.Command.LongDescription.DB.Delete"),
        ChangeDBPassword("-changepw", null, "Constants.Command.LongDescription.DB.ChangePw"),
        StashDBPassword("-stashpw", null, "Constants.Command.LongDescription.DB.StashPw"),
        ListSupportedDBTypes("-list", null, "Constants.Command.LongDescription.DB.List"),
        ConvertDB("-convert", null, "Constants.Command.LongDescription.DB.Convert"),
        DisplayDBPasswordExpiry("-expiry", null, "Constants.Command.LongDescription.DB.Expiry"),
        CreateSSCert("-create", null, "Constants.Command.LongDescription.Cert.Create"),
        AddCert("-add", null, "Constants.Command.LongDescription.Cert.Add"),
        Populate("-populate", KeymanSettings.Setting.NoDefaultCertsFunctionEnabled, "Constants.Command.LongDescription.Cert.Populate"),
        ListSigners("-listsigners", KeymanSettings.Setting.NoDefaultCertsFunctionEnabled, "Constants.Command.LongDescription.Cert.ListSigner"),
        DeleteCert("-delete", null, "Constants.Command.LongDescription.Cert.Delete"),
        DisplayCert("-details", null, "Constants.Command.LongDescription.Cert.Display"),
        ExportCert("-export", null, "Constants.Command.LongDescription.Cert.Export"),
        ReceiveCert("-receive", null, "Constants.Command.LongDescription.Cert.Receive"),
        ImportCert("-import", null, "Constants.Command.LongDescription.Cert.Import"),
        ExtractCert("-extract", null, "Constants.Command.LongDescription.Cert.Extract"),
        DisplayDefaultCert("-getdefault", null, "Constants.Command.LongDescription.Cert.GetDefault"),
        SetDefaultCert("-setdefault", null, "Constants.Command.LongDescription.Cert.SetDefault"),
        ListCerts("-list", null, "Constants.Command.LongDescription.Cert.List"),
        ModifyCert("-modify", null, "Constants.Command.LongDescription.Cert.Modify"),
        SignCert("-sign", null, "Constants.Command.LongDescription.Cert.Sign"),
        CreateCertRequest("-create", null, "Constants.Command.LongDescription.CertReq.Create"),
        DeleteCertRequest("-delete", null, "Constants.Command.LongDescription.CertReq.Delete"),
        DisplayCertRequest("-details", null, "Constants.Command.LongDescription.CertReq.Display"),
        ExtractCertRequest("-extract", null, "Constants.Command.LongDescription.CertReq.Extract"),
        ListCertRequests("-list", null, "Constants.Command.LongDescription.CertReq.List"),
        RecreateCertRequest("-recreate", null, "Constants.Command.LongDescription.CertReq.Recreate"),
        CreateSecretKey("-create", null, "Constants.Command.LongDescription.SecretKey.Create"),
        DeleteSecretKey("-delete", null, "Constants.Command.LongDescription.SecretKey.Delete"),
        DisplaySecretKey("-details", null, "Constants.Command.LongDescription.SecretKey.Display"),
        ExportSecretKey("-export", null, "Constants.Command.LongDescription.SecretKey.Export"),
        ImportSecretKey("-import", null, "Constants.Command.LongDescription.SecretKey.Import"),
        ListSecretKeys("-list", null, "Constants.Command.LongDescription.SecretKey.List"),
        RenameSecretKey("-rename", null, "Constants.Command.LongDescription.SecretKey.Rename"),
        Version(null, null, "Constants.Command.LongDescription.Version"),
        Help(null, null, "Constants.Command.LongDescription.Help"),
        LoadDB(null, null),
        CloseDb(null, null),
        AddProvider(null, null),
        RefreshLists(null, null),
        ImportCertRename(null, null),
        AddCertRename(null, null),
        RenameCert("-rename", KeymanSettings.Setting.RenameCertFunctionEnabled, "Constants.Command.LongDescription.Cert.Rename");

        private static TypeDisplayerFactory.TypeDisplayer<? super CommandType> displayer;
        private String commandLineParameter;
        private String longDescriptionKey;
        private KeymanSettings.Setting enabledSetting;

        private CommandType(String commandLineParam, KeymanSettings.Setting enabledSetting, String longDescriptionKey) {
            this.commandLineParameter = commandLineParam;
            this.longDescriptionKey = longDescriptionKey;
            this.enabledSetting = enabledSetting;
        }

        private CommandType(String commandLineParam, KeymanSettings.Setting enabledSetting) {
            this.commandLineParameter = commandLineParam;
            this.enabledSetting = enabledSetting;
        }

        @Override
        public String getCommandLineParameter() {
            return this.commandLineParameter;
        }

        public String getLongDescription() {
            return this.longDescriptionKey == null ? null : Messages.getString(this.longDescriptionKey);
        }

        public static void setDisplayer(TypeDisplayerFactory.TypeDisplayer<? super CommandType> newDisplayer) {
            displayer = newDisplayer;
        }

        public String toString() {
            return displayer.toString(this);
        }

        public boolean isEnabled() {
            return this.enabledSetting == null ? true : this.enabledSetting.getBoolean();
        }

        static {
            displayer = TypeDisplayerFactory.newEnumDisplayer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommandObject {
        KeyDB("-keydb", null, CommandType.ChangeDBPassword, CommandType.ConvertDB, CommandType.CreateDB, CommandType.DeleteDB, CommandType.DisplayDBPasswordExpiry, CommandType.ListSupportedDBTypes, CommandType.StashDBPassword),
        Cert("-cert", null, CommandType.AddCert, CommandType.CreateSSCert, CommandType.DeleteCert, CommandType.DisplayCert, CommandType.ExportCert, CommandType.ExtractCert, CommandType.DisplayDefaultCert, CommandType.ImportCert, CommandType.ListCerts, CommandType.ListSigners, CommandType.ModifyCert, CommandType.Populate, CommandType.ReceiveCert, CommandType.RenameCert, CommandType.SetDefaultCert, CommandType.SignCert),
        CertReq("-certreq", null, CommandType.CreateCertRequest, CommandType.DeleteCertRequest, CommandType.DisplayCertRequest, CommandType.ExtractCertRequest, CommandType.ListCertRequests, CommandType.RecreateCertRequest),
        SecKey("-seckey", KeymanSettings.Setting.SecretKeyFunctionEnabled, CommandType.CreateSecretKey, CommandType.DeleteSecretKey, CommandType.DisplaySecretKey, CommandType.ExportSecretKey, CommandType.ImportSecretKey, CommandType.ListSecretKeys, CommandType.RenameSecretKey),
        Version("-version", null, CommandType.Version),
        Help("-help", null, CommandType.Help);

        private List<CommandType> actions = new ArrayList<CommandType>();
        private String commandLineParameter;
        private KeymanSettings.Setting enabledSetting;

        private CommandObject(String commandLineParam, KeymanSettings.Setting enabledSetting, CommandType ... actions) {
            this.commandLineParameter = commandLineParam;
            this.enabledSetting = enabledSetting;
            for (CommandType action : actions) {
                if (!action.isEnabled()) continue;
                this.actions.add(action);
            }
        }

        public String getCommandLineParameter() {
            return this.commandLineParameter;
        }

        public List<CommandType> getActions() {
            return this.actions;
        }

        public boolean isEnabled() {
            return this.enabledSetting == null ? true : this.enabledSetting.getBoolean();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameter implements ValidatorFactory.Validatable,
    CommandLineParameterEnum
    {
        CA("-ca"),
        DatabaseName("-db"),
        DefaultCert("-default_cert"),
        DN("-dn"),
        Encryption("-encryption"),
        Expire("-expire"),
        Expiry("-expiry"),
        File("-file"),
        Format("-format"),
        KeyAlgorithm("-keyalg"),
        KeyAlias("-keyalias"),
        KeySize("-keysize"),
        Label("-label"),
        LabelRange("-labelrange"),
        ListFilter("<list filter>"),
        NewLabel("-new_label"),
        NewPassword("-new_pw"),
        Password("-pw"),
        SecondPassword("-pw"),
        SanDnsName("-san_dnsname"),
        SanEmailAddress("-san_emailaddr"),
        SanIpAddress("-san_ipaddr"),
        SerNum("-sernum"),
        ShowOID("-showOID"),
        SigAlg("-sig_alg"),
        Size("-size"),
        StashPassword("-stash"),
        Target("-target"),
        TargetPassword("-target_pw"),
        TargetType("-target_type"),
        Trust("-trust"),
        Type("-type"),
        X509Version("-x509version"),
        LabelMap("-label_map"),
        Crypto("-crypto"),
        TokenLabel("-tokenlabel"),
        RelativeSlotNumber("-relativeSlotNumber"),
        SecondaryDb("-secondaryDB"),
        SecondaryDbPassword("-secondaryDBpw"),
        OldFormat("-old_format"),
        NewFormat("-new_format"),
        Pfx("-pfx"),
        SecondaryDbType("-secondaryDbType"),
        ProviderClass("-provider_class");

        private String commandLineParameter;
        private static TypeDisplayerFactory.TypeDisplayer<? super Parameter> displayer;
        private static final Map<Parameter, ParserFactory.Parser<?>> parsers;

        private Parameter(String commandLineParameter) {
            this.commandLineParameter = commandLineParameter;
        }

        public boolean isUnary() {
            switch (this) {
                case ListFilter: 
                case ShowOID: 
                case StashPassword: 
                case Pfx: {
                    return true;
                }
            }
            return false;
        }

        public boolean isBinary() {
            return !this.isUnary();
        }

        public Object validate(Object value) throws KeyManagerException {
            try {
                return parsers.get(this).parse(value);
            }
            catch (KeyManagerException e) {
                e.addDetail(this.toString());
                throw e;
            }
        }

        public Object getUnaryValue(String string) {
            switch (this) {
                case ListFilter: {
                    return string;
                }
                case ShowOID: 
                case StashPassword: 
                case Pfx: {
                    return true;
                }
            }
            return null;
        }

        @Override
        public String getCommandLineParameter() {
            return this.commandLineParameter;
        }

        public ExtractorFactory.Extractor<Parameter, TokeniserFactory.Token<String>> getExtractor() {
            if (this.isUnary()) {
                if (this == ListFilter) {
                    return ExtractorFactory.newTaglessExtractor(this, com.ibm.gsk.ikeyman.command.Constants$ListFilter.getListMap());
                }
                return ExtractorFactory.newUnaryExtractor(this, true);
            }
            if (this == Password) {
                return ExtractorFactory.newMultiExtractor(this, SecondPassword);
            }
            if (this == SecondPassword) {
                return null;
            }
            if (this == Crypto) {
                return ExtractorFactory.newOptionalBinaryExtractor(this, "");
            }
            if (this == Expiry) {
                return ExtractorFactory.newOptionalBinaryExtractor(this, Integer.MAX_VALUE);
            }
            return ExtractorFactory.newBinaryExtractor(this);
        }

        public static void setDisplayer(TypeDisplayerFactory.TypeDisplayer<? super Parameter> newDisplayer) {
            displayer = newDisplayer;
        }

        public String toString() {
            return displayer.toString(this);
        }

        @Override
        public String getValidValues() {
            return parsers.get(this).getValidValues();
        }

        static {
            displayer = TypeDisplayerFactory.newEnumDisplayer();
            parsers = new EnumMap(Parameter.class);
            parsers.put(Format, ParserFactory.getDelegateParser(CertificateWriter.OutputMode.class, new CertificateWriter.OutputMode.OutputModeParser()));
            parsers.put(Type, ParserFactory.getDelegateParser(DatabaseType.class, new DatabaseType.DatabaseTypeParser()));
            parsers.put(TargetType, ParserFactory.getDelegateParser(DatabaseType.class, new DatabaseType.DatabaseTypeParser()));
            parsers.put(NewFormat, ParserFactory.getDelegateParser(DatabaseType.class, new DatabaseType.DatabaseTypeParser()));
            parsers.put(OldFormat, ParserFactory.getDelegateParser(DatabaseType.class, new DatabaseType.DatabaseTypeParser()));
            parsers.put(SecondaryDbType, ParserFactory.getDelegateParser(DatabaseType.class, new DatabaseType.DatabaseTypeParser()));
            parsers.put(ListFilter, ParserFactory.getDelegateParser(ListFilter.class, new ListFilter.ListFilterParser()));
            parsers.put(SigAlg, ParserFactory.getDelegateParser(SignatureAlgorithms.class, new SignatureAlgorithms.SignatureAlgorithmParser()));
            parsers.put(X509Version, ParserFactory.getMapParser(X509Version.class, String.class, com.ibm.gsk.ikeyman.keystore.entry.X509Version.getParseMap()));
            TreeMap<String, Encryption> encryptionMap = new TreeMap<String, Encryption>(ComparatorFactory.newIgnoreCaseStringComparator());
            encryptionMap.put("strong", com.ibm.gsk.ikeyman.command.Constants$Encryption.Strong);
            encryptionMap.put("weak", com.ibm.gsk.ikeyman.command.Constants$Encryption.Weak);
            parsers.put(Encryption, ParserFactory.getMapParser(Encryption.class, String.class, encryptionMap));
            TreeMap<String, Boolean> defaultMap = new TreeMap<String, Boolean>(ComparatorFactory.newIgnoreCaseStringComparator());
            defaultMap.put("yes", true);
            defaultMap.put("no", false);
            parsers.put(DefaultCert, ParserFactory.getMapParser(Boolean.class, String.class, defaultMap));
            TreeMap<String, Boolean> trustMap = new TreeMap<String, Boolean>(ComparatorFactory.newIgnoreCaseStringComparator());
            trustMap.put("enable", true);
            trustMap.put("disable", false);
            parsers.put(Trust, ParserFactory.getMapParser(Boolean.class, String.class, trustMap));
            TreeMap<String, Boolean> caMap = new TreeMap<String, Boolean>(ComparatorFactory.newIgnoreCaseStringComparator());
            caMap.put("true", true);
            caMap.put("false", false);
            parsers.put(CA, ParserFactory.getMapParser(Boolean.class, String.class, caMap));
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class IntComparator
            implements Comparator<String> {
                IntComparator() {
                }

                @Override
                public int compare(String o1, String o2) {
                    return new Integer(o1).compareTo(new Integer(o2));
                }
            }
            TreeMap<String, Integer> sizeMap = new TreeMap<String, Integer>(new IntComparator());
            sizeMap.put("512", 512);
            sizeMap.put("1024", 1024);
            sizeMap.put("2048", 2048);
            parsers.put(Size, ParserFactory.getMapParser(Integer.class, String.class, sizeMap));
            parsers.put(Crypto, ParserFactory.getCastParser(String.class));
            parsers.put(DatabaseName, ParserFactory.getCastParser(String.class));
            parsers.put(File, ParserFactory.getCastParser(String.class));
            parsers.put(Label, ParserFactory.getCastParser(String.class));
            parsers.put(LabelRange, ParserFactory.getCastParser(String.class));
            parsers.put(NewLabel, ParserFactory.getCastParser(String.class));
            parsers.put(NewPassword, ParserFactory.getCastParser(String.class));
            parsers.put(Password, ParserFactory.getCastParser(String.class));
            parsers.put(SecondPassword, ParserFactory.getCastParser(String.class));
            parsers.put(Target, ParserFactory.getCastParser(String.class));
            parsers.put(TargetPassword, ParserFactory.getCastParser(String.class));
            parsers.put(TokenLabel, ParserFactory.getCastParser(String.class));
            parsers.put(SanDnsName, ParserFactory.getCastParser(String.class));
            parsers.put(SanEmailAddress, ParserFactory.getCastParser(String.class));
            parsers.put(SanIpAddress, ParserFactory.getCastParser(String.class));
            parsers.put(SecondaryDb, ParserFactory.getCastParser(String.class));
            parsers.put(SecondaryDbPassword, ParserFactory.getCastParser(String.class));
            parsers.put(ProviderClass, ParserFactory.getCastParser(String.class));
            parsers.put(KeyAlgorithm, ParserFactory.getCastParser(String.class));
            parsers.put(KeyAlias, ParserFactory.getCastParser(String.class));
            parsers.put(ShowOID, ParserFactory.getCastParser(Boolean.class));
            parsers.put(StashPassword, ParserFactory.getCastParser(Boolean.class));
            parsers.put(Pfx, ParserFactory.getCastParser(Boolean.class));
            parsers.put(LabelMap, ParserFactory.getCastParser(LabelMap.class));
            parsers.put(DN, ParserFactory.getStringOrTypeParser(DisplayItemFactory.DNItemImpl.class));
            parsers.put(Expire, ParserFactory.getIntegerRangeParser((Integer)KeymanSettings.VALID_PASSWORD_EXPIRY_RANGE.getFirst(), (Integer)KeymanSettings.VALID_PASSWORD_EXPIRY_RANGE.getSecond()));
            parsers.put(Expiry, ParserFactory.getStringOrTypeParser(Integer.class));
            parsers.put(RelativeSlotNumber, ParserFactory.getStringOrTypeParser(Integer.class));
            parsers.put(SerNum, ParserFactory.getStringOrTypeParser(Integer.class));
            parsers.put(KeySize, ParserFactory.getStringOrTypeParser(Integer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SignatureAlgorithms {
        SHA1WithRSA("SHA_WITH_RSA", "SHAWithRSA"),
        SHA2WithRSA("SHA256_WITH_RSA", "SHA256WithRSA"),
        SHA3WithRSA("SHA384_WITH_RSA", "SHA384WithRSA"),
        SHA5WithRSA("SHA512_WITH_RSA", "SHA512WithRSA"),
        MD2WithRSA("MD2_WITH_RSA"),
        MD5WithRSA("MD5_WITH_RSA"),
        SHA1WithDSA("SHA_WITH_DSA", "SHAWithDSA");

        private String[] aliases;
        private boolean isSupported;
        private static SignatureAlgorithmParser parser;
        private static SignatureAlgorithms[] supportedValues;

        private SignatureAlgorithms(String ... aliases) {
            this.aliases = aliases;
            try {
                Signature.getInstance(this.toString(), KeymanUtil.getJCEProviderName());
                this.isSupported = true;
            }
            catch (Exception e) {
                this.isSupported = false;
            }
        }

        public static SignatureAlgorithms get(String value) {
            try {
                return parser.parse(value);
            }
            catch (KeyManagerException e) {
                return SHA1WithDSA;
            }
        }

        public static SignatureAlgorithms[] getSupportedValues() {
            if (supportedValues == null) {
                ArrayList<SignatureAlgorithms> supportedVals = new ArrayList<SignatureAlgorithms>();
                for (SignatureAlgorithms algorithm : SignatureAlgorithms.values()) {
                    if (!algorithm.isSupported) continue;
                    supportedVals.add(algorithm);
                }
                supportedValues = supportedVals.toArray(new SignatureAlgorithms[0]);
            }
            return supportedValues;
        }

        static {
            parser = new SignatureAlgorithmParser();
            supportedValues = null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class SignatureAlgorithmParser
        implements ParserFactory.ParserDelegate<SignatureAlgorithms> {
            private static final Map<String, SignatureAlgorithms> parseMap = new TreeMap<String, SignatureAlgorithms>(ComparatorFactory.newIgnoreCaseStringComparator());

            @Override
            public SignatureAlgorithms parse(String value) throws KeyManagerException {
                if (parseMap.containsKey(value)) {
                    return parseMap.get(value);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_SIGNATURE_ALGORITHM, value, this.getValidValues().toString());
            }

            @Override
            public Collection<? extends String> getValidValues() {
                return parseMap.keySet();
            }

            static {
                for (SignatureAlgorithms alg : SignatureAlgorithms.values()) {
                    parseMap.put(alg.toString(), alg);
                    for (String alias : alg.aliases) {
                        parseMap.put(alias, alg);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Encryption {
        Strong,
        Weak;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ListFilter {
        All,
        Personal,
        Site,
        CA,
        Secret,
        CertRequest;

        private static final Map<String, ListFilter> map;

        public static Map<String, ListFilter> getListMap() {
            return map;
        }

        static {
            map = new TreeMap<String, ListFilter>(ComparatorFactory.newIgnoreCaseStringComparator());
            map.put("all", All);
            map.put("personal", Personal);
            map.put("secret", Secret);
            map.put("site", Site);
            map.put("ca", CA);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ListFilterParser
        implements ParserFactory.ParserDelegate<ListFilter> {
            @Override
            public ListFilter parse(String value) throws KeyManagerException {
                if (map.containsKey(value)) {
                    return (ListFilter)((Object)map.get(value));
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_LIST_FILTER, value, this.getValues());
            }

            private String getValues() {
                return map.keySet().toString();
            }

            @Override
            public Collection<? extends String> getValidValues() {
                return map.keySet();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        ExistingSecondaryDb,
        NewSecondaryDb;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatabaseType implements FileNameEnum
    {
        UNKNOWN(false, false, false, null, SupportCheckerFactory.newConstantChecker(false), "", "", false),
        CMS(true, true, true, KeyStoreProxyCreatorFactory.newFileKeyStoreCreater("IBMCMSKS"), SupportCheckerFactory.newKeyStoreSupportChecker("IBMCMSKS"), KeymanSettings.Setting.DefaultCMSFileName.getString(), KeymanSettings.Setting.DefaultCMSFileNameExt.getString(), KeymanSettings.Setting.UseLastOpenedLocationCMS.getBoolean()),
        JKS(true, true, true, KeyStoreProxyCreatorFactory.newFileKeyStoreCreater("JKS"), SupportCheckerFactory.newKeyStoreSupportChecker("JKS"), KeymanSettings.Setting.DefaultJKSFileName.getString(), KeymanSettings.Setting.DefaultJKSFileNameExt.getString(), KeymanSettings.Setting.UseLastOpenedLocationJKS.getBoolean()),
        JCEKS(true, true, true, KeyStoreProxyCreatorFactory.newFileKeyStoreCreater("JCEKS"), SupportCheckerFactory.newKeyStoreSupportChecker("JCEKS"), KeymanSettings.Setting.DefaultJCEKSFileName.getString(), KeymanSettings.Setting.DefaultJCEKSFileNameExt.getString(), KeymanSettings.Setting.UseLastOpenedLocationJCEKS.getBoolean()),
        PKCS12(true, true, true, KeyStoreProxyCreatorFactory.newFileKeyStoreCreater("PKCS12"), SupportCheckerFactory.newKeyStoreSupportChecker("PKCS12"), KeymanSettings.Setting.DefaultPKCS12FileName.getString(), KeymanSettings.Setting.DefaultPKCS12FileNameExt.getString(), KeymanSettings.Setting.UseLastOpenedLocationPKCS12.getBoolean()),
        PFX(false, false, false, null, SupportCheckerFactory.newConstantChecker(false), "key", ".pfx", true),
        PKCS11Direct(true, false, false, KeyStoreProxyCreatorFactory.newPKCS11ImplDirectKeyStoreCreater(), SupportCheckerFactory.newProviderChecker("IBMPKCS11Impl"), new FileName(KeymanSettings.Setting.DefaultCryptoModule.getString()).getName(), KeymanUtil.isWindowsSystem() ? ".dll" : ".so", true),
        MSCapi(true, false, false, KeyStoreProxyCreatorFactory.newMSCapiKeyStoreCreater(KeyStoreProxyCreatorFactory.MSCapiType.ROOT), SupportCheckerFactory.newKeyStoreSupportChecker("Windows-ROOT"), "", "", false),
        PKCS11Config(true, false, false, KeyStoreProxyCreatorFactory.newPKCS11ImplKeyStoreCreater(), SupportCheckerFactory.newKeyStoreSupportChecker("PKCS11IMPLKS"), "", "", false);

        private static Collection<DatabaseType> supportedValues;
        private boolean openable;
        private boolean creatable;
        private boolean importable;
        private KeyStoreProxyCreatorFactory.KeyStoreProxyCreator creater;
        private SupportCheckerFactory.SupportChecker checker;
        private String defaultFileName;
        private String defaultFileExtension;
        private boolean useLastOpenedLocation;

        private DatabaseType(boolean openable, boolean creatable, boolean importable, KeyStoreProxyCreatorFactory.KeyStoreProxyCreator creater, SupportCheckerFactory.SupportChecker checker, String defaultFileName, String defaultFileExtension, boolean useLastOpenedLocation) {
            this.openable = openable;
            this.creatable = creatable;
            this.importable = importable;
            this.creater = creater;
            this.checker = checker;
            this.defaultFileName = defaultFileName;
            this.defaultFileExtension = defaultFileExtension;
            this.useLastOpenedLocation = useLastOpenedLocation;
        }

        public static synchronized DatabaseType[] values(SupportType support) {
            DatabaseType.updateSupportedValues();
            return support.getFilter().filter(supportedValues).toArray(new DatabaseType[0]);
        }

        public static DatabaseType getDefaultType() {
            return CMS;
        }

        public static synchronized void updateSupportedValues() {
            supportedValues = new ArrayList<DatabaseType>();
            for (DatabaseType type : DatabaseType.values()) {
                if (!type.checker.isSupported()) continue;
                supportedValues.add(type);
            }
        }

        public KeyStoreProxyCreatorFactory.KeyStoreProxyCreator getCreater() {
            return this.creater;
        }

        public static DatabaseType getTypeForExtension(String extension) {
            for (DatabaseType type : DatabaseType.values()) {
                try {
                    if (!extension.equalsIgnoreCase(type.defaultFileExtension)) continue;
                    return type;
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            return UNKNOWN;
        }

        public String getDefaultExtension() {
            return this.defaultFileExtension;
        }

        @Override
        public String getDefaultFileName() {
            return this.defaultFileName + this.defaultFileExtension;
        }

        public boolean supportsPasswordOptions() {
            return this == CMS;
        }

        public boolean supportsCertModifications() {
            return this == CMS;
        }

        public boolean useLastOpenedLocation() {
            return this.useLastOpenedLocation;
        }

        static {
            DatabaseType.updateSupportedValues();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class DatabaseTypeParser
        implements ParserFactory.ParserDelegate<DatabaseType> {
            private static final Map<String, DatabaseType> parseMap = new TreeMap<String, DatabaseType>(ComparatorFactory.newIgnoreCaseStringComparator());

            @Override
            public DatabaseType parse(String value) throws KeyManagerException {
                if (parseMap.containsKey(value)) {
                    return parseMap.get(value);
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_DATABASE_TYPE, value, this.getValidValues().toString());
            }

            @Override
            public Collection<? extends String> getValidValues() {
                return parseMap.keySet();
            }

            static {
                parseMap.put("cms", CMS);
                parseMap.put("kdb", CMS);
                parseMap.put("jks", JKS);
                parseMap.put("jceks", JCEKS);
                parseMap.put("pkcs12", PKCS12);
                parseMap.put("p12", PKCS12);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SupportType {
            All(FilterFactory.getFilter(new ConstantTester(true))),
            Opening(FilterFactory.getFilter(new OpenableTester())),
            Creation(FilterFactory.getFilter(new CreatableTester())),
            Secondary(FilterFactory.getFilter(new CreatableTester())),
            Import(FilterFactory.getFilter(new ImportableTester())),
            KeyImport(FilterFactory.getFilter(new CreatableTester(), new ImportableTester()));

            private FilterFactory.Filter<DatabaseType> filter;

            private SupportType(FilterFactory.Filter<DatabaseType> filter) {
                this.filter = filter;
            }

            public FilterFactory.Filter<DatabaseType> getFilter() {
                return this.filter;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static class ConstantTester
            implements FilterFactory.FilterTest<DatabaseType> {
                private boolean value;

                public ConstantTester(boolean value) {
                    this.value = value;
                }

                @Override
                public boolean test(DatabaseType type) {
                    return this.value;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static class ImportableTester
            implements FilterFactory.FilterTest<DatabaseType> {
                private ImportableTester() {
                }

                @Override
                public boolean test(DatabaseType value) {
                    return value.importable;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static class CreatableTester
            implements FilterFactory.FilterTest<DatabaseType> {
                private CreatableTester() {
                }

                @Override
                public boolean test(DatabaseType value) {
                    return value.creatable;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static class OpenableTester
            implements FilterFactory.FilterTest<DatabaseType> {
                private OpenableTester() {
                }

                @Override
                public boolean test(DatabaseType value) {
                    return value.openable;
                }
            }
        }
    }

    public static interface CommandLineParameterEnum {
        public String getCommandLineParameter();
    }
}

