/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory;
import com.ibm.gsk.ikeyman.command.FilterFactory;
import com.ibm.gsk.ikeyman.command.LabelMap;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.cli.CommandParser;
import com.ibm.gsk.ikeyman.command.password.PasswordCallbackHandlerFactory;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.io.CertificateWriter;
import com.ibm.gsk.ikeyman.io.SecretKeyWriter;
import com.ibm.gsk.ikeyman.keystore.EntryValidatorFactory;
import com.ibm.gsk.ikeyman.keystore.KeyStoreItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.CACertificates;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.Displayable;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreDefaultCert;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreModifyCert;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStorePasswordExpiry;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStorePasswordStash;
import com.ibm.gsk.ikeyman.keystore.ext.TreeDisplayer;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.StateMachineFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;

public class CommandFactory {
    private static Map<Constants.CommandType, Class<? extends Command>> commandMap = new HashMap<Constants.CommandType, Class<? extends Command>>();
    private static CallbackHandler passwordHandler = PasswordCallbackHandlerFactory.getCLIHandler();

    public static void setCallbackHandler(CallbackHandler handler) {
        Debug.entering(handler);
        passwordHandler = handler;
        Debug.exiting();
    }

    public static Command getCommand(ParameterMap map) throws KeyManagerException {
        Debug.entering(map);
        try {
            Constructor<? extends Command> c = commandMap.get(map.getCommandType()).getConstructor(ParameterMap.class);
            Debug.exiting();
            return c.newInstance(map);
        }
        catch (Exception e) {
            Debug.throwing(e);
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.OBJECT_INSTANTIATION_ERROR, (Throwable)e);
        }
    }

    private static void validateSAN(CommandParameters params) throws KeyManagerException {
        Debug.entering(params);
        if (!params.getSan().isEmpty() && !KeymanSettings.Setting.SANEnabled.getBoolean().booleanValue()) {
            KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.SAN_SUPPORT_NOT_ENABLED, KeymanSettings.Setting.SANEnabled.getPropertyKey(), KeymanSettings.getPropertyFileName());
            Debug.throwing(e);
            throw e;
        }
        Debug.exiting();
    }

    static {
        commandMap.put(Constants.CommandType.AddCert, AddCertCommand.class);
        commandMap.put(Constants.CommandType.AddCertRename, AddCertCommandRename.class);
        commandMap.put(Constants.CommandType.ChangeDBPassword, ChangeDbPasswordCommand.class);
        commandMap.put(Constants.CommandType.CloseDb, CloseDbCommand.class);
        commandMap.put(Constants.CommandType.ConvertDB, ConvertDbCommand.class);
        commandMap.put(Constants.CommandType.CreateCertRequest, CreateCertRequestCommand.class);
        commandMap.put(Constants.CommandType.CreateDB, CreateDbCommand.class);
        commandMap.put(Constants.CommandType.CreateSSCert, CreateSsCertCommand.class);
        commandMap.put(Constants.CommandType.DeleteCert, DeleteCertCommand.class);
        commandMap.put(Constants.CommandType.DeleteCertRequest, DeleteCertRequestCommand.class);
        commandMap.put(Constants.CommandType.DeleteDB, DeleteDbCommand.class);
        commandMap.put(Constants.CommandType.DisplayCert, DisplayCertCommand.class);
        commandMap.put(Constants.CommandType.DisplayCertRequest, DisplayCertRequestCommand.class);
        commandMap.put(Constants.CommandType.DisplayDBPasswordExpiry, DisplayDbPasswordExpiryCommand.class);
        commandMap.put(Constants.CommandType.ExportCert, ExportCertCommand.class);
        commandMap.put(Constants.CommandType.ExtractCert, ExtractCertCommand.class);
        commandMap.put(Constants.CommandType.ExtractCertRequest, ExtractCertRequestCommand.class);
        commandMap.put(Constants.CommandType.ImportCert, ImportCertCommand.class);
        commandMap.put(Constants.CommandType.ListCertRequests, ListCertRequestsCommand.class);
        commandMap.put(Constants.CommandType.ListCerts, ListCertsCommand.class);
        commandMap.put(Constants.CommandType.DisplayDefaultCert, DisplayDefaultCertCommand.class);
        commandMap.put(Constants.CommandType.ListSupportedDBTypes, ListSupportedDbTypesCommand.class);
        commandMap.put(Constants.CommandType.LoadDB, LoadDbCommand.class);
        commandMap.put(Constants.CommandType.ModifyCert, ModifyCertCommand.class);
        commandMap.put(Constants.CommandType.ReceiveCert, ReceiveCertCommand.class);
        commandMap.put(Constants.CommandType.RecreateCertRequest, RecreateCertRequestCommand.class);
        commandMap.put(Constants.CommandType.SetDefaultCert, SetDefaultCertCommand.class);
        commandMap.put(Constants.CommandType.SignCert, SignCertCommand.class);
        commandMap.put(Constants.CommandType.StashDBPassword, StashDbPasswordCommand.class);
        commandMap.put(Constants.CommandType.Version, VersionCommand.class);
        commandMap.put(Constants.CommandType.Help, HelpCommand.class);
        commandMap.put(Constants.CommandType.AddProvider, AddProviderCommand.class);
        commandMap.put(Constants.CommandType.CreateSecretKey, CreateSecretKeyCommand.class);
        commandMap.put(Constants.CommandType.DisplaySecretKey, DisplaySecretKeyCommand.class);
        commandMap.put(Constants.CommandType.DeleteSecretKey, DeleteSecretKeyCommand.class);
        commandMap.put(Constants.CommandType.RenameSecretKey, RenameSecretKeyCommand.class);
        commandMap.put(Constants.CommandType.ImportSecretKey, ImportSecretKeyCommand.class);
        commandMap.put(Constants.CommandType.ExportSecretKey, ExportSecretKeyCommand.class);
        commandMap.put(Constants.CommandType.ListSecretKeys, ListSecretKeysCommand.class);
        commandMap.put(Constants.CommandType.Populate, PopulateCommand.class);
        commandMap.put(Constants.CommandType.ListSigners, ListSignerCommand.class);
        commandMap.put(Constants.CommandType.ImportCertRename, ImportCertCommandRename.class);
        commandMap.put(Constants.CommandType.RefreshLists, LoadDbCommand.class);
        commandMap.put(Constants.CommandType.RenameCert, RenameCertCommand.class);
    }

    static class AddProviderCommand
    extends Command {
        private static final String KEY_STORE_PREFIX = "KeyStore.";

        public AddProviderCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.ProviderClass, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException {
            Object obj;
            Class<?> cl;
            String classNameParam;
            Debug.entering(params, listener, view);
            String className = classNameParam = params.getProviderClassName();
            String[] constructorParams = null;
            Class[] constructorClassList = null;
            if (classNameParam.length() > 0) {
                StateMachineFactory.MainParser parser = StateMachineFactory.getMainParser();
                try {
                    for (int i = 0; i < classNameParam.length(); ++i) {
                        parser.handle(Character.valueOf(classNameParam.charAt(i)));
                    }
                }
                catch (Exception e) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.CLASS_NOT_FOUND, (Throwable)e, classNameParam);
                }
                String[] splitParams = parser.getTokens();
                className = splitParams[0];
                constructorParams = new String[splitParams.length - 1];
                constructorClassList = new Class[splitParams.length - 1];
                for (int i = 1; i < splitParams.length; ++i) {
                    constructorParams[i - 1] = splitParams[i];
                    constructorClassList[i - 1] = String.class;
                }
            }
            try {
                cl = Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CLASS_NOT_FOUND, (Throwable)e1, className);
            }
            try {
                Constructor<?> constr = cl.getConstructor(constructorClassList);
                obj = constr.newInstance(constructorParams);
            }
            catch (Exception e1) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CANNOT_INSTANTIATE_OBJECT, (Throwable)e1, params.getProviderClassName());
            }
            if (obj instanceof Provider) {
                Provider prov = (Provider)obj;
                int index = Security.addProvider(prov);
                if (index == -1) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.PROVIDER_ALREADY_INSTALLED, params.getProviderClassName());
                }
                Set<Object> set = prov.keySet();
                for (String string : set) {
                    if (!string.startsWith(KEY_STORE_PREFIX)) continue;
                    String tempKS = string.substring(KEY_STORE_PREFIX.length());
                    try {
                        KeyStore.getInstance(tempKS, prov.getName());
                        break;
                    }
                    catch (Exception e) {
                        Security.removeProvider(prov.getName());
                        throw new KeyManagerException(KeyManagerException.ExceptionReason.KEY_STORE_INSTANTIATION_ERROR, (Throwable)e, tempKS);
                    }
                }
                this.fireKeyManagerEventProviderAdded(listener, prov.getName());
                Debug.exiting(null);
                return null;
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NOT_A_PROVIDER, params.getProviderClassName());
        }
    }

    static class HelpCommand
    extends Command {
        public HelpCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(new ValidatorFactory.Validation[0]), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException {
            Debug.entering(params, listener, view);
            view.showMessage(CommandParser.getProgramUsage());
            Debug.exiting(null);
            return null;
        }
    }

    static class VersionCommand
    extends Command {
        public VersionCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(new ValidatorFactory.Validation[0]), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException {
            Debug.entering(params, listener, view);
            String versionString = KeymanUtil.getVersionString();
            view.showMessage(versionString, Messages.getString("GUI.Title.About"));
            Debug.exiting(null);
            return null;
        }
    }

    static class ListSecretKeysCommand
    extends Command {
        public ListSecretKeysCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            DatabaseDescriptorFactory.DatabaseDescriptor sourceDescriptor = params.getSourceDescriptor(passwordHandler);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> ks = this.getValidKeystoreItem(sourceDescriptor);
            if (!ks.supportsEntry(SecretKeyItem.class)) {
                KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_TYPE_FOR_ACTION, Constants.CommandType.ListSecretKeys.toString(), ks.getDescriptor().getType().toString());
                Debug.throwing(e);
                throw e;
            }
            Displayable[] items = ks.getEntries(SecretKeyItem.class).toArray(new Displayable[0]);
            if (items.length > 0) {
                view.showMessage(MessageFormat.format(Messages.getString("Message.SecretKeysIn"), sourceDescriptor.toString()));
                for (Displayable item : items) {
                    view.showMessage("   " + ((Object)item).toString());
                }
            } else {
                view.showMessage(Messages.getString("Message.NoSecretKeyFound"));
            }
            Debug.exiting(null);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExportSecretKeyCommand
    extends Command {
        public ExportSecretKeyCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.Label, Constants.Parameter.LabelRange), ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.KeyAlias, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.File, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
        }

        @Override
        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            if (!item.supportsEntry(SecretKeyItem.class)) {
                KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_TYPE_FOR_ACTION, Constants.CommandType.ExportSecretKey.toString(), item.getDescriptor().getType().toString());
                Debug.throwing(e);
                throw e;
            }
            CertificateItem keyItem = item.getEntry(params.getKeyAlias(), CertificateItem.class, KeyManagerException.ExceptionReason.NO_CERTIFICATE_FOR_LABEL);
            Collection<Entry> entries = this.getKeys(item, params);
            OutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(params.getFile()));
                SecretKeyWriter writer = new SecretKeyWriter(os);
                for (Entry tempEntry : entries) {
                    SecretKeyItem entry = (SecretKeyItem)tempEntry;
                    byte[] encrypted = entry.encryptKey(keyItem.getPublicKey(), item.getKeyCreator().getProvider());
                    writer.write(entry.getLabel(), entry.getAlgorithm(), encrypted);
                }
            }
            catch (FileNotFoundException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_FILE_CREATION_ERROR, (Throwable)e, params.getFile());
            }
            catch (IOException e) {
                if (e.getMessage() != null) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR_MSG, (Throwable)e, e.getMessage());
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        Debug.log(e.toString(), new Object[0]);
                    }
                }
            }
            Debug.exiting(null);
            return null;
        }

        private Collection<Entry> getKeys(KeyStoreItem<?> item, CommandParameters params) throws KeyManagerException {
            if (params.isParameterPresent(Constants.Parameter.LabelRange)) {
                Collection<Entry> items = item.getEntries(SecretKeyItem.class);
                FilterFactory.Filter<Entry> filter = FilterFactory.getAliasRangeFilter(params);
                return filter.filter(items);
            }
            ArrayList<Entry> returnList = new ArrayList<Entry>();
            List<String> aliases = params.getLabels();
            for (String alias : aliases) {
                returnList.add(item.getEntry(alias, SecretKeyItem.class, KeyManagerException.ExceptionReason.NO_KEY_FOR_LABEL));
            }
            return returnList;
        }
    }

    static class ImportSecretKeyCommand
    extends Command {
        public ImportSecretKeyCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.KeyAlias, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.File, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
        }

        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            if (!item.supportsEntry(SecretKeyItem.class)) {
                KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_TYPE_FOR_ACTION, Constants.CommandType.ImportSecretKey.toString(), item.getDescriptor().getType().toString());
                Debug.throwing(e);
                throw e;
            }
            CertificateKeyItem keyItem = item.getEntry(params.getKeyAlias(), CertificateKeyItem.class, KeyManagerException.ExceptionReason.NO_KEY_FOR_LABEL);
            Collection<SecretKeyItem> secretKeys = EntryFactory.loadSecretKeys(params.getFile(), keyItem.getPrivateKey(), item.getKeyCreator().getProvider());
            keyItem = null;
            item.addAll(secretKeys, false, false, KeyStoreItem.ValidationMode.ADD);
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            Debug.exiting(null);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RenameSecretKeyCommand
    extends AbstractRenameCommand {
        public RenameSecretKeyCommand(ParameterMap map) {
            super(map);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected Entry getEntry(KeyStoreItem<?> item, CommandParameters params) throws KeyManagerException {
            return item.getEntry(params.getLabel(), SecretKeyItem.class, KeyManagerException.ExceptionReason.NO_KEY_FOR_LABEL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DisplaySecretKeyCommand
    extends AbstractDisplayCommand {
        public DisplaySecretKeyCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected Displayable getItem(KeyStoreItem<?> ks, CommandParameters params) throws KeyManagerException {
            return ks.getEntry(params.getLabel(), SecretKeyItem.class, KeyManagerException.ExceptionReason.NO_KEY_FOR_LABEL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DeleteSecretKeyCommand
    extends AbstractDeleteCommand {
        public DeleteSecretKeyCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected void validateEntry(KeyStoreItem<?> item, CommandParameters params) throws KeyManagerException {
            item.getEntry(params.getLabel(), SecretKeyItem.class, KeyManagerException.ExceptionReason.NO_KEY_FOR_LABEL);
        }

        @Override
        protected String getLabel(CommandParameters param) throws KeyManagerException {
            return param.getLabel();
        }
    }

    static class CreateSecretKeyCommand
    extends Command {
        public CreateSecretKeyCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.Label, Constants.Parameter.LabelRange), ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.KeyAlgorithm, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.KeySize, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
        }

        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            if (!item.supportsEntry(SecretKeyItem.class)) {
                KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_TYPE_FOR_ACTION, Constants.CommandType.CreateSecretKey.toString(), item.getDescriptor().getType().toString());
                Debug.throwing(e);
                throw e;
            }
            Map<String, SecretKey> keyMap = item.getKeyCreator().generateSecretKeys(params);
            Set<String> labels = keyMap.keySet();
            for (String label : labels) {
                SecretKeyItem secretKeyItem = EntryFactory.newSecretKey(label, keyMap.get(label));
                item.add((DatabaseDescriptorFactory.DatabaseDescriptor)((Object)secretKeyItem));
            }
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            Debug.exiting(null);
            return null;
        }
    }

    static class RecreateCertRequestCommand
    extends Command {
        public RecreateCertRequestCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.Target, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            Object entry = item.getItem(params.getLabel());
            if (!(entry instanceof CertificateKeyItem)) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_KEY_FOR_LABEL, params.getLabel());
            }
            CertificateKeyItem certificateKeyItem = (CertificateKeyItem)entry;
            CertificateRequestKeyItem certReq = certificateKeyItem.toCertRequest(item.getKeyCreator().getProvider());
            certReq.extract(params.getTarget(), null);
            Debug.exiting(null);
            return null;
        }
    }

    static class ListCertRequestsCommand
    extends Command {
        public ListCertRequestsCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            DatabaseDescriptorFactory.DatabaseDescriptor sourceDescriptor = params.getSourceDescriptor(passwordHandler);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> ks = this.getValidKeystoreItem(sourceDescriptor);
            Displayable[] items = ks.getEntries(CertificateRequestKeyItem.class).toArray(new Displayable[0]);
            if (items.length > 0) {
                view.showMessage(MessageFormat.format(Messages.getString("Message.CertRequestsIn"), sourceDescriptor.toString()));
                for (Displayable item : items) {
                    view.showMessage("   " + ((Object)item).toString());
                }
            } else {
                view.showMessage(Messages.getString("Message.NoRequestKeyFound"));
            }
            Debug.exiting(null);
            return null;
        }
    }

    static class ExtractCertRequestCommand
    extends Command {
        public ExtractCertRequestCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.Target, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.Format, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            CertificateRequestKeyItem entry = item.getEntry(params.getLabel(), CertificateRequestKeyItem.class, KeyManagerException.ExceptionReason.NO_REQUEST_FOR_LABEL);
            entry.extract(params.getTarget(), null);
            Debug.exiting(null);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DisplayCertRequestCommand
    extends AbstractDisplayCommand {
        public DisplayCertRequestCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.ShowOID, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected Displayable getItem(KeyStoreItem<?> ks, CommandParameters params) throws KeyManagerException {
            return ks.getEntry(params.getLabel(), CertificateRequestKeyItem.class, KeyManagerException.ExceptionReason.NO_REQUEST_FOR_LABEL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DeleteCertRequestCommand
    extends AbstractDeleteCommand {
        public DeleteCertRequestCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected void validateEntry(KeyStoreItem<?> item, CommandParameters params) throws KeyManagerException {
            item.getEntry(params.getLabel(), CertificateRequestKeyItem.class, KeyManagerException.ExceptionReason.NO_REQUEST_FOR_LABEL);
        }

        @Override
        protected String getLabel(CommandParameters param) throws KeyManagerException {
            return param.getLabel();
        }
    }

    static class CreateCertRequestCommand
    extends Command {
        private static final Map<Constants.Parameter, Object> defaults = new HashMap<Constants.Parameter, Object>();

        public CreateCertRequestCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.File, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.DN, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Size, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SigAlg, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SanDnsName, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SanEmailAddress, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SanIpAddress, ValidatorFactory.always())), defaults);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            CommandFactory.validateSAN(params);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            KeyPair keypair = item.getKeyCreator().generateKeyPair(params);
            CertificateRequestKeyItem requestItem = EntryFactory.newCertificateRequestItem(params, keypair, params.getSigAlg().toString(), item.getKeyCreator().getProvider());
            requestItem.extract(params.getFile(), null);
            item.add((DatabaseDescriptorFactory.DatabaseDescriptor)((Object)requestItem));
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            ControlObjectFactory.ControlObject returnObject = ControlObjectFactory.newMessage(MessageFormat.format(Messages.getString("Message.NewCertRequest"), params.getFile()));
            Debug.exiting(returnObject);
            return returnObject;
        }

        static {
            defaults.put(Constants.Parameter.Size, KeymanSettings.Setting.DefaultKeySize.getInteger());
            defaults.put(Constants.Parameter.SigAlg, KeymanSettings.DEFAULT_SIGNATURE_ALGORITHM);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RenameCertCommand
    extends AbstractRenameCommand {
        public RenameCertCommand(ParameterMap map) {
            super(map);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected Entry getEntry(KeyStoreItem<?> item, CommandParameters params) throws KeyManagerException {
            Debug.entering(item, params);
            CertificateItem returnValue = item.getCertificate(params.getLabel());
            Debug.exiting(returnValue);
            return returnValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractRenameCommand
    extends Command {
        private static final EntryValidatorFactory.EntryValidator entryValidator = EntryValidatorFactory.newDuplicateLabelValidator();

        protected AbstractRenameCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.NewLabel, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SecondaryDb, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbPassword, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbType, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb))), null);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            Entry entryItem = this.getEntry(item, params);
            entryItem.setLabel(params.getNewLabel());
            entryValidator.validate(entryItem, item);
            item.delete(params.getLabel());
            item.add((DatabaseDescriptorFactory.DatabaseDescriptor)((Object)entryItem));
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            Debug.exiting(null);
            return null;
        }

        protected abstract Entry getEntry(KeyStoreItem<?> var1, CommandParameters var2) throws KeyManagerException;
    }

    static class SignCertCommand
    extends Command {
        private static final Map<Constants.Parameter, Object> defaults = new HashMap<Constants.Parameter, Object>();

        public SignCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.File, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Expire, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Format, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Target, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SerNum, ValidatorFactory.always())), defaults);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            Object entry = item.getItem(params.getLabel());
            CertificateRequestItem certRequest = EntryFactory.loadCertificateRequestItem("dummyLabel", params.getFile());
            if (!(entry instanceof CertificateKeyItem)) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_KEY_FOR_LABEL, params.getLabel());
            }
            CertificateKeyItem certificateKeyItem = (CertificateKeyItem)entry;
            Integer serialNumber = params.isParameterPresent(Constants.Parameter.SerNum) ? params.getSerNum() : null;
            CertificateItem signedCert = certRequest.sign(certificateKeyItem, params.getExpire(), serialNumber, item.getKeyCreator().getProvider());
            signedCert.extract(params.getTarget(), params.getFormat());
            Debug.exiting(null);
            return null;
        }

        static {
            defaults.put(Constants.Parameter.Expire, KeymanSettings.Setting.DefaultCertExpire.getInteger());
            defaults.put(Constants.Parameter.Format, KeymanSettings.Setting.DefaultCertFormat.getValue(CertificateWriter.OutputMode.class, new CertificateWriter.OutputMode.OutputModeParser()));
            defaults.put(Constants.Parameter.Target, KeymanSettings.TARGET_DEFAULT);
        }
    }

    static class ModifyCertCommand
    extends Command {
        private static final Map<Constants.Parameter, Object> defaults = new HashMap<Constants.Parameter, Object>();

        public ModifyCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Trust, ValidatorFactory.always())), defaults);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            if (!(item instanceof KeyStoreModifyCert)) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_TYPE_FOR_ACTION, Constants.CommandType.ModifyCert.toString(), item.getDescriptor().getType().toString());
            }
            ((KeyStoreModifyCert)((Object)item)).modifyCertificate(params.getLabel(), params.isTrust());
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            Debug.exiting(null);
            return null;
        }

        static {
            defaults.put(Constants.Parameter.Trust, KeymanSettings.Setting.DefaultCertTrust.getBoolean());
        }
    }

    static class ListSignerCommand
    extends Command {
        public ListSignerCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(new ValidatorFactory.Validation[0]), null);
        }

        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            if (!(view instanceof TreeDisplayer)) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ARGUMENT, "Parameter to run function must be a TreeDisplayer.");
            }
            ((TreeDisplayer)((Object)view)).displayTree(CACertificates.getCertificateTree());
            Debug.exiting(null);
            return null;
        }
    }

    static class ListCertsCommand
    extends Command {
        private static final Map<Constants.Parameter, Object> defaults = new HashMap<Constants.Parameter, Object>();

        public ListCertsCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.optional(Constants.Parameter.ListFilter, ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.Expiry, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SecondaryDb, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbPassword, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbType, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb))), defaults);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            FilterFactory.Filter<CertificateItem> filter = FilterFactory.getCertificateFilter(params);
            DatabaseDescriptorFactory.DatabaseDescriptor sourceDescriptor = params.getSourceDescriptor(passwordHandler);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> ks = this.getValidKeystoreItem(sourceDescriptor);
            CertificateItem[] items = filter.filter(ks.getEntries(CertificateItem.class)).toArray(new CertificateItem[0]);
            if (items.length > 0) {
                view.showMessage(MessageFormat.format(Messages.getString("Message.CertificatesIn"), sourceDescriptor.toString()));
                for (CertificateItem item : items) {
                    view.showMessage("   " + item.toString());
                    if (!params.isParameterPresent(Constants.Parameter.Expiry)) continue;
                    view.showMessage("       " + item.getValidity());
                }
            } else {
                view.showMessage(Messages.getString("Message.NoKeyFound"));
            }
            Debug.exiting(null);
            return null;
        }

        static {
            defaults.put(Constants.Parameter.ListFilter, (Object)KeymanSettings.Setting.DefaultListOption.getValue(Constants.ListFilter.class, new Constants.ListFilter.ListFilterParser()));
        }
    }

    static class SetDefaultCertCommand
    extends Command {
        public SetDefaultCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            if (!(item instanceof KeyStoreDefaultCert)) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_TYPE_FOR_ACTION, Constants.CommandType.SetDefaultCert.toString(), item.getDescriptor().getType().toString());
            }
            ((KeyStoreDefaultCert)((Object)item)).setDefaultCertificate(params.getLabel());
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            Debug.exiting(null);
            return null;
        }
    }

    static class DisplayDefaultCertCommand
    extends Command {
        public DisplayDefaultCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            if (view == null) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NULL_PARAMETER, "view parameter to run function is missing");
            }
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> ks = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            if (!(ks instanceof KeyStoreDefaultCert)) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_TYPE_FOR_ACTION, Constants.CommandType.DisplayDefaultCert.toString(), ks.getDescriptor().getType().toString());
            }
            String defaultLabel = ((KeyStoreDefaultCert)((Object)ks)).getDefaultCertificate();
            Object item = ks.getItem(defaultLabel);
            view.displayDetails((Displayable)item);
            Debug.exiting(null);
            return null;
        }
    }

    static class ExtractCertCommand
    extends Command {
        private static final Map<Constants.Parameter, Object> defaults = new HashMap<Constants.Parameter, Object>();

        public ExtractCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.Target, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.Format, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SecondaryDb, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbPassword, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbType, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb))), defaults);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            CertificateItem entry = item.getCertificate(params.getLabel());
            entry.extract(params.getTarget(), params.getFormat());
            Debug.exiting(null);
            return null;
        }

        static {
            defaults.put(Constants.Parameter.Format, KeymanSettings.Setting.DefaultCertFormat.getValue(CertificateWriter.OutputMode.class, new CertificateWriter.OutputMode.OutputModeParser()));
        }
    }

    static class ImportCertCommand
    extends AbstractImportCommand {
        public ImportCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.File), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.Target, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SecondPassword, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.TargetPassword, ValidatorFactory.itemPresent(Constants.Parameter.Target)), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.TargetType, ValidatorFactory.itemPresent(Constants.Parameter.Target)), ValidatorFactory.optional(Constants.Parameter.NewLabel, ValidatorFactory.itemPresent(Constants.Parameter.Label)), ValidatorFactory.optional(Constants.Parameter.SecondaryDb, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbPassword, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbType, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.Pfx, ValidatorFactory.and(ValidatorFactory.itemPresent(Constants.Parameter.File), ValidatorFactory.not(ValidatorFactory.itemPresent(Constants.Parameter.Label))))), null);
            Debug.entering();
            Debug.exiting();
        }
    }

    static class ImportCertCommandRename
    extends AbstractImportCommand {
        public ImportCertCommandRename(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.File), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.Target, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.LabelMap, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SecondPassword, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.TargetPassword, ValidatorFactory.itemPresent(Constants.Parameter.Target)), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.TargetType, ValidatorFactory.itemPresent(Constants.Parameter.Target)), ValidatorFactory.optional(Constants.Parameter.SecondaryDb, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbPassword, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbType, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.Pfx, ValidatorFactory.and(ValidatorFactory.itemPresent(Constants.Parameter.File), ValidatorFactory.not(ValidatorFactory.itemPresent(Constants.Parameter.Label))))), null);
            Debug.entering();
            Debug.exiting();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractImportCommand
    extends Command {
        protected AbstractImportCommand(ParameterMap map, ValidatorFactory.Validator validator, Map<Constants.Parameter, Object> defaults) {
            super(map, validator, defaults);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> source = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> target = this.getValidKeystoreItem(params.getTargetDescriptor(passwordHandler));
            if (params.isParameterPresent(Constants.Parameter.LabelMap)) {
                LabelMap labels = params.getLabelMap();
                AbstractImportCommand.importCertHelper(source, target, labels, false);
            } else if (params.isParameterPresent(Constants.Parameter.Label)) {
                String label = params.getLabel();
                String newLabel = params.isParameterPresent(Constants.Parameter.NewLabel) ? params.getNewLabel() : label;
                LabelMap labels = new LabelMap(label, newLabel);
                AbstractImportCommand.importCertHelper(source, target, labels, false);
            } else {
                Collection<String> sourceAliases = source.getAliases();
                LabelMap labels = new LabelMap(sourceAliases);
                AbstractImportCommand.importCertHelper(source, target, labels, true);
            }
            this.fireKeyManagerEventDatabaseChanged(listener, target);
            Debug.exiting(null);
            return null;
        }

        private static void importCertHelper(KeyStoreItem<?> source, KeyStoreItem<?> target, LabelMap labels, boolean ignoreExisting) throws KeyManagerException {
            Debug.entering(source, target, labels, ignoreExisting);
            ArrayList importEntries = new ArrayList();
            for (String oldLabel : labels.getOldLabels()) {
                Object sourceItem = source.getItem(oldLabel);
                sourceItem.setLabel(labels.getNewLabel(oldLabel));
                importEntries.add(sourceItem);
            }
            target.addAll(importEntries, ignoreExisting, false, KeyStoreItem.ValidationMode.IMPORT);
            Debug.exiting();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReceiveCertCommand
    extends DefaultableCommand {
        public ReceiveCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.File, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.Format, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.DefaultCert, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected String addKey(KeyStoreItem<?> item, CommandParameters params) throws KeyManagerException {
            Debug.entering(item, params);
            Collection<CertificateItem> newCerts = EntryFactory.loadCertificateItems(params.getFile(), item.getKeyCreator().getProvider());
            String returnValue = item.receiveCertificate(newCerts);
            Debug.exiting(returnValue);
            return returnValue;
        }
    }

    static class ExportCertCommand
    extends Command {
        public ExportCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.Target, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.TargetPassword, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.TargetType, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Encryption, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> target;
            Debug.entering(params, listener, view);
            String label = params.getLabel();
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> source = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            try {
                target = this.getValidKeystoreItem(params.getTargetDescriptor(passwordHandler));
            }
            catch (KeyManagerException e) {
                if (e.getReason() == KeyManagerException.ExceptionReason.INPUT_FILE_NOT_FOUND) {
                    try {
                        target = KeyStoreItemFactory.createKeyStore(params.getTargetDescriptor(passwordHandler));
                    }
                    catch (CancelledException e1) {
                        return null;
                    }
                    target.clear();
                }
                throw e;
            }
            Object entry = source.getItem(label);
            if (!(entry instanceof CertificateKeyItem)) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_KEY_FOR_LABEL, label);
            }
            target.add((DatabaseDescriptorFactory.DatabaseDescriptor)entry);
            this.fireKeyManagerEventDatabaseChanged(listener, target);
            Debug.exiting(null);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DisplayCertCommand
    extends AbstractDisplayCommand {
        public DisplayCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.ShowOID, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SecondaryDb, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbPassword, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbType, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb))), null);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected Displayable getItem(KeyStoreItem<?> ks, CommandParameters params) throws KeyManagerException {
            return ks.getCertificate(params.getLabel());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DeleteCertCommand
    extends AbstractDeleteCommand {
        public DeleteCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.SecondaryDb, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbPassword, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbType, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb))), null);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected void validateEntry(KeyStoreItem<?> item, CommandParameters params) throws KeyManagerException {
            item.getEntry(params.getLabel(), CertificateItem.class, KeyManagerException.ExceptionReason.NO_CERTIFICATE_FOR_LABEL);
        }

        @Override
        protected String getLabel(CommandParameters param) throws KeyManagerException {
            return param.getLabel();
        }
    }

    static class PopulateCommand
    extends Command {
        public PopulateCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.SecondaryDb, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbPassword, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbType, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb))), null);
            Debug.entering();
            Debug.exiting();
        }

        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            List<String> labels = params.getLabels();
            ArrayList<CertificateItem> caCerts = new ArrayList<CertificateItem>();
            for (String label : labels) {
                Collection<CertificateItem> certs = CACertificates.getCACertificates(label);
                if (certs == null) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_CA_CERT_FOR_LABEL, label, Constants.CommandType.ListSigners.getCommandLineParameter());
                }
                for (CertificateItem cert : certs) {
                    caCerts.add(cert);
                }
            }
            item.addAll(caCerts, true, false, KeyStoreItem.ValidationMode.IMPORT);
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            Debug.exiting(null);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AddCertCommandRename
    extends AbstractAddCommand {
        public AddCertCommandRename(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.LabelMap, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.File, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.Format, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Trust, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected List<CertificateItem> getCertsToAdd(List<CertificateItem> items, CommandParameters params) throws KeyManagerException {
            Debug.entering(items, params);
            LabelMap labels = params.getLabelMap();
            ArrayList<CertificateItem> addEntries = new ArrayList<CertificateItem>();
            block0: for (CertificateItem item : items) {
                for (String oldLabel : labels.getOldLabels()) {
                    if (!item.getLabel().equalsIgnoreCase(oldLabel)) continue;
                    item.setLabel(labels.getNewLabel(oldLabel));
                    addEntries.add(item);
                    continue block0;
                }
            }
            Debug.exiting(addEntries);
            return addEntries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AddCertCommand
    extends AbstractAddCommand {
        public AddCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.File, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.Format, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Trust, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SecondaryDb, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbPassword, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbType, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb))), null);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected List<CertificateItem> getCertsToAdd(List<CertificateItem> items, CommandParameters params) throws KeyManagerException {
            Debug.entering(items, params);
            if (params.isParameterPresent(Constants.Parameter.Label)) {
                items = EntryFactory.reorderCertChain(items);
                items.get(0).setLabel(params.getLabel());
            }
            Debug.exiting(items);
            return items;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractAddCommand
    extends Command {
        protected AbstractAddCommand(ParameterMap map, ValidatorFactory.Validator validator, Map<Constants.Parameter, Object> defaults) {
            super(map, validator, defaults);
            Debug.entering();
            Debug.exiting();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            ArrayList<CertificateItem> certItems = new ArrayList<CertificateItem>(EntryFactory.loadCertificateItems(params.getFile(), item.getKeyCreator().getProvider()));
            List<CertificateItem> itemsToAdd = this.getCertsToAdd(certItems, params);
            boolean trust = true;
            if (params.isParameterPresent(Constants.Parameter.Trust) && !params.isTrust()) {
                if (!(item instanceof KeyStoreModifyCert)) throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_DATABASE_TYPE_FOR_PARAMETER, Constants.Parameter.Trust.toString(), item.getDescriptor().getType().toString());
                trust = false;
            } else if (item instanceof KeyStoreModifyCert && KeymanSettings.Setting.DefaultCertTrust.getBoolean() != null) {
                trust = KeymanSettings.Setting.DefaultCertTrust.getBoolean();
            }
            item.addAll(itemsToAdd, false, false, KeyStoreItem.ValidationMode.ADD);
            if (!trust) {
                for (CertificateItem cert : itemsToAdd) {
                    ((KeyStoreModifyCert)((Object)item)).modifyCertificate(cert.getLabel(), trust);
                }
            }
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            Debug.exiting(null);
            return null;
        }

        protected abstract List<CertificateItem> getCertsToAdd(List<CertificateItem> var1, CommandParameters var2) throws KeyManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CreateSsCertCommand
    extends DefaultableCommand {
        private static final Map<Constants.Parameter, Object> defaults = new HashMap<Constants.Parameter, Object>();

        public CreateSsCertCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.required(Constants.Parameter.Label, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.DN, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.Expire, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Size, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.X509Version, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.DefaultCert, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.CA, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SigAlg, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SanDnsName, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SanEmailAddress, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.SanIpAddress, ValidatorFactory.always())), defaults);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected String addKey(KeyStoreItem<?> item, CommandParameters params) throws KeyManagerException {
            Debug.entering(item, params);
            CommandFactory.validateSAN(params);
            KeyPair keypair = item.getKeyCreator().generateKeyPair(params);
            CertificateKeyItem certificateKeyItem = EntryFactory.newKeyItem(params, keypair, params.getSigAlg().toString(), item.getKeyCreator().getProvider());
            item.add(certificateKeyItem);
            Debug.exiting(certificateKeyItem.getLabel());
            return certificateKeyItem.getLabel();
        }

        static {
            defaults.put(Constants.Parameter.Size, KeymanSettings.Setting.DefaultKeySize.getInteger() + "");
            defaults.put(Constants.Parameter.X509Version, KeymanSettings.X509_VERSION_DEFAULT);
            defaults.put(Constants.Parameter.Expire, KeymanSettings.Setting.DefaultCertExpire.getInteger());
            defaults.put(Constants.Parameter.SigAlg, KeymanSettings.DEFAULT_SIGNATURE_ALGORITHM);
            defaults.put(Constants.Parameter.CA, KeymanSettings.Setting.DefaultSSCertBasicConstraints.getBoolean());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class DefaultableCommand
    extends Command {
        protected DefaultableCommand(ParameterMap map, ValidatorFactory.Validator validator, Map<Constants.Parameter, Object> defaults) {
            super(map, validator, defaults);
            Debug.entering();
            Debug.exiting();
        }

        @Override
        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            if (params.isParameterPresent(Constants.Parameter.DefaultCert) && !(item instanceof KeyStoreDefaultCert)) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_DATABASE_TYPE_FOR_PARAMETER, Constants.Parameter.DefaultCert.toString(), item.getDescriptor().getType().toString());
            }
            String keyLabel = this.addKey(item, params);
            ControlObjectFactory.ControlObject ctrlObj = null;
            ParameterMap map = item.getDescriptor().getDatabaseParameters(false);
            map.put(Constants.Parameter.Label, keyLabel);
            map.put(Constants.CommandType.SetDefaultCert);
            Command command = CommandFactory.getCommand(map);
            if (params.isParameterPresent(Constants.Parameter.DefaultCert) && params.isDefaultCert()) {
                command.invoke(this.loader, listener, view);
            } else if (KeymanSettings.Setting.DefaultCertDefault.getBoolean() != null && item instanceof KeyStoreDefaultCert) {
                if (KeymanSettings.Setting.DefaultCertDefault.getBoolean().booleanValue()) {
                    command.invoke(this.loader, listener, view);
                }
            } else if (controlObjectsEnabled && item instanceof KeyStoreDefaultCert) {
                if (item.getEntries(CertificateKeyItem.class).size() > 1) {
                    ctrlObj = ControlObjectFactory.newChoiceCommand(Messages.getString("Question.SetDefaultKey"), command, null);
                } else if (item.getEntries(CertificateKeyItem.class).size() == 1) {
                    ctrlObj = ControlObjectFactory.newCommandObject(command);
                }
            }
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            Debug.exiting(ctrlObj);
            return ctrlObj;
        }

        protected abstract String addKey(KeyStoreItem<?> var1, CommandParameters var2) throws KeyManagerException;
    }

    static class DisplayDbPasswordExpiryCommand
    extends Command {
        public DisplayDbPasswordExpiryCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            if (!(item instanceof KeyStorePasswordExpiry)) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_TYPE_FOR_ACTION, Constants.CommandType.DisplayDBPasswordExpiry.toString(), item.getDescriptor().getType().toString());
            }
            Date expireTime = ((KeyStorePasswordExpiry)((Object)item)).getPasswordExpiry();
            if (expireTime == null) {
                view.showMessage(Messages.getString("Message.PasswordDoesntExpire"), Messages.getString("GUI.Title.PasswordExpiry"));
            } else {
                view.showMessage(MessageFormat.format(Messages.getString("Message.PasswordExpiry"), KeymanUtil.getLocalisedDateTimeToString(expireTime)), Messages.getString("GUI.Title.PasswordExpiry"));
            }
            Debug.exiting(null);
            return null;
        }
    }

    static class ConvertDbCommand
    extends Command {
        public ConvertDbCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Target, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.NewPassword, ValidatorFactory.always()), ValidatorFactory.optional(ValidatorFactory.choice(Constants.Parameter.OldFormat, Constants.Parameter.Type), ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.NewFormat, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Expire, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.StashPassword, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> convertedItem;
            String targetFileName;
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            Constants.DatabaseType newType = params.isParameterPresent(Constants.Parameter.NewFormat) ? params.getNewFormat() : (params.isParameterPresent(Constants.Parameter.Target) ? DatabaseDescriptorFactory.deriveDatabaseType(new FileName(params.getTarget())) : Constants.DatabaseType.getDefaultType());
            if (params.isParameterPresent(Constants.Parameter.Target)) {
                targetFileName = params.getTarget();
            } else {
                FileName tempName = new FileName(item.getDescriptor().getFileName()).substituteExtension(newType.getDefaultExtension());
                targetFileName = tempName.toString();
            }
            DatabaseDescriptorFactory.DatabaseDescriptor descriptor = DatabaseDescriptorFactory.getDatabaseDescriptor(item.getDescriptor(), newType);
            descriptor.setFileName(targetFileName);
            descriptor.setPassword(params);
            try {
                convertedItem = KeyStoreItemFactory.createKeyStore(descriptor, item.getEntries(Entry.class));
            }
            catch (KeyManagerException e) {
                if (controlObjectsEnabled) {
                    if (e.getReason() == KeyManagerException.ExceptionReason.OUTPUT_FILE_EXISTS) {
                        CompoundCommand yesCommand = new CompoundCommand(new FileDeletionCommand(targetFileName), new CreateAndPopulateCommand(descriptor, item.getEntries(Entry.class)));
                        ControlObjectFactory.ControlObject returnObject = ControlObjectFactory.newChoiceCommand(Messages.getString("Question.ReplaceExistingFile"), yesCommand, null);
                        Debug.exiting(returnObject);
                        return returnObject;
                    }
                    Debug.throwing(e);
                    throw e;
                }
                boolean sameFile = new File(targetFileName).getAbsolutePath().equals(new File(params.getSourceDescriptor(passwordHandler).getFileNameString()).getAbsolutePath());
                if (e.getReason() != KeyManagerException.ExceptionReason.OUTPUT_FILE_EXISTS || !sameFile) {
                    Debug.throwing(e);
                    throw e;
                }
                convertedItem = item;
                convertedItem.changePassword(params);
            }
            this.fireKeyManagerEventDatabaseOpened(listener, convertedItem);
            Debug.exiting(null);
            return null;
        }
    }

    static class LoadDbCommand
    extends Command {
        public LoadDbCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName)), ValidatorFactory.optional(Constants.Parameter.SecondaryDb, ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbPassword, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb)), ValidatorFactory.optional(Constants.Parameter.SecondaryDbType, ValidatorFactory.itemPresent(Constants.Parameter.SecondaryDb))), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            this.fireKeyManagerEventDatabaseOpened(listener, item);
            Debug.exiting(null);
            return null;
        }
    }

    static class ListSupportedDbTypesCommand
    extends Command {
        public ListSupportedDbTypesCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(new ValidatorFactory.Validation[0]), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException {
            Debug.entering(params, listener, view);
            view.showMessage(MessageFormat.format(Messages.getString("Message.SupportedDbTypes"), KeymanUtil.getSupportedDatabaseTypes()));
            Debug.exiting(null);
            return null;
        }
    }

    static class StashDbPasswordCommand
    extends Command {
        public StashDbPasswordCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            if (!(item instanceof KeyStorePasswordStash)) {
                KeyManagerException e = new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_TYPE_FOR_ACTION, Constants.CommandType.StashDBPassword.toString(), item.getDescriptor().getType().toString());
                Debug.throwing(e);
                throw e;
            }
            ((KeyStorePasswordStash)((Object)item)).stashPassword();
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            ControlObjectFactory.ControlObject returnObject = ControlObjectFactory.newMessage(MessageFormat.format(Messages.getString("Message.StashFileCreated"), new FileName(params.getDatabaseName()).changeExtension(".sth")));
            Debug.exiting(returnObject);
            return returnObject;
        }
    }

    static class CloseDbCommand
    extends Command {
        public CloseDbCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.DatabaseName, Constants.Parameter.Crypto), ValidatorFactory.always()), ValidatorFactory.required(ValidatorFactory.choice(Constants.Parameter.RelativeSlotNumber, Constants.Parameter.TokenLabel), ValidatorFactory.itemPresent(Constants.Parameter.Crypto)), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            DatabaseDescriptorFactory.DatabaseDescriptor descriptor = params.getSourceDescriptor(passwordHandler);
            this.closeKeyStoreItem(descriptor);
            this.fireKeyManagerEventDatabaseClosed(listener, descriptor);
            Debug.exiting(null);
            return null;
        }
    }

    static class ChangeDbPasswordCommand
    extends Command {
        public ChangeDbPasswordCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.required(Constants.Parameter.NewPassword, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Expire, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.StashPassword, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getKeystoreItem(params.getSourceDescriptor(passwordHandler));
            item.changePassword(params);
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            Debug.exiting(null);
            return null;
        }
    }

    static class DeleteDbCommand
    extends Command {
        public DeleteDbCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.itemPresent(Constants.Parameter.DatabaseName))), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            item.delete();
            this.closeKeyStoreItem((DatabaseDescriptorFactory.DatabaseDescriptor)item.getDescriptor());
            this.fireKeyManagerEventDatabaseClosed(listener, (DatabaseDescriptorFactory.DatabaseDescriptor)item.getDescriptor());
            Debug.exiting(null);
            return null;
        }
    }

    static class CreateDbCommand
    extends Command {
        public CreateDbCommand(ParameterMap map) {
            super(map, ValidatorFactory.newValidator(ValidatorFactory.required(Constants.Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Password, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Type, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.Expire, ValidatorFactory.always()), ValidatorFactory.optional(Constants.Parameter.StashPassword, ValidatorFactory.always())), null);
            Debug.entering();
            Debug.exiting();
        }

        public ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            try {
                DatabaseDescriptorFactory.DatabaseDescriptor descriptor = params.getSourceDescriptor(passwordHandler);
                if (descriptor.getFileName().getFileExtension().equals("")) {
                    descriptor.getFileName().setExtension(descriptor.getType().getDefaultExtension());
                }
                KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = KeyStoreItemFactory.createKeyStore(descriptor);
                this.fireKeyManagerEventDatabaseOpened(listener, item);
                Debug.exiting(null);
                return null;
            }
            catch (KeyManagerException e) {
                if (controlObjectsEnabled && e.getReason() == KeyManagerException.ExceptionReason.OUTPUT_FILE_EXISTS) {
                    CompoundCommand yesCommand = new CompoundCommand(new FileDeletionCommand(params.getDatabaseName()), this);
                    ControlObjectFactory.ControlObject returnObject = ControlObjectFactory.newChoiceCommand(Messages.getString("Question.ReplaceExistingFile"), yesCommand, null);
                    Debug.exiting(returnObject);
                    return returnObject;
                }
                Debug.throwing(e);
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractDisplayCommand
    extends Command {
        public AbstractDisplayCommand(ParameterMap map, ValidatorFactory.Validator validator, Map<Constants.Parameter, Object> defaults) {
            super(map, validator, defaults);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            if (view == null) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NULL_PARAMETER, "view parameter to run function is missing");
            }
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> ks = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            Displayable item = this.getItem(ks, params);
            if (params.isParameterPresent(Constants.Parameter.ShowOID)) {
                if (!(view instanceof TreeDisplayer)) throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ARGUMENT, "Parameter to run function must be a TreeDisplayer.");
                ((TreeDisplayer)((Object)view)).displayTree(item.toTree());
            } else {
                view.displayDetails(item);
            }
            Debug.exiting(null);
            return null;
        }

        protected abstract Displayable getItem(KeyStoreItem<?> var1, CommandParameters var2) throws KeyManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractDeleteCommand
    extends Command {
        public AbstractDeleteCommand(ParameterMap map, ValidatorFactory.Validator validator, Map<Constants.Parameter, Object> defaults) {
            super(map, validator, defaults);
        }

        @Override
        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = this.getValidKeystoreItem(params.getSourceDescriptor(passwordHandler));
            this.validateEntry(item, params);
            item.delete(this.getLabel(params));
            this.fireKeyManagerEventDatabaseChanged(listener, item);
            Debug.exiting(null);
            return null;
        }

        protected abstract void validateEntry(KeyStoreItem<?> var1, CommandParameters var2) throws KeyManagerException;

        protected abstract String getLabel(CommandParameters var1) throws KeyManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CreateAndPopulateCommand
    extends Command {
        private DatabaseDescriptorFactory.DatabaseDescriptor descriptor;
        private Collection<? extends Entry> entries;

        public CreateAndPopulateCommand(DatabaseDescriptorFactory.DatabaseDescriptor descriptor, Collection<? extends Entry> entries) {
            super(new ParameterMap(), ValidatorFactory.newValidator(new ValidatorFactory.Validation[0]), null);
            Debug.entering();
            this.descriptor = descriptor;
            this.entries = entries;
            Debug.exiting();
        }

        @Override
        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            KeyStoreItem<? extends DatabaseDescriptorFactory.DatabaseDescriptor> item = KeyStoreItemFactory.createKeyStore(this.descriptor, this.entries);
            this.fireKeyManagerEventDatabaseOpened(listener, item);
            Debug.exiting(null);
            return null;
        }
    }

    static class FileDeletionCommand
    extends Command {
        private String[] files;

        public FileDeletionCommand(String ... files) {
            super(new ParameterMap(), ValidatorFactory.newValidator(new ValidatorFactory.Validation[0]), null);
            Debug.entering();
            this.files = files;
            Debug.exiting();
        }

        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            for (String file : this.files) {
                File f = new File(file);
                if (!f.exists() || f.delete()) continue;
                throw new KeyManagerException(KeyManagerException.ExceptionReason.FILE_DELETION_FAILED, file);
            }
            Debug.exiting(null);
            return null;
        }
    }

    static class CompoundCommand
    extends Command {
        private Command[] commands;

        public CompoundCommand(Command ... commands) {
            super(new ParameterMap(), ValidatorFactory.newValidator(new ValidatorFactory.Validation[0]), null);
            Debug.entering();
            this.commands = commands;
            Debug.exiting();
        }

        protected ControlObjectFactory.ControlObject run(CommandParameters params, KeyManagerEventListener listener, Displayer view) throws KeyManagerException, CancelledException {
            Debug.entering(params, listener, view);
            ControlObjectFactory.ControlObject controlObj = null;
            for (Command command : this.commands) {
                ControlObjectFactory.ControlObject temp = null;
                temp = command.invoke(this.loader, listener, view);
                if (temp == null) continue;
                controlObj = temp;
            }
            Debug.exiting(controlObj);
            return controlObj;
        }
    }
}

