/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import java.io.InputStream;

final class IntableByteSequenceFactory {
    private IntableByteSequenceFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static IntableByteSequence newIntableByteSequence(ByteSequence sequence) throws NullPointerException {
        if (sequence == null) {
            throw new NullPointerException();
        }
        return new IntableByteSequenceImpl(sequence);
    }

    public static IntableByteSequence newIntableByteSequence(int value) {
        if (value == 0) {
            return new IntableByteSequenceImpl(ByteSequenceFactory.newConstantByteSequence((byte)0, 4));
        }
        ByteSequence sequence = ByteSequenceFactory.newByteSequence(new Integer(value >> 24 & 0xFF).byteValue()).append(ByteSequenceFactory.newByteSequence(new Integer(value >> 16 & 0xFF).byteValue())).append(ByteSequenceFactory.newByteSequence(new Integer(value >> 8 & 0xFF).byteValue())).append(ByteSequenceFactory.newByteSequence(new Integer(value & 0xFF).byteValue()));
        return new IntableByteSequenceImpl(sequence);
    }

    private static final class IntableByteSequenceImpl
    implements IntableByteSequence {
        private final ByteSequence sequence;
        private int value;
        private boolean valueCalculated;

        IntableByteSequenceImpl(ByteSequence sequence) {
            this.sequence = sequence;
        }

        public int toInt() {
            if (!this.valueCalculated) {
                ByteSequenceIterator it = this.sequence.getIterator();
                while (it.hasNextByte()) {
                    int b = it.getNextByte();
                    if (b < 0) {
                        b += 256;
                    }
                    this.value <<= 8;
                    this.value |= b;
                }
                this.valueCalculated = true;
            }
            return this.value;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.sequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.get(index);
        }

        public int length() {
            return this.sequence.length();
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            return this.sequence.append(sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.sequence.length() || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.getSubSequence(fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            return this.sequence.indexOf(b);
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.indexOf(position, b);
        }

        public int lastIndexOf(byte b) {
            return this.sequence.lastIndexOf(b);
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.lastIndexOf(position, b);
        }

        public boolean isEmpty() {
            return this.sequence.isEmpty();
        }

        public InputStream getInputStream() {
            return this.sequence.getInputStream();
        }

        public ByteSequenceIterator getIterator() {
            return this.sequence.getIterator();
        }

        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.getIterator(position);
        }

        public String toBinaryString() {
            return this.sequence.toBinaryString();
        }

        public String toOctalString() {
            return this.sequence.toOctalString();
        }

        public String toHexString() {
            return this.sequence.toHexString();
        }

        public String toString() {
            return ((Object)this.sequence).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            if (this.sequence.length() != s.length()) {
                return false;
            }
            ByteSequenceIterator it1 = this.getIterator();
            ByteSequenceIterator it2 = s.getIterator();
            while (it1.hasNextByte() && it2.hasNextByte()) {
                byte e2;
                byte e1 = it1.getNextByte();
                if (e1 == (e2 = it2.getNextByte())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return ((Object)this.sequence).hashCode();
        }
    }
}

