/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.AbstractCertificateRequestStore;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadFileTypeException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadMagicNumberException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadRecordFlagException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BadVersionNumberException;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.Buffer;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.BufferFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeader;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeaderFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeaderHashGeneratorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileType;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequence;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequenceFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.MagicNumberValidatorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.QueryableRequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.QueryableRequestDatabaseFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RecordFlag;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabaseFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabaseHashGeneratorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecord;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordDataHashGenerator;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordDataHashGeneratorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncoding;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordEncodingFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.VersionNumber;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.FileModificationTracker;
import com.ibm.gsk.ikeyman.io.LockedFileOutputStream;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.sequence.Sequence;
import com.ibm.gsk.ikeyman.sequence.SequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcsutil.PKCSException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSCertificateRequestFile
extends AbstractCertificateRequestStore<DatabaseDescriptorFactory.CMSDatabaseDescriptor> {
    private static final IntableByteSequence ZERO = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 4));
    private static final IntableByteSequence ZERO_MD5_HASH = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 16));
    private static final int FIXED_RECORD_LENGTH = 5000;
    private static final IntableByteSequence FIXED_RECORD_LENGTH_SEQUENCE = IntableByteSequenceFactory.newIntableByteSequence(5000);
    private static final ByteSequence UNUSED_FILE_LABEL = ByteSequenceFactory.newConstantByteSequence((byte)0, 24);
    public static final String EXTENSION = ".rdb";
    private File file;
    private QueryableRequestDatabase requestDatabase;
    private String storePassword;
    private List<String> aliases;
    private FileModificationTracker tracker;

    protected CMSCertificateRequestFile(File f, String password) throws KeyManagerException {
        this.file = f;
        this.storePassword = password;
        this.tracker = new FileModificationTracker(f.getAbsolutePath());
        this.load();
    }

    protected CMSCertificateRequestFile(File f, String password, QueryableRequestDatabase db) throws KeyManagerException {
        this.file = f;
        this.storePassword = password;
        this.tracker = new FileModificationTracker(f.getAbsolutePath());
        this.requestDatabase = db;
        this.rebuildAliasesList();
    }

    private void load() throws KeyManagerException {
        FileInputStream in;
        this.tracker.loaded();
        try {
            in = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e1) {
            this.aliases = new ArrayList<String>();
            return;
        }
        try {
            this.requestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(in));
            in.close();
            this.rebuildAliasesList();
        }
        catch (BadMagicNumberException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad Magic Number");
        }
        catch (BadVersionNumberException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad Version Number");
        }
        catch (BadFileTypeException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad File Type");
        }
        catch (BadRecordFlagException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad Record Flag");
        }
        catch (NullPointerException e) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NULL_POINTER, (Throwable)e);
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
        }
    }

    private void rebuildAliasesList() throws KeyManagerException {
        if (this.requestDatabase == null) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.RDB_UNINITIALISED, new String[0]);
        }
        try {
            this.aliases = new ArrayList<String>();
            Sequence<RequestRecord> records = this.requestDatabase.getRecords();
            for (RequestRecord record : records) {
                Buffer label = record.getLabel();
                byte[] labelContent = new byte[label.getHeader().toInt()];
                label.getContent().getInputStream().read(labelContent);
                this.aliases.add(new String(labelContent, "UTF-8"));
            }
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<CertificateRequestKeyItem> getItems() throws KeyManagerException {
        ArrayList<CertificateRequestKeyItem> returnList = new ArrayList<CertificateRequestKeyItem>();
        for (String alias : this.aliases) {
            returnList.add(this.getItem(alias));
        }
        return returnList;
    }

    @Override
    public CertificateRequestKeyItem getItem(String label) throws KeyManagerException {
        if (this.contains(label)) {
            RequestRecord currentRecord = this.requestDatabase.getRecordByLabel(label);
            return CMSCertificateRequestFile.getCertRequest(label, currentRecord, this.storePassword);
        }
        throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_REQUEST_FOR_LABEL, label);
    }

    @Override
    public void delete(String label) throws KeyManagerException {
        if (!this.contains(label)) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_REQUEST_FOR_LABEL, label);
        }
        RequestRecord record = this.requestDatabase.getRecordByLabel(label);
        Sequence<RequestRecord> allRecords = this.requestDatabase.getRecords();
        int index = allRecords.indexOf(record);
        ByteSequence newStoreSequence = null;
        try {
            Sequence<RequestRecord> remaining = allRecords.getSubSequence(0, index).append(allRecords.getSubSequence(index + 1, allRecords.length()));
            newStoreSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.requestDatabase.getHeader().getMajorVersionNumber()).append(this.requestDatabase.getHeader().getMinorVersionNumber()).append(ZERO).append(FileType.X509KYP).append(FIXED_RECORD_LENGTH_SEQUENCE).append(IntableByteSequenceFactory.newIntableByteSequence(remaining.length())).append(UNUSED_FILE_LABEL).append(this.requestDatabase.getHeader().getPasswordHeaderHash()).append(this.requestDatabase.getHeader().getPasswordDatabaseHash());
            for (RequestRecord rec : remaining) {
                newStoreSequence = newStoreSequence.append(rec);
            }
        }
        catch (NullPointerException e) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NULL_POINTER, (Throwable)e);
        }
        try {
            this.requestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(newStoreSequence.getInputStream()));
            this.updateHeaderHashes();
        }
        catch (BadMagicNumberException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad Magic Number");
        }
        catch (BadVersionNumberException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad Version Number");
        }
        catch (BadFileTypeException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad File Type");
        }
        catch (BadRecordFlagException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad Record Flag");
        }
        catch (NullPointerException e) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NULL_POINTER, (Throwable)e);
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
        }
        this.rebuildAliasesList();
    }

    private static CertificateRequestKeyItem getCertRequest(String label, RequestRecord rec, String password) throws KeyManagerException {
        try {
            RequestRecordEncoding encoding = rec.getEncoding();
            CertificationRequest req = encoding.getCertificationRequest();
            PrivateKey privateKey = encoding.getPrivateKey(password.toCharArray());
            return EntryFactory.loadCertificateRequestItem(label, req, privateKey);
        }
        catch (Exception e) {
            Debug.throwing(e);
            return EntryFactory.newUnloadableCertificateRequestItem(label);
        }
    }

    @Override
    public void save() throws KeyManagerException {
        try {
            BufferedOutputStream bufferedStream = new BufferedOutputStream(new LockedFileOutputStream(this.file));
            ByteSequenceIterator it = this.requestDatabase.getIterator();
            while (it.hasNextByte()) {
                bufferedStream.write(it.getNextByte());
            }
            bufferedStream.close();
        }
        catch (FileNotFoundException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_FILE_CREATION_ERROR, (Throwable)e, this.file.getAbsolutePath());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("ByteSequenceIterator.getNextByte() threw invalid exception.", e);
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.OUTPUT_STREAM_WRITE_ERROR, (Throwable)e, this.file.getAbsolutePath());
        }
    }

    @Override
    public void add(CertificateRequestKeyItem item) throws KeyManagerException {
        try {
            int id = this.requestDatabase.getNextRecordID();
            CertificationRequest req = item.getRequest();
            String alias = item.getLabel();
            PrivateKey privateKey = item.getPrivateKey();
            RequestRecordDataHashGenerator hashGen = RequestRecordDataHashGeneratorFactory.newRequestRecordDataHashGenerator();
            ByteSequence aliasSeq = IntableByteSequenceFactory.newIntableByteSequence(alias.length()).append(ByteSequenceFactory.newByteSequence(alias.getBytes("UTF-8")));
            ArrayList<RequestRecord> records = new ArrayList<RequestRecord>(1);
            ByteSequence record = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(id)).append(RequestRecordEncodingFactory.newRequestRecordEncoding(id, req, privateKey, this.storePassword.toCharArray(), alias)).append(BufferFactory.newBuffer(aliasSeq.getInputStream())).append(hashGen.generateSubjectPublicKeyInfoHash(req));
            records.add(RequestRecordFactory.newRequestRecord(record.getInputStream(), 5000));
            Sequence additionalRecords = SequenceFactory.newSequence(records);
            Sequence<RequestRecord> totalRecords = this.requestDatabase.getRecords().append(additionalRecords);
            ByteSequence newStoreSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.requestDatabase.getHeader().getMajorVersionNumber()).append(this.requestDatabase.getHeader().getMinorVersionNumber()).append(ZERO).append(FileType.X509KYP).append(FIXED_RECORD_LENGTH_SEQUENCE).append(IntableByteSequenceFactory.newIntableByteSequence(totalRecords.length())).append(UNUSED_FILE_LABEL).append(this.requestDatabase.getHeader().getPasswordHeaderHash()).append(this.requestDatabase.getHeader().getPasswordDatabaseHash());
            for (RequestRecord rec : totalRecords) {
                newStoreSequence = newStoreSequence.append(rec);
            }
            this.requestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(newStoreSequence.getInputStream()));
            this.updateHeaderHashes();
            this.rebuildAliasesList();
        }
        catch (NullPointerException e) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NULL_POINTER, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.UNSUPPORTED_ENCODING, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.PUBLIC_KEY_COPY_ERROR, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
        }
        catch (PKCSException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.PRIVATE_KEY_ENCRYPTION_ERROR, (Throwable)e, item.getLabel());
        }
    }

    private void updateHeaderHashes() throws NoSuchAlgorithmException, IOException {
        ByteSequence newHeaderSequence;
        FileHeader header = this.requestDatabase.getHeader();
        ByteSequence headerHash = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator(header).generateHash(header, this.storePassword);
        ByteSequence keystoreSequence = newHeaderSequence = header.getSubSequence(0, header.length() - 2 * header.getPasswordHeaderHash().length()).append(headerHash).append(header.getPasswordDatabaseHash());
        for (RequestRecord rec : this.requestDatabase.getRecords()) {
            keystoreSequence = keystoreSequence.append(rec);
        }
        RequestDatabase db = RequestDatabaseFactory.newRequestDatabase(keystoreSequence.getInputStream());
        ByteSequence dbHash = RequestDatabaseHashGeneratorFactory.newRequestDatabaseHashGenerator(header).generateHash(db, this.storePassword);
        header = db.getHeader();
        keystoreSequence = newHeaderSequence = header.getSubSequence(0, header.length() - header.getPasswordDatabaseHash().length()).append(dbHash);
        for (RequestRecord rec : db.getRecords()) {
            keystoreSequence = keystoreSequence.append(rec);
        }
        this.requestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(keystoreSequence.getInputStream()));
    }

    public static CMSCertificateRequestFile loadRequestFile(FileName fileName, String password) throws KeyManagerException {
        File f = new File(fileName.changeExtension(EXTENSION).toString());
        if (!f.exists()) {
            return CMSCertificateRequestFile.createRequestFile(fileName, password);
        }
        return new CMSCertificateRequestFile(f, password);
    }

    public static CMSCertificateRequestFile createRequestFile(FileName fileName, String password) throws KeyManagerException {
        try {
            File f = new File(fileName.changeExtension(EXTENSION).toString());
            ByteSequence headerSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(VersionNumber.THREE).append(VersionNumber.ONE).append(ZERO).append(FileType.X509KYP).append(FIXED_RECORD_LENGTH_SEQUENCE).append(IntableByteSequenceFactory.newIntableByteSequence(0)).append(UNUSED_FILE_LABEL).append(ZERO_MD5_HASH).append(ZERO_MD5_HASH);
            FileHeader header = FileHeaderFactory.newFileHeader(headerSequence.getInputStream());
            ByteSequence headerHash = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator(header).generateHash(header, password);
            ByteSequence keystoreSequence = headerSequence = headerSequence.getSubSequence(0, headerSequence.length() - 2 * ZERO_MD5_HASH.length()).append(headerHash).append(ZERO_MD5_HASH);
            RequestDatabase db = RequestDatabaseFactory.newRequestDatabase(keystoreSequence.getInputStream());
            ByteSequence dbHash = RequestDatabaseHashGeneratorFactory.newRequestDatabaseHashGenerator(header).generateHash(db, password);
            keystoreSequence = headerSequence = headerSequence.getSubSequence(0, headerSequence.length() - ZERO_MD5_HASH.length()).append(dbHash);
            QueryableRequestDatabase queriableDb = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(keystoreSequence.getInputStream()));
            return new CMSCertificateRequestFile(f, password, queriableDb);
        }
        catch (BadMagicNumberException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad Magic Number");
        }
        catch (BadVersionNumberException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad Version Number");
        }
        catch (BadFileTypeException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad File Type");
        }
        catch (BadRecordFlagException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_REQUEST_FILE, (Throwable)e, "Bad Record Flag");
        }
        catch (NullPointerException e) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NULL_POINTER, (Throwable)e);
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.IO_ERROR, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
        }
    }

    @Override
    public void delete() throws KeyManagerException {
        if (this.file.exists() && !this.file.delete()) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.FILE_DELETION_FAILED, this.file.getAbsolutePath());
        }
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public void changePassword(CommandParameters params) throws KeyManagerException {
        String newPassword;
        if (params.isParameterPresent(Constants.Parameter.NewPassword) && !this.storePassword.equals(newPassword = params.getNewPassword())) {
            try {
                this.updateEncryptedRecords(this.storePassword.toCharArray(), newPassword.toCharArray());
                this.storePassword = newPassword;
                this.updateHeaderHashes();
            }
            catch (Exception e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.RDB_PASSWORD_CHANGE_ERROR, (Throwable)e);
            }
        }
    }

    private void updateEncryptedRecords(char[] currentPassword, char[] newPassword) throws IOException, PKCSException, CertificateEncodingException, CertificateException, NoSuchAlgorithmException {
        Sequence<RequestRecord> keys = this.requestDatabase.getRecords();
        HashMap<Integer, RequestRecord> newKeys = new HashMap<Integer, RequestRecord>(keys.length());
        for (RequestRecord record : keys) {
            Buffer aliasBuffer = record.getLabel();
            byte[] contents = new byte[aliasBuffer.getHeader().toInt()];
            aliasBuffer.getContent().getInputStream().read(contents);
            String alias = new String(contents, "UTF-8");
            RequestRecordEncoding encoding = record.getEncoding();
            RequestRecordEncoding newEncoding = RequestRecordEncodingFactory.newRequestRecordEncoding(record.getRecordId().toInt(), encoding.getCertificationRequest(), encoding.getPrivateKey(currentPassword), newPassword, alias);
            ByteSequence newRecordSequence = record.getRecordFlag().append(record.getRecordId()).append(newEncoding).append(record.getLabel()).append(ZERO).append(record.getSubjectPublicKeyInfoHash());
            newKeys.put(record.getRecordId().toInt(), RequestRecordFactory.newRequestRecord(newRecordSequence.getInputStream(), 5000));
        }
        ByteSequence newKeystore = this.requestDatabase.getHeader();
        for (RequestRecord record : this.requestDatabase.getRecords()) {
            RequestRecord rec = (RequestRecord)newKeys.get(record.getRecordId().toInt());
            if (rec != null) {
                newKeystore = newKeystore.append(rec);
                continue;
            }
            newKeystore = newKeystore.append(record);
        }
        this.requestDatabase = QueryableRequestDatabaseFactory.newQueryableRequestDatabase(RequestDatabaseFactory.newRequestDatabase(newKeystore.getInputStream()));
    }

    @Override
    public void refresh() throws KeyManagerException {
        this.load();
    }

    @Override
    public boolean needsRefresh() {
        return this.tracker.needsRefresh();
    }
}

