/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.Buffer;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.ByteSequenceInputStream;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.ByteSequenceInputStreamFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequence;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.IntableByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import java.io.IOException;
import java.io.InputStream;

final class BufferFactory {
    private BufferFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static Buffer newBuffer(InputStream in) throws NullPointerException, IOException {
        ByteSequence content;
        if (in == null) {
            throw new NullPointerException();
        }
        ByteSequenceInputStream bsis = ByteSequenceInputStreamFactory.newByteSequenceInputStream();
        ByteSequence s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        IntableByteSequence header = IntableByteSequenceFactory.newIntableByteSequence(s);
        int len = header.toInt();
        if (len < 1) {
            content = ByteSequenceFactory.newByteSequence(new byte[0]);
        } else {
            s = bsis.getByteSequence(in, len);
            if (s == null) {
                return null;
            }
            content = s;
        }
        return new BufferImpl(header, content);
    }

    private static final class BufferImpl
    implements Buffer {
        private final IntableByteSequence header;
        private final ByteSequence content;
        private final ByteSequence sequence;

        BufferImpl(IntableByteSequence header, ByteSequence content) {
            this.header = header;
            this.content = content;
            this.sequence = header.append(content);
        }

        public IntableByteSequence getHeader() {
            return this.header;
        }

        public ByteSequence getContent() {
            return this.content;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.sequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.get(index);
        }

        public int length() {
            return this.sequence.length();
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() == 0) {
                return this;
            }
            return this.sequence.append(sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.sequence.length() || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.getSubSequence(fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            return this.sequence.indexOf(b);
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.indexOf(position, b);
        }

        public int lastIndexOf(byte b) {
            return this.sequence.lastIndexOf(b);
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.lastIndexOf(position, b);
        }

        public boolean isEmpty() {
            return this.sequence.isEmpty();
        }

        public InputStream getInputStream() {
            return this.sequence.getInputStream();
        }

        public ByteSequenceIterator getIterator() {
            return this.sequence.getIterator();
        }

        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.getIterator(position);
        }

        public String toBinaryString() {
            return this.sequence.toBinaryString();
        }

        public String toOctalString() {
            return this.sequence.toOctalString();
        }

        public String toHexString() {
            return this.sequence.toHexString();
        }

        public String toString() {
            return ((Object)this.sequence).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            ByteSequenceIterator it1 = this.getIterator();
            ByteSequenceIterator it2 = s.getIterator();
            while (it1.hasNextByte() && it2.hasNextByte()) {
                byte e2;
                byte e1 = it1.getNextByte();
                if (e1 == (e2 = it2.getNextByte())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return ((Object)this.sequence).hashCode();
        }
    }
}

