/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.cert.PolicyNodeImpl;
import com.ibm.security.cert.PolicyTree;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CertificatePoliciesExtension;
import com.ibm.security.x509.CertificatePolicyMap;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PolicyInformation;
import com.ibm.security.x509.PolicyMappingsExtension;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class PolicyChecker
extends PKIXCertPathChecker {
    private PolicyTree policyTree;
    private X509Certificate certificate;
    private boolean policyQualifiersRejected;
    private Set<String> user_initial_policy_set;
    int inhibit_any_policy;
    private int explicit_policy;
    private int policy_mapping;
    private int currentCertIndex;
    private CertPath certPath;
    public static final ObjectIdentifier anyPolicy_OID;
    private int numberOfCertsInCertPath;
    static final String[] myExtensions;

    public PolicyChecker(CertPath cp, boolean rejected, Set policy, int pexplicit, int pmapping, int pinhibit) {
        this.certPath = cp;
        this.policyQualifiersRejected = rejected;
        this.user_initial_policy_set = policy;
        this.explicit_policy = pexplicit;
        this.policy_mapping = pmapping;
        this.inhibit_any_policy = pinhibit;
        this.policyTree = new PolicyTree();
        this.numberOfCertsInCertPath = this.certPath.getCertificates().size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        this.certificate = (X509Certificate)cert;
        Vector policyInfo = new Vector();
        CertificatePoliciesExtension extension = (CertificatePoliciesExtension)CertPathUtil.getPolicyInformation(this.certificate, policyInfo, this.policyQualifiersRejected);
        if (((Object)this.certificate.getIssuerDN()).equals(this.certificate.getSubjectDN())) {
            --this.currentCertIndex;
            --this.numberOfCertsInCertPath;
            return;
        }
        try {
            if (extension == null || extension.get("cert_policies") == null) {
                this.policyTree.setValid(false);
            } else {
                if (this.policyQualifiersRejected && extension.isCritical()) {
                    throw new CertPathValidatorException("Reject the certificate", null, this.certPath, this.currentCertIndex);
                }
                if (this.policyTree.isValid()) {
                    this.checkPolicies(this.certificate, extension, this.policyTree);
                }
            }
        }
        catch (IOException e) {
            throw new CertPathValidatorException("Internal error occurs while checking certificate policies extension", (Throwable)e, this.certPath, this.currentCertIndex);
        }
        if (this.explicit_policy <= 0 && !this.policyTree.isValid()) {
            throw new CertPathValidatorException("Fail to pass policy check.", null, this.certPath, this.currentCertIndex);
        }
        if (this.currentCertIndex > 0) {
            int valueOfInhibitPolicy;
            int[] valueOfPolicyConstraints;
            PolicyMappingsExtension mappingExt = null;
            Object[] objs = CertPathUtil.getExtension("x509.info.extensions.PolicyMappings", this.certificate);
            if (objs[1] != null) {
                try {
                    mappingExt = new PolicyMappingsExtension((Boolean)objs[0], objs[1]);
                }
                catch (IOException e) {
                    throw new CertPathValidatorException("An internal error has occurred.", (Throwable)e, this.certPath, this.currentCertIndex);
                }
            }
            if (mappingExt != null) {
                this.checkPolicyMappings(this.certificate, mappingExt, this.policyTree);
            }
            if (this.explicit_policy != 0) {
                --this.explicit_policy;
            }
            if (this.policy_mapping != 0) {
                --this.policy_mapping;
            }
            if (this.inhibit_any_policy != 0) {
                --this.inhibit_any_policy;
            }
            if ((valueOfPolicyConstraints = CertPathUtil.getPolicyConstraints(this.certificate)) != null) {
                if (valueOfPolicyConstraints[0] < this.explicit_policy) {
                    this.explicit_policy = valueOfPolicyConstraints[0];
                }
                if (valueOfPolicyConstraints[1] < this.policy_mapping) {
                    this.policy_mapping = valueOfPolicyConstraints[1];
                }
            }
            if ((valueOfInhibitPolicy = CertPathUtil.getInhibitAnyPolicy(this.certificate)) < this.inhibit_any_policy) {
                this.inhibit_any_policy = valueOfInhibitPolicy;
            }
        }
        CertPathUtil.removeExtensions(unresolvedCritExts, myExtensions);
        if (this.currentCertIndex == 0) {
            this.policyTree = this.wrapUp(this.certificate);
        }
        --this.currentCertIndex;
    }

    private void checkPolicies(X509Certificate certificate, CertificatePoliciesExtension ext, PolicyTree policyTree) throws CertPathValidatorException {
        Iterator it;
        Vector policyQualifiers;
        ObjectIdentifier p_OID;
        boolean critical = ext.isCritical();
        List policyInfoSeq = null;
        try {
            policyInfoSeq = (List)ext.get("cert_policies");
        }
        catch (IOException e) {
            throw new CertPathValidatorException("Fail to pass policy check", (Throwable)e, this.certPath, this.currentCertIndex);
        }
        ArrayList nodes = null;
        nodes = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex - 1);
        for (PolicyInformation p : policyInfoSeq) {
            PolicyNodeImpl newNode;
            HashSet<String> expectedPolicySet;
            PolicyNodeImpl parent;
            int j;
            p_OID = null;
            try {
                p_OID = p.getPolicyIdentifier();
            }
            catch (IOException e) {
                throw new CertPathValidatorException("Fail to pass policy check", (Throwable)e, this.certPath, this.currentCertIndex);
            }
            if (p_OID.equals(anyPolicy_OID)) continue;
            policyQualifiers = p.getPolicyQualifiers();
            if (policyQualifiers == null) {
                policyQualifiers = new Vector();
            }
            boolean matched = false;
            for (j = 0; j < nodes.size(); ++j) {
                parent = (PolicyNodeImpl)nodes.get(j);
                if (!parent.match(p_OID)) continue;
                matched = true;
                expectedPolicySet = new HashSet<String>();
                expectedPolicySet.add(p_OID.toString());
                newNode = new PolicyNodeImpl(p_OID, new HashSet(policyQualifiers), critical, expectedPolicySet, parent);
                parent.addChild(newNode);
                policyTree.addNode(newNode);
            }
            if (matched) continue;
            for (j = 0; j < nodes.size(); ++j) {
                parent = (PolicyNodeImpl)nodes.get(j);
                if (!parent.getValidPolicy().equals(anyPolicy_OID.toString())) continue;
                expectedPolicySet = new HashSet();
                expectedPolicySet.add(p_OID.toString());
                newNode = new PolicyNodeImpl(p_OID, new HashSet(policyQualifiers), critical, expectedPolicySet, parent);
                parent.addChild(newNode);
                policyTree.addNode(newNode);
            }
        }
        for (PolicyInformation p : policyInfoSeq) {
            p_OID = null;
            try {
                p_OID = p.getPolicyIdentifier();
            }
            catch (IOException e) {
                throw new CertPathValidatorException("Fail to pass policy check", (Throwable)e, this.certPath, this.currentCertIndex);
            }
            if (!p_OID.equals(anyPolicy_OID) || CertPathUtil.getInhibitAnyPolicy(certificate) <= 0) continue;
            policyQualifiers = p.getPolicyQualifiers();
            if (policyQualifiers == null) {
                policyQualifiers = new Vector();
            }
            for (int j = 0; j < nodes.size(); ++j) {
                PolicyNodeImpl parent = (PolicyNodeImpl)nodes.get(j);
                it = parent.getExpectedPolicies().iterator();
                while (it.hasNext()) {
                    ObjectIdentifier policy = null;
                    try {
                        policy = new ObjectIdentifier((String)it.next());
                    }
                    catch (IOException ex) {
                        continue;
                    }
                    boolean found = false;
                    Iterator itor = parent.getChildren();
                    while (itor.hasNext()) {
                        PolicyNodeImpl child = (PolicyNodeImpl)itor.next();
                        if (!child.match(policy)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    HashSet<String> expectedPolicySet = new HashSet<String>();
                    expectedPolicySet.add(policy.toString());
                    PolicyNodeImpl newNode = new PolicyNodeImpl(policy, new HashSet(policyQualifiers), critical, expectedPolicySet, parent);
                    parent.addChild(newNode);
                    policyTree.addNode(newNode);
                }
            }
        }
        ArrayList leaves = null;
        for (int count = this.numberOfCertsInCertPath - this.currentCertIndex - 1; count > 0; --count) {
            leaves = policyTree.getNodes(count);
            int total = leaves.size();
            for (int i = 0; i < total; ++i) {
                PolicyNodeImpl pn = (PolicyNodeImpl)leaves.get(i);
                it = pn.getChildren();
                if (it.hasNext()) continue;
                PolicyNodeImpl parent = (PolicyNodeImpl)((PolicyNodeImpl)leaves.get(i)).getParent();
                if (parent != null) {
                    parent.removeChild(pn);
                    policyTree.remove(pn);
                    --i;
                    --total;
                    continue;
                }
                throw new CertPathValidatorException("Fail to pass policy check", (Throwable)new CertPathValidatorException("Policy tree broken"), this.certPath, this.currentCertIndex);
            }
        }
        if (policyTree.getNodes(1) == null) {
            policyTree.setValid(false);
        }
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("The direction of forward is not supported.", null, this.certPath, this.currentCertIndex);
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        HashSet<String> set = new HashSet<String>();
        set.add("2.5.29.32");
        return set;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public PolicyTree getPolicyTree() {
        return this.policyTree;
    }

    private void checkPolicyMappings(X509Certificate cert, PolicyMappingsExtension extension, PolicyTree policyTree) throws CertPathValidatorException {
        Vector maps = null;
        try {
            maps = (Vector)extension.get("map");
        }
        catch (IOException e) {
            throw new CertPathValidatorException("An internal error has occurred.", (Throwable)e, this.certPath, this.currentCertIndex);
        }
        block6: for (int i = 0; i < maps.size(); ++i) {
            ArrayList leaves;
            CertificatePolicyMap cpm = (CertificatePolicyMap)maps.get(i);
            ObjectIdentifier issuer_OID = cpm.getIssuerIdentifier().getIdentifier();
            ObjectIdentifier subject_OID = cpm.getSubjectIdentifier().getIdentifier();
            if (issuer_OID.equals(anyPolicy_OID) || subject_OID.equals(anyPolicy_OID)) {
                throw new CertPathValidatorException("Error in policy mapping extension", null, this.certPath, this.currentCertIndex);
            }
            if (this.policy_mapping > 0) {
                int j;
                leaves = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex);
                boolean found = false;
                for (j = 0; j < leaves.size(); ++j) {
                    PolicyNodeImpl node = (PolicyNodeImpl)leaves.get(j);
                    if (!node.getValidPolicy().equals(issuer_OID.toString())) continue;
                    found = true;
                    HashSet<String> set = new HashSet<String>();
                    set.add(subject_OID.toString());
                    node.setExpectedPolicySet(set);
                }
                if (found) continue;
                leaves = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex - 1);
                for (j = 0; j < leaves.size(); ++j) {
                    PolicyNodeImpl parent = (PolicyNodeImpl)leaves.get(j);
                    if (!parent.getValidPolicy().equals(anyPolicy_OID)) continue;
                    Vector policyInfo = new Vector();
                    CertificatePoliciesExtension ext = (CertificatePoliciesExtension)CertPathUtil.getPolicyInformation(cert, policyInfo, this.policyQualifiersRejected);
                    Vector policies = null;
                    try {
                        policies = (Vector)ext.get("cert_policies");
                    }
                    catch (IOException e) {
                        throw new CertPathValidatorException("An internal error has occurred.", (Throwable)e, this.certPath, this.currentCertIndex);
                    }
                    for (int k = 0; k < policies.size(); ++k) {
                        PolicyInformation pinfo = (PolicyInformation)policies.get(k);
                        try {
                            if (!pinfo.getPolicyIdentifier().equals(anyPolicy_OID)) continue;
                            HashSet<String> set = new HashSet<String>();
                            set.add(cpm.getSubjectIdentifier().getIdentifier().toString());
                            PolicyNodeImpl newNode = new PolicyNodeImpl(issuer_OID, new HashSet(pinfo.getPolicyQualifiers()), extension.isCritical(), set, parent);
                            parent.addChild(newNode);
                            policyTree.addNode(newNode);
                            continue block6;
                        }
                        catch (IOException e) {
                            throw new CertPathValidatorException("An internal error has occured.", (Throwable)e, this.certPath, this.currentCertIndex);
                        }
                    }
                    continue block6;
                }
                continue;
            }
            if (this.policy_mapping != 0) continue;
            leaves = policyTree.getNodes(this.numberOfCertsInCertPath - this.currentCertIndex);
            for (int j = 0; j < leaves.size(); ++j) {
                PolicyNodeImpl node = (PolicyNodeImpl)leaves.get(j);
                if (!node.getValidPolicy().equals(issuer_OID.toString())) continue;
                ((PolicyNodeImpl)node.getParent()).removeChild(node);
                policyTree.remove(node);
            }
            for (int count = this.numberOfCertsInCertPath - this.currentCertIndex - 1; count > 0; --count) {
                leaves = policyTree.getNodes(count);
                int total = leaves.size();
                for (int j = 0; j < total; ++j) {
                    PolicyNodeImpl pn = (PolicyNodeImpl)leaves.get(j);
                    Iterator it = pn.getChildren();
                    if (it.hasNext()) continue;
                    PolicyNodeImpl parent = (PolicyNodeImpl)((PolicyNodeImpl)leaves.get(j)).getParent();
                    if (parent != null) {
                        parent.removeChild(pn);
                        policyTree.remove(pn);
                        --j;
                        --total;
                        continue;
                    }
                    throw new CertPathValidatorException("Fail to pass policy check", (Throwable)new CertPathValidatorException("Policy tree broken"), this.certPath, this.currentCertIndex);
                }
            }
        }
    }

    private PolicyTree wrapUp(X509Certificate cert) throws CertPathValidatorException {
        int[] valueOfPolicyConstraints;
        if (!((Object)this.certificate.getIssuerDN()).equals(this.certificate.getSubjectDN()) && this.explicit_policy != 0) {
            --this.explicit_policy;
        }
        if ((valueOfPolicyConstraints = CertPathUtil.getPolicyConstraints(this.certificate)) != null && valueOfPolicyConstraints[0] == 0) {
            this.explicit_policy = 0;
        }
        if (this.policyTree.isValid()) {
            if (this.user_initial_policy_set.size() == 1 && this.user_initial_policy_set.contains(anyPolicy_OID.toString())) {
                return this.policyTree;
            }
            ArrayList<PolicyNodeImpl> valid_policy_node_set = new ArrayList<PolicyNodeImpl>();
            PolicyNodeImpl node2 = null;
            ArrayList list = null;
            for (int i = this.policyTree.getDepth(); i > 0; --i) {
                list = this.policyTree.getNodes(i);
                for (PolicyNodeImpl node2 : list) {
                    if (!node2.getParent().getValidPolicy().equals(anyPolicy_OID.toString())) continue;
                    valid_policy_node_set.add(node2);
                }
            }
            for (PolicyNodeImpl node2 : valid_policy_node_set) {
                String valid_policy = node2.getValidPolicy();
                if (this.user_initial_policy_set.contains(valid_policy) || valid_policy.equals(anyPolicy_OID.toString())) continue;
                Iterator it = node2.getChildren();
                while (it.hasNext()) {
                    PolicyNodeImpl child = (PolicyNodeImpl)it.next();
                    this.deleteChild(this.policyTree, child);
                }
                ((PolicyNodeImpl)node2.getParent()).removeChild(node2);
                this.policyTree.remove(node2);
            }
            ArrayList leaves = null;
            for (int count = this.numberOfCertsInCertPath - 1; count > 0; --count) {
                leaves = this.policyTree.getNodes(count);
                if (leaves == null) continue;
                int total = leaves.size();
                for (int j = 0; j < total; ++j) {
                    PolicyNodeImpl pn = (PolicyNodeImpl)leaves.get(j);
                    Iterator it = pn.getChildren();
                    if (it.hasNext()) continue;
                    PolicyNodeImpl parent = (PolicyNodeImpl)((PolicyNodeImpl)leaves.get(j)).getParent();
                    if (parent != null) {
                        parent.removeChild(pn);
                        this.policyTree.remove(pn);
                        --j;
                        --total;
                        continue;
                    }
                    throw new CertPathValidatorException("Fail to pass policy check", (Throwable)new CertPathValidatorException("Policy tree broken"), this.certPath, this.currentCertIndex);
                }
            }
            if (this.policyTree.getNodes(1) == null) {
                this.policyTree.setValid(false);
            }
        }
        if (!this.policyTree.isValid() && this.explicit_policy <= 0) {
            throw new CertPathValidatorException("Fail to pass certification path processing", null, this.certPath, this.currentCertIndex);
        }
        return this.policyTree;
    }

    private void deleteChild(PolicyTree atree, PolicyNodeImpl n) {
        Iterator it = n.getChildren();
        while (it.hasNext()) {
            PolicyNodeImpl child = (PolicyNodeImpl)it.next();
            this.deleteChild(atree, child);
        }
        atree.remove(n);
    }

    static {
        myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.CertificatePolicies").toString(), OIDMap.getOID((String)"x509.info.extensions.PolicyConstraints").toString(), OIDMap.getOID((String)"x509.info.extensions.InhibitAnyPolicy").toString()};
        ObjectIdentifier temp = null;
        try {
            temp = new ObjectIdentifier("2.5.29.32.0");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        anyPolicy_OID = temp;
    }
}

