/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.ConnectionKey;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.Transport;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.util.LimitedMultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class ConnectionTableImpl
implements ConnectionTable {
    private static final String CLASS = ConnectionTableImpl.class.getName();
    private final int lowWaterMark;
    private final int highWaterMark;
    private final LimitedMultiMap multimap;
    private ORB orb;
    private static final int NCLEAN = 5;

    public ConnectionTableImpl(ORB oRB, Transport transport) {
        this.orb = oRB;
        this.highWaterMark = oRB.getHighWaterMark();
        this.lowWaterMark = oRB.getLowWaterMark();
        int n = oRB.getConnectionMultiplicity();
        this.multimap = new LimitedMultiMap(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "shutdown:98");
        }
        while (true) {
            ConnectionTableImpl connectionTableImpl = this;
            synchronized (connectionTableImpl) {
                this.multimap.performScheduledRemovals();
                Iterator iterator = this.multimap.valueIterator();
                while (iterator.hasNext()) {
                    ORBConnection oRBConnection = (ORBConnection)iterator.next();
                    if (oRBConnection.isBusy()) continue;
                    try {
                        oRBConnection.cleanUp();
                    }
                    catch (Exception exception) {
                        Trc.fail(Trc.stackTrace(exception), CLASS, "shutdown:111");
                    }
                    iterator.remove();
                }
                if (this.multimap.isEmpty()) {
                    this.multimap.performScheduledRemovals();
                    break;
                }
            }
            Thread.yield();
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "shutdown:131");
        }
    }

    private boolean cleanUpConnection(ORBConnection oRBConnection) {
        Trc.info("Cleaning up: ", oRBConnection, CLASS, "cleanUpConnection:140");
        try {
            oRBConnection.cleanUp();
            return true;
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "cleanUpConnection:145");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanUp() {
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4 = this.orb.getState();
        if (n4 != 1 && n4 != 2) {
            this.shutdown();
            return true;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "cleanUp:168", (Object)("lowWaterMark=" + this.lowWaterMark + ", highWaterMark=" + this.highWaterMark));
        }
        ConnectionTableImpl connectionTableImpl = this;
        synchronized (connectionTableImpl) {
            n2 = n3 = this.multimap.size();
            bl = this.multimap.performScheduledRemovals();
            n = this.multimap.size();
            n2 -= n;
            if (this.multimap.size() > this.lowWaterMark) {
                this.removeStaleConnections();
                bl = true;
            }
            n -= this.multimap.size();
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "cleanUp:185", (Object)("size was " + n3 + ", removed: " + n2 + ", cleaned: " + n));
        }
        return bl;
    }

    private void removeStaleConnections() {
        ORBConnection oRBConnection2;
        ConnectionKey connectionKey;
        Object[] objectArray = new ORBConnection[5];
        Object[] objectArray2 = new ConnectionKey[5];
        Iterator iterator = this.multimap.keyIterator();
        while (iterator.hasNext()) {
            connectionKey = (ConnectionKey)iterator.next();
            for (ORBConnection oRBConnection2 : this.multimap.get(connectionKey)) {
                Comparator comparator;
                int n;
                if (oRBConnection2.isBusy() || (n = Arrays.binarySearch(objectArray, oRBConnection2, comparator = ORBConnection.MOST_STALE_FIRST)) >= 0 || (n = -n - 1) >= 5) continue;
                ConnectionTableImpl.insert(oRBConnection2, objectArray, n);
                ConnectionTableImpl.insert(connectionKey, objectArray2, n);
            }
        }
        for (int i = 0; i < 5 && (oRBConnection2 = objectArray[i]) != null; ++i) {
            connectionKey = objectArray2[i];
            boolean bl = this.cleanUpConnection(objectArray[i]);
            if (!bl) continue;
            this.multimap.remove(connectionKey, oRBConnection2);
        }
    }

    private static final void insert(Object object, Object[] objectArray, int n) {
        int n2 = n + 1;
        System.arraycopy(objectArray, n, objectArray, n2, objectArray.length - n2);
        objectArray[n] = object;
    }

    public void checkConnectionTable() {
        if (this.multimap.size() > this.highWaterMark) {
            this.cleanUp();
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" size=").append(this.multimap.size());
        Iterator iterator = this.multimap.valueIterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n").append(iterator.next());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ConnectionKey connectionKey, ORBConnection oRBConnection) {
        LimitedMultiMap.RemoveToken removeToken;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "addConnection:287", (Object)connectionKey, (Object)oRBConnection);
        }
        ConnectionTableImpl connectionTableImpl = this;
        synchronized (connectionTableImpl) {
            this.multimap.performScheduledRemovals();
            removeToken = this.multimap.put(connectionKey, oRBConnection);
        }
        oRBConnection.setRemoveToken(removeToken);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "addConnection:297", (Object)("size=" + this.multimap.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionKey connectionKey) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "removeConnection(key):308", (Object)connectionKey);
        }
        if (this.multimap.multiplicity != 1) {
            throw new UnsupportedOperationException("The WAS pluggable transport does not support multiple connections");
        }
        ConnectionTableImpl connectionTableImpl = this;
        synchronized (connectionTableImpl) {
            Iterator iterator = this.multimap.get(connectionKey).iterator();
            if (iterator.hasNext()) {
                this.multimap.scheduleRemoval(connectionKey, iterator.next());
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "removeConnection(key):322", (Object)("size=" + this.multimap.size()));
        }
    }

    public void removeConnection(ORBConnection oRBConnection) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "removeConnection:335", (Object)oRBConnection);
        }
        LimitedMultiMap.RemoveToken removeToken = (LimitedMultiMap.RemoveToken)oRBConnection.getRemoveToken();
        this.multimap.scheduleRemoval(removeToken);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "removeConnection:342", (Object)("size=" + this.multimap.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORBConnection getConnection(ConnectionKey connectionKey) {
        int n;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "getConnection:350", (Object)connectionKey);
        }
        ORBConnection oRBConnection = null;
        ORBConnection oRBConnection2 = null;
        long l = -1L;
        ConnectionTableImpl connectionTableImpl = this;
        synchronized (connectionTableImpl) {
            this.multimap.performScheduledRemovals();
            Collection collection = this.multimap.get(connectionKey);
            n = collection.size();
            for (ORBConnection oRBConnection3 : collection) {
                long l2 = oRBConnection3.considerForCurrentThread();
                if (l2 == Long.MAX_VALUE) {
                    oRBConnection2 = oRBConnection3;
                    break;
                }
                if (l2 <= l) continue;
                oRBConnection = oRBConnection3;
                l = l2;
            }
        }
        if (oRBConnection2 == null && n == this.multimap.multiplicity) {
            oRBConnection2 = oRBConnection;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8192L, this, "getConnection:392", "number of connections = " + n + ", highest suitability score = " + l);
            ORBRas.orbTrcLogger.exit(4100L, this, "getConnection:397", (Object)oRBConnection2);
        }
        return oRBConnection2;
    }

    protected void setHook(LimitedMultiMap.Hook hook) {
        this.multimap.setHook(hook);
    }

    LimitedMultiMap getMultiMap() {
        return this.multimap;
    }
}

