/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.WriteValueTransformerStrategy;
import com.ibm.rmi.util.PartnerVersionUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.omg.CORBA.INTERNAL;

public class WriteZoneInfoTransformer
implements WriteValueTransformerStrategy {
    private static final String CLASS = WriteZoneInfoTransformer.class.getName();
    public static final WriteValueTransformerStrategy INSTANCE = new WriteZoneInfoTransformer();
    private static final Object[] noArgs = new Object[0];
    private static final Class zoneInfoClass;
    private static final Method getLastRuleInstanceMethod;
    private static final Method getRawOffsetMethod;
    private static final Method getIDMethod;

    private WriteZoneInfoTransformer() {
    }

    public Serializable transformValue(Serializable serializable, short s) {
        if (null != serializable && PartnerVersionUtil.needOldTimeZone(s) && zoneInfoClass.isAssignableFrom(serializable.getClass())) {
            try {
                TimeZone timeZone = (TimeZone)getLastRuleInstanceMethod.invoke((Object)serializable, noArgs);
                if (null == timeZone) {
                    Integer n = (Integer)getRawOffsetMethod.invoke((Object)serializable, noArgs);
                    String string = (String)getIDMethod.invoke((Object)serializable, noArgs);
                    timeZone = new SimpleTimeZone(n, string);
                }
                serializable = timeZone;
            }
            catch (Exception exception) {
                INTERNAL iNTERNAL = new INTERNAL("Error transforming ZoneInfo object.");
                iNTERNAL.initCause((Throwable)exception);
                Trc.ffdc((Exception)((Object)iNTERNAL), CLASS, "transformValue:95");
                throw iNTERNAL;
            }
        }
        return serializable;
    }

    static {
        try {
            Info info = (Info)AccessController.doPrivileged(new InitAction());
            zoneInfoClass = info.zoneInfoClass;
            getLastRuleInstanceMethod = info.getLastRuleInstanceMethod;
            getRawOffsetMethod = info.getRawOffsetMethod;
            getIDMethod = info.getIDMethod;
        }
        catch (PrivilegedActionException privilegedActionException) {
            INTERNAL iNTERNAL = new INTERNAL("Error initializing " + CLASS);
            iNTERNAL.initCause((Throwable)privilegedActionException);
            Trc.ffdc((Exception)((Object)iNTERNAL), CLASS, "<clinit>:68");
            throw iNTERNAL;
        }
    }

    private static final class InitAction
    implements PrivilegedExceptionAction {
        private InitAction() {
        }

        public Object run() throws Exception {
            Class[] classArray = new Class[]{};
            Info info = new Info();
            info.zoneInfoClass = Class.forName("sun.util.calendar.ZoneInfo");
            info.getLastRuleInstanceMethod = info.zoneInfoClass.getMethod("getLastRuleInstance", classArray);
            info.getLastRuleInstanceMethod.setAccessible(true);
            info.getRawOffsetMethod = info.zoneInfoClass.getMethod("getRawOffset", classArray);
            info.getRawOffsetMethod.setAccessible(true);
            info.getIDMethod = info.zoneInfoClass.getMethod("getID", classArray);
            info.getIDMethod.setAccessible(true);
            return info;
        }
    }

    private static final class Info {
        Class zoneInfoClass = null;
        Method getLastRuleInstanceMethod = null;
        Method getRawOffsetMethod = null;
        Method getIDMethod = null;

        private Info() {
        }
    }
}

