/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.ConnectionKeyGenerator;
import com.ibm.CORBA.channel.IIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPChannelHelper;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.channel.giop.GIOPInboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBInboundChannelFactory;
import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.Profile;
import com.ibm.rmi.channel.IIOPChannelPluginImpl;
import com.ibm.rmi.channel.giop.GIOPConnectionTable;
import com.ibm.rmi.channel.orb.ORBChannelHelper;
import com.ibm.rmi.channel.orb.ORBServerChannel;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPImpl;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.TransportInterface;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class TransportService
implements ORBForTransports,
TransportInterface {
    private static final String CLASS = TransportService.class.getName();
    private ChannelFramework channelFramework = null;
    private static Object initChainLock = new Object();
    private String chainGroupName = null;
    private ORB theORB;
    private Profile serverProfile = null;
    private IIOPChannelPlugin iiopChannelPlugin = null;
    private GIOPConnectionTable connTable;
    private int inboundORBChannelCount = 0;
    private final boolean commTraceEnabled;
    private ORBServerChannel fvdServerChannel = null;

    public TransportService(ORB oRB, GIOPImpl gIOPImpl) {
        this.theORB = oRB;
        this.commTraceEnabled = oRB.CommTraceIsEnabled();
        this.iiopChannelPlugin = (IIOPChannelPlugin)oRB.getPlugin(IIOPChannelPlugin.class.getName());
        this.channelFramework = this.iiopChannelPlugin.getChannelFramework();
        this.connTable = new GIOPConnectionTable(oRB);
        if (oRB.getClientCallback()) {
            this.fvdServerChannel = new ORBServerChannel(oRB);
        }
        Trc.info("ChannelFramework= ", this.channelFramework == null ? "null" : "not null", " IIOPChannelPlugin=", this.iiopChannelPlugin, " fvdChannel=", this.fvdServerChannel == null ? "null" : this.fvdServerChannel, CLASS, "<init>:160");
    }

    public ChannelFramework getChannelFramework() {
        return this.channelFramework;
    }

    public int getConnectTimeout() {
        return this.theORB.getConnectTimeout();
    }

    public boolean isCommTraceEnabled() {
        return this.commTraceEnabled;
    }

    public Connection get(Profile profile, ClientSubcontract clientSubcontract, String string) {
        return null;
    }

    public Connection get(Profile profile, ClientDelegate clientDelegate, String string) {
        return null;
    }

    public Connection getConnection(IOR iOR, ClientDelegate clientDelegate, String string) {
        Trc.begin2(iOR, clientDelegate, CLASS, "getConnection:218");
        ConnectionKeyGenerator connectionKeyGenerator = this.iiopChannelPlugin.getConnectionKeyGenerator(iOR, clientDelegate, string);
        Trc.info(connectionKeyGenerator, CLASS, "getConnection:226");
        Connection connection = null;
        GIOPConnectionKey gIOPConnectionKey = connectionKeyGenerator.getNextKey();
        block4: while (true) {
            try {
                while (connection == null) {
                    IOException iOException;
                    Trc.info(gIOPConnectionKey, CLASS, "getConnection:235");
                    VirtualConnectionFactory virtualConnectionFactory = gIOPConnectionKey.getVirtualConnectionFactory();
                    if (virtualConnectionFactory == null) {
                        iOException = new IOException("Outbound channel chain may not have been initialized");
                        Trc.ffdc(iOException, CLASS, "getConnection:244");
                        throw iOException;
                    }
                    GIOPChannelHelper.setOrb(virtualConnectionFactory.getName(), (com.ibm.CORBA.iiop.ORB)this.theORB);
                    iOException = (OutboundVirtualConnection)virtualConnectionFactory.createConnection();
                    Map map = iOException.getStateMap();
                    try {
                        iOException.connect(gIOPConnectionKey);
                        connection = (Connection)map.get("Connection");
                        continue block4;
                    }
                    catch (Exception exception) {
                        GIOPConnectionKey gIOPConnectionKey2 = connectionKeyGenerator.getNextKey();
                        if (gIOPConnectionKey2 == null) {
                            throw exception;
                        }
                        gIOPConnectionKey = gIOPConnectionKey2;
                    }
                }
                break;
            }
            catch (Exception exception) {
                Trc.warn(exception, CLASS, "getConnection:286");
                if (exception instanceof SystemException) {
                    throw (SystemException)((Object)exception);
                }
                TRANSIENT tRANSIENT = new TRANSIENT(exception.toString() + ":host=" + gIOPConnectionKey.getRemoteHost() + ",port=" + gIOPConnectionKey.getRemotePort(), 1229127170, CompletionStatus.COMPLETED_NO);
                tRANSIENT.initCause((Throwable)exception);
                throw tRANSIENT;
            }
        }
        Trc.complete(connection, CLASS, "getConnection:303");
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTransports() {
        Trc.begin(CLASS, "initTransports:315");
        if (this.theORB.getClientCallback()) {
            Trc.complete("enableClientCallback - server not started", CLASS, "initTransports:319");
            return;
        }
        String string = this.theORB.getORBServerHost();
        int n = this.theORB.getListenerPort();
        Object object = initChainLock;
        synchronized (object) {
            block14: {
                if (this.serverProfile != null) {
                    return;
                }
                if (this.iiopChannelPlugin instanceof IIOPChannelPluginImpl) {
                    ((IIOPChannelPluginImpl)this.iiopChannelPlugin).initTCPChainGroup(string, n);
                }
                this.chainGroupName = this.iiopChannelPlugin.getChainGroupName();
                if (this.chainGroupName == null) {
                    this.serverProfile = new Profile(this.theORB, string, n, null);
                    Trc.info(this.iiopChannelPlugin, ": null chainGroupName", CLASS, "initTransports:354");
                    return;
                }
                try {
                    ChainGroupData chainGroupData = this.channelFramework.getChainGroup(this.chainGroupName);
                    if (chainGroupData == null) {
                        this.serverProfile = new Profile(this.theORB, string, n, null);
                        throw new Exception("Chain Group " + this.chainGroupName + " not found in ChannelFramework");
                    }
                    ChainData[] chainDataArray = chainGroupData.getChains();
                    this.setORBConfigForChainGroup(chainDataArray, n);
                    if (n == 0) {
                        ChainEnquirer chainEnquirer;
                        ChainEnquirer chainEnquirer2 = chainEnquirer = new ChainEnquirer(this.channelFramework, chainDataArray[0].getName());
                        synchronized (chainEnquirer2) {
                            this.channelFramework.startChainGroup(this.chainGroupName);
                            n = chainEnquirer.getListenerPort();
                            break block14;
                        }
                    }
                    this.channelFramework.startChainGroup(this.chainGroupName);
                }
                catch (Exception exception) {
                    Trc.ffdc(exception, CLASS, "initTransports:394");
                    INTERNAL iNTERNAL = new INTERNAL(exception.toString(), 1229125000, CompletionStatus.COMPLETED_NO);
                    iNTERNAL.initCause((Throwable)exception);
                    throw iNTERNAL;
                }
            }
            this.serverProfile = new Profile(this.theORB, string, n, null);
        }
        Trc.complete("serverHost=", string, " serverPort=", Trc.str(n), " listeningPort=", Trc.str(n), CLASS, "initTransports:409");
    }

    public Profile getServerIIOPProfile() {
        Trc.begin(CLASS, "getServerIIOPProfile:418");
        if (this.serverProfile == null) {
            this.initTransports();
        }
        Trc.complete(CLASS, "getServerIIOPProfile:422");
        return this.serverProfile;
    }

    public String getHostIPAddress(String string) {
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            Trc.warn(unknownHostException, CLASS, "getHostIPAddress:434");
            INTERNAL iNTERNAL = new INTERNAL(unknownHostException.toString(), 1229125046, CompletionStatus.COMPLETED_MAYBE);
            iNTERNAL.initCause((Throwable)unknownHostException);
            throw iNTERNAL;
        }
    }

    private void setORBConfigForChainGroup(ChainData[] chainDataArray, int n) {
        Map map = null;
        Map map2 = null;
        Trc.begin(CLASS, "setORBConfigForChainGroup:473");
        for (int i = 0; i < chainDataArray.length; ++i) {
            ORB oRB;
            ChannelData[] channelDataArray = chainDataArray[i].getChannelList();
            for (int j = 0; j < channelDataArray.length; ++j) {
                Class clazz = channelDataArray[j].getFactoryType();
                if (GIOPInboundChannelFactory.class.isAssignableFrom(clazz)) {
                    map2 = channelDataArray[j].getPropertyBag();
                    continue;
                }
                if (!ORBInboundChannelFactory.class.isAssignableFrom(clazz)) continue;
                map = channelDataArray[j].getPropertyBag();
                ++this.inboundORBChannelCount;
            }
            if (map != null) {
                oRB = (ORB)map.get(ORBChannelHelper.ORB);
                if (oRB == null) {
                    map.put(ORBChannelHelper.ORB, this.theORB);
                } else if (oRB != this.theORB) {
                    Trc.ffdc("" + this.theORB + " is now set in " + chainDataArray[i].getName() + " which already has ORB " + oRB, CLASS, "setORBConfigForChainGroup:505");
                    map.put(ORBChannelHelper.ORB, this.theORB);
                }
            }
            if (map2 != null) {
                oRB = (ORB)map2.get("ORB");
                if (oRB == null) {
                    map2.put("ORB", this.theORB);
                } else if (oRB != this.theORB) {
                    Trc.ffdc(this.theORB + " is now set in " + chainDataArray[i].getName() + " which already has ORB " + oRB, CLASS, "setORBConfigForChainGroup:522");
                    map2.put("ORB", this.theORB);
                }
            }
            if (!Trc.enabled()) continue;
            for (int j = 0; j < channelDataArray.length; ++j) {
                Map map3 = channelDataArray[j].getPropertyBag();
                Trc.info("Chain=", chainDataArray[i].getName(), " Channel=", channelDataArray[j].getName(), "[", channelDataArray[j].getFactoryType(), "] properties= ", map3, CLASS, "setORBConfigForChainGroup:534");
            }
        }
        Trc.complete(CLASS, "setORBConfigForChainGroup:539");
    }

    public GIOPConnectionTable getConnectionTable() {
        return this.connTable;
    }

    public void shutdown() {
        Trc.begin(CLASS, "shutdown:560");
        this.connTable.shutdown();
        this.iiopChannelPlugin.shutdown();
        this.channelFramework = null;
        this.connTable = null;
        this.iiopChannelPlugin = null;
        GIOPChannelHelper.cleanUp((com.ibm.CORBA.iiop.ORB)this.theORB);
        this.theORB = null;
        Trc.complete(CLASS, "shutdown:568");
    }

    public String getUserSpecifiedLocalHost() {
        return this.theORB.getUserSpecifiedLocalHost();
    }

    public String getProperty(String string) {
        return this.theORB.getProperty(string);
    }

    public void setTransportData(Object object) {
    }

    public Object getTransportData() {
        return null;
    }

    public ORBConnection createORBConnection() {
        return null;
    }

    public ORBConnection createORBConnectionForServer() {
        return null;
    }

    public void createListener(int n) {
        Trc.warn(new IOException("You should set up the listener in the ORB chain group"), CLASS, "createListener:643");
    }

    public void destroyListener(int n) {
        Trc.warn(new IOException("Listeners must be destroyed while destroying or shuttingdown the ORB chain group"), CLASS, "destroyListener:660");
    }

    public int getInboundORBChannelCount() {
        return this.inboundORBChannelCount;
    }

    public ORBServerChannel getFvdServerChannel() {
        return this.fvdServerChannel;
    }

    private static class ChainEnquirer
    implements ChainEventListener {
        private final ChannelFramework channelFramework;
        private final String chainName;
        private boolean waitForStart = true;
        private int listeningPort = 0;

        ChainEnquirer(ChannelFramework channelFramework, String string) {
            Trc.begin(CLASS, "ChainStartListener:696");
            this.channelFramework = channelFramework;
            this.chainName = string;
            try {
                channelFramework.addChainEventListener((ChainEventListener)this, string);
                Trc.complete(CLASS, "ChainStartListener:701");
            }
            catch (ChainException chainException) {
                this.endWaiting();
                Trc.fail((Object)chainException, CLASS, "ChainStartListener:704");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void chainStarted(ChainData chainData) {
            Trc.begin(CLASS, "chainStarted:717");
            try {
                this.channelFramework.removeChainEventListener((ChainEventListener)this, this.chainName);
            }
            catch (ChainException chainException) {
                // empty catch block
            }
            ChainEnquirer chainEnquirer = this;
            synchronized (chainEnquirer) {
                if (this.waitForStart) {
                    try {
                        this.listeningPort = this.channelFramework.getListeningPort(this.chainName);
                        Trc.complete(Trc.str(this.listeningPort), CLASS, "chainStarted:729");
                    }
                    catch (Exception exception) {
                        Trc.fail(CLASS, "chainStarted:731");
                    }
                    finally {
                        this.endWaiting();
                    }
                }
            }
        }

        int getListenerPort() {
            Trc.begin(CLASS, "getListenerPort:745");
            while (this.waitForStart) {
                try {
                    Trc.info("waiting ...", CLASS, "getListenerPort:748");
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Trc.complete(Trc.str(this.listeningPort), CLASS, "getListenerPort:753");
            return this.listeningPort;
        }

        private synchronized void endWaiting() {
            this.waitForStart = false;
            this.notify();
        }

        public void chainInitialized(ChainData chainData) {
        }

        public void chainStopped(ChainData chainData) {
            Trc.info(CLASS, "chainStopped:780");
            this.endWaiting();
        }

        public void chainDestroyed(ChainData chainData) {
            Trc.info(CLASS, "chainDestroyed:792");
            this.endWaiting();
        }

        public void chainUpdated(ChainData chainData) {
        }
    }
}

